/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.components.MangoColorIconPanel;
import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPicker;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.roi.ColorManager;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.ROIDefaultLabels;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import org.apache.commons.lang3.StringUtils;

public class RoiMaskInput
extends AbstractInput
implements ActionListener,
MangoColorSelectedListener {
    private final VolumeManager manager;
    private final boolean useDefaultName;
    private final long arg;
    private long result;
    private JPanel colorsPanel;
    private JDialog dialog;
    private transient Popup popup;
    private static final long serialVersionUID = 1L;

    public RoiMaskInput(String name, long arg, VolumeManager manager) {
        this(name, arg, manager, true);
    }

    public RoiMaskInput(String name, long arg, VolumeManager manager, boolean useDefaultName) {
        super(name);
        this.arg = arg;
        this.manager = manager;
        this.useDefaultName = useDefaultName;
        this.result = this.arg;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " (default: " + StringUtilities.makeNiceBinaryString((long)this.arg) + ")?";
        this.ask(question);
    }

    private void createGUI() {
        JButton button = new JButton();
        button.addActionListener(this);
        this.colorsPanel = new JPanel();
        this.colorsPanel.setLayout(new BoxLayout(this.colorsPanel, 1));
        if (this.useDefaultName) {
            button.setText("Colors...");
        } else {
            button.setText(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()));
        }
        this.add(button);
        this.add(this.colorsPanel);
        this.updateColorPanels();
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            sc.close();
            if (!StringUtils.isBlank((CharSequence)line)) {
                String str = line.replaceAll("\\s+", "");
                return Long.parseLong(str, 2);
            }
            return this.arg;
        }
        return this.result;
    }

    private void updateColorPanels() {
        this.colorsPanel.removeAll();
        ROIColor[] colorSet = ROIColor.getROIColors();
        SliceViewer viewer = (SliceViewer)this.manager;
        int index = 0;
        Box box = null;
        for (int ctr = 0; ctr < 64; ++ctr) {
            if ((1L << ctr & this.result) == 0L) continue;
            ROIColor color = colorSet[ctr];
            MangoColorIconPanel colorPanel = new MangoColorIconPanel(viewer.getROIManager(), this, color, viewer.getROIManager().getLabel(color.getIndex(), ROIDefaultLabels.getDefaultLabelBitPlaneOrder(ctr, viewer.getROIManager().getBuffer().getMaximumColors())), false);
            if (index % 4 == 0) {
                box = Box.createHorizontalBox();
                box.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            }
            box.add(colorPanel);
            box.add(Box.createHorizontalStrut(2));
            this.colorsPanel.add(box);
            ++index;
        }
        this.colorsPanel.validate();
        if (this.dialog != null) {
            this.dialog.pack();
        }
    }

    private void closePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    public void colorSelected(int colorNum) {
        this.closePopup();
        this.result |= 1L << colorNum;
        this.updateColorPanels();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.popup != null) {
            this.closePopup();
        } else {
            SliceViewer viewer = (SliceViewer)this.manager;
            if (viewer != null) {
                this.popup = PopupFactory.getSharedInstance().getPopup(this, new MangoColorPicker((ColorManager)viewer.getROIManager(), this, viewer.getROIManager(), viewer.getROIManager().getBuffer().getMaximumColors(), false), this.getLocationOnScreen().x, this.getLocationOnScreen().y + 35);
                this.popup.show();
            }
        }
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }
}

