/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class OrientationInput
extends AbstractInput {
    private static final long serialVersionUID = 1L;
    private MangoComboBox<String> selectBoxOrder;
    private MangoComboBox<String> selectBoxSense;
    private final Object arg;
    private static final String[] ORIENTATION = new String[]{"XYZ", "XZY", "YXZ", "YZX", "ZXY", "ZYX"};
    private static final String[] SENSE = new String[]{"+++", "++-", "+-+", "-++", "+--", "-+-", "--+", "---"};

    public OrientationInput(String name, Object arg) {
        super(name);
        this.arg = arg;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " (default: " + this.arg + ")?";
        this.ask(question);
    }

    private void createGUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()) + ": "));
        this.selectBoxOrder = new MangoComboBox<String>((T[])ORIENTATION);
        this.selectBoxSense = new MangoComboBox<String>((T[])SENSE);
        if (this.arg != null && this.arg instanceof String) {
            this.selectBoxOrder.setSelectedItem(((String)this.arg).substring(0, 3));
            this.selectBoxSense.setSelectedItem(((String)this.arg).substring(3));
        }
        this.add(this.selectBoxOrder);
        this.add(this.selectBoxSense);
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            sc.close();
            if (!StringUtils.isBlank((CharSequence)line)) {
                return line.trim();
            }
            return this.arg;
        }
        return this.selectBoxOrder.getSelectedItem().toString() + this.selectBoxSense.getSelectedItem().toString();
    }
}

