/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class OptionInput
extends AbstractInput {
    private static final long serialVersionUID = 1L;
    private MangoComboBox<Object> selectBox;
    private final Object arg;
    private final Map<?, ?> map;
    private final List<?> list;

    public OptionInput(String name, Map<?, ?> map, Object arg) {
        super(name);
        this.map = map;
        this.list = null;
        this.arg = arg;
        this.createUI();
    }

    public OptionInput(String name, List<?> list, Object arg) {
        super(name);
        this.map = null;
        this.list = list;
        this.arg = arg;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = this.map != null ? question + " (default: " + this.arg + ") [options: " + StringUtils.join(this.map.keySet(), (String)", ") + "]?" : question + " (default: " + this.arg + ") [options: " + StringUtils.join(this.list, (String)", ") + "]?";
        this.ask(question);
    }

    private void createGUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()) + ": "));
        if (this.map != null) {
            Object[] keys = this.map.keySet().toArray(new Object[this.map.size()]);
            this.selectBox = new MangoComboBox<Object>((T[])keys);
            if (this.arg != null) {
                this.selectBox.setSelectedItem(this.arg);
            }
            this.add(this.selectBox);
        } else if (this.list != null) {
            Object[] keys = this.list.toArray(new Object[this.list.size()]);
            this.selectBox = new MangoComboBox<Object>((T[])keys);
            if (this.arg != null) {
                this.selectBox.setSelectedItem(this.arg);
            }
            this.add(this.selectBox);
        }
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            if (this.map != null) {
                while (!this.map.keySet().contains(line.trim()) && !StringUtils.isBlank((CharSequence)line)) {
                    this.createCLI();
                    line = sc.nextLine();
                }
            } else if (this.list != null) {
                while (!this.list.contains(line.trim()) && !StringUtils.isBlank((CharSequence)line)) {
                    this.createCLI();
                    line = sc.nextLine();
                }
            }
            sc.close();
            if (StringUtils.isBlank((CharSequence)line)) {
                if (this.map != null) {
                    return this.map.get(this.arg);
                }
                return this.arg;
            }
            if (this.map != null) {
                return this.map.get(line);
            }
            return line;
        }
        if (this.map != null) {
            return this.map.get(this.selectBox.getSelectedItem());
        }
        return this.selectBox.getSelectedItem();
    }
}

