/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.dialogs.modal.file.OpenFileDialog;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class OpenLocationInput
extends AbstractInput
implements ActionListener {
    private MangoTextField text;
    private String arg;
    private final VolumeManager manager;
    public static final int DEFAULT_SIZE = 16;
    private static final long serialVersionUID = 1L;

    public OpenLocationInput(String name, String arg, VolumeManager manager) {
        super(name);
        this.manager = manager;
        this.arg = arg;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String dir = null;
        dir = this.manager != null ? FileUtilities.getParent((URI)this.manager.getLoadedURI()) : Platform.getHomeDirectory();
        if (StringUtils.isBlank((CharSequence)this.arg)) {
            this.arg = dir;
        }
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " (default: " + this.arg + ")?";
        this.ask(question);
    }

    private void createGUI() {
        String dir = null;
        dir = this.manager != null ? FileUtilities.getParent((URI)this.manager.getLoadedURI()) : Platform.getHomeDirectory();
        if (StringUtils.isBlank((CharSequence)this.arg)) {
            this.arg = dir;
        }
        this.text = new MangoTextField(this.arg, 16);
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()) + ": "));
        this.add(this.text);
        JButton button = new JButton("Select File...");
        button.addActionListener(this);
        this.add(button);
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            sc.close();
            if (!StringUtils.isBlank((CharSequence)line)) {
                return line;
            }
            return this.arg;
        }
        return this.text.getText();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        File startFile = new File(this.text.getText());
        File file = OpenFileDialog.showOpenFileChooser(null, startFile.getParent(), null, "All Files");
        if (file != null) {
            this.text.setText(file.toString());
        }
    }
}

