/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.dialogs.cine.AbstractCine;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.dialogs.script.input.BooleanInput;
import edu.uthscsa.ric.mango.dialogs.script.input.ColorInput;
import edu.uthscsa.ric.mango.dialogs.script.input.CoordinateInput;
import edu.uthscsa.ric.mango.dialogs.script.input.FloatInput;
import edu.uthscsa.ric.mango.dialogs.script.input.IntegerInput;
import edu.uthscsa.ric.mango.dialogs.script.input.KernelSizeInput;
import edu.uthscsa.ric.mango.dialogs.script.input.ObjectInput;
import edu.uthscsa.ric.mango.dialogs.script.input.OpenLocationInput;
import edu.uthscsa.ric.mango.dialogs.script.input.OpenVolumeManagerInput;
import edu.uthscsa.ric.mango.dialogs.script.input.OptionInput;
import edu.uthscsa.ric.mango.dialogs.script.input.OrientationInput;
import edu.uthscsa.ric.mango.dialogs.script.input.RoiIndexInput;
import edu.uthscsa.ric.mango.dialogs.script.input.RoiMaskInput;
import edu.uthscsa.ric.mango.dialogs.script.input.RotationAxisInput;
import edu.uthscsa.ric.mango.dialogs.script.input.SaveLocationInput;
import edu.uthscsa.ric.mango.dialogs.script.input.SeriesIndexInput;
import edu.uthscsa.ric.mango.dialogs.script.input.SliceDirectionInput;
import edu.uthscsa.ric.mango.dialogs.script.input.SliceNumberInput;
import edu.uthscsa.ric.mango.dialogs.script.input.StringInput;
import edu.uthscsa.ric.mango.dialogs.script.input.SurfaceInput;
import edu.uthscsa.ric.mango.dialogs.script.input.SurfaceShapeInput;
import edu.uthscsa.ric.mango.dialogs.script.input.TextInput;
import edu.uthscsa.ric.mango.dialogs.script.input.VolumeInput;
import edu.uthscsa.ric.mango.viewerprojection.ProjectionViewer;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceReader;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Header;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class MultiInput
extends JPanel {
    private List<Object> results;
    private final List<AbstractInput> inputs = new ArrayList<AbstractInput>();
    private final List<Object> defaults;
    private final List<String> names;
    private final List<String> types;
    private final String title;
    private final VolumeManager manager;
    private final boolean headless;
    private static final long serialVersionUID = 1L;
    public static final String TYPE_BOOLEAN = Boolean.TYPE.getName();
    public static final String TYPE_INTEGER = Integer.TYPE.getName();
    public static final String TYPE_SHORT = Short.TYPE.getName();
    public static final String TYPE_LONG = Long.TYPE.getName();
    public static final String TYPE_FLOAT = Float.TYPE.getName();
    public static final String TYPE_DOUBLE = Double.TYPE.getName();
    public static final String TYPE_STRING = "string";
    public static final String TYPE_ROTATION_AXIS = "rotationAxis";
    public static final String TYPE_SLICE_DIR = "sliceDirection";
    public static final String TYPE_DIR = "direction";
    public static final String TYPE_SLICE_NUM = "sliceNumber";
    public static final String TYPE_ROI_MASK = "roiMask";
    public static final String TYPE_KERNEL_SIZE = "kernelSize";
    public static final String TYPE_RANK_TYPE = "rankType";
    public static final String TYPE_VIDEO_FORMAT = "videoFormat";
    public static final String TYPE_VIDEO_QUALITY = "videoQuality";
    public static final String TYPE_VOLUME = "volume";
    public static final String TYPE_OVERLAY = "overlay";
    public static final String TYPE_OVERLAYS = "overlays";
    public static final String TYPE_VIDEO_FPS = "fps";
    public static final String TYPE_START_SERIES = "seriesIndex";
    public static final String TYPE_START_SERIES_INDEX = "startingSeriesIndex";
    public static final String TYPE_END_SERIES_INDEX = "endingSeriesIndex";
    public static final String TYPE_SERIES_GROUP_SIZE = "seriesGroupSize";
    public static final String TYPE_STAT_TYPE = "statisticType";
    public static final String TYPE_SAVE_LOCATION = "saveLocation";
    public static final String TYPE_OPEN_LOCATION = "openLocation";
    public static final String TYPE_OPEN_CONTEXTS = "manager";
    public static final String TYPE_FILTER_TYPE = "filterType";
    public static final String TYPE_THRESHOLD = "threshold";
    public static final String TYPE_THRESHOLD_MIN = "thresholdMin";
    public static final String TYPE_THRESHOLD_MAX = "thresholdMax";
    public static final String TYPE_ROI_OUTPUT = "roiOutputColorIndex";
    public static final String TYPE_ROI_COLOR = "roiColorIndex";
    public static final String TYPE_COORDINATE = "coordinate";
    public static final String TYPE_COLOR_TABLE = "colorTable";
    public static final String TYPE_HEADER_FORMAT = "headerFormat";
    public static final String TYPE_SURFACE_EXPORT_FORMAT = "surfaceFormat";
    public static final String TYPE_DATA_TYPE = "datatype";
    public static final String TYPE_NUM_BYTES = "numBytes";
    public static final String TYPE_ORIENTATION = "orientation";
    public static final String TYPE_INTERPOLATION = "interpolation";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_EXPRESSION = "expression";
    public static final String TYPE_PROJECTION_QUALITY = "projectionQuality";
    public static final String TYPE_RGB = "rgb";
    public static final String TYPE_SURFACES = "surfaces";
    public static final String TYPE_SURFACE = "surface";
    public static final String TYPE_SURFACE_RENDER_TYPE = "renderType";
    public static final String TYPE_SURFACE_SHAPE = "shape";
    public static final String TYPE_SURFACE_SHAPE_TO = "toShape";
    public static final String TYPE_SURFACE_SHAPE_FROM = "fromShape";
    public static final String TYPE_SURFACE_SHAPE_POINT_TO = "toPoint";
    public static final String TYPE_SURFACE_SHAPE_POINT_FROM = "fromPoint";

    public MultiInput(VolumeManager manager, String title, List<String> names, List<String> types, List<Object> defaults, boolean headless) {
        this.headless = headless;
        this.title = title;
        this.names = names;
        this.types = types;
        this.defaults = defaults;
        this.manager = manager;
    }

    public void createInputs() {
        List<Object> args;
        int numArgs = this.names.size();
        if (this.headless) {
            this.createCLI();
            this.results = new ArrayList<Object>();
        }
        if ((args = this.defaults) != null && args.size() != numArgs) {
            args = null;
        }
        for (int ctr = 0; ctr < numArgs; ++ctr) {
            List list;
            HashMap<String, Integer> map;
            Object arg;
            AbstractInput input = null;
            String argName = this.names.get(ctr);
            String argType = this.types.get(ctr);
            Object object = arg = args != null ? this.defaults.get(ctr) : null;
            if (argName.equals(TYPE_SLICE_DIR) || argType.equals(TYPE_SLICE_DIR)) {
                input = new SliceDirectionInput(argName, arg != null ? (Integer)arg : -1, this.manager);
            } else if (argName.equals(TYPE_DIR) || argType.equals(TYPE_DIR)) {
                input = new SliceDirectionInput(argName, arg != null ? (Integer)arg : -1, this.manager, true);
            } else if (argName.equals(TYPE_SLICE_NUM) || argType.equals(TYPE_SLICE_NUM)) {
                input = new SliceNumberInput(argName, arg != null ? (Integer)arg : -1, this.manager);
            } else if (argName.equals(TYPE_ROTATION_AXIS) || argType.equals(TYPE_ROTATION_AXIS)) {
                input = new RotationAxisInput(argName, arg != null ? (Integer)arg : -1, this.manager);
            } else if (argName.equals(TYPE_ROI_MASK) || argType.equals(TYPE_ROI_MASK)) {
                input = new RoiMaskInput(argName, arg != null ? Long.parseLong(arg.toString()) : 0L, this.manager);
            } else if (argName.equals(TYPE_KERNEL_SIZE) || argType.equals(TYPE_KERNEL_SIZE)) {
                input = new KernelSizeInput(argName, arg != null ? (Integer)arg : 3);
            } else if (argName.equals(TYPE_RGB) || argType.equals(TYPE_RGB)) {
                input = new ColorInput(argName, arg != null ? (Integer)arg : 0);
            } else if (argName.equals(TYPE_SURFACE) || argType.equals(TYPE_SURFACE)) {
                input = new SurfaceInput(argName, this.manager, false);
            } else if (argName.equals(TYPE_SURFACES) || argType.equals(TYPE_SURFACES)) {
                input = new SurfaceInput(argName, this.manager, true);
            } else if (argName.equals(TYPE_SURFACE_SHAPE) || argType.equals(TYPE_SURFACE_SHAPE)) {
                input = new SurfaceShapeInput(argName, this.manager, false, false);
            } else if (argName.equals(TYPE_SURFACE_SHAPE_TO) || argType.equals(TYPE_SURFACE_SHAPE_TO)) {
                input = new SurfaceShapeInput(argName, this.manager, true, true);
            } else if (argName.equals(TYPE_SURFACE_SHAPE_FROM) || argType.equals(TYPE_SURFACE_SHAPE_FROM)) {
                input = new SurfaceShapeInput(argName, this.manager, false, false);
            } else if (argName.equals(TYPE_SURFACE_SHAPE_POINT_FROM) || argType.equals(TYPE_SURFACE_SHAPE_POINT_FROM)) {
                input = new SurfaceShapeInput(argName, this.manager, false, true);
            } else if (argName.equals(TYPE_SURFACE_SHAPE_POINT_TO) || argType.equals(TYPE_SURFACE_SHAPE_POINT_TO)) {
                input = new SurfaceShapeInput(argName, this.manager, false, true);
            } else if (argName.equals(TYPE_RANK_TYPE) || argType.equals(TYPE_RANK_TYPE)) {
                map = new HashMap<String, Integer>();
                map.put("Min", 1);
                map.put("Median", 2);
                map.put("Max", 4);
                input = new OptionInput(argName, map, (Object)"Median");
            } else if (argName.equals(TYPE_SURFACE_RENDER_TYPE) || argType.equals(TYPE_SURFACE_RENDER_TYPE)) {
                map = new HashMap();
                map.put("Triangles", 0);
                map.put("Wireframe", 1);
                map.put("Points", 2);
                input = new OptionInput(argName, map, (Object)"Triangles");
            } else if (argName.equals(TYPE_FILTER_TYPE) || argType.equals(TYPE_FILTER_TYPE)) {
                map = new HashMap();
                map.put("Slice", 2);
                map.put("Volume", 4);
                map.put("Time", 1);
                input = new OptionInput(argName, map, (Object)"Volume");
            } else if (argName.equals(TYPE_VIDEO_FORMAT) || argType.equals(TYPE_VIDEO_FORMAT)) {
                map = new LinkedHashMap();
                int index = 0;
                for (String string : AbstractCine.OPTION_FORMATS) {
                    map.put(string, index++);
                }
                input = new OptionInput(argName, map, (Object)AbstractCine.OPTION_FORMATS.get(0));
            } else if (argName.equals(TYPE_VIDEO_QUALITY) || argType.equals(TYPE_VIDEO_QUALITY)) {
                map = new LinkedHashMap();
                int index = 0;
                for (String string : AbstractCine.OPTION_QUALITY) {
                    map.put(string, index++);
                }
                input = new OptionInput(argName, map, (Object)AbstractCine.OPTION_QUALITY.get(0));
            } else if (argName.equals(TYPE_PROJECTION_QUALITY) || argType.equals(TYPE_PROJECTION_QUALITY)) {
                map = new LinkedHashMap();
                int index = 0;
                for (String string : ProjectionViewer.OPTION_QUALITY) {
                    map.put(string, index++);
                }
                input = new OptionInput(argName, map, (Object)ProjectionViewer.OPTION_QUALITY.get(2));
            } else if (argName.equals(TYPE_VIDEO_FPS) || argType.equals(TYPE_VIDEO_FPS)) {
                input = new OptionInput(argName, AbstractCine.FPS, (Object)AbstractCine.FPS.get(0));
            } else if (argName.equals(TYPE_HEADER_FORMAT) || argType.equals(TYPE_HEADER_FORMAT)) {
                input = new OptionInput(argName, Header.getWritableHeaderFormatNames(), (Object)"NIFTI");
            } else if (argName.equals(TYPE_SURFACE_EXPORT_FORMAT) || argType.equals(TYPE_SURFACE_EXPORT_FORMAT)) {
                Set<String> set = SurfaceReader.getLoadedFormats().keySet();
                set.remove(".surf");
                ArrayList<String> list2 = new ArrayList<String>(set);
                input = new OptionInput(argName, list2, (Object)(arg != null ? (String)arg : null));
            } else if (argName.equals(TYPE_COLOR_TABLE) || argType.equals(TYPE_COLOR_TABLE)) {
                list = Arrays.asList(LookupTableManager.getAllLUTNames());
                input = new OptionInput(argName, list, (Object)list.get(0));
            } else if (argName.equals(TYPE_STAT_TYPE) || argType.equals(TYPE_STAT_TYPE)) {
                map = new HashMap();
                map.put("Sum", 0);
                map.put("Mean", 1);
                map.put("Max", 2);
                map.put("Min", 3);
                map.put("SD", 4);
                String argStr = "Mean";
                if (arg != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (!arg.equals(entry.getValue())) continue;
                        argStr = (String)entry.getKey();
                    }
                }
                input = new OptionInput(argName, map, (Object)argStr);
            } else if (argName.equals(TYPE_DATA_TYPE) || argType.equals(TYPE_DATA_TYPE)) {
                map = new HashMap();
                map.put("Integer (Signed)", 2);
                map.put("Integer (Unsigned)", 3);
                map.put("Float", 4);
                String argStr = "Mean";
                if (arg != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (!arg.equals(entry.getValue())) continue;
                        argStr = (String)entry.getKey();
                    }
                }
                input = new OptionInput(argName, map, (Object)argStr);
            } else if (argName.equals(TYPE_INTERPOLATION) || argType.equals(TYPE_INTERPOLATION)) {
                map = new HashMap();
                map.put("Nearest Neighbor", 0);
                map.put("Trilinear", 1);
                map.put("Sinc", 2);
                input = new OptionInput(argName, map, (Object)"Trilinear");
            } else if (argName.equals(TYPE_NUM_BYTES) || argType.equals(TYPE_NUM_BYTES)) {
                list = new ArrayList<String>();
                list.add((String)((Object)Integer.valueOf(1)));
                list.add((String)((Object)Integer.valueOf(2)));
                list.add((String)((Object)Integer.valueOf(4)));
                input = new OptionInput(argName, list, arg != null ? arg : Integer.valueOf(2));
            } else if (argName.equals(TYPE_SAVE_LOCATION) || argType.equals(TYPE_SAVE_LOCATION)) {
                input = new SaveLocationInput(argName, arg != null ? arg.toString() : null, this.manager);
            } else if (argName.equals(TYPE_ORIENTATION) || argType.equals(TYPE_ORIENTATION)) {
                input = new OrientationInput(argName, arg != null ? arg.toString() : "XYZ+--");
            } else if (argName.equals(TYPE_VOLUME) || argType.equals(TYPE_VOLUME)) {
                input = new VolumeInput(argName, this.manager, false, false);
            } else if (argName.equals(TYPE_OVERLAY) || argType.equals(TYPE_OVERLAY)) {
                input = new VolumeInput(argName, this.manager, false, true);
            } else if (argName.equals(TYPE_OVERLAYS) || argType.equals(TYPE_OVERLAYS)) {
                input = new VolumeInput(argName, this.manager, true, true);
            } else if (argName.equals(TYPE_OPEN_CONTEXTS) || argType.equals(TYPE_OPEN_CONTEXTS)) {
                input = new OpenVolumeManagerInput(argName, Mango.getInstance(), this.manager);
            } else if (argName.equals(TYPE_OPEN_LOCATION) || argType.equals(TYPE_OPEN_LOCATION)) {
                input = new OpenLocationInput(argName, arg != null ? arg.toString() : null, this.manager);
            } else if (argName.equals(TYPE_START_SERIES_INDEX) || argType.equals(TYPE_START_SERIES_INDEX)) {
                input = new SeriesIndexInput(argName, arg != null ? (Integer)arg : 0, this.manager);
            } else if (argName.equals(TYPE_START_SERIES) || argType.equals(TYPE_START_SERIES)) {
                input = new SeriesIndexInput(argName, arg != null ? (Integer)arg : 0, this.manager);
            } else if (argName.equals(TYPE_END_SERIES_INDEX) || argType.equals(TYPE_END_SERIES_INDEX)) {
                input = new SeriesIndexInput(argName, arg != null ? (Integer)arg : this.manager.getBaseVolume().getSeriesLength() - 1, this.manager);
            } else if (argName.equals(TYPE_SERIES_GROUP_SIZE) || argType.equals(TYPE_SERIES_GROUP_SIZE)) {
                input = new SeriesIndexInput(argName, arg != null ? (Integer)arg - 1 : this.manager.getBaseVolume().getSeriesLength() - 1, this.manager);
            } else if (argName.equals(TYPE_THRESHOLD) || argType.equals(TYPE_THRESHOLD)) {
                input = new FloatInput("Threshold", Double.valueOf((arg != null ? arg : Double.valueOf(((SliceViewer)this.manager).getCurrentScreenVolume().getScreenMin())).toString()));
            } else if (argName.equals(TYPE_THRESHOLD_MIN) || argType.equals(TYPE_THRESHOLD_MIN)) {
                input = new FloatInput("Min", Double.valueOf((arg != null ? arg : Double.valueOf(((SliceViewer)this.manager).getCurrentScreenVolume().getScreenMin())).toString()));
            } else if (argName.equals(TYPE_THRESHOLD_MAX) || argType.equals(TYPE_THRESHOLD_MAX)) {
                input = new FloatInput("Max", Double.valueOf((arg != null ? arg : Double.valueOf(((SliceViewer)this.manager).getCurrentScreenVolume().getScreenMax())).toString()));
            } else if (argName.equals(TYPE_ROI_OUTPUT) || argType.equals(TYPE_ROI_OUTPUT)) {
                input = new RoiIndexInput(argName, arg != null ? (Integer)arg : -1, this.manager, false);
            } else if (argName.equals(TYPE_ROI_COLOR) || argType.equals(TYPE_ROI_COLOR)) {
                input = new RoiIndexInput(argName, arg != null ? (Integer)arg : -1, this.manager, true);
            } else if (argName.equals(TYPE_COORDINATE) || argType.equals(TYPE_COORDINATE)) {
                input = new CoordinateInput(argName, arg != null ? (Coordinate)arg : null, this.manager);
            } else if (argType.equals(TYPE_BOOLEAN)) {
                input = new BooleanInput(argName, arg != null ? (Boolean)arg : false);
            } else if (argType.equals(TYPE_FLOAT) || argType.equals(TYPE_DOUBLE)) {
                input = new FloatInput(argName, arg != null ? (Double)arg : 0.0);
            } else if (argType.equals(TYPE_SHORT) || argType.equals(TYPE_INTEGER) || argType.equals(TYPE_LONG)) {
                input = new IntegerInput(argName, arg != null ? (Integer)arg : 0);
            } else if (argName.equals(TYPE_TEXT) || argName.equals(TYPE_EXPRESSION)) {
                input = new TextInput(argName, arg != null ? (String)arg : "");
            } else if (argType.equals(TYPE_STRING)) {
                input = new StringInput(argName, arg != null ? (String)arg : "");
            } else {
                if (arg != null && arg instanceof List && (list = (List)arg).size() > 0) {
                    input = new OptionInput(argName, list, list.get(0));
                }
                if (input == null) {
                    input = new ObjectInput(argName, arg != null ? arg : "");
                }
            }
            if (this.headless) {
                this.results.add(((AbstractInput)input).getResult());
            }
            this.inputs.add(input);
        }
        if (!this.headless) {
            this.createGUI();
        }
    }

    private void createCLI() {
        System.out.println(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.title));
    }

    private void createGUI() {
        this.setLayout(new BoxLayout(this, 1));
        for (AbstractInput input : this.inputs) {
            this.add(input);
        }
    }

    public Iterable<Object> getResultHeadless() {
        return this.results;
    }

    public Iterable<Object> getResult() {
        ArrayList<Object> objs = new ArrayList<Object>();
        for (AbstractInput input : this.inputs) {
            objs.add(input.getResult());
        }
        return objs;
    }
}

