/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.lang3.StringUtils;

public class CoordinateInput
extends AbstractInput {
    private final VolumeManager manager;
    private JSpinner spinnerX;
    private JSpinner spinnerY;
    private JSpinner spinnerZ;
    private final Coordinate arg;
    private static final long serialVersionUID = 1L;

    public CoordinateInput(String name, Coordinate arg, VolumeManager manager) {
        super(name);
        this.arg = arg;
        this.manager = manager;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " (default: " + this.arg.xDbl + " " + this.arg.yDbl + " " + this.arg.zDbl + ")?";
        this.ask(question);
    }

    private void createGUI() {
        Coordinate coord = this.arg;
        if (coord == null) {
            coord = this.manager.getCurrentPosition();
        }
        int xDim = this.manager.getBaseVolume().getXDim();
        int yDim = this.manager.getBaseVolume().getYDim();
        int zDim = this.manager.getBaseVolume().getZDim();
        this.spinnerX = new JSpinner(new SpinnerNumberModel(coord.xInt, 0, xDim - 1, 1));
        this.spinnerY = new JSpinner(new SpinnerNumberModel(coord.yInt, 0, yDim - 1, 1));
        this.spinnerZ = new JSpinner(new SpinnerNumberModel(coord.zInt, 0, zDim - 1, 1));
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(StringUtils.isNotBlank((CharSequence)this.getName()) ? this.getName() + ": " : "Coordinate: "));
        this.add(this.spinnerX);
        this.add(this.spinnerY);
        this.add(this.spinnerZ);
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            sc.close();
            if (!StringUtils.isBlank((CharSequence)line)) {
                Scanner sc2 = new Scanner(line);
                double x = sc2.nextDouble();
                double y = sc2.nextDouble();
                double z = sc2.nextDouble();
                sc2.close();
                return new Coordinate(x, y, z);
            }
            return this.arg;
        }
        return new Coordinate((double)((Number)this.spinnerX.getModel().getValue()).intValue(), (double)((Number)this.spinnerY.getModel().getValue()).intValue(), (double)((Number)this.spinnerZ.getModel().getValue()).intValue());
    }
}

