/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Scanner;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;

public class ColorInput
extends AbstractInput
implements ActionListener {
    private Color currentColor;
    private JPanel colorSwatchPanel;
    public static final int SWATCH_SIZE = 25;
    private static final long serialVersionUID = 1L;

    public ColorInput(String name, int rgb) {
        super(name);
        this.currentColor = new Color(rgb);
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " (default: " + Integer.toHexString(this.currentColor.getRGB()).substring(2) + ")?";
        this.ask(question);
    }

    private void createGUI() {
        JButton colorButton = new JButton("Select Color...");
        colorButton.setFocusable(false);
        colorButton.addActionListener(this);
        this.colorSwatchPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(ColorInput.this.currentColor.getRed(), ColorInput.this.currentColor.getGreen(), ColorInput.this.currentColor.getBlue()));
                g.fillRect(0, 0, 25, 25);
            }
        };
        this.colorSwatchPanel.setPreferredSize(new Dimension(25, 25));
        this.colorSwatchPanel.setMaximumSize(this.colorSwatchPanel.getPreferredSize());
        this.colorSwatchPanel.setMinimumSize(this.colorSwatchPanel.getPreferredSize());
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BoxLayout(colorPanel, 0));
        colorPanel.add(Box.createHorizontalStrut(8));
        colorPanel.add(colorButton);
        colorPanel.add(Box.createHorizontalStrut(8));
        colorPanel.add(this.colorSwatchPanel);
        colorPanel.add(Box.createHorizontalStrut(8));
        JPanel colorPanel2 = new JPanel();
        colorPanel2.setLayout(new BoxLayout(colorPanel2, 1));
        colorPanel2.add(colorPanel);
        colorPanel2.add(Box.createVerticalStrut(4));
        this.setLayout(new BoxLayout(this, 1));
        this.add(colorPanel2);
        this.add(Box.createVerticalStrut(8));
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            sc.close();
            if (!StringUtils.isBlank((CharSequence)line)) {
                String colorStr = line.trim();
                try {
                    return new Color(Integer.valueOf(colorStr.substring(0, 2), 16), Integer.valueOf(colorStr.substring(2, 4), 16), Integer.valueOf(colorStr.substring(4, 6), 16)).getRGB();
                }
                catch (Exception ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
            return this.currentColor.getRGB();
        }
        return this.currentColor.getRGB();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.currentColor = JColorChooser.showDialog(null, "Choose Color", this.currentColor);
        this.colorSwatchPanel.repaint();
    }
}

