/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script;

import edu.uthscsa.ric.cli.ParameterNameAnnotation;
import edu.uthscsa.ric.mango.Atlas;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoContext;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.components.MangoDropDownButton;
import edu.uthscsa.ric.mango.dialogs.modal.file.OpenFileDialog;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.dialogs.script.BeanHelper;
import edu.uthscsa.ric.mango.dialogs.script.CommandFilter;
import edu.uthscsa.ric.mango.dialogs.script.FieldListRenderer;
import edu.uthscsa.ric.mango.dialogs.script.Recordable;
import edu.uthscsa.ric.mango.dialogs.script.ScriptClass;
import edu.uthscsa.ric.mango.dialogs.script.ScriptField;
import edu.uthscsa.ric.mango.dialogs.script.ScriptFilenameFilter;
import edu.uthscsa.ric.mango.dialogs.script.ScriptMethod;
import edu.uthscsa.ric.mango.dialogs.script.Snippets;
import edu.uthscsa.ric.mango.dialogs.script.TextAreaOutputStream;
import edu.uthscsa.ric.mango.dialogs.script.UserInput;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerprojection.ProjectionManager;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewersurface.SurfaceManager;
import edu.uthscsa.ric.mango.window.ToolboxAssociated;
import edu.uthscsa.ric.roi.Line;
import edu.uthscsa.ric.roi.Point;
import edu.uthscsa.ric.roi.ROI;
import edu.uthscsa.ric.roi.ROIData;
import edu.uthscsa.ric.roi.mask.ROIMaskBuffer;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.DesktopUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.visualization.surface.primitives.Shape;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.AnalysisPoint;
import edu.uthscsa.ric.volume.Cluster;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.Histogram;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.VoxelDimensions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.python.core.PyException;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class ScriptManager
implements ActionListener,
CaretListener,
ComponentListener,
ItemListener,
PopupMenuListener,
ToolboxAssociated,
ViewerAssociated {
    private JButton addInputButton;
    private JButton addMethodButton;
    private JButton addVariableButton;
    private JButton deleteButton;
    private JButton exportButton;
    private JButton importButton;
    private JButton newScriptButton;
    private JButton recordButton;
    private JButton runButton;
    private JButton saveButton;
    private JFrame frame;
    private JPanel bottomPanel;
    private JPanel fieldPanel;
    private JPanel managementPanel;
    private JPanel managementPanelBottom;
    private JPanel textPanel;
    private JPopupMenu popup;
    private JTextArea textOutputArea;
    private JTextArea textScriptArea;
    private JToggleButton editButton;
    private MangoComboBox<ScriptField> fieldBox;
    private MangoComboBox<ScriptClass> classBox;
    private MangoComboBox<String> inputBox;
    private MangoComboBox<ScriptMethod> methodsBox;
    private MangoComboBox<String> scriptSelectBox;
    private PythonInterpreter interp;
    private SliceViewer viewer;
    private String selectedVariable;
    private boolean freezeUpdate;
    private boolean lastActionWasPause;
    private boolean miniMode;
    private boolean recordButtonPressed;
    private boolean recordWithDialogs;
    private long popupTimeCanceled;
    private Thread scriptThread;
    private final Mango mango;
    private JButton addFieldButton;
    private JSplitPane splitPane;
    private MangoComboBox<String> snippetBox;
    private JButton addSnippetButton;
    private JPopupMenu popupHelp;
    private long popupHelpTimeCanceled;
    private JButton helpButton;
    private static boolean isPlaying;
    private static boolean isRecording;
    public static final List<String> EXCLUDED_FIELDS;
    public static final List<String> RECORD_ANIMATION_FRAME;
    public static final String ACTION_ADD_FIELD = "ACTION_ADD_FIELD";
    public static final String ACTION_ADD_INPUT = "ACTION_ADD_INPUT";
    public static final String ACTION_ADD_SNIPPET = "ACTION_ADD_SNIPPET";
    public static final String ACTION_ADD_METHOD = "ACTION_ADD_METHOD";
    public static final String ACTION_ADD_VAR = "ACTION_ADD_VAR";
    public static final String ACTION_DELETE = "ACTION_DELETE";
    public static final String ACTION_EDIT = "ACTION_EDIT";
    public static final String ACTION_HELP = "ACTION_HELP";
    public static final String ACTION_EXEC = "ACTION_EXEC";
    public static final String ACTION_EXPORT = "ACTION_EXPORT";
    public static final String ACTION_IMPORT = "ACTION_IMPORT";
    public static final String ACTION_NEW = "ACTION_NEW";
    public static final String ACTION_RECORD = "ACTION_RECORD";
    public static final String ACTION_RUN = "ACTION_RUN";
    public static final String ACTION_SAVE = "ACTION_SAVE";
    public static final String ACTION_SAVEAS = "ACTION_SAVEAS";
    public static final String ACTION_SCRIPT_SELECTED = "ACTION_SCRIPT_SELECTED";
    public static final String ACTION_STOP = "ACTION_STOP";
    public static final String ACTION_UPDATE_METHODS = "ACTION_UPDATE_METHODS";
    public static final String ACTION_WITHOUT_DIALOGS = "Without user input";
    public static final String ACTION_WITH_DIALOGS = "With user input";
    public static final String ACTION_HELP_API = "API";
    public static final String ACTION_HELP_EXAMPLES = "Examples";
    public static final String ACTION_HELP_TUTORIAL = "Tutorial";
    public static final String ARROW = "\u279e";
    public static final String DEFAULT_NAME = "My New Script";
    public static final String DEFAULT_VOLMAN_MANAGER;
    public static final String EXTENSION = ".py";
    public static final String FALSE = "False";
    public static final String FLIP_ORIENTATION = "flipOrientation";
    public static final String M_CTX = "m_Mango";
    public static final String M_CTX_CONTEXT = "m_Mango_mango";
    public static final String M_VOLMAN = "m_VolMan";
    public static final String PARAMETER_GET_AVAILABLE_MASK = ".roiData.availableMask";
    public static final String PARAMETER_GET_BASE_VOLUME = ".baseVolume";
    public static final String PARAMETER_GET_CURRENT_COORD = ".currentPosition";
    public static final String PARAMETER_GET_CURRENT_ROI = ".roiColor";
    public static final String PARAMETER_GET_CURRENT_VOLUME = ".currentVolume";
    public static final String PARAMETER_GET_HIST_ANALYSIS = ".histogramAnalysis";
    public static final String PARAMETER_GET_MAIN_SLICE_DIR = ".sliceDirection";
    public static final String PARAMETER_GET_MAIN_SLICE_NUM = ".sliceNumber";
    public static final String PARAMETER_GET_SELECTED_LINES = ".roiData.selectedLines";
    public static final String PARAMETER_GET_ALL_LINES = ".roiData.usedLines";
    public static final String PARAMETER_GET_SELECTED_MASK = ".roiData.selectedMask";
    public static final String PARAMETER_GET_SELECTED_ROIS = ".roiData.selectedROIs";
    public static final String PARAMETER_GET_ALL_ROIS = ".roiData.allROIs";
    public static final String PARAMETER_GET_USED_MASK = ".roiData.usedMask";
    public static final String PARAMETER_SURFACE_MANAGER = ".surfaceManager";
    public static final String PROMPT = ">>> ";
    public static final String RECORD_CLOSE = "disposeVolumeManager";
    public static final String RECORD_PAUSE = "pauseScriptForUserInput";
    public static final String RUN_OPERATION = "runOperation";
    public static final String SELECT_MENU_OPTION = "selectMenuOption";
    public static final String SET_MENU_OPTION = "setMenuOption";
    public static final String TEXT_ADD = "Add";
    public static final String TITLE = "Script Manager";
    public static final String TRUE = "True";
    public static final int MAX_COMBOBOX_WIDTH = 400;
    public static final int MAX_NUM_FIELD_BOXES = 5;
    public static final int MINIMUM_HEIGHT = 300;
    public static final int MINIMUM_WIDTH = 350;
    public static final int SOURCE_LINE_MAX_SIZE = 80;
    private static final Map<String, Class<?>> API;

    public static File[] findScriptFiles() {
        File dir = Platform.getScriptsDir();
        if (!dir.exists()) {
            FileUtilities.mkdirs((File)dir);
        }
        return dir.listFiles(new ScriptFilenameFilter());
    }

    public static String makeNiceType(Class<?> type) {
        String typeStr = null;
        String className = (String)CollectionUtilities.getKeyByValue(API, type);
        if (StringUtils.isNotBlank((CharSequence)className)) {
            typeStr = className;
        } else if (type.isArray()) {
            typeStr = type.getComponentType() + "[]";
        } else {
            typeStr = type.toString();
            if (typeStr.equals("void")) {
                typeStr = "";
            } else {
                typeStr = typeStr.replace("class ", "");
                typeStr = typeStr.replace("interface ", "");
            }
        }
        return typeStr;
    }

    public static void runScriptSilently(String name, final MangoContext ctx, final VolumeManager manager) {
        File[] scriptFiles = ScriptManager.findScriptFiles();
        File scriptFile = null;
        for (File file : scriptFiles) {
            String filename = FileUtilities.removeExtension((String)file.getName());
            if (!filename.equals(name)) continue;
            scriptFile = file;
            break;
        }
        final File scriptFileF = scriptFile;
        if (scriptFile != null) {
            Thread workThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProgressMeter progress = ctx.makeProgressMeter();
                    progress.start(0, 0, 100);
                    progress.setIndeterminateMode(true);
                    PythonInterpreter interp = ScriptManager.makeInterpreter();
                    interp.setOut((OutputStream)new TextAreaOutputStream(Mango.getInstance().getConsole().getTextArea(), ""));
                    interp.setErr((OutputStream)new TextAreaOutputStream(Mango.getInstance().getConsole().getTextArea(), ""));
                    try {
                        ScriptManager.addUserInputFunctions(interp);
                        ScriptManager.addVariables(interp, ctx, manager);
                        isPlaying = true;
                        interp.exec(FileUtils.readFileToString((File)scriptFileF));
                        ScriptManager.showDoneScriptMessage();
                    }
                    catch (PyException ex) {
                        AppLogger.error((String)ex.toString());
                        Mango.showErrorDialogStatic("The script did not run successfully.  Please\ncheck the console for more information.", "Script Error");
                    }
                    catch (IOException ex) {
                        AppLogger.error((Throwable)ex);
                        Mango.showErrorDialogStatic("The script did not run successfully.  Please\ncheck the console for more information.", "Script Error");
                    }
                    finally {
                        progress.setIndeterminateMode(false);
                        progress.setValue(progress.getMax());
                        isPlaying = false;
                    }
                }
            };
            workThread.start();
        }
    }

    public static void runScriptConsole(String name, MangoContext ctx, VolumeManager manager) {
        File[] scriptFiles = ScriptManager.findScriptFiles();
        File scriptFile = null;
        for (File file : scriptFiles) {
            String filename = FileUtilities.removeExtension((String)file.getName());
            if (!filename.equals(name)) continue;
            scriptFile = file;
            break;
        }
        ScriptManager.runScriptConsole(scriptFile, ctx, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runScriptConsole(File scriptFile, MangoContext ctx, VolumeManager manager) {
        if (scriptFile != null) {
            PythonInterpreter interp = ScriptManager.makeInterpreter();
            try {
                ScriptManager.addUserInputFunctions(interp);
                ScriptManager.addVariables(interp, ctx, manager);
                isPlaying = true;
                interp.exec(FileUtils.readFileToString((File)scriptFile));
            }
            catch (PyException ex) {
                AppLogger.error((String)ex.toString());
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
            finally {
                isPlaying = false;
            }
        } else {
            AppLogger.error((String)"That script was not found!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runScriptConsoleExpression(String expression, int region, MangoContext ctx, VolumeManager manager, boolean save) {
        if (StringUtils.isNotBlank((CharSequence)expression)) {
            PythonInterpreter interp = ScriptManager.makeInterpreter();
            try {
                ScriptManager.addUserInputFunctions(interp);
                ScriptManager.addVariables(interp, ctx, manager);
                isPlaying = true;
                String command = "m_VolMan_manager.selectAll()\nm_VolMan_result = m_VolMan_manager.runOperation(\"" + expression + "\"," + region + ",False,True,False)";
                if (save) {
                    command = command + "\nm_VolMan_result.save()";
                }
                interp.exec(command);
            }
            catch (PyException ex) {
                AppLogger.error((String)ex.toString());
            }
            finally {
                isPlaying = false;
            }
        } else {
            AppLogger.error((String)"That script was not found!");
        }
    }

    private static void addUserInputFunctions(PythonInterpreter interp) {
        interp.exec(UserInput.IMPORT);
        for (String func : UserInput.INPUT_FUNCTIONS) {
            interp.exec(func);
        }
    }

    private static void addVariables(PythonInterpreter interp, MangoContext ctx, VolumeManager manager) {
        int start;
        List viewers = ctx.getAllVolumeManagersFrom(manager);
        interp.set(M_CTX_CONTEXT, (Object)ctx);
        if (manager != null) {
            interp.set(DEFAULT_VOLMAN_MANAGER, (Object)manager);
            start = 1;
        } else {
            start = 0;
        }
        for (int ctr = start; ctr < viewers.size(); ++ctr) {
            interp.set(DEFAULT_VOLMAN_MANAGER + (ctr + 1), viewers.get(ctr));
        }
        for (Map.Entry<String, Class<?>> entry : API.entrySet()) {
            interp.set(entry.getKey(), entry.getValue());
        }
    }

    private static String findReturnValue(String line) {
        String returnVal = null;
        int index = -1;
        Pattern pattern = Pattern.compile("=\\s*(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            index = matcher.start();
        }
        if (index != -1) {
            returnVal = line.substring(0, line.indexOf(61)).trim();
        }
        return returnVal;
    }

    private static PythonInterpreter makeInterpreter() {
        return new PythonInterpreter(null, new PySystemState());
    }

    private static String makeMethodDescription(ScriptMethod method, JTextArea textArea, boolean userInput) {
        String sig = null;
        sig = userInput ? method.getSignatureWithUserInput() : method.getSignature();
        Pattern pattern = Pattern.compile("=\\s*(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
        Matcher matcher = pattern.matcher(sig);
        if (matcher.find()) {
            sig = sig.substring(matcher.start() + 1).trim();
        }
        String type = ScriptManager.makeNiceType(method.getReturnType());
        String finalReturnType = "";
        if (StringUtils.isNotBlank((CharSequence)type)) {
            String returnType;
            finalReturnType = returnType = ScriptManager.makePythonType(method.getReturnType()) + "_result";
            String testText = textArea.getText();
            int index = 2;
            while (testText.indexOf(finalReturnType) != -1) {
                finalReturnType = returnType + index++;
            }
            finalReturnType = finalReturnType + " = ";
        }
        return finalReturnType + method.getVariableName() + '.' + sig;
    }

    private static String makePythonType(Class<?> type) {
        String typeStr = null;
        String className = (String)CollectionUtilities.getKeyByValue(API, type);
        if (StringUtils.isNotBlank((CharSequence)className)) {
            typeStr = className;
        } else if (type.isArray()) {
            typeStr = "array_" + type.getComponentType().toString();
        } else if (type.isPrimitive()) {
            typeStr = type.toString();
            typeStr = typeStr.replace("class ", "");
            typeStr = typeStr.replace("interface ", "");
            typeStr = typeStr.substring(typeStr.lastIndexOf(46) + 1);
        } else {
            typeStr = type.toString();
            typeStr = typeStr.replace("class ", "");
            typeStr = typeStr.replace("interface ", "");
            typeStr = "j_" + typeStr.substring(typeStr.lastIndexOf(46) + 1);
        }
        return typeStr;
    }

    private static String makeSignature(Method method, String[] argValues) {
        Object[] args;
        block13: {
            String name;
            ParameterNameAnnotation pna;
            ParameterNameAnnotation annotation;
            Object[] argTypes = method.getParameterTypes();
            args = new String[]{};
            if (!ArrayUtils.isNotEmpty((Object[])argTypes)) break block13;
            String[] parameterNames = null;
            args = new String[argTypes.length];
            if (method.isAnnotationPresent(ParameterNameAnnotation.class) && (annotation = method.getAnnotation(ParameterNameAnnotation.class)) != null && argTypes.length != (parameterNames = (pna = annotation).names()).length) {
                AppLogger.warn((String)("Number of args does not match number of parameter names:" + method.toGenericString()));
                parameterNames = null;
            }
            if (CollectionUtilities.isNotEmpty((Object)argValues)) {
                if (argValues.length == argTypes.length) {
                    for (int ctr = 0; ctr < argTypes.length; ++ctr) {
                        if (StringUtils.isNotEmpty((CharSequence)argValues[ctr])) {
                            args[ctr] = argValues[ctr];
                            continue;
                        }
                        if (StringUtils.isNotEmpty((CharSequence)parameterNames[ctr])) {
                            name = parameterNames[ctr];
                            if (name.indexOf(47) != -1) {
                                name = name.substring(name.indexOf(47) + 1);
                            }
                            args[ctr] = name;
                            continue;
                        }
                        args[ctr] = ((Class)argTypes[ctr]).getName();
                    }
                } else {
                    AppLogger.warn((String)("Number of args does not match number of arg values:" + method.toGenericString()));
                    for (int ctr = 0; ctr < argTypes.length; ++ctr) {
                        args[ctr] = ((Class)argTypes[ctr]).getName();
                    }
                }
            } else {
                for (int ctr = 0; ctr < argTypes.length; ++ctr) {
                    if (parameterNames != null) {
                        name = parameterNames[ctr];
                        if (name.indexOf(47) != -1) {
                            name = name.substring(name.indexOf(47) + 1);
                        }
                        args[ctr] = name;
                        continue;
                    }
                    args[ctr] = ((Class)argTypes[ctr]).getName();
                }
            }
        }
        return "(" + StringUtils.join((Object[])args, (String)", ") + ")";
    }

    private static void setVariablesNames(SliceViewer manager) {
        int start;
        List<VolumeManager> viewers = Mango.getInstance().getAllVolumeManagersFrom(manager);
        if (manager != null) {
            manager.setScriptObjectName(DEFAULT_VOLMAN_MANAGER);
            start = 1;
        } else {
            start = 0;
        }
        for (int ctr = start; ctr < viewers.size(); ++ctr) {
            ((SliceViewer)viewers.get(ctr)).setScriptObjectName(DEFAULT_VOLMAN_MANAGER + (ctr + 1));
        }
    }

    private static void showDoneScriptMessage() {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                Mango.getInstance().showInfoDialog("Done!", "Script Message");
            }
        });
    }

    public ScriptManager(Mango mango) {
        this(mango, null);
    }

    public ScriptManager(Mango mango, SliceViewer viewer) {
        this.mango = mango;
        this.viewer = viewer;
        this.miniMode = true;
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.freezeUpdate) {
            return;
        }
        String command = ae.getActionCommand();
        if (command.equalsIgnoreCase(ACTION_HELP_API)) {
            DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//scriptapi.html");
        } else if (command.equalsIgnoreCase(ACTION_HELP_EXAMPLES)) {
            DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//scriptexamples.html");
        } else if (command.equalsIgnoreCase(ACTION_HELP_TUTORIAL)) {
            DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//scripttutorial.html");
        } else if (command.equals(ACTION_ADD_VAR)) {
            JTextArea textAreaFocused = this.findFocusedTextArea(this.textScriptArea);
            String line = this.classBox.getSelectedItem().toString();
            this.replaceSelection(textAreaFocused, line);
        } else if (command.equals(ACTION_ADD_FIELD)) {
            JTextArea textAreaFocused = this.findFocusedTextArea(this.textScriptArea);
            String line = this.makeCurrentFieldDescription();
            this.replaceSelection(textAreaFocused, line);
        } else if (command.equals(ACTION_ADD_METHOD)) {
            this.recordButtonPressed = false;
            this.showPopup();
        } else if (command.equals(ACTION_HELP)) {
            this.showHelpPopup();
        } else if (command.equals(ACTION_ADD_INPUT)) {
            JTextArea textAreaFocused = this.findFocusedTextArea(this.textScriptArea);
            String line = this.inputBox.getSelectedItem().toString();
            this.replaceSelection(textAreaFocused, line);
        } else if (command.equals(ACTION_ADD_SNIPPET)) {
            String[] snippet;
            JTextArea textAreaFocused = this.findFocusedTextArea(this.textScriptArea);
            String line = this.snippetBox.getSelectedItem().toString();
            for (String str : snippet = Snippets.SNIPPETS.get(line)) {
                this.replaceSelection(textAreaFocused, str);
            }
        } else if (command.equals(ACTION_NEW)) {
            this.makeNewScript();
        } else if (command.equals(ACTION_SAVE)) {
            this.saveFile();
        } else if (command.equals(ACTION_DELETE)) {
            this.deleteFile();
        } else if (command.equals(ACTION_EDIT)) {
            this.miniMode = !this.miniMode;
            this.updateMiniMode();
        } else if (command.equals(ACTION_EXPORT)) {
            this.exportFile();
        } else if (command.equals(ACTION_IMPORT)) {
            this.importFile();
        } else if (command.equals(ACTION_RUN)) {
            this.stopRecording();
            if (isPlaying) {
                this.scriptThread.stop();
            } else {
                this.runScript(Mango.getInstance(), this.viewer);
            }
        } else if (command.equals(ACTION_UPDATE_METHODS)) {
            this.updateMethods();
        } else if (command.equals(ACTION_STOP)) {
            if (isRecording) {
                this.stopRecording();
            }
        } else if (command.equals(ACTION_RECORD)) {
            if (isRecording) {
                this.stopRecording();
            } else {
                this.recordButtonPressed = true;
                this.showPopup();
            }
        } else if (command.equals(ACTION_WITHOUT_DIALOGS)) {
            if (this.recordButtonPressed) {
                this.recordWithoutDialogs();
            } else {
                this.addMethodWithoutDialogs();
            }
        } else if (command.equals(ACTION_WITH_DIALOGS)) {
            if (this.recordButtonPressed) {
                this.recordWithDialogs();
            } else {
                this.addMethodWithDialogs();
            }
        }
    }

    @Override
    public void caretUpdate(CaretEvent ce) {
        Class<?> klass;
        String foundVariable = this.findSelectedVariable(ce.getDot(), ce.getMark());
        if (StringUtils.isNotBlank((CharSequence)foundVariable) && (klass = this.getClassOfSelectedVariable(foundVariable)) != null) {
            ScriptClass scriptClass = new ScriptClass((String)CollectionUtilities.getKeyByValue(API, klass), klass);
            this.classBox.setSelectedItem(scriptClass);
            this.selectedVariable = foundVariable;
            this.updateMethods();
        }
    }

    @Override
    public String getDescription() {
        return TITLE;
    }

    public Object getVariableByName(String name) {
        return this.interp.get(name);
    }

    @Override
    public SliceViewer getViewer() {
        return this.viewer;
    }

    @Override
    public JFrame getWindow() {
        return this.frame;
    }

    public boolean isPlaying() {
        return isPlaying;
    }

    public boolean isRecording() {
        return isRecording;
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (this.freezeUpdate) {
            return;
        }
        if (ie.getStateChange() == 1) {
            Object source = ie.getSource();
            if (source == this.scriptSelectBox) {
                this.scriptSelected();
            } else if (source == this.classBox) {
                this.classSelected();
            }
        }
        this.updateMethods();
        this.updateEnabledItems();
    }

    public ScriptMethod makeScriptMethod(Method method, String[] argValues, boolean forceNeedsUserInput) {
        ScriptMethod scriptMethod = new ScriptMethod(method.getName() + ScriptManager.makeSignature(method, argValues), method.getReturnType());
        String methodWithUserInputs = method.getName() + this.makeUserInputSignature(method, argValues, forceNeedsUserInput);
        scriptMethod.setSignatureWithUserInput(methodWithUserInputs);
        return scriptMethod;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
        if (pme.getSource() == this.popup) {
            this.popupTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupHelp) {
            this.popupHelpTimeCanceled = new Date().getTime();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }

    public void recordAction(String name, Recordable recordable, final String[] argValues, final boolean forceNeedsUserInput) {
        int numArgs = argValues == null ? 0 : argValues.length;
        final Method method = recordable.findRecordableMethod(name, numArgs);
        final String varName = recordable.getScriptObjectName();
        if (method != null) {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    boolean closing = false;
                    if (method.getName().equals(ScriptManager.RECORD_CLOSE) && ScriptManager.this.viewer != null) {
                        closing = true;
                    } else if (method.getName().equals(ScriptManager.RECORD_PAUSE)) {
                        if (ScriptManager.this.lastActionWasPause) {
                            return;
                        }
                        ScriptManager.this.lastActionWasPause = true;
                    } else {
                        ScriptManager.this.lastActionWasPause = false;
                    }
                    ScriptMethod scriptMethod = ScriptManager.this.makeScriptMethod(method, argValues, forceNeedsUserInput);
                    scriptMethod.setVariableName(varName);
                    String scriptLine = ScriptManager.makeMethodDescription(scriptMethod, ScriptManager.this.textScriptArea, true);
                    String returnVal = ScriptManager.findReturnValue(scriptLine);
                    if (returnVal != null && returnVal.startsWith(ScriptManager.M_VOLMAN)) {
                        Mango.getInstance().getAllViewers().lastElement().setScriptObjectName(returnVal);
                    }
                    ScriptManager.this.replaceSelection(ScriptManager.this.textScriptArea, scriptLine);
                    if (closing) {
                        ScriptManager.this.stopRecording();
                        ScriptManager.this.saveFile();
                    }
                }
            });
        } else {
            AppLogger.error((String)"Method not found");
        }
    }

    private String[] indent(String[] strings, int level) {
        ArrayList<String> indentedLines = new ArrayList<String>();
        for (int ctr = 0; ctr < strings.length; ++ctr) {
            String str = strings[ctr];
            if (str.length() <= 80) {
                indentedLines.add(str);
                continue;
            }
            int index = StringUtilities.findIndexOfCharacter((String)str, (char)'(', (int)0, (boolean)true);
            if (level > 0 || ctr > 0 || index == -1) {
                index = StringUtilities.findLastIndexOfCharacter((String)str, (char)',', (int)0, (int)80, (boolean)false);
            }
            if (index == -1) {
                indentedLines.add(str);
                continue;
            }
            String[] lines = new String[]{str.substring(0, index + 1), str.substring(index + 1)};
            lines[1] = StringUtils.leftPad((String)lines[1], (int)(lines[1].length() + 4));
            indentedLines.add(lines[0]);
            if (!StringUtils.isNotBlank((CharSequence)lines[1])) continue;
            indentedLines.add(lines[1]);
        }
        String[] indented = indentedLines.toArray(new String[indentedLines.size()]);
        boolean more = false;
        for (String str : indented) {
            if (str.length() <= 80 || (!str.trim().endsWith(",") || StringUtilities.findNumberOfCharacters((String)str, (char)',', (boolean)false) <= 1) && (str.trim().endsWith(",") || StringUtilities.findNumberOfCharacters((String)str, (char)',', (boolean)false) <= 0)) continue;
            more = true;
            break;
        }
        if (more) {
            indented = this.indent(indented, level + 1);
        }
        return indented;
    }

    public void showPopup() {
        long timeSinceCancel = new Date().getTime() - this.popupTimeCanceled;
        if (timeSinceCancel > 250L) {
            if (this.recordButtonPressed) {
                this.popup.show(this.recordButton, 2, 35);
            } else {
                this.popup.show(this.addMethodButton, 2, 35);
            }
        }
    }

    public void showHelpPopup() {
        long timeSinceCancel = new Date().getTime() - this.popupHelpTimeCanceled;
        if (timeSinceCancel > 250L) {
            this.popupHelp.show(this.helpButton, 2, 35);
        }
    }

    private void deassociateWindow() {
        for (SliceViewer viewer : this.mango.getAllViewers()) {
            viewer.deassociateWindow(this);
        }
        this.mango.getToolBox().deassociateWindow(this);
    }

    public void showTool(boolean startRecording, boolean withDialogs, SliceViewer viewer) {
        if (this.isRecording()) {
            this.stopRecording();
        }
        this.recordWithDialogs = withDialogs;
        this.miniMode = startRecording;
        this.viewer = viewer;
        ScriptManager.setVariablesNames(viewer);
        this.updateMethods();
        this.updateMiniMode();
        this.deassociateWindow();
        if (viewer != null) {
            viewer.associateWindow(this);
        } else {
            this.mango.getToolBox().associateWindow(this);
        }
        if (viewer != null) {
            this.frame.setLocation(DisplayUtils.getNextWindowLocation(viewer.getViewerContainer(), this.frame.getSize(), null, Platform.isApplet()));
        } else {
            this.frame.setLocation(DisplayUtils.getCenterDialogLocation(this.mango.getToolBox(), this.frame.getSize()));
        }
        this.frame.setVisible(true);
        if (startRecording) {
            this.makeNewScript();
            this.startRecording();
        }
    }

    private void addAllClasses() {
        ScriptClass contextClass = null;
        for (Map.Entry<String, Class<?>> entry : API.entrySet()) {
            ScriptClass scriptClass = new ScriptClass(entry.getKey(), entry.getValue());
            if (scriptClass.getShortName().equals(M_VOLMAN)) {
                contextClass = scriptClass;
            }
            this.classBox.addItem(scriptClass);
        }
        this.classBox.setSelectedItem(contextClass);
    }

    private void updateField(Class<?> beanType) {
        ScriptField field;
        BeanInfo beanInfo = BeanHelper.getBeanInfo(beanType);
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        ArrayList<ScriptField> fieldList = new ArrayList<ScriptField>();
        this.fieldBox.removeAllItems();
        for (PropertyDescriptor pd : descriptors) {
            Class<?> type;
            String name = pd.getName();
            if (EXCLUDED_FIELDS.contains(name) || (type = pd.getPropertyType()) == null) continue;
            field = new ScriptField(name, type);
            fieldList.add(field);
        }
        Field[] fields = beanType.getFields();
        for (Field fld : fields) {
            Deprecated annotation = fld.getAnnotation(Deprecated.class);
            if (annotation != null) continue;
            field = new ScriptField(fld.getName(), fld.getType());
            fieldList.add(field);
        }
        Collections.sort(fieldList);
        for (ScriptField scriptField : fieldList) {
            this.fieldBox.addItem(scriptField);
        }
        this.updateMethods();
        this.updateFieldBoxSizes();
        this.fieldPanel.revalidate();
    }

    private void addMethodWithDialogs() {
        ScriptMethod method = (ScriptMethod)this.methodsBox.getSelectedItem();
        JTextArea textAreaFocused = this.findFocusedTextArea(this.textScriptArea);
        String line = ScriptManager.makeMethodDescription(method, textAreaFocused, true);
        this.replaceSelection(textAreaFocused, line);
    }

    private void addMethodWithoutDialogs() {
        ScriptMethod method = (ScriptMethod)this.methodsBox.getSelectedItem();
        JTextArea textAreaFocused = this.findFocusedTextArea(this.textScriptArea);
        String line = ScriptManager.makeMethodDescription(method, textAreaFocused, false);
        this.replaceSelection(textAreaFocused, line);
    }

    private void replaceSelection(JTextArea textArea, String line) {
        String[] indented;
        StringBuffer sb = new StringBuffer();
        for (String str : indented = this.indent(new String[]{line}, 0)) {
            sb.append(str).append('\n');
        }
        textArea.replaceSelection(sb.toString());
    }

    private void classSelected() {
        this.freezeUpdate = true;
        this.selectedVariable = null;
        this.updateField(((ScriptClass)this.classBox.getSelectedItem()).getType());
        this.freezeUpdate = false;
    }

    private void clearOutputArea() {
        ((AbstractDocument)this.textOutputArea.getDocument()).setDocumentFilter(null);
        this.textOutputArea.setText("");
        ((AbstractDocument)this.textOutputArea.getDocument()).setDocumentFilter(new CommandFilter(PROMPT));
    }

    private void createUI() {
        this.recordButton = new JButton("Record", MangoStyle.ICON_RECORD_DISABLED);
        this.recordButton.addActionListener(this);
        this.recordButton.setActionCommand(ACTION_RECORD);
        this.recordButton.setFocusable(false);
        this.recordButton.setHorizontalAlignment(2);
        this.runButton = new JButton(MangoStyle.ICON_PLAY);
        this.runButton.addActionListener(this);
        this.runButton.setActionCommand(ACTION_RUN);
        this.runButton.setFocusable(false);
        this.runButton.setPreferredSize(new Dimension(this.runButton.getPreferredSize().height, this.runButton.getPreferredSize().height));
        this.editButton = new JToggleButton(MangoStyle.ICON_EDIT);
        this.editButton.addActionListener(this);
        this.editButton.setActionCommand(ACTION_EDIT);
        this.editButton.setPreferredSize(this.runButton.getPreferredSize());
        this.editButton.setFocusable(false);
        this.editButton.setPreferredSize(new Dimension(this.editButton.getPreferredSize().height, this.editButton.getPreferredSize().height));
        this.helpButton = new JButton("Help", MangoStyle.ICON_HELP);
        this.helpButton.addActionListener(this);
        this.helpButton.setActionCommand(ACTION_HELP);
        this.helpButton.setFocusable(false);
        this.scriptSelectBox = new MangoComboBox();
        this.scriptSelectBox.setEditable(true);
        this.scriptSelectBox.setPreferredSize(new Dimension(150, this.scriptSelectBox.getPreferredSize().height));
        this.scriptSelectBox.setMinimumSize(new Dimension(150, this.scriptSelectBox.getPreferredSize().height));
        this.scriptSelectBox.setMaximumSize(new Dimension(150, this.scriptSelectBox.getPreferredSize().height));
        this.scriptSelectBox.addItemListener(this);
        this.scriptSelectBox.setFont(this.scriptSelectBox.getFont().deriveFont(12.0f));
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand(ACTION_SAVE);
        this.saveButton.setPreferredSize(new Dimension(this.saveButton.getPreferredSize().width, this.runButton.getPreferredSize().height));
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        controlPanel.add(this.scriptSelectBox);
        controlPanel.add(this.saveButton);
        controlPanel.add(Box.createHorizontalGlue());
        controlPanel.add(Box.createHorizontalStrut(4));
        controlPanel.add(this.runButton);
        controlPanel.add(this.recordButton);
        controlPanel.add(Box.createHorizontalGlue());
        controlPanel.add(Box.createHorizontalStrut(8));
        controlPanel.add(this.helpButton);
        controlPanel.add(this.editButton);
        this.newScriptButton = new JButton("New Script");
        this.newScriptButton.addActionListener(this);
        this.newScriptButton.setActionCommand(ACTION_NEW);
        this.exportButton = new JButton("Export...");
        this.exportButton.addActionListener(this);
        this.exportButton.setActionCommand(ACTION_EXPORT);
        this.importButton = new JButton("Import...");
        this.importButton.addActionListener(this);
        this.importButton.setActionCommand(ACTION_IMPORT);
        this.deleteButton = new JButton("Delete...");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setActionCommand(ACTION_DELETE);
        this.managementPanelBottom = new JPanel();
        this.managementPanelBottom.setLayout(new BoxLayout(this.managementPanelBottom, 0));
        this.managementPanelBottom.add(this.newScriptButton);
        this.managementPanelBottom.add(Box.createHorizontalStrut(2));
        this.managementPanelBottom.add(this.deleteButton);
        this.managementPanelBottom.add(Box.createHorizontalStrut(2));
        this.managementPanelBottom.add(this.importButton);
        this.managementPanelBottom.add(Box.createHorizontalStrut(2));
        this.managementPanelBottom.add(this.exportButton);
        this.managementPanelBottom.add(Box.createHorizontalGlue());
        this.managementPanel = new JPanel();
        this.managementPanel.setLayout(new BoxLayout(this.managementPanel, 1));
        this.managementPanel.add(controlPanel);
        this.managementPanel.add(this.managementPanelBottom);
        this.managementPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.managementPanel.getPreferredSize().height));
        this.textScriptArea = new JTextArea(10, 35);
        this.textScriptArea.addCaretListener(this);
        this.textScriptArea.setMaximumSize(this.textScriptArea.getPreferredSize());
        this.textScriptArea.setEditable(true);
        this.textScriptArea.setLineWrap(false);
        this.textScriptArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JScrollPane textScriptAreaScroller = new JScrollPane(this.textScriptArea);
        textScriptAreaScroller.setHorizontalScrollBarPolicy(31);
        textScriptAreaScroller.setVerticalScrollBarPolicy(20);
        textScriptAreaScroller.setBorder(null);
        this.textOutputArea = new JTextArea(5, 20);
        ((AbstractDocument)this.textOutputArea.getDocument()).setDocumentFilter(new CommandFilter(PROMPT));
        this.textOutputArea.setMaximumSize(this.textOutputArea.getPreferredSize());
        this.textOutputArea.setEditable(true);
        this.textOutputArea.setBackground(Color.LIGHT_GRAY);
        this.textOutputArea.setLineWrap(false);
        this.textOutputArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.textOutputArea.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), ACTION_EXEC);
        this.textOutputArea.getActionMap().put(ACTION_EXEC, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                ScriptManager.this.executeCommand();
            }
        });
        JScrollPane textOutputAreaScroller = new JScrollPane(this.textOutputArea);
        textOutputAreaScroller.setHorizontalScrollBarPolicy(31);
        textOutputAreaScroller.setVerticalScrollBarPolicy(20);
        textOutputAreaScroller.setBorder(null);
        this.splitPane = new JSplitPane(0, textScriptAreaScroller, textOutputAreaScroller);
        this.splitPane.setResizeWeight(0.75);
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new BoxLayout(this.textPanel, 0));
        this.textPanel.add(this.splitPane);
        this.textPanel.setPreferredSize(new Dimension(600, this.splitPane.getPreferredSize().height));
        this.classBox = new MangoComboBox();
        this.classBox.addItemListener(this);
        this.classBox.setPrototypeDisplayValue(ScriptClass.PROTOTYPE);
        JPanel classPanel = new JPanel();
        classPanel.setLayout(new BoxLayout(classPanel, 0));
        classPanel.add(new JLabel("Classes:"));
        classPanel.add(Box.createHorizontalStrut(2));
        classPanel.add(this.classBox);
        this.fieldBox = new MangoComboBox();
        this.fieldBox.setRenderer(new FieldListRenderer(true));
        this.addFieldButton = new JButton(TEXT_ADD);
        this.addFieldButton.addActionListener(this);
        this.addFieldButton.setActionCommand(ACTION_ADD_FIELD);
        this.fieldPanel = new JPanel();
        this.fieldPanel.setLayout(new BoxLayout(this.fieldPanel, 0));
        this.fieldPanel.add(new JLabel("Properties:"));
        this.fieldPanel.add(this.fieldBox);
        this.fieldPanel.add(this.addFieldButton);
        this.addVariableButton = new JButton(TEXT_ADD);
        this.addVariableButton.addActionListener(this);
        this.addVariableButton.setActionCommand(ACTION_ADD_VAR);
        this.addVariableButton.setFocusable(false);
        classPanel.add(Box.createHorizontalStrut(2));
        classPanel.add(this.addVariableButton);
        this.methodsBox = new MangoComboBox();
        this.methodsBox.setPrototypeDisplayValue(ScriptMethod.PROTOTYPE);
        this.addMethodButton = new MangoDropDownButton(TEXT_ADD);
        this.addMethodButton.addActionListener(this);
        this.addMethodButton.setActionCommand(ACTION_ADD_METHOD);
        this.addMethodButton.setFocusable(false);
        JPanel methodsPanel = new JPanel();
        methodsPanel.setLayout(new BoxLayout(methodsPanel, 0));
        methodsPanel.add(new JLabel("Methods:"));
        methodsPanel.add(Box.createHorizontalStrut(4));
        methodsPanel.add(this.methodsBox);
        methodsPanel.add(Box.createHorizontalStrut(2));
        methodsPanel.add(this.addMethodButton);
        this.inputBox = new MangoComboBox();
        this.inputBox.setPrototypeDisplayValue("       ");
        this.addInputButton = new JButton(TEXT_ADD);
        this.addInputButton.addActionListener(this);
        this.addInputButton.setActionCommand(ACTION_ADD_INPUT);
        this.addInputButton.setFocusable(false);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 0));
        inputPanel.add(new JLabel("Inputs:"));
        inputPanel.add(Box.createHorizontalStrut(4));
        inputPanel.add(this.inputBox);
        inputPanel.add(Box.createHorizontalStrut(2));
        inputPanel.add(this.addInputButton);
        this.initializeInputs();
        this.snippetBox = new MangoComboBox();
        this.snippetBox.setPrototypeDisplayValue("       ");
        this.addSnippetButton = new JButton(TEXT_ADD);
        this.addSnippetButton.addActionListener(this);
        this.addSnippetButton.setActionCommand(ACTION_ADD_SNIPPET);
        this.addSnippetButton.setFocusable(false);
        JPanel snippetPanel = new JPanel();
        snippetPanel.setLayout(new BoxLayout(snippetPanel, 0));
        snippetPanel.add(new JLabel("Snippets:"));
        snippetPanel.add(Box.createHorizontalStrut(4));
        snippetPanel.add(this.snippetBox);
        snippetPanel.add(Box.createHorizontalStrut(2));
        snippetPanel.add(this.addSnippetButton);
        this.initializeSnippets();
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        this.bottomPanel.add(classPanel);
        this.bottomPanel.add(Box.createVerticalStrut(2));
        this.bottomPanel.add(this.fieldPanel);
        this.bottomPanel.add(Box.createVerticalStrut(2));
        this.bottomPanel.add(methodsPanel);
        this.bottomPanel.add(Box.createVerticalStrut(2));
        this.bottomPanel.add(new JSeparator(0));
        this.bottomPanel.add(Box.createVerticalStrut(2));
        JPanel examplePanel = new JPanel();
        examplePanel.setLayout(new BoxLayout(examplePanel, 0));
        examplePanel.add(inputPanel);
        examplePanel.add(Box.createHorizontalStrut(8));
        examplePanel.add(snippetPanel);
        this.bottomPanel.add(examplePanel);
        this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.managementPanel);
        mainPanel.add(this.textPanel);
        mainPanel.add(this.bottomPanel);
        this.frame = new JFrame();
        this.frame.setTitle(TITLE);
        this.frame.setDefaultCloseOperation(1);
        this.frame.setIconImage(MangoStyle.ICON_APP.getImage());
        this.frame.setContentPane(mainPanel);
        this.frame.addComponentListener(this);
        SwingWidgetUtilities.setFontOfAllComponents((Container)this.frame, (Font)MangoStyle.FONT_REGULAR, null);
        this.textScriptArea.setFont(new Font("Monospaced", 0, 12));
        this.textOutputArea.setFont(new Font("Monospaced", 0, 12));
        this.mango.getToolBox().associateWindow(this);
        this.updateMiniMode();
        if (this.viewer != null) {
            this.frame.setLocation(DisplayUtils.getNextWindowLocation(this.viewer.getViewerContainer(), this.frame.getSize(), null, Platform.isApplet()));
        } else {
            this.frame.setLocation(DisplayUtils.getCenterDialogLocation(this.mango.getToolBox(), this.frame.getSize()));
        }
        this.frame.setVisible(true);
        this.recordButton.setPreferredSize(new Dimension(this.recordButton.getPreferredSize().width, this.recordButton.getPreferredSize().height));
        this.recordButton.setMinimumSize(new Dimension(this.recordButton.getPreferredSize().width, this.recordButton.getPreferredSize().height));
        this.recordButton.setMaximumSize(new Dimension(this.recordButton.getPreferredSize().width, this.recordButton.getPreferredSize().height));
        this.scriptSelectBox.requestFocusInWindow();
        this.textScriptArea.requestFocusInWindow();
        this.addAllClasses();
        if (this.findScripts(false)) {
            this.scriptSelected();
        } else {
            this.makeNewScript();
        }
        this.makeHelpPopupMenu();
        this.makeMethodPopupMenu();
        this.updateEnabledItems();
        this.writeToOutputArea(PROMPT);
    }

    private void deleteFile() {
        int result = JOptionPane.showConfirmDialog(this.frame, "Are you sure you wish to delete this script?", "Delete Confirmation", 2);
        if (result == 0) {
            File currentScriptFile = this.makeCurrentScriptFile(this.scriptSelectBox.getEditor().getItem().toString());
            FileUtilities.delete((File)currentScriptFile);
            if (this.findScripts(true)) {
                this.scriptSelected();
            } else {
                this.makeNewScript();
            }
            this.scriptSelected();
            Mango.getInstance().updateScripts();
        }
    }

    private void executeCommand() {
        try {
            String command = this.getLastLine();
            this.writeToOutputArea("\n");
            if (StringUtils.isNotBlank((CharSequence)command)) {
                if (this.interp == null) {
                    this.resetInterpreter();
                }
                this.interp.exec(command);
            }
            this.writeToOutputArea(PROMPT);
        }
        catch (BadLocationException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (PyException ex) {
            this.writeToOutputArea("Error: " + ex.toString() + PROMPT);
        }
    }

    private void exportFile() {
        File fileSrc = this.makeCurrentScriptFile(this.scriptSelectBox.getEditor().getItem().toString());
        File fileDest = SaveFileDialog.showSaveFileChooser(this.frame, Platform.getHomeDirectory(), fileSrc.getName());
        if (fileDest != null) {
            try {
                FileUtils.writeStringToFile((File)fileDest, (String)this.textScriptArea.getText());
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    private JTextArea findFocusedTextArea(JTextArea defaultTextArea) {
        Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (comp instanceof JTextArea) {
            return (JTextArea)comp;
        }
        return defaultTextArea;
    }

    private boolean findScripts(boolean deleting) {
        File[] scriptFiles;
        this.freezeUpdate = true;
        Object currentSelection = this.scriptSelectBox.getEditor().getItem();
        this.scriptSelectBox.removeAllItems();
        for (File file : scriptFiles = ScriptManager.findScriptFiles()) {
            this.scriptSelectBox.addItem(FileUtilities.removeExtension((String)file.getName()));
        }
        if (!deleting && currentSelection != null && StringUtils.isNotBlank((CharSequence)currentSelection.toString())) {
            this.scriptSelectBox.getEditor().setItem(currentSelection);
        } else {
            this.scriptSelectBox.getEditor().setItem(this.scriptSelectBox.getItemAt(0));
        }
        this.freezeUpdate = false;
        return this.scriptSelectBox.getItemCount() > 0;
    }

    private String findSelectedVariable(int dot, int mark) {
        String source = this.textScriptArea.getText();
        int length = source.length();
        int start = Math.min(dot, mark);
        int end = Math.max(dot, mark);
        if (start < length) {
            char character;
            String testString = source.substring(start, end);
            for (int ctr = 0; ctr < testString.length(); ++ctr) {
                if (!Character.isWhitespace(testString.charAt(ctr))) continue;
                return null;
            }
            while (start > 0 && (Character.isLetterOrDigit(character = source.charAt(start)) || character == '_' || character == '.')) {
                --start;
            }
            while (end < length && (Character.isLetterOrDigit(character = source.charAt(end)) || character == '_')) {
                ++end;
            }
            if (start < end) {
                return source.substring(start + 1, end).trim();
            }
        }
        return null;
    }

    private Class<?> getClassOfSelectedVariable(String var) {
        Class<?> klass = null;
        String[] parts = StringUtils.split((String)var, (char)'.');
        if (CollectionUtilities.isNotEmpty((Object)parts)) {
            String baseClass = null;
            int index = parts[0].lastIndexOf(95);
            if (index != -1 && StringUtils.isNotBlank((CharSequence)(baseClass = parts[0].substring(0, index))) && (klass = API.get(baseClass)) != null && parts.length > 1) {
                for (int ctr = 1; ctr < parts.length; ++ctr) {
                    PropertyDescriptor[] descriptors;
                    if (klass == null) continue;
                    BeanInfo beanInfo = BeanHelper.getBeanInfo(klass);
                    for (PropertyDescriptor pd : descriptors = beanInfo.getPropertyDescriptors()) {
                        String name = pd.getName();
                        if (!parts[ctr].equals(name)) continue;
                        klass = pd.getPropertyType();
                    }
                }
            }
        }
        return klass;
    }

    private String getLastLine() throws BadLocationException {
        int last = this.textOutputArea.getLineCount() - 1;
        int start = this.textOutputArea.getLineStartOffset(last);
        int end = this.textOutputArea.getLineEndOffset(last);
        String str = this.textOutputArea.getText().substring(start, end);
        if (str.startsWith(PROMPT)) {
            return str.substring(PROMPT.length()).trim();
        }
        return str.trim();
    }

    private void importFile() {
        File fileSrc = OpenFileDialog.showOpenFileChooser(this.frame, Platform.getHomeDirectory(), new String[]{EXTENSION}, "Script Files");
        if (fileSrc != null) {
            File fileDest = new File(Platform.getScriptsDir(), fileSrc.getName());
            try {
                int index = 2;
                while (fileDest.exists()) {
                    fileDest = new File(Platform.getScriptsDir(), FileUtilities.removeExtension((String)fileSrc.getName()) + " (" + index++ + ")" + EXTENSION);
                }
                FileUtils.copyFile((File)fileSrc, (File)fileDest);
                this.findScripts(true);
                String scriptName = FileUtilities.removeExtension((String)fileDest.getName());
                this.scriptSelectBox.setSelectedItem(scriptName);
                this.scriptSelected();
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    private void initializeSnippets() {
        Set<String> snippets = Snippets.SNIPPETS.keySet();
        for (String snippet : snippets) {
            this.snippetBox.addItem(snippet);
        }
    }

    private void initializeInputs() {
        for (String sig : UserInput.INPUTS_SIGNATURES) {
            this.inputBox.addItem(sig);
        }
    }

    private String makeCurrentFieldDescription() {
        StringBuffer sb = new StringBuffer();
        String fieldName = null;
        fieldName = StringUtils.isNotBlank((CharSequence)this.selectedVariable) ? this.selectedVariable : (this.classBox.getSelectedItem().toString().equals(M_VOLMAN) && this.viewer != null ? this.viewer.getScriptObjectName() : (this.classBox.getSelectedItem().toString().equals(M_CTX) ? M_CTX_CONTEXT : "?"));
        sb.append(fieldName).append('.').append(this.fieldBox.getSelectedItem().toString());
        return sb.toString();
    }

    private File makeCurrentScriptFile(String name) {
        return new File(Platform.getScriptsDir(), name + EXTENSION);
    }

    private void makeMethodPopupMenu() {
        this.popup = new JPopupMenu();
        JMenuItem withDialogMenuItem = new JMenuItem(ACTION_WITH_DIALOGS);
        withDialogMenuItem.setActionCommand(ACTION_WITH_DIALOGS);
        withDialogMenuItem.addActionListener(this);
        this.popup.add(withDialogMenuItem);
        JMenuItem withoutDialogMenuItem = new JMenuItem(ACTION_WITHOUT_DIALOGS);
        withoutDialogMenuItem.setActionCommand(ACTION_WITHOUT_DIALOGS);
        withoutDialogMenuItem.addActionListener(this);
        this.popup.add(withoutDialogMenuItem);
        this.popup.addPopupMenuListener(this);
    }

    private void makeHelpPopupMenu() {
        this.popupHelp = new JPopupMenu();
        JMenuItem helpTutorial = new JMenuItem(ACTION_HELP_TUTORIAL);
        helpTutorial.setActionCommand(ACTION_HELP_TUTORIAL);
        helpTutorial.addActionListener(this);
        this.popupHelp.add(helpTutorial);
        JMenuItem helpExamples = new JMenuItem(ACTION_HELP_EXAMPLES);
        helpExamples.setActionCommand(ACTION_HELP_EXAMPLES);
        helpExamples.addActionListener(this);
        this.popupHelp.add(helpExamples);
        JMenuItem helpAPI = new JMenuItem(ACTION_HELP_API);
        helpAPI.setActionCommand(ACTION_HELP_API);
        helpAPI.addActionListener(this);
        this.popupHelp.add(helpAPI);
        this.popupHelp.addPopupMenuListener(this);
    }

    private void makeNewScript() {
        this.scriptSelectBox.getEditor().setItem(DEFAULT_NAME);
        this.scriptSelectBox.setSelectedItem(DEFAULT_NAME);
        this.textScriptArea.setText("# This script is written in Python (Jython implementation 2.5.3)\n");
        this.textScriptArea.append("# See the Help menu for tutorials, example scripts and API\n");
        this.textScriptArea.append("#   m_Mango_mango (class m_Mango) represents the application\n");
        if (this.viewer != null) {
            this.textScriptArea.append("#   m_VolMan_manager (class m_VolMan) represents this viewer\n");
        }
        this.textScriptArea.append("# Select a class in the API guide below to view its properties and methods\n");
        this.textScriptArea.append("\n");
        this.resetVariables();
        this.classSelected();
        this.updateMethods();
        this.updateEnabledItems();
    }

    private String makeUserInputSignature(Method method, String[] args, boolean forceNeedsUserInput) {
        return "(" + UserInput.makeUserInputString(this.viewer, method, args, forceNeedsUserInput, !this.recordWithDialogs) + ")";
    }

    private void parseScript(File file) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        List scriptLines = FileUtils.readLines((File)file);
        StringBuffer scriptTextBuffer = new StringBuffer();
        this.freezeUpdate = true;
        for (String line : scriptLines) {
            scriptTextBuffer.append(line);
            scriptTextBuffer.append('\n');
        }
        this.textScriptArea.setText(scriptTextBuffer.toString());
        this.clearOutputArea();
        this.updateVariableOptions();
    }

    private void record() {
        ScriptManager.setVariablesNames(this.viewer);
        this.startRecording();
    }

    private void recordWithDialogs() {
        this.recordWithDialogs = true;
        this.record();
    }

    private void recordWithoutDialogs() {
        this.recordWithDialogs = false;
        this.record();
    }

    private void resetInterpreter() {
        this.interp = ScriptManager.makeInterpreter();
        this.interp.setOut((OutputStream)new TextAreaOutputStream(this.textOutputArea, PROMPT));
        this.interp.setErr((OutputStream)new TextAreaOutputStream(this.textOutputArea, PROMPT));
    }

    private void resetVariables() {
        this.updateVariableOptions();
    }

    private void runScript(final MangoContext ctx, final VolumeManager manager) {
        this.clearOutputArea();
        this.writeToOutputArea(">>> Running " + this.scriptSelectBox.getEditor().getItem().toString() + "...\n");
        this.scriptThread = new Thread(){

            @Override
            public void run() {
                ProgressMeter progress = ctx.makeProgressMeter();
                progress.start(0, 0, 100);
                progress.setIndeterminateMode(true);
                try {
                    ScriptManager.this.resetInterpreter();
                    ScriptManager.addUserInputFunctions(ScriptManager.this.interp);
                    ScriptManager.addVariables(ScriptManager.this.interp, ctx, manager);
                    isPlaying = true;
                    ScriptManager.this.updateEnabledItems();
                    ScriptManager.this.interp.exec(ScriptManager.this.textScriptArea.getText());
                    ScriptManager.showDoneScriptMessage();
                }
                catch (PyException ex) {
                    AppLogger.error((String)ex.toString());
                    ScriptManager.this.writeToOutputArea("Error: " + (Object)((Object)ex) + "\n");
                }
                finally {
                    ScriptManager.this.writeToOutputArea(ScriptManager.PROMPT);
                    progress.setIndeterminateMode(false);
                    progress.setValue(progress.getMax());
                    isPlaying = false;
                    ScriptManager.this.updateEnabledItems();
                }
            }
        };
        this.scriptThread.start();
    }

    private void saveFile() {
        try {
            String name = this.validateSaveName(this.scriptSelectBox.getEditor().getItem().toString());
            File currentScriptFile = this.makeCurrentScriptFile(name);
            FileUtils.write((File)currentScriptFile, (CharSequence)this.textScriptArea.getText());
            this.findScripts(false);
            this.scriptSelected();
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        Mango.getInstance().updateScripts();
    }

    private void scriptSelected() {
        this.freezeUpdate = true;
        this.resetVariables();
        try {
            File currentScriptFile = this.makeCurrentScriptFile(this.scriptSelectBox.getEditor().getItem().toString());
            if (currentScriptFile.exists()) {
                this.scriptSelectBox.setSelectedItem(this.scriptSelectBox.getEditor().getItem().toString());
                this.parseScript(currentScriptFile);
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (InstantiationException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            AppLogger.error((Throwable)ex);
        }
        this.freezeUpdate = false;
        this.classSelected();
        this.updateMethods();
        this.updateEnabledItems();
    }

    private void startRecording() {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                isRecording = true;
                ScriptManager.this.updateEnabledItems();
            }
        });
    }

    private void stopRecording() {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                isRecording = false;
                ScriptManager.this.updateEnabledItems();
            }
        });
    }

    private void updateEnabledItems() {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                File currentScriptFile = ScriptManager.this.makeCurrentScriptFile(ScriptManager.this.scriptSelectBox.getEditor().getItem().toString());
                ScriptManager.this.deleteButton.setEnabled(currentScriptFile.exists());
                ScriptManager.this.recordButton.setEnabled(!isPlaying);
                ScriptManager.this.recordButton.setIcon(isRecording ? MangoStyle.ICON_RECORD : MangoStyle.ICON_RECORD_DISABLED);
                ScriptManager.this.recordButton.setText(isRecording ? " Stop" : "Record");
                ScriptManager.this.runButton.setEnabled(!isRecording);
                ScriptManager.this.runButton.setIcon(isPlaying ? MangoStyle.ICON_STOP : MangoStyle.ICON_PLAY);
                ScriptManager.this.exportButton.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.importButton.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.saveButton.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.deleteButton.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.newScriptButton.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.scriptSelectBox.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.classBox.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.methodsBox.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.fieldBox.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.inputBox.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.snippetBox.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.textOutputArea.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.textScriptArea.setEnabled(!isRecording);
                ScriptManager.this.addMethodButton.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.addVariableButton.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.addFieldButton.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.addInputButton.setEnabled(!isRecording && !isPlaying);
                ScriptManager.this.addSnippetButton.setEnabled(!isRecording && !isPlaying);
                if (isPlaying) {
                    ScriptManager.this.frame.setTitle("Script Manager (Playing)");
                } else if (isRecording) {
                    ScriptManager.this.frame.setTitle("Script Manager (Recording)");
                } else {
                    ScriptManager.this.frame.setTitle(ScriptManager.TITLE);
                }
            }
        });
    }

    private void updateFieldBoxSizes() {
    }

    private void updateMethods() {
        this.freezeUpdate = true;
        this.methodsBox.removeAllItems();
        this.methodsBox.setEnabled(true);
        ArrayList<ScriptMethod> methodList = new ArrayList<ScriptMethod>();
        Class<?> fieldType = ((ScriptClass)this.classBox.getSelectedItem()).getType();
        Method[] methods = fieldType.getDeclaredMethods();
        for (Method method : methods) {
            Deprecated annotation = method.getAnnotation(Deprecated.class);
            if (annotation != null) continue;
            ScriptMethod scriptMethod = this.makeScriptMethod(method, null, false);
            String fieldName = null;
            fieldName = StringUtils.isNotBlank((CharSequence)this.selectedVariable) ? this.selectedVariable : (this.classBox.getSelectedItem().toString().equals(M_CTX) ? M_CTX_CONTEXT : (this.classBox.getSelectedItem().toString().equals(M_VOLMAN) && this.viewer != null ? this.viewer.getScriptObjectName() : "?"));
            scriptMethod.setVariableName(fieldName);
            methodList.add(scriptMethod);
        }
        Collections.sort(methodList);
        for (ScriptMethod scriptMethod : methodList) {
            this.methodsBox.addItem(scriptMethod);
        }
        this.freezeUpdate = false;
    }

    private void updateMiniMode() {
        this.managementPanelBottom.setVisible(!this.miniMode);
        this.textPanel.setVisible(!this.miniMode);
        this.bottomPanel.setVisible(!this.miniMode);
        this.helpButton.setVisible(!this.miniMode);
        if (this.miniMode) {
            this.frame.setResizable(false);
            this.managementPanel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        } else {
            this.frame.setResizable(true);
            this.managementPanel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        }
        this.editButton.setSelected(!this.miniMode);
        this.splitPane.setDividerLocation(0.75);
        this.frame.validate();
        this.frame.pack();
    }

    private void updateVariableOptions() {
        boolean foundVariables = this.classBox.getItemCount() > 0;
        this.classBox.setVisible(foundVariables);
        this.addVariableButton.setVisible(foundVariables);
    }

    private String validateSaveName(String name) {
        String nameValidated = name;
        if (nameValidated.indexOf(EXTENSION) != -1) {
            nameValidated = nameValidated.substring(0, nameValidated.indexOf(EXTENSION));
        }
        if (StringUtils.isBlank((CharSequence)nameValidated)) {
            nameValidated = DEFAULT_NAME;
        }
        return nameValidated;
    }

    private void writeToOutputArea(final String str) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                ((AbstractDocument)ScriptManager.this.textOutputArea.getDocument()).setDocumentFilter(null);
                ScriptManager.this.textOutputArea.append(str);
                ((AbstractDocument)ScriptManager.this.textOutputArea.getDocument()).setDocumentFilter(new CommandFilter(ScriptManager.PROMPT));
            }
        });
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
        this.deassociateWindow();
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    static {
        EXCLUDED_FIELDS = CollectionUtilities.immutable((String[])new String[]{"class"});
        RECORD_ANIMATION_FRAME = CollectionUtilities.immutable((String[])new String[]{"|", "/", "-", "\\"});
        API = new TreeMap();
        DEFAULT_VOLMAN_MANAGER = "m_VolMan_manager";
        API.put(M_CTX, MangoContext.class);
        API.put("m_Stat", Analysis.class);
        API.put("m_StatPoint", AnalysisPoint.class);
        API.put("m_Coord", Coordinate.class);
        API.put("m_Coord4D", Coordinate4D.class);
        API.put("m_Bounds", ImageBounds.class);
        API.put("m_Des", ImageDescription.class);
        API.put("m_ImageDims", ImageDimensions.class);
        API.put("m_VoxelDims", VoxelDimensions.class);
        API.put("m_Range", ImageRange.class);
        API.put("m_ROIData", ROIData.class);
        API.put("m_Vol", ImageVolume.class);
        API.put("m_Hist", Histogram.class);
        API.put("m_Surf", Surface.class);
        API.put("m_SurfShape", Shape.class);
        API.put(M_VOLMAN, VolumeManager.class);
        API.put("m_SurfMan", SurfaceManager.class);
        API.put("m_ProjMan", ProjectionManager.class);
        API.put("m_ROI", ROI.class);
        API.put("m_Atlas", Atlas.class);
        API.put("m_Cluster", Cluster.class);
        API.put("m_Transform", ImageTransform.class);
        API.put("m_ImageType", ImageType.class);
        API.put("m_ROILine", Line.class);
        API.put("m_ROIPoint", Point.class);
        API.put("m_ROIMask", ROIMaskBuffer.class);
    }
}

