/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.modal.utilities;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.MangoDropDownButton;
import edu.uthscsa.ric.mango.dialogs.modal.file.OpenFileDialog;
import edu.uthscsa.ric.mango.dialogs.modal.utilities.CommandLineUtility;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.io.FileUtils;

public class InstallUtilitiesDialog
extends JPanel
implements ActionListener,
PopupMenuListener {
    private JButton installButton;
    private JButton showButton;
    private JPopupMenu popup;
    private String jarLocation;
    private boolean addedNewLine;
    private long popupTimeCanceled;
    private JScrollBar scrollBar;
    private JTextArea textArea;
    private JTextField binDir;
    private JCheckBox mangoBox;
    private final Vector<CommandLineUtility> allUtilities = new Vector();
    private static final String MANGO_BIN = "MANGOBIN";
    private static final String[] WINDOWS_MANGO_PATH = new String[]{"setx", "MANGOBIN", ""};
    private static final String[] WINDOWS_PATH = new String[]{"setx", "PATH", "\"%PATH%;%MANGOBIN%\""};
    private static final long serialVersionUID = 1L;
    public static final List<String> DEFAULT_UTILITY_CLASSES = CollectionUtilities.immutable((String[])new String[]{"edu.uthscsa.ric.cli.applytransform.ApplyTransform", "edu.uthscsa.ric.cli.convert2avw.Convert2AVW", "edu.uthscsa.ric.cli.convert2des.Convert2NEMA", "edu.uthscsa.ric.cli.convert2dcm.Convert2DCM", "edu.uthscsa.ric.cli.convert2nii.Convert2NIFTI", "edu.uthscsa.ric.cli.imageinfo.ImageInfo", "edu.uthscsa.ric.mango.MangoClient", "edu.uthscsa.ric.cli.newmat.Newmat", "edu.uthscsa.ric.cli.groupvolumes.GroupVolumes", "edu.uthscsa.ric.cli.makeroi.CreateROI", "edu.uthscsa.ric.cli.script.MangoScript"});
    public static final List<String> DEFAULT_UTILITY_NAMES = CollectionUtilities.immutable((String[])new String[]{"applytransform", "convert2avw", "convert2des", "convert2dcm", "convert2nii", "imageinfo", "mango", "resizer", "vols2series", "makeroi", "script"});
    public static final String DEFAULT_BIN_PATH = "bin";
    public static final String MANGO_BIN_BASH_PATH = "PATH=${MANGOBIN}:${PATH}; export PATH";
    public static final String MANGO_BIN_CSH_PATH = "setenv PATH ${MANGOBIN}:${PATH}";
    public static final String MEM_ARGS = "-Djava.awt.headless=true -Xms64M -Xmx512M -XX:MaxDirectMemorySize=1536M";
    public static final String PROXY_CLASS = "edu.uthscsa.ric.cli.Proxy";
    public static final String UNIX_ALL_ARGS = "\"$@\"";
    public static final String UNIX_SHELL_HEADER = "#!/bin/bash";
    public static final String WINDOWS_ALL_ARGS = "%*";
    public static final String WINDOWS_BATCH_EXT = ".bat";
    public static final String WINDOWS_BATCH_HEADER = "@ echo off";
    public static final String TEXT_TO = " to ";
    public static final String TEXT_BACKING_UP = "Backing up ";
    public static final String TEXT_EDITING = "Editing ";
    public static final String ACTION_SHOW = "show";
    public static final String TEXT_ERROR = "Error: ";
    public static final String MANGO_PREFIX = "mango-";

    private static String addToPath(String dir) {
        if (Platform.WINDOWS) {
            return InstallUtilitiesDialog.addToPathWindows(dir);
        }
        return InstallUtilitiesDialog.addToPathUnix(dir);
    }

    private static String addToPathUnix(String dir) {
        File file;
        StringBuffer sb = new StringBuffer(128);
        File userHome = new File(Platform.getHomeDirectory());
        File location = new File(dir);
        File bashProfile = new File(userHome.toString(), ".bash_profile");
        File bashrc = new File(userHome.toString(), ".bashrc");
        File bashLogin = new File(userHome.toString(), ".bash_login");
        File profile = new File(userHome.toString(), ".profile");
        File cshrc = new File(userHome.toString(), ".cshrc");
        File tcshrc = new File(userHome.toString(), ".tcshrc");
        File login = new File(userHome.toString(), ".login");
        boolean hasBashProfile = bashProfile.exists();
        boolean hasBashRc = bashrc.exists();
        boolean hasBashLogin = bashLogin.exists();
        boolean hasProfile = profile.exists();
        boolean hasCshrc = cshrc.exists();
        boolean hasTcshrc = tcshrc.exists();
        boolean hasLogin = login.exists();
        sb.append("Updating BASH initialization files...\n");
        if (hasBashProfile) {
            file = InstallUtilitiesDialog.backupFile(bashProfile, sb);
            InstallUtilitiesDialog.appendToFile(bashProfile, location, MANGO_BIN_BASH_PATH, sb);
            sb.append(TEXT_BACKING_UP + bashProfile.toString() + TEXT_TO + file.toString() + "\n");
            sb.append(TEXT_EDITING + bashProfile.toString() + "\n");
        } else if (hasBashLogin) {
            file = InstallUtilitiesDialog.backupFile(bashLogin, sb);
            InstallUtilitiesDialog.appendToFile(bashLogin, location, MANGO_BIN_BASH_PATH, sb);
            sb.append(TEXT_BACKING_UP + bashLogin.toString() + TEXT_TO + file.toString() + "\n");
            sb.append(TEXT_EDITING + bashLogin.toString() + "\n");
        } else if (hasProfile) {
            file = InstallUtilitiesDialog.backupFile(profile, sb);
            InstallUtilitiesDialog.appendToFile(profile, location, MANGO_BIN_BASH_PATH, sb);
            sb.append(TEXT_BACKING_UP + profile.toString() + TEXT_TO + file.toString() + "\n");
            sb.append(TEXT_EDITING + profile.toString() + "\n");
        } else {
            InstallUtilitiesDialog.appendToFile(bashProfile, location, MANGO_BIN_BASH_PATH, sb);
            sb.append("Initialization files were not found: " + bashProfile.toString() + " " + bashLogin.toString() + " " + profile.toString() + "\n");
            sb.append("Writing " + bashProfile.toString() + "\n");
        }
        if (hasBashRc) {
            file = InstallUtilitiesDialog.backupFile(bashrc, sb);
            InstallUtilitiesDialog.appendToFile(bashrc, location, MANGO_BIN_BASH_PATH, sb);
            sb.append(TEXT_BACKING_UP + bashrc.toString() + TEXT_TO + file.toString() + "\n");
            sb.append(TEXT_EDITING + bashrc.toString() + "\n");
        } else {
            InstallUtilitiesDialog.appendToFile(bashrc, location, MANGO_BIN_BASH_PATH, sb);
            sb.append("Writing " + bashrc.toString() + "\n");
        }
        sb.append("Updating C-shell initialization files...\n");
        if (hasTcshrc) {
            file = InstallUtilitiesDialog.backupFile(tcshrc, sb);
            InstallUtilitiesDialog.appendToFile(tcshrc, location, MANGO_BIN_CSH_PATH, sb);
            sb.append(TEXT_BACKING_UP + tcshrc.toString() + TEXT_TO + file.toString() + "\n");
            sb.append(TEXT_EDITING + tcshrc.toString() + "\n");
        } else if (hasCshrc) {
            file = InstallUtilitiesDialog.backupFile(cshrc, sb);
            InstallUtilitiesDialog.appendToFile(cshrc, location, MANGO_BIN_CSH_PATH, sb);
            sb.append(TEXT_BACKING_UP + cshrc.toString() + TEXT_TO + file.toString() + "\n");
            sb.append(TEXT_EDITING + cshrc.toString() + "\n");
        } else if (hasLogin) {
            file = InstallUtilitiesDialog.backupFile(login, sb);
            InstallUtilitiesDialog.appendToFile(login, location, MANGO_BIN_CSH_PATH, sb);
            sb.append(TEXT_BACKING_UP + login.toString() + TEXT_TO + file.toString() + "\n");
            sb.append(TEXT_EDITING + login.toString() + "\n");
        } else {
            InstallUtilitiesDialog.appendToFile(cshrc, location, MANGO_BIN_CSH_PATH, sb);
            sb.append("Initialization files were not found: " + tcshrc.toString() + " " + cshrc.toString() + " " + login.toString() + "\n");
            sb.append("Writing " + cshrc.toString() + "\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String addToPathWindows(String dir) {
        StringBuffer sb = new StringBuffer(24);
        BufferedReader br = null;
        try {
            String line;
            InstallUtilitiesDialog.WINDOWS_MANGO_PATH[2] = "\"" + dir + "\"";
            Process process = new ProcessBuilder(WINDOWS_MANGO_PATH).start();
            br = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            process = new ProcessBuilder(WINDOWS_PATH).start();
            br = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            sb.append("Successfully added path.");
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            sb.append(TEXT_ERROR + ex.getMessage());
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendToFile(File shellFile, File binDir, String lineVal, StringBuffer sb) {
        String line = lineVal;
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new BufferedWriter(new FileWriter(shellFile, true)));
            if (line.equals(MANGO_BIN_BASH_PATH)) {
                line = "MANGOBIN=" + binDir.toString() + "; " + line;
            } else if (line.equals(MANGO_BIN_CSH_PATH)) {
                line = "setenv MANGOBIN " + binDir.toString() + "; " + line;
            }
            writer.println();
            writer.println(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File backupFile(File file, StringBuffer sb) {
        BufferedReader reader = null;
        PrintWriter writer = null;
        File backupFile = new File(file.getParent(), file.getName() + ".backup");
        int ctr = 2;
        while (backupFile.exists()) {
            backupFile = new File(file.getParent(), file.getName() + ".backup" + ctr);
            ++ctr;
        }
        try {
            reader = new BufferedReader(new FileReader(file));
            writer = new PrintWriter(new BufferedWriter(new FileWriter(backupFile)));
            String line = reader.readLine();
            while (line != null) {
                writer.println(line);
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            sb.append(TEXT_ERROR + ex.getMessage() + "\n");
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
            if (writer != null) {
                writer.close();
            }
        }
        return backupFile;
    }

    private static String findPath() {
        return InstallUtilitiesDialog.findPath(true);
    }

    private static String findPath(boolean useDefault) {
        if (Platform.WINDOWS) {
            return InstallUtilitiesDialog.findPathWindows(useDefault);
        }
        return InstallUtilitiesDialog.findPathUnix(useDefault);
    }

    private static String findPathUnix(boolean useDefault) {
        File userHome = new File(Platform.getHomeDirectory());
        File bashProfile = new File(userHome.toString(), ".bash_profile");
        File bashrc = new File(userHome.toString(), ".bashrc");
        File bashLogin = new File(userHome.toString(), ".bash_login");
        File profile = new File(userHome.toString(), ".profile");
        File cshrc = new File(userHome.toString(), ".cshrc");
        File tcshrc = new File(userHome.toString(), ".tcshrc");
        File login = new File(userHome.toString(), ".login");
        boolean hasBashProfile = bashProfile.exists();
        boolean hasBashRc = bashrc.exists();
        boolean hasBashLogin = bashLogin.exists();
        boolean hasProfile = profile.exists();
        boolean hasCshrc = cshrc.exists();
        boolean hasTcshrc = tcshrc.exists();
        boolean hasLogin = login.exists();
        try {
            String path;
            if (hasBashProfile) {
                String path2 = InstallUtilitiesDialog.parseMangoBinPath(FileUtils.readFileToString((File)bashProfile));
                if (path2 != null) {
                    return path2;
                }
            } else if (hasBashLogin) {
                String path3 = InstallUtilitiesDialog.parseMangoBinPath(FileUtils.readFileToString((File)bashLogin));
                if (path3 != null) {
                    return path3;
                }
            } else if (hasProfile) {
                String path4 = InstallUtilitiesDialog.parseMangoBinPath(FileUtils.readFileToString((File)profile));
                if (path4 != null) {
                    return path4;
                }
            } else if (hasBashRc) {
                String path5 = InstallUtilitiesDialog.parseMangoBinPath(FileUtils.readFileToString((File)bashrc));
                if (path5 != null) {
                    return path5;
                }
            } else if (hasTcshrc) {
                String path6 = InstallUtilitiesDialog.parseMangoBinPath(FileUtils.readFileToString((File)tcshrc));
                if (path6 != null) {
                    return path6;
                }
            } else if (hasCshrc) {
                String path7 = InstallUtilitiesDialog.parseMangoBinPath(FileUtils.readFileToString((File)cshrc));
                if (path7 != null) {
                    return path7;
                }
            } else if (hasLogin && (path = InstallUtilitiesDialog.parseMangoBinPath(FileUtils.readFileToString((File)login))) != null) {
                return path;
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        if (useDefault) {
            return InstallUtilitiesDialog.getDefaultPath().toString();
        }
        return null;
    }

    private static String findPathWindows(boolean useDefault) {
        File file;
        String mangobin = System.getenv(MANGO_BIN);
        if (mangobin != null && (file = new File(mangobin)).exists()) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        if (useDefault) {
            return InstallUtilitiesDialog.getDefaultPath().toString();
        }
        return null;
    }

    private static File getDefaultPath() {
        return new File(Platform.getHomeDirectory(), DEFAULT_BIN_PATH);
    }

    private static String parseMangoBinPath(String str) {
        int end;
        int start;
        String testPath;
        File file;
        String path = null;
        int index = str.indexOf(MANGO_BIN);
        if (index != -1 && (file = new File(testPath = str.substring(start = str.indexOf(61, index) + 1, end = str.indexOf(59, start)))).exists()) {
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String showProgram(File dir, String processName) {
        StringBuffer sb = new StringBuffer();
        File processFile = new File(dir, processName);
        if (!processFile.exists()) {
            sb.append("Error: This file was not found: " + processFile + "\n");
        } else {
            sb.append(processFile.toString());
            sb.append('\n');
            BufferedReader br = null;
            try {
                String line;
                Process process = new ProcessBuilder(processFile.toString()).start();
                br = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
                sb.append(TEXT_ERROR + ex.getMessage() + "\n");
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String writeFile(File dir, String name, String args, String className, String jarLoc, String proxyClass) {
        String message = "";
        File file = new File(dir.toString(), name);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            if (Platform.WINDOWS) {
                writer.print(WINDOWS_BATCH_HEADER);
            } else {
                writer.print(UNIX_SHELL_HEADER);
            }
            writer.println();
            if (Platform.WINDOWS) {
                writer.print("\"" + System.getProperty("java.home") + "/bin/java.exe\" " + args + " -cp \"" + jarLoc + "\" " + className + " " + (proxyClass != null ? proxyClass + " " : "") + WINDOWS_ALL_ARGS);
            } else {
                writer.print(System.getProperty("java.home") + "/bin/java " + args + " -cp \"" + jarLoc + "\" " + className + " " + (proxyClass != null ? proxyClass + " " : "") + UNIX_ALL_ARGS);
            }
            writer.println();
            message = message + "Wrote file " + file.toString() + "\n";
        }
        try {
            if (Platform.MAC || Platform.UNIX) {
                Runtime.getRuntime().exec("chmod 755 " + file.toString());
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            message = message + "Error: (Permissions error) " + ex.getMessage() + "\n";
        }
        return message;
    }

    public InstallUtilitiesDialog() {
        this.makeAllUtilities();
        if (Platform.MAC) {
            this.jarLocation = Platform.getJarDirectory() + "/Mango.jar";
        } else if (Platform.WINDOWS) {
            String jarWindows = Platform.getJarDirectory() + "\\Mango.jar";
            this.jarLocation = jarWindows = jarWindows.replaceAll("\\\\", "\\\\\\\\");
        } else if (Platform.UNIX) {
            this.jarLocation = Platform.getJarDirectory() + "/Mango.jar";
        }
        this.createUI();
    }

    private void createUI() {
        this.textArea = new JTextArea(20, 40);
        this.textArea.setMaximumSize(this.textArea.getPreferredSize());
        this.textArea.setEditable(false);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        JScrollPane scroller = new JScrollPane(this.textArea);
        this.scrollBar = scroller.getVerticalScrollBar();
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                if (InstallUtilitiesDialog.this.addedNewLine) {
                    InstallUtilitiesDialog.this.scrollBar.setValue(InstallUtilitiesDialog.this.scrollBar.getMaximum() - InstallUtilitiesDialog.this.scrollBar.getVisibleAmount());
                    InstallUtilitiesDialog.this.addedNewLine = false;
                }
            }
        });
        JLabel binDirLabel = new JLabel("Location: ");
        this.binDir = new JTextField(InstallUtilitiesDialog.findPath(), 15);
        this.binDir.setMaximumSize(this.binDir.getPreferredSize());
        JButton openFile = new JButton("Select Directory...");
        openFile.setActionCommand("file");
        openFile.addActionListener(this);
        this.mangoBox = new JCheckBox("Add prefix");
        this.mangoBox.setSelected(true);
        this.mangoBox.setActionCommand("prefix");
        this.mangoBox.addActionListener(this);
        JButton bashButton = new JButton("Add To Path");
        bashButton.setActionCommand("path");
        bashButton.addActionListener(this);
        JPanel binDirPanel = new JPanel();
        binDirPanel.setLayout(new BoxLayout(binDirPanel, 0));
        binDirPanel.add(Box.createHorizontalStrut(4));
        binDirPanel.add(binDirLabel);
        binDirPanel.add(this.binDir);
        binDirPanel.add(Box.createHorizontalStrut(2));
        binDirPanel.add(this.mangoBox);
        binDirPanel.add(Box.createHorizontalStrut(2));
        binDirPanel.add(openFile);
        binDirPanel.add(Box.createHorizontalStrut(4));
        binDirPanel.add(bashButton);
        binDirPanel.add(Box.createHorizontalStrut(4));
        JPanel textAreaPanel = new JPanel();
        textAreaPanel.setLayout(new BoxLayout(textAreaPanel, 0));
        textAreaPanel.add(scroller);
        this.setLayout(new BoxLayout(this, 1));
        this.add(textAreaPanel);
        this.add(binDirPanel);
        this.popup = new JPopupMenu();
        this.makeShowButton();
        this.makeInstallButton();
        this.makePopupMenu();
        this.printInstructions();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_SHOW)) {
            long timeSinceCancel = new Date().getTime() - this.popupTimeCanceled;
            if (timeSinceCancel > 250L) {
                this.popup.show(this.showButton, 2, 35);
            }
        } else if (command.equals("file")) {
            File selectedFile = new File(this.binDir.getText());
            selectedFile = OpenFileDialog.showOpenFolderChooser(Mango.getInstance().getToolBox(), selectedFile.toString());
            if (selectedFile != null) {
                this.binDir.setText(selectedFile.toString());
            }
        } else if (command.equals("install")) {
            this.install();
        } else if (command.indexOf(ACTION_SHOW) != -1) {
            File location = new File(this.binDir.getText());
            int index = Integer.parseInt(command.substring(4));
            this.print(InstallUtilitiesDialog.showProgram(location, this.getUtilityName(index, false)));
        } else if (command.equals("path")) {
            this.print(InstallUtilitiesDialog.addToPath(this.binDir.getText()));
        } else if (command.equals("prefix")) {
            this.makeAllUtilities();
            this.makePopupMenu();
        }
    }

    public JButton getInstallButton() {
        return this.installButton;
    }

    public JButton getShowButton() {
        return this.showButton;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
        if (pme.getSource() == this.popup) {
            this.popupTimeCanceled = new Date().getTime();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }

    private void findPluginUtilities() {
        String[] classes;
        for (String classe : classes = Mango.getPluginClasses()) {
            try {
                Class<?> theClass = Class.forName(classe);
                Method meth = theClass.getMethod("getCommandLineName", new Class[0]);
                if (meth == null) continue;
                Object obj = theClass.newInstance();
                Object name = meth.invoke(obj, new Object[0]);
                CommandLineUtility clu = new CommandLineUtility(name.toString(), PROXY_CLASS);
                clu.setProxyClass(classe);
                this.allUtilities.add(clu);
            }
            catch (ClassNotFoundException ex) {
                if (!AppLogger.isDebugEnabled()) continue;
                AppLogger.debug((String)ex.getMessage());
            }
            catch (NoSuchMethodException ex) {
                if (!AppLogger.isDebugEnabled()) continue;
                AppLogger.debug((String)ex.getMessage());
            }
            catch (SecurityException ex) {
                if (!AppLogger.isDebugEnabled()) continue;
                AppLogger.debug((String)ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                if (!AppLogger.isDebugEnabled()) continue;
                AppLogger.debug((String)ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                if (!AppLogger.isDebugEnabled()) continue;
                AppLogger.debug((String)ex.getMessage());
            }
            catch (InvocationTargetException ex) {
                if (!AppLogger.isDebugEnabled()) continue;
                AppLogger.debug((String)ex.getMessage());
            }
            catch (InstantiationException ex) {
                if (!AppLogger.isDebugEnabled()) continue;
                AppLogger.debug((String)ex.getMessage());
            }
        }
    }

    private String getUtilityName(int index, boolean forceNoPrefix) {
        String name = Platform.WINDOWS ? this.allUtilities.get(index).getScriptName() + WINDOWS_BATCH_EXT : this.allUtilities.get(index).getScriptName();
        if (this.mangoBox.isSelected() && !forceNoPrefix && !name.equals("mango")) {
            name = MANGO_PREFIX + name;
        }
        return name;
    }

    private void install() {
        File location = new File(this.binDir.getText());
        if (!location.exists()) {
            boolean success = location.mkdirs();
            if (success) {
                this.print("Created directory at " + location.toString());
            } else {
                this.print("Error: Could not create directory at " + location.toString());
                return;
            }
        }
        this.removeOldFiles(location);
        for (int ctr = 0; ctr < this.allUtilities.size(); ++ctr) {
            CommandLineUtility clu = this.allUtilities.get(ctr);
            this.print(InstallUtilitiesDialog.writeFile(location, this.getUtilityName(ctr, false), MEM_ARGS, clu.getClassName(), this.jarLocation, clu.getProxyClass()));
        }
        this.print("");
    }

    private void makeAllUtilities() {
        this.allUtilities.removeAllElements();
        for (int ctr = 0; ctr < DEFAULT_UTILITY_NAMES.size(); ++ctr) {
            CommandLineUtility clu = new CommandLineUtility(DEFAULT_UTILITY_NAMES.get(ctr), DEFAULT_UTILITY_CLASSES.get(ctr));
            this.allUtilities.add(clu);
        }
        this.findPluginUtilities();
    }

    private void makeInstallButton() {
        this.installButton = new JButton("Install");
        this.installButton.setActionCommand("install");
        this.installButton.addActionListener(this);
        this.installButton.setFocusable(false);
    }

    private void makePopupMenu() {
        this.popup.removeAll();
        for (int ctr = 0; ctr < this.allUtilities.size(); ++ctr) {
            JMenuItem mi = new JMenuItem(this.getUtilityName(ctr, false));
            mi.setActionCommand(ACTION_SHOW + ctr);
            mi.addActionListener(this);
            this.popup.add(mi);
        }
        this.popup.addPopupMenuListener(this);
    }

    private void makeShowButton() {
        this.showButton = new MangoDropDownButton("Test");
        this.showButton.setActionCommand(ACTION_SHOW);
        this.showButton.addActionListener(this);
        this.showButton.setFocusable(false);
    }

    private void print(String string) {
        this.addedNewLine = true;
        this.textArea.append(string + "\n");
    }

    private void printInstructions() {
        this.print("This tool can be used to install and update utilities for use at the command-line.  The command-line utilities can be used regardless if Mango is running.\n");
        this.print("1) In the text box below, enter an appropriate location to store the utility scripts.  By default, " + this.binDir.getText() + " is used.\n");
        this.print("2) If this location is not already in your path (or if you are not sure), click the 'Add to Path' button.\n");
        this.print("3) Click the 'Install' button to write the utility scripts to this directory.\n");
        this.print("4) Optional: click Test and select a utility script to test if installation was successful.\n");
        this.print("5) Open a new " + (Platform.WINDOWS ? "command" : "terminal") + " window.  The utilities should now be accessible to you at the command-line.\n");
    }

    private boolean oldFilesFound(File location) {
        int count = 0;
        for (int ctr = 0; ctr < this.allUtilities.size(); ++ctr) {
            File file = new File(location.toString(), this.getUtilityName(ctr, true));
            if (!file.exists()) continue;
            ++count;
        }
        return count > 3;
    }

    private void removeOldFiles(File location) {
        boolean success;
        File file;
        int ctr;
        boolean oldFilesFound = this.oldFilesFound(location);
        if (oldFilesFound) {
            for (ctr = 0; ctr < this.allUtilities.size(); ++ctr) {
                file = new File(location.toString(), this.getUtilityName(ctr, true));
                if (!file.exists()) continue;
                success = file.delete();
                if (success) {
                    this.print("Removed file " + file.toString());
                    continue;
                }
                this.print("Warning: Could not remove file " + file.toString());
            }
        }
        for (ctr = 0; ctr < this.allUtilities.size(); ++ctr) {
            file = new File(location.toString(), this.getUtilityName(ctr, false));
            if (!file.exists()) continue;
            success = file.delete();
            if (success) {
                this.print("Removed file " + file.toString());
                continue;
            }
            this.print("Warning: Could not remove file " + file.toString());
        }
    }
}

