/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.modal.headereditor;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.EditableHeader;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.ReadableHeader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class HeaderEditor
implements ActionListener {
    private final File file;
    private boolean openInMango;
    private EditableHeader editable;
    private Map<String, List<JComponent>> guiMap;
    private final SliceViewer editingViewer;
    public static final Dimension GUI_DIMENSION = new Dimension(600, 650);
    public static final int BUFFER_SIZE = 4096;
    public static final int FIELD_WIDTH = 500;
    public static final int MINIMUM_FIELD_SIZE = 50;
    public static final int PADDING = 5;
    public static final String ACTION_ANONYMIZE = "Anonymize";

    public HeaderEditor(File file, SliceViewer editingViewer) {
        this.editingViewer = editingViewer;
        this.file = file;
    }

    public ReadableHeader readFiles() throws InvalidHeaderException {
        Header header = new Header(this.file);
        return header.getReadable();
    }

    public void createUI(ReadableHeader readable) throws InvalidHeaderException {
        if (readable instanceof EditableHeader) {
            this.editable = (EditableHeader)readable;
            JScrollPane gui = null;
            Map map = null;
            JTextArea textArea = null;
            String name = this.editable.getPluginName();
            if (StringUtils.isNotBlank((CharSequence)readable.getImageDescription().getImageTypeDescription())) {
                name = name + " (" + readable.getImageDescription().getImageTypeDescription() + ")";
            }
            if (this.editable.isTextEditableHeader()) {
                textArea = new JTextArea();
                gui = this.buildTextGUI(this.file, textArea);
                textArea.setCaretPosition(0);
            } else {
                map = this.editable.getEditableFieldValues();
                Map optionsCodeMap = this.editable.getHumanReadableFieldOptions();
                this.guiMap = new HashMap<String, List<JComponent>>();
                gui = this.buildGUI(map, optionsCodeMap, this.guiMap, name);
            }
            Mango mango = Mango.getInstance();
            String title = readable.getImageDescription().getTitle();
            if (StringUtils.isBlank((CharSequence)title)) {
                title = this.file.getName();
            }
            MangoFocusableOptionPane jopf = new MangoFocusableOptionPane((Frame)null, (Object)gui, "Edit Header: " + title, -1);
            final JOptionPane jop = jopf.getJOptionPane();
            JButton buttonOk = new JButton("Save");
            buttonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    jop.setValue(0);
                    jop.setVisible(false);
                }
            });
            JButton buttonCancel = new JButton("Cancel");
            buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    jop.setValue(2);
                    jop.setVisible(false);
                }
            });
            JButton buttonOpen = new JButton(this.editingViewer != null ? "Save and Reload" : "Save and Open");
            buttonOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    HeaderEditor.this.openInMango = true;
                    jop.setValue(0);
                    jop.setVisible(false);
                }
            });
            Object[] options = null;
            options = this.editingViewer != null ? new Object[]{buttonOpen, buttonCancel} : new Object[]{buttonOk, buttonOpen, buttonCancel};
            jopf.setOptions(options);
            jopf.setInitialValue(buttonOk);
            int result = jopf.show(true);
            if (result == 0) {
                if (this.editingViewer != null) {
                    this.editingViewer.forceDispose();
                }
                if (this.editable.isTextEditableHeader()) {
                    String text = textArea.getText();
                    try {
                        FileUtils.write((File)this.file, (CharSequence)text);
                    }
                    catch (IOException ex) {
                        AppLogger.error((Throwable)ex);
                    }
                } else {
                    for (Map.Entry<String, List<JComponent>> entry : this.guiMap.entrySet()) {
                        String key = entry.getKey();
                        List originalValues = (List)map.get(key);
                        List<JComponent> fields = entry.getValue();
                        int size = fields.size();
                        for (int ctr = 0; ctr < size; ++ctr) {
                            String originalVal = (String)originalValues.get(ctr);
                            JComponent comp = fields.get(ctr);
                            String newVal = null;
                            if (comp instanceof JTextComponent) {
                                JTextComponent compText = (JTextComponent)comp;
                                newVal = compText.getText();
                            } else if (comp instanceof JComboBox) {
                                JComboBox compBox = (JComboBox)comp;
                                newVal = ((EditableHeader.CodeOption)compBox.getSelectedItem()).getCode();
                            }
                            if (originalVal.equals(newVal)) continue;
                            this.editable.setEditableFieldValue(key, newVal, ctr);
                        }
                    }
                    this.editable.writeHeader();
                }
                if (this.openInMango && mango != null) {
                    mango.addViewer(this.file);
                }
            }
        } else {
            throw new InvalidHeaderException("Cannot edit this header type!");
        }
    }

    private JScrollPane buildTextGUI(File headerFile, JTextArea textArea) {
        String text = "";
        try {
            text = FileUtils.readFileToString((File)headerFile);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        textArea.setText(text);
        JLabel warningLabel = new JLabel("Warning: Altering the header may make the image unreadable.");
        warningLabel.setForeground(Color.RED);
        JPanel warningPanel = new JPanel();
        warningPanel.setLayout(new BoxLayout(warningPanel, 0));
        warningPanel.add(Box.createHorizontalStrut(4));
        warningPanel.add(warningLabel);
        warningPanel.add(Box.createHorizontalGlue());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(warningPanel);
        mainPanel.add(Box.createVerticalStrut(4));
        mainPanel.add(textArea);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane scroller = new JScrollPane(mainPanel);
        scroller.setBorder(null);
        scroller.setPreferredSize(GUI_DIMENSION);
        return scroller;
    }

    private JScrollPane buildGUI(Map<String, List<String>> map, Map<String, List<EditableHeader.CodeOption>> codeOptionsMap, Map<String, List<JComponent>> guiMap, String name) {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JLabel nameLabel = new JLabel("File Format: " + name);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(nameLabel);
        labelPanel.add(Box.createHorizontalGlue());
        mainPanel.add(labelPanel);
        mainPanel.add(Box.createVerticalStrut(4));
        JLabel warningLabel = new JLabel("Warning: Altering the header may make the image unreadable.");
        warningLabel.setForeground(Color.RED);
        JButton anonButton = new JButton(ACTION_ANONYMIZE);
        anonButton.addActionListener(this);
        JPanel anonPanel = new JPanel();
        anonPanel.setLayout(new BoxLayout(anonPanel, 0));
        anonPanel.add(anonButton);
        anonPanel.add(Box.createHorizontalStrut(12));
        anonPanel.add(warningLabel);
        anonPanel.add(Box.createHorizontalGlue());
        List anonFields = this.editable.getAnonymizableFields();
        if (anonFields != null && anonFields.size() > 0) {
            mainPanel.add(anonPanel);
            mainPanel.add(Box.createVerticalStrut(4));
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String key = entry.getKey();
            List<EditableHeader.CodeOption> options = null;
            if (codeOptionsMap != null) {
                options = codeOptionsMap.get(key);
            }
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.add(new JLabel(key + ": "));
            ArrayList<JTextField> fields = new ArrayList<JTextField>();
            Iterator<String> itVals = entry.getValue().iterator();
            int index = 0;
            while (itVals.hasNext()) {
                if (index == 8) {
                    panel.setPreferredSize(new Dimension(500, panel.getPreferredSize().height));
                    mainPanel.add(panel);
                    panel = new JPanel();
                    panel.setLayout(new BoxLayout(panel, 0));
                    panel.add(new JLabel("  "));
                    index = 0;
                }
                String value = itVals.next();
                JComponent comp = null;
                if (options != null && !options.isEmpty()) {
                    JComboBox<EditableHeader.CodeOption> box = new JComboBox<EditableHeader.CodeOption>(options.toArray(new EditableHeader.CodeOption[options.size()]));
                    for (EditableHeader.CodeOption codeOption : options) {
                        if (!value.equals(codeOption.getCode())) continue;
                        box.setSelectedItem(codeOption);
                    }
                    comp = box;
                } else {
                    comp = new JTextField(value);
                }
                comp.setMinimumSize(new Dimension(50, ((JComponent)comp).getPreferredSize().height));
                comp.setMaximumSize(new Dimension(Integer.MAX_VALUE, ((JComponent)comp).getPreferredSize().height));
                fields.add((JTextField)comp);
                panel.add(comp);
                ++index;
            }
            panel.setPreferredSize(new Dimension(500, panel.getPreferredSize().height));
            mainPanel.add(panel);
            guiMap.put(key, fields);
        }
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane scroller = new JScrollPane(mainPanel);
        scroller.setBorder(null);
        scroller.setPreferredSize(GUI_DIMENSION);
        return scroller;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_ANONYMIZE)) {
            this.doAnonymization();
        }
    }

    public void doAnonymization() {
        List editableFields = this.editable.getAnonymizableFields();
        for (Map.Entry<String, List<JComponent>> entry : this.guiMap.entrySet()) {
            String key = entry.getKey();
            if (!editableFields.contains(key)) continue;
            List<JComponent> fields = entry.getValue();
            for (JComponent field : fields) {
                field.setBackground(Color.YELLOW);
            }
        }
        this.editable.anonymize();
        Map map = this.editable.getEditableFieldValues();
        for (Map.Entry<String, List<JComponent>> entry : this.guiMap.entrySet()) {
            String key = entry.getKey();
            if (!editableFields.contains(key)) continue;
            List anonVals = (List)map.get(key);
            List<JComponent> fields = entry.getValue();
            if (anonVals.size() != fields.size()) continue;
            int length = anonVals.size();
            for (int ctr = 0; ctr < length; ++ctr) {
                JComponent comp = fields.get(ctr);
                if (!(comp instanceof JTextField)) continue;
                JTextField compText = (JTextField)comp;
                compText.setText((String)anonVals.get(ctr));
            }
        }
    }
}

