/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.modal.file;

import edu.uthscsa.ric.mango.dialogs.modal.file.OpenFileDialog;
import edu.uthscsa.ric.mango.platform.Platform;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public final class SaveFileDialog {
    private static boolean open;
    public static final String TEXT_SAVE_FILE = "Save File";

    private SaveFileDialog() {
    }

    public static File showSaveFileChooser(Window window, String startDirectory, String filename) {
        if (Platform.MAC) {
            FileDialog fileDialog = null;
            String ext = null;
            if (filename.indexOf(46) != -1) {
                ext = filename.substring(filename.lastIndexOf(46));
            }
            fileDialog = window instanceof Frame ? new FileDialog((Frame)window, TEXT_SAVE_FILE, 1) : (window instanceof Dialog ? new FileDialog((Dialog)window, TEXT_SAVE_FILE, 1) : new FileDialog((Frame)null, TEXT_SAVE_FILE, 1));
            fileDialog.setDirectory(startDirectory);
            fileDialog.setFile(filename);
            open = true;
            fileDialog.setVisible(true);
            open = false;
            String selectedFileString = fileDialog.getFile();
            String selectedDirString = fileDialog.getDirectory();
            File selectedFile = null;
            if (selectedFileString != null && selectedFileString.length() > 0) {
                if (ext != null && selectedFileString.indexOf(46) == -1) {
                    selectedFileString = selectedFileString + ext;
                }
                selectedFile = new File(selectedDirString, selectedFileString);
            }
            return selectedFile;
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File(startDirectory));
        fileChooser.setSelectedFile(new File(startDirectory, filename));
        open = true;
        int value = fileChooser.showSaveDialog(null);
        open = false;
        File selectedFile = null;
        if (value == 0) {
            selectedFile = fileChooser.getSelectedFile();
        }
        return selectedFile;
    }

    public static File showSaveFolderChooser(Object frame, String startDirectory) {
        if (Platform.MAC) {
            return OpenFileDialog.showOpenFolderChooser(frame, startDirectory);
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File(startDirectory));
        fileChooser.setSelectedFile(new File(startDirectory));
        fileChooser.setFileSelectionMode(1);
        open = true;
        int value = fileChooser.showSaveDialog(null);
        open = false;
        File selectedFile = null;
        if (value == 0) {
            selectedFile = fileChooser.getSelectedFile();
        }
        return selectedFile;
    }

    public static boolean isOpen() {
        return open;
    }

    public static File showSaveFileChooserWithAccessory(Window window, String startDirectory, String filename, JComponent accessoryPanel) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File(startDirectory));
        fileChooser.setSelectedFile(new File(startDirectory, filename));
        if (accessoryPanel != null) {
            fileChooser.setAccessory(accessoryPanel);
        }
        open = true;
        int value = fileChooser.showSaveDialog(window);
        open = false;
        File selectedFile = null;
        if (value == 0) {
            selectedFile = fileChooser.getSelectedFile();
        }
        return selectedFile;
    }
}

