/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.modal.file;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;

public class MangoFileFilter
extends FileFilter
implements FilenameFilter {
    private boolean foldersOnly;
    private final String description;
    private final String[] extensions;

    protected MangoFileFilter(boolean foldersOnly) {
        this(null, null);
        this.foldersOnly = foldersOnly;
    }

    protected MangoFileFilter(String[] extensions, String description) {
        this.extensions = extensions;
        this.description = description;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.extensions == null) {
            return true;
        }
        String fileName = file.getName();
        for (String extension : this.extensions) {
            if (!fileName.toLowerCase().endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File dir, String filename) {
        if (this.foldersOnly) {
            return filename == null || filename.equals("");
        }
        if (filename == null || filename.length() == 0) {
            return false;
        }
        if (this.extensions == null) {
            return true;
        }
        for (String extension : this.extensions) {
            if (!filename.toLowerCase().endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

