/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.modal;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.dialogs.modal.file.OpenFileDialog;
import edu.uthscsa.ric.mango.viewerslice.menus.ViewerMenuAction;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.formats.nifti.NIFTI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.nio.ByteOrder;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class RawImageDialog
extends JPanel
implements ActionListener {
    private Color imageSizeOriginalColor;
    private File dataInterceptFile;
    private File dataScaleFile;
    private JLabel equalSize;
    private JLabel fileSize;
    private JLabel imageSize;
    private JLabel totalSize;
    private JPanel fileSizeMainPanel;
    private JRadioButton big;
    private JRadioButton dataInterceptGlobal;
    private JRadioButton dataInterceptSlice;
    private JRadioButton dataScaleGlobal;
    private JRadioButton dataScaleSlice;
    private JRadioButton little;
    private JRadioButton type64;
    private JRadioButton type16;
    private JRadioButton type32;
    private JRadioButton type8;
    private JRadioButton typeAscii;
    private JRadioButton typeFloat;
    private JRadioButton typeSigned;
    private JRadioButton typeUnsigned;
    private JTextField colSize;
    private JTextField cols;
    private JTextField dataIntercept;
    private JTextField dataInterceptSliceText;
    private JTextField dataScale;
    private JTextField dataScaleSliceText;
    private JTextField file;
    private JTextField headerOffset;
    private JTextField rowSize;
    private JTextField rows;
    private JTextField sliceSize;
    private JTextField slices;
    private JTextField timepoints;
    private JTextField tr;
    private JTextField trailerOffset;
    private MangoComboBox<String> orientation;
    private MangoComboBox<String> sense;
    private MangoComboBox<String> spatialUnits;
    private MangoComboBox<String> temporalUnits;
    private int offsetSize;
    private int selectedFileSize;
    private final Mango mango;
    private static AtomicReference<File> fileStored = new AtomicReference();
    private static AtomicReference<ImageDimensions> imageDims = new AtomicReference();
    private static AtomicReference<ImageRange> imageRange = new AtomicReference();
    private static AtomicReference<ImageType> imageType = new AtomicReference();
    private static AtomicReference<String> orientationStored = new AtomicReference();
    private static AtomicReference<VoxelDimensions> voxelDims = new AtomicReference();
    private static final long serialVersionUID = 1L;
    public static final ByteOrder BYTE_ORDER = ByteOrder.nativeOrder();
    public static final String DEFAULT_IMAGE_DIMENSION = "100";
    public static final String DEFAULT_IMAGE_DIMENSION_TIME = "1";
    public static final String DEFAULT_VOXEL_DIMENSION = "1.0";
    public static final String DEFAULT_VOXEL_DIMENSION_TIME = "0";
    public static final String TEXT_DEFAULT = "Default";
    public static final String TEXT_SELECT_FILE = "Select file...";
    public static final String ACTION_UPDATE_IMAGE_SIZE = "updateImageSize";
    public static final List<String> ORIENTATION = CollectionUtilities.immutable((String[])new String[]{"Default", "XYZ", "XZY", "YXZ", "YZX", "ZXY", "ZYX"});
    public static final List<String> SENSE = CollectionUtilities.immutable((String[])new String[]{"Default", "+++", "++-", "+-+", "-++", "+--", "-+-", "--+", "---"});
    public static final int SPATIAL_UNITS_INDEX = 2;
    public static final int TEMPORAL_UNITS_INDEX = 1;

    public RawImageDialog(Mango mango) {
        this.mango = mango;
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_UPDATE_IMAGE_SIZE)) {
            this.updateImageSize(false);
        } else if (command.equals("openFile")) {
            File selectedFile = OpenFileDialog.showOpenFileChooser(Mango.getInstance().getToolBox(), this.mango.getLoadFileDirectory(), null, "All Files");
            if (selectedFile != null) {
                this.file.setText(selectedFile.toString());
                this.file.setForeground(Color.BLACK);
                this.updateImageSize(false);
            }
        } else if (command.equals("dataScale")) {
            this.selectDataScaleFile();
        } else if (command.equals("dataIntercept")) {
            this.selectDataInterceptFile();
        } else if (command.equals("typeFloat")) {
            this.type32.setSelected(true);
            this.updateType();
        } else if (command.equals("typeAscii")) {
            this.updateType();
        } else if (command.equals("typeSigned") || command.equals("typeUnsigned")) {
            this.updateType();
        } else if (command.equals("type8")) {
            if (this.typeFloat.isSelected()) {
                this.typeSigned.setSelected(true);
            }
            this.updateType();
        } else if (command.equals("type16")) {
            if (this.typeFloat.isSelected()) {
                this.typeSigned.setSelected(true);
            }
            this.updateType();
        } else if (command.equals("type32")) {
            this.updateType();
        } else if (command.equals("type64")) {
            this.updateType();
        } else if (command.equals("updateScale")) {
            this.updateScale();
        } else if (command.equals("updateIntercept")) {
            this.updateIntercept();
        }
    }

    private void createUI() {
        JLabel dimX = new JLabel("Cols");
        dimX.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        JLabel dimY = new JLabel("Rows");
        dimY.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        JLabel dimZ = new JLabel("Slices");
        dimZ.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        JLabel sizeX = new JLabel("Cols");
        sizeX.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        JLabel sizeY = new JLabel("Rows");
        sizeY.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        JLabel sizeZ = new JLabel("Slices");
        sizeZ.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        JLabel dimT = new JLabel("Vols");
        dimY.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        JLabel sizeT = new JLabel("Vols");
        sizeT.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                RawImageDialog.this.updateImageSize(true);
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        };
        this.rows = new MangoTextField(DEFAULT_IMAGE_DIMENSION, 4, keyListener, false);
        this.rows.addActionListener(this);
        this.rows.setActionCommand(ACTION_UPDATE_IMAGE_SIZE);
        this.rows.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.rows.getPreferredSize().height));
        this.cols = new MangoTextField(DEFAULT_IMAGE_DIMENSION, 4, keyListener, false);
        this.cols.addActionListener(this);
        this.cols.setActionCommand(ACTION_UPDATE_IMAGE_SIZE);
        this.cols.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.cols.getPreferredSize().height));
        this.slices = new MangoTextField(DEFAULT_IMAGE_DIMENSION, 4, keyListener, false);
        this.slices.addActionListener(this);
        this.slices.setActionCommand(ACTION_UPDATE_IMAGE_SIZE);
        this.slices.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.slices.getPreferredSize().height));
        this.rowSize = new MangoTextField(DEFAULT_VOXEL_DIMENSION, 4, keyListener, false);
        this.rowSize.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.rowSize.getPreferredSize().height));
        this.colSize = new MangoTextField(DEFAULT_VOXEL_DIMENSION, 4, keyListener, false);
        this.colSize.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.colSize.getPreferredSize().height));
        this.sliceSize = new MangoTextField(DEFAULT_VOXEL_DIMENSION, 4, keyListener, false);
        this.sliceSize.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.sliceSize.getPreferredSize().height));
        this.timepoints = new MangoTextField(DEFAULT_IMAGE_DIMENSION_TIME, 4, keyListener, false);
        this.timepoints.addActionListener(this);
        this.timepoints.setActionCommand(ACTION_UPDATE_IMAGE_SIZE);
        this.timepoints.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.timepoints.getPreferredSize().height));
        this.tr = new MangoTextField(DEFAULT_VOXEL_DIMENSION_TIME, 4, keyListener, false);
        this.tr.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.tr.getPreferredSize().height));
        JPanel imageDimPanel = new JPanel();
        imageDimPanel.setLayout(new BoxLayout(imageDimPanel, 0));
        imageDimPanel.add(Box.createHorizontalGlue());
        imageDimPanel.add(Box.createHorizontalStrut(4));
        imageDimPanel.add(dimX);
        imageDimPanel.add(Box.createHorizontalStrut(2));
        imageDimPanel.add(this.cols);
        imageDimPanel.add(Box.createHorizontalStrut(10));
        imageDimPanel.add(dimY);
        imageDimPanel.add(Box.createHorizontalStrut(2));
        imageDimPanel.add(this.rows);
        imageDimPanel.add(Box.createHorizontalStrut(10));
        imageDimPanel.add(dimZ);
        imageDimPanel.add(Box.createHorizontalStrut(2));
        imageDimPanel.add(this.slices);
        imageDimPanel.add(Box.createHorizontalStrut(10));
        imageDimPanel.add(dimT);
        imageDimPanel.add(Box.createHorizontalStrut(2));
        imageDimPanel.add(this.timepoints);
        imageDimPanel.add(Box.createHorizontalStrut(4));
        imageDimPanel.add(Box.createHorizontalGlue());
        imageDimPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Image Dimensions"));
        JLabel spatialUnitsLabel = new JLabel("Spatial:");
        this.spatialUnits = new MangoComboBox<String>((T[])new String[]{NIFTI.getNiftiUnitString(0), NIFTI.getNiftiUnitString(3), NIFTI.getNiftiUnitString(2), NIFTI.getNiftiUnitString(1)});
        this.spatialUnits.setSelectedIndex(2);
        JLabel temporalUnitsLabel = new JLabel("Temporal:");
        this.temporalUnits = new MangoComboBox<String>((T[])new String[]{NIFTI.getNiftiUnitString(0), NIFTI.getNiftiUnitString(8), NIFTI.getNiftiUnitString(16), NIFTI.getNiftiUnitString(24)});
        this.temporalUnits.setSelectedIndex(1);
        this.temporalUnits.setMaximumSize(this.temporalUnits.getPreferredSize());
        this.temporalUnits.setMinimumSize(this.temporalUnits.getPreferredSize());
        this.spatialUnits.setMaximumSize(this.temporalUnits.getPreferredSize());
        this.spatialUnits.setMinimumSize(this.temporalUnits.getPreferredSize());
        JPanel unitsPanel = new JPanel();
        unitsPanel.setLayout(new BoxLayout(unitsPanel, 0));
        unitsPanel.add(Box.createHorizontalGlue());
        unitsPanel.add(Box.createHorizontalStrut(4));
        unitsPanel.add(spatialUnitsLabel);
        unitsPanel.add(Box.createHorizontalStrut(2));
        unitsPanel.add(this.spatialUnits);
        unitsPanel.add(Box.createHorizontalGlue());
        unitsPanel.add(Box.createHorizontalStrut(20));
        unitsPanel.add(Box.createHorizontalGlue());
        unitsPanel.add(temporalUnitsLabel);
        unitsPanel.add(Box.createHorizontalStrut(2));
        unitsPanel.add(this.temporalUnits);
        unitsPanel.add(Box.createHorizontalStrut(4));
        unitsPanel.add(Box.createHorizontalGlue());
        JPanel voxDimPanel = new JPanel();
        voxDimPanel.setLayout(new BoxLayout(voxDimPanel, 0));
        voxDimPanel.add(Box.createHorizontalStrut(4));
        voxDimPanel.add(sizeX);
        voxDimPanel.add(Box.createHorizontalStrut(2));
        voxDimPanel.add(this.colSize);
        voxDimPanel.add(Box.createHorizontalStrut(10));
        voxDimPanel.add(sizeY);
        voxDimPanel.add(Box.createHorizontalStrut(2));
        voxDimPanel.add(this.rowSize);
        voxDimPanel.add(Box.createHorizontalStrut(10));
        voxDimPanel.add(sizeZ);
        voxDimPanel.add(Box.createHorizontalStrut(2));
        voxDimPanel.add(this.sliceSize);
        voxDimPanel.add(Box.createHorizontalStrut(10));
        voxDimPanel.add(sizeT);
        voxDimPanel.add(Box.createHorizontalStrut(2));
        voxDimPanel.add(this.tr);
        voxDimPanel.add(Box.createHorizontalStrut(4));
        JPanel voxPanel = new JPanel();
        voxPanel.setLayout(new BoxLayout(voxPanel, 1));
        voxPanel.add(voxDimPanel);
        voxPanel.add(Box.createVerticalStrut(4));
        voxPanel.add(unitsPanel);
        voxPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Voxel Dimensions & Units"));
        this.typeSigned = new JRadioButton("Integer (Signed)");
        this.typeSigned.setActionCommand("typeSigned");
        this.typeSigned.addActionListener(this);
        this.typeUnsigned = new JRadioButton("Integer (Unsigned)");
        this.typeUnsigned.setActionCommand("typeUnsigned");
        this.typeUnsigned.addActionListener(this);
        this.typeFloat = new JRadioButton("Float");
        this.typeFloat.setActionCommand("typeFloat");
        this.typeFloat.addActionListener(this);
        this.typeAscii = new JRadioButton("ASCII");
        this.typeAscii.setActionCommand("typeAscii");
        this.typeAscii.addActionListener(this);
        JLabel bitsLabel = new JLabel("Bits:");
        this.type8 = new JRadioButton("8");
        this.type8.setActionCommand("type8");
        this.type8.addActionListener(this);
        this.type16 = new JRadioButton("16");
        this.type16.setActionCommand("type16");
        this.type16.addActionListener(this);
        this.type32 = new JRadioButton("32");
        this.type32.setActionCommand("type32");
        this.type32.addActionListener(this);
        this.type64 = new JRadioButton("64");
        this.type64.setActionCommand("type64");
        this.type64.addActionListener(this);
        JLabel orderLabel2 = new JLabel("Byte Order:");
        this.little = new JRadioButton("Little");
        this.big = new JRadioButton("Big");
        ButtonGroup orderGroup = new ButtonGroup();
        orderGroup.add(this.little);
        orderGroup.add(this.big);
        if (BYTE_ORDER.toString().equals("BIG_ENDIAN")) {
            this.big.setSelected(true);
        } else {
            this.little.setSelected(true);
        }
        ButtonGroup typeGroup = new ButtonGroup();
        typeGroup.add(this.typeSigned);
        typeGroup.add(this.typeUnsigned);
        typeGroup.add(this.typeFloat);
        typeGroup.add(this.typeAscii);
        this.typeSigned.setSelected(true);
        ButtonGroup typeBytes = new ButtonGroup();
        typeBytes.add(this.type8);
        typeBytes.add(this.type16);
        typeBytes.add(this.type32);
        typeBytes.add(this.type64);
        this.type16.setSelected(true);
        JPanel orderPanel = new JPanel();
        orderPanel.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        orderPanel.add(orderLabel2);
        orderPanel.add(this.big);
        orderPanel.add(this.little);
        JPanel datatypePanel = new JPanel();
        datatypePanel.setLayout(new BoxLayout(datatypePanel, 0));
        datatypePanel.add(Box.createHorizontalGlue());
        datatypePanel.add(Box.createHorizontalStrut(4));
        datatypePanel.add(this.typeSigned);
        datatypePanel.add(this.typeUnsigned);
        datatypePanel.add(this.typeFloat);
        datatypePanel.add(this.typeAscii);
        datatypePanel.add(Box.createHorizontalStrut(4));
        datatypePanel.add(Box.createHorizontalGlue());
        JPanel datatypePanel2 = new JPanel();
        datatypePanel2.setLayout(new BoxLayout(datatypePanel2, 0));
        datatypePanel2.add(Box.createHorizontalGlue());
        datatypePanel2.add(bitsLabel);
        datatypePanel2.add(this.type8);
        datatypePanel2.add(this.type16);
        datatypePanel2.add(this.type32);
        datatypePanel2.add(this.type64);
        datatypePanel2.add(Box.createHorizontalStrut(30));
        datatypePanel2.add(orderLabel2);
        datatypePanel2.add(this.big);
        datatypePanel2.add(this.little);
        datatypePanel2.add(Box.createHorizontalGlue());
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BoxLayout(typePanel, 1));
        typePanel.add(datatypePanel);
        typePanel.add(datatypePanel2);
        typePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Datatype"));
        imageDimPanel.setMaximumSize(new Dimension(typePanel.getPreferredSize().width, imageDimPanel.getPreferredSize().height));
        imageDimPanel.setMinimumSize(new Dimension(typePanel.getPreferredSize().width, imageDimPanel.getPreferredSize().height));
        voxDimPanel.setMaximumSize(new Dimension(typePanel.getPreferredSize().width, voxDimPanel.getPreferredSize().height));
        voxDimPanel.setMinimumSize(new Dimension(typePanel.getPreferredSize().width, voxDimPanel.getPreferredSize().height));
        JLabel dataScaleLabel = new JLabel("Multiply:");
        this.dataScale = new MangoTextField(DEFAULT_VOXEL_DIMENSION, 3, keyListener, true);
        this.dataScale.addActionListener(this);
        this.dataScale.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.dataScale.getPreferredSize().height));
        this.dataScaleSliceText = new JTextField(TEXT_SELECT_FILE, 13);
        this.dataScaleSliceText.setEnabled(false);
        this.dataScaleSliceText.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.dataScaleSliceText.getPreferredSize().height));
        this.dataScaleGlobal = new JRadioButton("Global");
        this.dataScaleGlobal.addActionListener(this);
        this.dataScaleGlobal.setActionCommand("updateScale");
        this.dataScaleSlice = new JRadioButton("Slice");
        this.dataScaleSlice.addActionListener(this);
        this.dataScaleSlice.setActionCommand("updateScale");
        ButtonGroup dataScaleBG = new ButtonGroup();
        dataScaleBG.add(this.dataScaleGlobal);
        dataScaleBG.add(this.dataScaleSlice);
        this.dataScaleGlobal.setSelected(true);
        JPanel dataScalePanel = new JPanel();
        dataScalePanel.setLayout(new BoxLayout(dataScalePanel, 0));
        dataScalePanel.add(Box.createHorizontalGlue());
        dataScalePanel.add(Box.createHorizontalStrut(4));
        dataScalePanel.add(dataScaleLabel);
        dataScalePanel.add(Box.createHorizontalStrut(2));
        dataScalePanel.add(this.dataScale);
        dataScalePanel.add(this.dataScaleGlobal);
        dataScalePanel.add(this.dataScaleSlice);
        dataScalePanel.add(this.dataScaleSliceText);
        dataScalePanel.add(Box.createHorizontalStrut(4));
        dataScalePanel.add(Box.createHorizontalGlue());
        JLabel dataInterceptLabel = new JLabel("Add:");
        this.dataIntercept = new MangoTextField("0.0", 3, keyListener, true);
        this.dataIntercept.addActionListener(this);
        this.dataIntercept.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.dataIntercept.getPreferredSize().height));
        this.dataInterceptSliceText = new JTextField(TEXT_SELECT_FILE, 13);
        this.dataInterceptSliceText.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.dataInterceptSliceText.getPreferredSize().height));
        this.dataInterceptSliceText.setEnabled(false);
        this.dataInterceptGlobal = new JRadioButton("Global");
        this.dataInterceptGlobal.addActionListener(this);
        this.dataInterceptGlobal.setActionCommand("updateIntercept");
        this.dataInterceptSlice = new JRadioButton("Slice");
        this.dataInterceptSlice.addActionListener(this);
        this.dataInterceptSlice.setActionCommand("updateIntercept");
        ButtonGroup dataInterceptBG = new ButtonGroup();
        dataInterceptBG.add(this.dataInterceptGlobal);
        dataInterceptBG.add(this.dataInterceptSlice);
        this.dataInterceptGlobal.setSelected(true);
        JPanel dataInterceptPanel = new JPanel();
        dataInterceptPanel.setLayout(new BoxLayout(dataInterceptPanel, 0));
        dataInterceptPanel.add(Box.createHorizontalGlue());
        dataInterceptPanel.add(Box.createHorizontalStrut(15));
        dataInterceptPanel.add(dataInterceptLabel);
        dataInterceptPanel.add(Box.createHorizontalStrut(2));
        dataInterceptPanel.add(this.dataIntercept);
        dataInterceptPanel.add(this.dataInterceptGlobal);
        dataInterceptPanel.add(this.dataInterceptSlice);
        dataInterceptPanel.add(this.dataInterceptSliceText);
        dataInterceptPanel.add(Box.createHorizontalStrut(4));
        dataInterceptPanel.add(Box.createHorizontalGlue());
        JPanel dataScaleFullPanel = new JPanel();
        dataScaleFullPanel.setLayout(new BoxLayout(dataScaleFullPanel, 1));
        dataScaleFullPanel.add(dataScalePanel);
        dataScaleFullPanel.add(dataInterceptPanel);
        dataScaleFullPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Scale"));
        JLabel orderLabel = new JLabel("Order (Col, Row, Slice):");
        JLabel senseLabel = new JLabel("Sense:");
        this.orientation = new MangoComboBox<String>((T[])CollectionUtilities.array(ORIENTATION));
        this.sense = new MangoComboBox<String>((T[])CollectionUtilities.array(SENSE));
        this.sense.setMaximumRowCount(9);
        this.orientation.setMaximumSize(this.orientation.getPreferredSize());
        this.orientation.setMinimumSize(this.orientation.getPreferredSize());
        this.sense.setMaximumSize(this.sense.getPreferredSize());
        this.sense.setMinimumSize(this.sense.getPreferredSize());
        JPanel orientationPanel = new JPanel();
        orientationPanel.setLayout(new BoxLayout(orientationPanel, 0));
        orientationPanel.add(Box.createHorizontalGlue());
        orientationPanel.add(orderLabel);
        orientationPanel.add(Box.createHorizontalStrut(2));
        orientationPanel.add(this.orientation);
        orientationPanel.add(Box.createHorizontalStrut(10));
        orientationPanel.add(senseLabel);
        orientationPanel.add(Box.createHorizontalStrut(2));
        orientationPanel.add(this.sense);
        orientationPanel.add(Box.createHorizontalGlue());
        orientationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Orientation"));
        JButton openFile = new JButton("Select...");
        openFile.setActionCommand("openFile");
        openFile.addActionListener(this);
        this.file = new JTextField("Select file that contains image data...", 25);
        this.file.setForeground(Color.GRAY);
        this.file.setEditable(false);
        this.file.addActionListener(this);
        this.file.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.file.getPreferredSize().height));
        JPanel fileOpenPanel = new JPanel();
        fileOpenPanel.setLayout(new BoxLayout(fileOpenPanel, 0));
        fileOpenPanel.add(Box.createHorizontalStrut(4));
        fileOpenPanel.add(Box.createHorizontalGlue());
        fileOpenPanel.add(this.file);
        fileOpenPanel.add(Box.createHorizontalStrut(2));
        fileOpenPanel.add(openFile);
        fileOpenPanel.add(Box.createHorizontalGlue());
        fileOpenPanel.add(Box.createHorizontalStrut(4));
        JLabel fileSizeTitle = new JLabel("File:");
        this.fileSize = new JLabel(DEFAULT_VOXEL_DIMENSION_TIME);
        JPanel fileSizePanel = new JPanel();
        fileSizePanel.setLayout(new BoxLayout(fileSizePanel, 0));
        fileSizePanel.add(fileSizeTitle);
        fileSizePanel.add(Box.createHorizontalStrut(5));
        fileSizePanel.add(this.fileSize);
        JLabel totalSizeTitle = new JLabel("Calculated:");
        this.totalSize = new JLabel(DEFAULT_VOXEL_DIMENSION_TIME);
        JPanel totalSizePanel = new JPanel();
        totalSizePanel.setLayout(new BoxLayout(totalSizePanel, 0));
        totalSizePanel.add(totalSizeTitle);
        totalSizePanel.add(Box.createHorizontalStrut(5));
        totalSizePanel.add(this.totalSize);
        this.equalSize = new JLabel("");
        JPanel equalSizePanel = new JPanel();
        equalSizePanel.setLayout(new BoxLayout(equalSizePanel, 0));
        equalSizePanel.add(this.equalSize);
        JLabel imageSizeTitle = new JLabel("Image:");
        this.imageSize = new JLabel(DEFAULT_VOXEL_DIMENSION_TIME);
        this.imageSizeOriginalColor = this.imageSize.getForeground();
        JPanel imageSizePanel = new JPanel();
        imageSizePanel.setLayout(new BoxLayout(imageSizePanel, 0));
        imageSizePanel.add(imageSizeTitle);
        imageSizePanel.add(Box.createHorizontalStrut(5));
        imageSizePanel.add(this.imageSize);
        KeyListener offsetKeyListener1 = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                RawImageDialog.this.updateHeader();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        KeyListener offsetKeyListener2 = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                RawImageDialog.this.updateTrailer();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        JLabel offsetTitle = new JLabel("Header:");
        this.headerOffset = new MangoTextField(DEFAULT_VOXEL_DIMENSION_TIME, 5, offsetKeyListener2, false);
        this.headerOffset.setMaximumSize(this.headerOffset.getPreferredSize());
        this.headerOffset.setMinimumSize(this.headerOffset.getPreferredSize());
        JPanel offsetPanel = new JPanel();
        offsetPanel.setLayout(new BoxLayout(offsetPanel, 0));
        offsetPanel.add(offsetTitle);
        offsetPanel.add(this.headerOffset);
        JLabel trailerTitle = new JLabel("Trailer:");
        this.trailerOffset = new MangoTextField(DEFAULT_VOXEL_DIMENSION_TIME, 5, offsetKeyListener1, false);
        this.trailerOffset.setMaximumSize(this.trailerOffset.getPreferredSize());
        this.trailerOffset.setMinimumSize(this.trailerOffset.getPreferredSize());
        JPanel trailerPanel = new JPanel();
        trailerPanel.setLayout(new BoxLayout(trailerPanel, 0));
        trailerPanel.add(trailerTitle);
        trailerPanel.add(this.trailerOffset);
        JPanel fileSizeMainTop = new JPanel();
        fileSizeMainTop.setLayout(new BoxLayout(fileSizeMainTop, 0));
        fileSizeMainTop.add(Box.createHorizontalStrut(4));
        fileSizeMainTop.add(Box.createHorizontalGlue());
        fileSizeMainTop.add(offsetPanel);
        fileSizeMainTop.add(Box.createHorizontalGlue());
        fileSizeMainTop.add(imageSizePanel);
        fileSizeMainTop.add(Box.createHorizontalGlue());
        fileSizeMainTop.add(trailerPanel);
        fileSizeMainTop.add(Box.createHorizontalGlue());
        fileSizeMainTop.add(Box.createHorizontalStrut(4));
        JPanel fileSizeMainBottom = new JPanel();
        fileSizeMainBottom.setLayout(new BoxLayout(fileSizeMainBottom, 0));
        fileSizeMainBottom.add(Box.createHorizontalStrut(4));
        fileSizeMainBottom.add(Box.createHorizontalGlue());
        fileSizeMainBottom.add(fileSizePanel);
        fileSizeMainBottom.add(Box.createHorizontalStrut(8));
        fileSizeMainBottom.add(this.equalSize);
        fileSizeMainBottom.add(Box.createHorizontalStrut(8));
        fileSizeMainBottom.add(totalSizePanel);
        fileSizeMainBottom.add(Box.createHorizontalGlue());
        fileSizeMainBottom.add(Box.createHorizontalStrut(4));
        this.fileSizeMainPanel = new JPanel();
        this.fileSizeMainPanel.setLayout(new BoxLayout(this.fileSizeMainPanel, 1));
        this.fileSizeMainPanel.add(fileSizeMainTop);
        this.fileSizeMainPanel.add(fileSizeMainBottom);
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 1));
        filePanel.add(fileOpenPanel);
        filePanel.add(Box.createVerticalStrut(4));
        filePanel.add(this.fileSizeMainPanel);
        filePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "File & Offset"));
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add(imageDimPanel);
        this.add(Box.createVerticalStrut(8));
        this.add(voxPanel);
        this.add(Box.createVerticalStrut(8));
        this.add(typePanel);
        this.add(Box.createVerticalStrut(8));
        this.add(dataScaleFullPanel);
        this.add(Box.createVerticalStrut(8));
        this.add(orientationPanel);
        this.add(Box.createVerticalStrut(8));
        this.add(filePanel);
        this.updateDialog();
    }

    private String doValidate() {
        int imageSizeValue;
        int fileSizeValue;
        int colsVal = 0;
        try {
            colsVal = Integer.parseInt(this.cols.getText().trim());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            return "Cols (Image Dimensions) must be an integer!";
        }
        if (colsVal <= 0) {
            return "Cols (Image Dimensions) must be greater than zero!";
        }
        int rowsVal = 0;
        try {
            rowsVal = Integer.parseInt(this.rows.getText().trim());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            return "Rows (Image Dimensions) must be an integer!";
        }
        if (rowsVal <= 0) {
            return "Rows (Image Dimensions) must be greater than zero!";
        }
        int slicesVal = 0;
        try {
            slicesVal = Integer.parseInt(this.slices.getText().trim());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            return "Slices (Image Dimensions) must be an integer!";
        }
        if (slicesVal <= 0) {
            return "Slices (Image Dimensions) must be greater than zero!";
        }
        int timepointsVal = 0;
        try {
            timepointsVal = Integer.parseInt(this.timepoints.getText().trim());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            return "Vols (Image Dimensions) must be an integer!";
        }
        if (timepointsVal <= 0) {
            return "Vols (Image Dimensions) must be greater than zero!";
        }
        double colsSizeVal = 0.0;
        try {
            colsSizeVal = Double.parseDouble(this.colSize.getText().trim());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            return "Cols (Voxel Dimensions) must be a number!";
        }
        if (colsSizeVal <= 0.0) {
            return "Cols (Voxel Dimensions) must be greater than zero!";
        }
        double rowsSizeVal = 0.0;
        try {
            rowsSizeVal = Double.parseDouble(this.rowSize.getText().trim());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            return "Rows (Voxel Dimensions) must be a number!";
        }
        if (rowsSizeVal <= 0.0) {
            return "Rows (Voxel Dimensions) must be greater than zero!";
        }
        double slicesSizeVal = 0.0;
        try {
            slicesSizeVal = Double.parseDouble(this.sliceSize.getText().trim());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            return "Slices (Voxel Dimensions) must be a number!";
        }
        if (slicesSizeVal <= 0.0) {
            return "Slices (Voxel Dimensions) must be greater than zero!";
        }
        double trVal = 0.0;
        try {
            trVal = Double.parseDouble(this.tr.getText().trim());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            return "Time (Voxel Dimensions) must be a number!";
        }
        if (timepointsVal > 1) {
            if (trVal <= 0.0) {
                return "Time (Voxel Dimensions) must be greater than zero!";
            }
        } else if (trVal < 0.0) {
            return "Time (Voxel Dimensions) cannot be negative!";
        }
        int offsetVal = 0;
        try {
            offsetVal = Integer.parseInt(this.headerOffset.getText().trim());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            return "Offset must be an integer!";
        }
        if (offsetVal < 0) {
            return "Offset cannot be less than zero!";
        }
        if (!this.typeAscii.isSelected() && (fileSizeValue = Integer.parseInt(this.fileSize.getText())) < (imageSizeValue = Integer.parseInt(this.imageSize.getText())) + offsetVal) {
            return "Image size plus offset size cannot exceed file size!";
        }
        return null;
    }

    private int findExtraSize() {
        int offsetVal = 0;
        try {
            if (this.typeAscii.isSelected()) {
                offsetVal = 0;
            } else {
                int fileSizeValue = 0;
                try {
                    fileSizeValue = Integer.parseInt(this.fileSize.getText().trim());
                }
                catch (NumberFormatException ex) {
                    this.fileSize.setText(DEFAULT_VOXEL_DIMENSION_TIME);
                }
                int imageSizeValue = 0;
                try {
                    imageSizeValue = Integer.parseInt(this.imageSize.getText().trim());
                }
                catch (NumberFormatException ex) {
                    this.imageSize.setText(DEFAULT_VOXEL_DIMENSION_TIME);
                }
                offsetVal = fileSizeValue - imageSizeValue;
            }
            if (offsetVal < 0) {
                offsetVal = 0;
            }
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return offsetVal;
    }

    private ImageDimensions getImageDimensions() {
        ImageDimensions id = null;
        try {
            int time = Integer.parseInt(this.timepoints.getText().trim());
            if (time <= 1) {
                time = 1;
            }
            id = new ImageDimensions(Integer.parseInt(this.cols.getText().trim()), Integer.parseInt(this.rows.getText().trim()), Integer.parseInt(this.slices.getText().trim()), time);
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageRange getImageRange() {
        int numVals;
        ImageDimensions id;
        boolean isInterceptGlobal;
        ImageRange ir = null;
        float dataScaleFloat = 1.0f;
        float dataInterceptFloat = 0.0f;
        File dataScaleTempFile = null;
        File dataInterceptTempFile = null;
        float[] dataScaleArray = null;
        float[] dataInterceptArray = null;
        boolean isScaleGlobal = this.dataScaleGlobal.isSelected();
        if (isScaleGlobal) {
            try {
                dataScaleFloat = (float)Double.parseDouble(this.dataScale.getText());
            }
            catch (Exception ex) {
                AppLogger.info((Throwable)ex);
                dataScaleFloat = 1.0f;
            }
        } else {
            dataScaleTempFile = new File(this.dataScaleSliceText.getText());
            if (!dataScaleTempFile.exists()) {
                dataScaleTempFile = null;
                dataScaleFloat = 1.0f;
            }
        }
        if (isInterceptGlobal = this.dataInterceptGlobal.isSelected()) {
            try {
                dataInterceptFloat = (float)Double.parseDouble(this.dataIntercept.getText());
            }
            catch (Exception ex) {
                AppLogger.info((Throwable)ex);
                dataInterceptFloat = 0.0f;
            }
        } else {
            dataInterceptTempFile = new File(this.dataInterceptSliceText.getText());
            if (!dataInterceptTempFile.exists()) {
                dataInterceptTempFile = null;
                dataInterceptFloat = 0.0f;
            }
        }
        if ((id = this.getImageDimensions()) != null && (numVals = id.getSlices() * id.getTimepoints()) > 0) {
            String str;
            StringTokenizer tokenizer;
            int index;
            String string;
            dataScaleArray = new float[numVals];
            dataInterceptArray = new float[numVals];
            if (dataScaleTempFile != null) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(dataScaleTempFile));
                    string = reader.readLine();
                    index = 0;
                    while (string != null && index < numVals) {
                        tokenizer = new StringTokenizer(string);
                        while (tokenizer.hasMoreTokens() && index < numVals) {
                            str = tokenizer.nextToken();
                            dataScaleArray[index++] = (float)Double.parseDouble(str);
                        }
                        string = reader.readLine();
                    }
                }
                catch (Exception ex) {
                    AppLogger.error((Throwable)ex);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception ex) {
                        AppLogger.warn((Throwable)ex);
                    }
                }
            } else {
                for (int ctr = 0; ctr < numVals; ++ctr) {
                    dataScaleArray[ctr] = dataScaleFloat;
                }
            }
            if (dataInterceptTempFile != null) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(dataInterceptTempFile));
                    string = reader.readLine();
                    index = 0;
                    while (string != null && index < numVals) {
                        tokenizer = new StringTokenizer(string);
                        while (tokenizer.hasMoreTokens() && index < numVals) {
                            str = tokenizer.nextToken();
                            dataInterceptArray[index++] = (float)Double.parseDouble(str);
                        }
                        string = reader.readLine();
                    }
                }
                catch (Exception ex) {
                    AppLogger.error((Throwable)ex);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception ex) {
                        AppLogger.warn((Throwable)ex);
                    }
                }
            } else {
                for (int ctr = 0; ctr < numVals; ++ctr) {
                    dataInterceptArray[ctr] = dataInterceptFloat;
                }
            }
        }
        ir = new ImageRange(0.0, 0.0, 0.0, 0.0);
        if (dataScaleArray != null) {
            ir.setDataScaleSlopes(dataScaleArray);
        }
        if (dataInterceptArray != null) {
            ir.setDataScaleIntercepts(dataInterceptArray);
        }
        this.dataScaleFile = dataScaleTempFile;
        this.dataInterceptFile = dataInterceptTempFile;
        return ir;
    }

    private ImageType getImageType() {
        int numBytes = 0;
        if (this.type8.isSelected()) {
            numBytes = 1;
        } else if (this.type16.isSelected()) {
            numBytes = 2;
        } else if (this.type32.isSelected()) {
            numBytes = 4;
        } else if (this.type64.isSelected()) {
            numBytes = 8;
        }
        int byteType = 0;
        if (this.typeSigned.isSelected()) {
            byteType = 2;
        } else if (this.typeUnsigned.isSelected()) {
            byteType = 3;
        } else if (this.typeFloat.isSelected()) {
            byteType = 4;
        } else if (this.typeAscii.isSelected()) {
            byteType = 4;
        }
        return new ImageType(numBytes, byteType, numBytes * 8, this.little.isSelected());
    }

    private String getOrientationString() {
        String orient1 = (String)this.orientation.getSelectedItem();
        String orient2 = (String)this.sense.getSelectedItem();
        if (orient1.equals(TEXT_DEFAULT)) {
            orient1 = "XYZ";
        }
        if (orient2.equals(TEXT_DEFAULT)) {
            orient2 = "+--";
        }
        return orient1 + orient2;
    }

    private File getSelectedFile() {
        return new File(this.file.getText().trim());
    }

    private VoxelDimensions getVoxelDimensions() {
        VoxelDimensions vd = null;
        try {
            vd = new VoxelDimensions(Double.parseDouble(this.colSize.getText().trim()), Double.parseDouble(this.rowSize.getText().trim()), Double.parseDouble(this.sliceSize.getText().trim()), Double.parseDouble(this.tr.getText().trim()));
            vd.setSpatialUnit((String)this.spatialUnits.getSelectedItem());
            vd.setTemporalUnit((String)this.temporalUnits.getSelectedItem());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return vd;
    }

    public boolean openImage() {
        String error = this.doValidate();
        if (error != null) {
            JOptionPane.showMessageDialog(this, error + " ", "Error", 0);
            return false;
        }
        int offsetVal = 0;
        try {
            offsetVal = Integer.parseInt(this.headerOffset.getText().trim());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        File selectedFile = this.getSelectedFile();
        ImageDimensions id = this.getImageDimensions();
        ImageType it = this.getImageType();
        it.setAscii(this.typeAscii.isSelected());
        VoxelDimensions vd = this.getVoxelDimensions();
        ImageRange ir = this.getImageRange();
        id.setImageOffset(offsetVal);
        Header header = new Header(it, id, vd, ir);
        header.setOrientation(this.getOrientationString());
        header.setImageFile(selectedFile);
        String orient1 = (String)this.orientation.getSelectedItem();
        String orient2 = (String)this.sense.getSelectedItem();
        if (orient1.equals(TEXT_DEFAULT) || orient2.equals(TEXT_DEFAULT)) {
            header.setOrientationCertainty(1);
        } else {
            header.setOrientationCertainty(2);
        }
        this.mango.addViewer(header, selectedFile);
        try {
            imageDims.set((ImageDimensions)id.clone());
            voxelDims.set((VoxelDimensions)vd.clone());
            imageType.set((ImageType)it.clone());
            imageRange.set((ImageRange)ir.clone());
        }
        catch (CloneNotSupportedException ex) {
            AppLogger.error((Throwable)ex);
        }
        orientationStored.set(this.getOrientationString());
        fileStored.set(this.getSelectedFile());
        return true;
    }

    private void selectDataInterceptFile() {
        File selectedFile = ViewerMenuAction.makeOpenFileChooser(null, Mango.getInstance().getLoadFileDirectory(), "All Files");
        if (selectedFile != null) {
            this.dataInterceptSliceText.setEnabled(true);
            this.dataInterceptSliceText.setText(selectedFile.toString());
        } else {
            this.dataInterceptSliceText.setEnabled(false);
            this.dataInterceptGlobal.setSelected(true);
            this.updateIntercept();
        }
    }

    private void selectDataScaleFile() {
        File selectedFile = ViewerMenuAction.makeOpenFileChooser(null, Mango.getInstance().getLoadFileDirectory(), "All Files");
        if (selectedFile != null) {
            this.dataScaleSliceText.setEnabled(true);
            this.dataScaleSliceText.setText(selectedFile.toString());
        } else {
            this.dataScaleSliceText.setEnabled(false);
            this.dataScaleGlobal.setSelected(true);
            this.updateScale();
        }
    }

    private void updateDialog() {
        if (imageDims.get() != null && voxelDims.get() != null && imageType.get() != null && orientationStored.get() != null && fileStored.get() != null && imageRange.get() != null) {
            this.cols.setText(String.valueOf(imageDims.get().getCols()));
            this.rows.setText(String.valueOf(imageDims.get().getRows()));
            this.slices.setText(String.valueOf(imageDims.get().getSlices()));
            this.timepoints.setText(String.valueOf(imageDims.get().getTimepoints()));
            this.colSize.setText(String.valueOf(voxelDims.get().getColSize(true)));
            this.rowSize.setText(String.valueOf(voxelDims.get().getRowSize(true)));
            this.sliceSize.setText(String.valueOf(voxelDims.get().getSliceThickness(true)));
            this.tr.setText(String.valueOf(voxelDims.get().getTR()));
            if (imageType.get().isAscii()) {
                this.typeAscii.setSelected(true);
            } else if (imageType.get().getByteTypeString().equals("Signed Integer")) {
                this.typeSigned.setSelected(true);
            } else if (imageType.get().getByteTypeString().equals("Unsigned Integer")) {
                this.typeUnsigned.setSelected(true);
            } else if (imageType.get().getByteTypeString().equals("Float")) {
                this.typeFloat.setSelected(true);
            }
            if (imageType.get().getNumBytesPerVoxel() == 1) {
                this.type8.setSelected(true);
                this.little.setEnabled(false);
                this.big.setEnabled(false);
            } else if (imageType.get().getNumBytesPerVoxel() == 2) {
                this.type16.setSelected(true);
                this.little.setEnabled(true);
                this.big.setEnabled(true);
            } else if (imageType.get().getNumBytesPerVoxel() == 4) {
                this.type32.setSelected(true);
                this.little.setEnabled(true);
                this.big.setEnabled(true);
            } else if (imageType.get().getNumBytesPerVoxel() == 8) {
                this.type64.setSelected(true);
                this.little.setEnabled(true);
                this.big.setEnabled(true);
            }
            if (voxelDims.get().getSpatialUnit() == 0) {
                this.spatialUnits.setSelectedItem(NIFTI.getNiftiUnitString(0));
            } else if (voxelDims.get().getSpatialUnit() == 3) {
                this.spatialUnits.setSelectedItem(NIFTI.getNiftiUnitString(3));
            } else if (voxelDims.get().getSpatialUnit() == 2) {
                this.spatialUnits.setSelectedItem(NIFTI.getNiftiUnitString(2));
            } else if (voxelDims.get().getSpatialUnit() == 1) {
                this.spatialUnits.setSelectedItem(NIFTI.getNiftiUnitString(1));
            }
            if (voxelDims.get().getTemporalUnit() == 0) {
                this.temporalUnits.setSelectedItem(NIFTI.getNiftiUnitString(0));
            } else if (voxelDims.get().getTemporalUnit() == 8) {
                this.temporalUnits.setSelectedItem(NIFTI.getNiftiUnitString(8));
            } else if (voxelDims.get().getTemporalUnit() == 16) {
                this.temporalUnits.setSelectedItem(NIFTI.getNiftiUnitString(16));
            } else if (voxelDims.get().getTemporalUnit() == 24) {
                this.temporalUnits.setSelectedItem(NIFTI.getNiftiUnitString(24));
            }
            if (imageType.get().isLittleEndian()) {
                this.little.setSelected(true);
            } else {
                this.big.setSelected(true);
            }
            if (this.dataScaleFile != null) {
                this.dataScaleSliceText.setText(this.dataScaleFile.toString());
                this.dataScaleSlice.setSelected(true);
            } else {
                this.dataScale.setText(String.valueOf(imageRange.get().getDataScaleSlopes()[0]));
                this.dataScaleGlobal.setSelected(true);
            }
            if (this.dataInterceptFile != null) {
                this.dataInterceptSliceText.setText(this.dataInterceptFile.toString());
                this.dataInterceptSlice.setSelected(true);
            } else {
                this.dataIntercept.setText(String.valueOf(imageRange.get().getDataScaleIntercepts()[0]));
                this.dataInterceptGlobal.setSelected(true);
            }
            this.orientation.setSelectedItem(orientationStored.get().substring(0, 3));
            this.sense.setSelectedItem(orientationStored.get().substring(3, 6));
            this.file.setText(fileStored.toString());
            this.file.setForeground(Color.BLACK);
            this.updateImageSize(false);
            this.updateType();
            this.offsetSize = this.findExtraSize();
            this.headerOffset.setText(String.valueOf(imageDims.get().getImageOffset()));
            this.trailerOffset.setText(String.valueOf(this.offsetSize - imageDims.get().getImageOffset()));
        } else {
            this.updateImageSize(false);
            this.updateType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateFileSize() {
        if (this.typeAscii.isSelected()) {
            this.fileSize.setText("ASCII");
        } else {
            File selectedFile = this.getSelectedFile();
            if (selectedFile != null && selectedFile.exists()) {
                this.selectedFileSize = 0;
                FileInputStream input = null;
                try {
                    input = new FileInputStream(selectedFile);
                    this.selectedFileSize = input.available();
                }
                catch (Exception ex) {
                    AppLogger.error((Throwable)ex);
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (Exception ex) {
                        AppLogger.warn((Throwable)ex);
                    }
                }
                this.fileSize.setText(String.valueOf(this.selectedFileSize));
            }
            this.fileSize.setText(String.valueOf(this.selectedFileSize));
        }
        this.fileSizeMainPanel.setVisible(!this.typeAscii.isSelected());
        return this.selectedFileSize;
    }

    private void updateHeader() {
        int trailerSize = 0;
        try {
            trailerSize = Integer.parseInt(this.trailerOffset.getText().trim());
        }
        catch (NumberFormatException ex) {
            AppLogger.warn((Throwable)ex);
        }
        int headerSize = this.offsetSize - trailerSize;
        this.headerOffset.setText(String.valueOf(headerSize));
        this.updateTotal();
    }

    private int updateImageSize(boolean allowEmpty) {
        int numBytes = 0;
        if (this.typeAscii.isSelected()) {
            numBytes = 1;
        } else if (this.type8.isSelected()) {
            numBytes = 1;
        } else if (this.type16.isSelected()) {
            numBytes = 2;
        } else if (this.type32.isSelected()) {
            numBytes = 4;
        } else if (this.type64.isSelected()) {
            numBytes = 8;
        }
        if (allowEmpty && this.cols.getText().trim().equals("")) {
            return 0;
        }
        int colsVal = 0;
        try {
            colsVal = Integer.parseInt(this.cols.getText().trim());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            colsVal = 100;
        }
        if (colsVal <= 0) {
            colsVal = 100;
        }
        this.cols.setText(String.valueOf(colsVal));
        if (allowEmpty && this.rows.getText().trim().equals("")) {
            return 0;
        }
        int rowsVal = 0;
        try {
            rowsVal = Integer.parseInt(this.rows.getText().trim());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            rowsVal = 100;
        }
        if (rowsVal <= 0) {
            rowsVal = 100;
        }
        this.rows.setText(String.valueOf(rowsVal));
        if (allowEmpty && this.slices.getText().trim().equals("")) {
            return 0;
        }
        int slicesVal = 0;
        try {
            slicesVal = Integer.parseInt(this.slices.getText().trim());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            slicesVal = 100;
        }
        if (slicesVal <= 0) {
            slicesVal = 100;
        }
        this.slices.setText(String.valueOf(slicesVal));
        if (allowEmpty && this.timepoints.getText().trim().equals("")) {
            return 0;
        }
        int tVal = 0;
        try {
            tVal = Integer.parseInt(this.timepoints.getText().trim());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            tVal = 1;
        }
        if (tVal <= 0) {
            tVal = 1;
        }
        this.timepoints.setText(String.valueOf(tVal));
        int totalSize = 0;
        try {
            totalSize = Integer.parseInt(this.cols.getText().trim()) * Integer.parseInt(this.rows.getText().trim()) * Integer.parseInt(this.slices.getText().trim()) * Integer.parseInt(this.timepoints.getText().trim()) * numBytes;
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        this.imageSize.setText(String.valueOf(totalSize));
        int sizeFile = this.updateFileSize();
        this.offsetSize = this.findExtraSize();
        this.trailerOffset.setText(DEFAULT_VOXEL_DIMENSION_TIME);
        this.updateHeader();
        if (sizeFile < totalSize + this.offsetSize) {
            this.imageSize.setForeground(Color.RED);
        } else {
            this.imageSize.setForeground(this.imageSizeOriginalColor);
        }
        this.updateTotal();
        return totalSize;
    }

    private void updateIntercept() {
        if (this.dataInterceptGlobal.isSelected()) {
            this.dataIntercept.setText("0.0");
            this.dataIntercept.setEnabled(true);
            this.dataInterceptSliceText.setText(TEXT_SELECT_FILE);
            this.dataInterceptSliceText.setEnabled(false);
        } else {
            this.dataIntercept.setText("");
            this.dataIntercept.setEnabled(false);
            this.selectDataInterceptFile();
        }
    }

    private void updateScale() {
        if (this.dataScaleGlobal.isSelected()) {
            this.dataScale.setText(DEFAULT_VOXEL_DIMENSION);
            this.dataScale.setEnabled(true);
            this.dataScaleSliceText.setText(TEXT_SELECT_FILE);
            this.dataScaleSliceText.setEnabled(false);
        } else {
            this.dataScale.setText("");
            this.dataScale.setEnabled(false);
            this.selectDataScaleFile();
        }
    }

    private void updateTotal() {
        int headerSizeValue = 0;
        try {
            headerSizeValue = Integer.parseInt(this.headerOffset.getText().trim());
        }
        catch (NumberFormatException ex) {
            AppLogger.warn((Throwable)ex);
        }
        int imageSizeValue = 0;
        try {
            imageSizeValue = Integer.parseInt(this.imageSize.getText().trim());
        }
        catch (NumberFormatException ex) {
            this.imageSize.setText(DEFAULT_VOXEL_DIMENSION_TIME);
        }
        int trailerSizeValue = 0;
        try {
            trailerSizeValue = Integer.parseInt(this.trailerOffset.getText().trim());
        }
        catch (NumberFormatException ex) {
            AppLogger.warn((Throwable)ex);
        }
        int totalSizeValue = headerSizeValue + imageSizeValue + trailerSizeValue;
        this.totalSize.setText(String.valueOf(totalSizeValue));
        int fileSizeValue = 0;
        try {
            fileSizeValue = Integer.parseInt(this.fileSize.getText().trim());
        }
        catch (NumberFormatException ex) {
            this.fileSize.setText("");
        }
        if (fileSizeValue == totalSizeValue) {
            this.equalSize.setText("=");
            this.equalSize.setForeground(Color.BLACK);
        } else if (fileSizeValue > totalSizeValue) {
            this.equalSize.setText(">");
            this.equalSize.setForeground(Color.RED);
        } else if (fileSizeValue < totalSizeValue) {
            this.equalSize.setText("<");
            this.equalSize.setForeground(Color.RED);
        }
    }

    private void updateTrailer() {
        int headerSize = 0;
        try {
            headerSize = Integer.parseInt(this.headerOffset.getText().trim());
        }
        catch (NumberFormatException ex) {
            AppLogger.warn((Throwable)ex);
        }
        int trailerSize = this.offsetSize - headerSize;
        this.trailerOffset.setText(String.valueOf(trailerSize));
        this.updateTotal();
    }

    private void updateType() {
        this.type64.setEnabled(!this.typeAscii.isSelected());
        this.type32.setEnabled(!this.typeAscii.isSelected());
        this.type16.setEnabled(!this.typeAscii.isSelected());
        this.type8.setEnabled(!this.typeAscii.isSelected());
        this.big.setEnabled(!this.type8.isSelected() && !this.typeAscii.isSelected());
        this.little.setEnabled(!this.type8.isSelected() && !this.typeAscii.isSelected());
        this.updateImageSize(false);
    }
}

