/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.modal;

import edu.uthscsa.ric.mango.Atlas;
import edu.uthscsa.ric.mango.ImageLoader;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoPlugin;
import edu.uthscsa.ric.mango.MangoPluginType;
import edu.uthscsa.ric.mango.core.Version;
import edu.uthscsa.ric.mango.dialogs.modal.file.OpenFileDialog;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.plugin.atlases.atlasfsl.AtlasFSL;
import edu.uthscsa.ric.mango.plugin.atlases.atlasfsl.AtlasFormatException;
import edu.uthscsa.ric.mango.viewerslice.menus.ViewerMenuAction;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.DesktopUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.visualization.surface.SurfacePlugin;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormat;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.WritableHeader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class PluginManagerDialog
extends JPanel
implements PopupMenuListener,
ActionListener {
    private JButton addButton;
    private JButton removeButton;
    private JPopupMenu popup;
    private Vector<Vector<Object>> data;
    private boolean isAddingNewLine;
    private long popupTimeCanceled;
    private final DefaultTableModel model;
    private final JScrollBar scrollBar;
    private final JTable table;
    private final Mango mango;
    private final Map<String, File> pluginFileMap = new HashMap<String, File>();
    private static final long serialVersionUID = 1L;
    public static final Color BACKGROUND = Color.LIGHT_GRAY;
    public static final Color SELECTED_COLOR = new Color(177, 222, 255);
    public static final Dimension START_SIZE = new Dimension(575, 500);
    public static final List<String> ACTIONS = CollectionUtilities.immutable((String[])new String[]{"Select Plugin JAR File...", "Select Atlas Folder..."});
    public static final String MESSAGE_NEW = "New version available!";
    public static final String MESSAGE_UPDATE = "Please update this plugin";
    public static final String MESSAGE_VERSION = "Requires Mango";
    public static final String TITLE = "Plugin Manager";

    public static String getPluginName(Object obj) {
        String name = null;
        if (obj != null) {
            if (obj instanceof MangoPluginType) {
                try {
                    MangoPluginType mpt = (MangoPluginType)obj;
                    name = mpt.getPluginName();
                }
                catch (AbstractMethodError err) {
                    AppLogger.error((Throwable)err);
                }
                catch (IncompatibleClassChangeError err) {
                    AppLogger.error((Throwable)err);
                }
            }
            if (name == null) {
                try {
                    if (obj instanceof MangoPlugin) {
                        MangoPlugin mptMangoPlugin = (MangoPlugin)obj;
                        name = mptMangoPlugin.getPluginName();
                    } else if (obj instanceof SurfacePlugin) {
                        SurfacePlugin mptSurfacePlugin = (SurfacePlugin)obj;
                        name = mptSurfacePlugin.getPluginName();
                    } else if (obj instanceof Atlas) {
                        Atlas mptAtlas = (Atlas)obj;
                        name = mptAtlas.getPluginName();
                    } else if (obj instanceof ImageLoader) {
                        ImageLoader mptImageLoader = (ImageLoader)obj;
                        name = mptImageLoader.getPluginName();
                    } else if (obj instanceof ReadableHeader) {
                        ReadableHeader mptReadableHeader = (ReadableHeader)obj;
                        name = mptReadableHeader.getPluginName();
                    }
                }
                catch (AbstractMethodError err) {
                    AppLogger.error((Throwable)err);
                }
                catch (IncompatibleClassChangeError err) {
                    AppLogger.error((Throwable)err);
                }
            }
        }
        return name;
    }

    public static boolean hasNewVersionsAvailable() {
        Vector<Vector<Object>> data = PluginManagerDialog.makeData(null);
        for (Vector<Object> vec : data) {
            Object plugin = vec.get(0);
            if (!PluginManagerDialog.hasNewVersion(plugin)) continue;
            return true;
        }
        return false;
    }

    public static boolean supportsCurrentMangoVersion(Object obj) {
        if (obj != null && obj instanceof MangoPluginType) {
            try {
                MangoPluginType mpt = (MangoPluginType)obj;
                Version mangoVersionSupported = new Version(mpt.getMinimumVersionSupported());
                Version mangoVersionCurrent = new Version(Mango.getVersionString());
                return !mangoVersionCurrent.isLessThan(mangoVersionSupported);
            }
            catch (IncompatibleClassChangeError err) {
                AppLogger.errorMinimal((Throwable)err);
                return true;
            }
        }
        return true;
    }

    private static Version getMinimumSupportedMangoVersion(Object obj) {
        if (obj != null && obj instanceof MangoPluginType) {
            try {
                MangoPluginType mpt = (MangoPluginType)obj;
                return new Version(mpt.getMinimumVersionSupported());
            }
            catch (IncompatibleClassChangeError err) {
                AppLogger.error((Throwable)err);
                return null;
            }
        }
        return null;
    }

    private static Version getPluginVersion(Object obj) {
        String versionStr = null;
        if (obj != null && obj instanceof MangoPluginType) {
            try {
                MangoPluginType mpt = (MangoPluginType)obj;
                versionStr = mpt.getVersion();
            }
            catch (IncompatibleClassChangeError err) {
                AppLogger.error((Throwable)err);
            }
        }
        return new Version(versionStr);
    }

    private static boolean hasNewVersion(Object obj) {
        if (obj != null && obj instanceof MangoPluginType) {
            try {
                MangoPluginType mpt = (MangoPluginType)obj;
                return mpt.hasNewerVersion();
            }
            catch (IncompatibleClassChangeError err) {
                AppLogger.error((Throwable)err);
                return false;
            }
        }
        return false;
    }

    private static boolean hasPluginURL(Object obj) {
        if (obj != null && obj instanceof MangoPluginType) {
            try {
                MangoPluginType mpt = (MangoPluginType)obj;
                URL url = mpt.getPluginURL();
                if (url != null) {
                    return true;
                }
            }
            catch (IncompatibleClassChangeError err) {
                AppLogger.error((Throwable)err);
                return false;
            }
        }
        return false;
    }

    private static boolean isOldPlugin(Object obj) {
        if (obj != null) {
            if (obj instanceof MangoPluginType) {
                try {
                    MangoPluginType mpt = (MangoPluginType)obj;
                    String version = mpt.getMinimumVersionSupported();
                    if (AppLogger.isDebugEnabled()) {
                        AppLogger.debug((String)("Plugin " + obj + " request version " + version));
                    }
                    return false;
                }
                catch (IncompatibleClassChangeError err) {
                    AppLogger.error((Throwable)err);
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    private static Vector<Vector<Object>> makeData(Map<String, File> fileMap) {
        File atlasDir;
        File[] atlasFiles;
        Vector<Vector<Object>> someData = new Vector<Vector<Object>>();
        File pluginDir = Platform.getPluginDir();
        File[] pluginFiles = pluginDir.listFiles();
        if (pluginFiles != null) {
            for (File file : pluginFiles) {
                File deleteFile;
                if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip") || file.getName().startsWith("replace_") || (deleteFile = new File(file.getParent(), file.getName() + ".delete")).exists()) continue;
                Vector<Object> dataCurrent = new Vector<Object>();
                try {
                    MangoPlugin mp;
                    final Object ob = Mango.loadPlugin(file, false);
                    if (fileMap != null) {
                        fileMap.put(PluginManagerDialog.getPluginName(ob), file);
                    }
                    if (ob instanceof WritableHeader) {
                        WritableHeader wh = (WritableHeader)ob;
                        dataCurrent.add(wh);
                        dataCurrent.add(PluginManagerDialog.getPluginVersion(wh));
                    } else if (ob instanceof ReadableHeader) {
                        ReadableHeader rh = (ReadableHeader)ob;
                        dataCurrent.add(rh);
                        dataCurrent.add(PluginManagerDialog.getPluginVersion(rh));
                    } else if (ob instanceof Atlas) {
                        Atlas at = (Atlas)ob;
                        dataCurrent.add(at);
                        dataCurrent.add(PluginManagerDialog.getPluginVersion(at));
                    } else if (ob instanceof ImageLoader) {
                        ImageLoader il = (ImageLoader)ob;
                        dataCurrent.add(il);
                        dataCurrent.add(PluginManagerDialog.getPluginVersion(il));
                    } else if (ob instanceof SurfacePlugin) {
                        SurfacePlugin sp = (SurfacePlugin)ob;
                        dataCurrent.add(sp);
                        dataCurrent.add(PluginManagerDialog.getPluginVersion(sp));
                    } else if (ob instanceof MangoPlugin) {
                        mp = (MangoPlugin)ob;
                        dataCurrent.add(mp);
                        dataCurrent.add(PluginManagerDialog.getPluginVersion(mp));
                    } else if (ob instanceof SurfaceFormat) {
                        mp = (SurfaceFormat)ob;
                        dataCurrent.add(mp);
                        dataCurrent.add(PluginManagerDialog.getPluginVersion(mp));
                    }
                    if (PluginManagerDialog.hasPluginURL(ob)) {
                        JButton button = new JButton("Support Page");
                        button.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                MangoPluginType mpt = (MangoPluginType)ob;
                                DesktopUtilities.openURL((String)mpt.getPluginURL().toString());
                            }
                        });
                        dataCurrent.add(button);
                    } else {
                        dataCurrent.add("");
                    }
                    dataCurrent.add("");
                }
                catch (Exception ex) {
                    AppLogger.error((Throwable)ex);
                }
                catch (Error err) {
                    AppLogger.error((Throwable)err);
                }
                if (dataCurrent.size() != 4) continue;
                someData.add(dataCurrent);
            }
        }
        if ((atlasFiles = (atlasDir = Platform.getAtlasDir()).listFiles()) != null) {
            for (File file : atlasFiles) {
                if (!file.isDirectory() || !file.toString().endsWith(".atlas")) continue;
                try {
                    final AtlasFSL atlas = new AtlasFSL(file);
                    if (fileMap != null) {
                        fileMap.put(PluginManagerDialog.getPluginName(atlas), file);
                    }
                    Vector<Object> dataCurrent = new Vector<Object>();
                    dataCurrent.add(atlas);
                    dataCurrent.add("Atlas");
                    if (PluginManagerDialog.hasPluginURL(atlas)) {
                        JButton button = new JButton("Support Page");
                        button.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                AtlasFSL mpt = atlas;
                                DesktopUtilities.openURL((String)mpt.getPluginURL().toString());
                            }
                        });
                        dataCurrent.add(button);
                    } else {
                        dataCurrent.add("");
                    }
                    dataCurrent.add(" ");
                    someData.add(dataCurrent);
                }
                catch (AtlasFormatException ex) {
                    AppLogger.error((Throwable)ex);
                }
            }
        }
        Collections.sort(someData, new PluginDataComparator());
        return someData;
    }

    public PluginManagerDialog(Mango mango) {
        this.mango = mango;
        this.model = new DefaultTableModel();
        this.table = new JTable(this.model){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.updateTableData();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                Object obj;
                if (PluginManagerDialog.this.table.rowAtPoint(me.getPoint()) != -1 && PluginManagerDialog.this.table.columnAtPoint(me.getPoint()) == PluginManagerDialog.this.table.convertColumnIndexToView(2) && (obj = PluginManagerDialog.this.table.getValueAt(PluginManagerDialog.this.table.rowAtPoint(me.getPoint()), PluginManagerDialog.this.table.convertColumnIndexToView(2))) instanceof JButton) {
                    JButton button = (JButton)obj;
                    button.setSelected(true);
                    PluginManagerDialog.this.table.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                Object obj;
                if (PluginManagerDialog.this.table.rowAtPoint(me.getPoint()) != -1 && (obj = PluginManagerDialog.this.table.getValueAt(PluginManagerDialog.this.table.rowAtPoint(me.getPoint()), PluginManagerDialog.this.table.convertColumnIndexToView(2))) instanceof JButton) {
                    JButton button = (JButton)obj;
                    if (button.isSelected()) {
                        button.doClick();
                    }
                    button.setSelected(false);
                    PluginManagerDialog.this.table.repaint();
                }
                PluginManagerDialog.this.updateRemoveButton();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PluginManagerDialog.this.updateRemoveButton();
            }
        });
        JScrollPane scroller = new JScrollPane(this.table);
        scroller.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (PluginManagerDialog.this.table.rowAtPoint(me.getPoint()) <= 0) {
                    PluginManagerDialog.this.table.clearSelection();
                    PluginManagerDialog.this.removeButton.setEnabled(false);
                }
            }
        });
        this.scrollBar = scroller.getVerticalScrollBar();
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                if (PluginManagerDialog.this.isAddingNewLine) {
                    PluginManagerDialog.this.scrollBar.setValue(PluginManagerDialog.this.scrollBar.getMaximum() - PluginManagerDialog.this.scrollBar.getVisibleAmount());
                    PluginManagerDialog.this.isAddingNewLine = false;
                }
            }
        });
        JPanel scrollerPanel = new JPanel(new BorderLayout());
        scrollerPanel.add((Component)scroller, "Center");
        scrollerPanel.setBackground(BACKGROUND);
        scrollerPanel.setPreferredSize(new Dimension(500, 200));
        JPanel linkPanel = new JPanel();
        linkPanel.setLayout(new BoxLayout(linkPanel, 0));
        JLabel linkLabel = new JLabel("<html><i><a href=\"http://rii.uthscsa.edu/mango//mango.html#pluginslist\">Get more plugins...</a></i></html>");
        linkLabel.setFont(new Font("SansSerif", 0, 11));
        linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//mango.html#pluginslist");
            }
        });
        linkLabel.setMaximumSize(linkLabel.getPreferredSize());
        JLabel linkLabel3 = new JLabel("<html><i><a href=\"http://rii.uthscsa.edu/mango//atlas_spec.html\">Learn more about atlases...</a></i></html>");
        linkLabel3.setFont(new Font("SansSerif", 0, 11));
        linkLabel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//atlas_spec.html");
            }
        });
        linkLabel3.setMaximumSize(linkLabel3.getPreferredSize());
        JLabel linkLabel2 = new JLabel("<html><i><a href=\"http://rii.uthscsa.edu/mango//develop.html\">Learn more about plugins...</a></i></html>");
        linkLabel2.setFont(new Font("SansSerif", 0, 11));
        linkLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//develop.html");
            }
        });
        linkLabel2.setMaximumSize(linkLabel2.getPreferredSize());
        linkPanel.add(Box.createHorizontalStrut(8));
        linkPanel.add(linkLabel);
        linkPanel.add(Box.createHorizontalGlue());
        linkPanel.add(linkLabel2);
        linkPanel.add(Box.createHorizontalGlue());
        linkPanel.add(linkLabel3);
        linkPanel.add(Box.createHorizontalStrut(8));
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(START_SIZE);
        this.setBackground(BACKGROUND);
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.add(scrollerPanel);
        this.add(linkPanel);
        this.makePopupMenu();
        this.checkVersionInfo();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.indexOf("show0") != -1) {
            this.addPlugin();
        } else if (command.indexOf("show1") != -1) {
            this.addAtlas();
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
        if (pme.getSource() == this.popup) {
            this.popupTimeCanceled = new Date().getTime();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }

    public void removePlugin() {
        int row = this.table.getSelectedRow();
        if (row >= 0) {
            String pluginName = PluginManagerDialog.getPluginName(this.table.getValueAt(row, 0));
            File file = this.pluginFileMap.get(pluginName);
            String name = null;
            if (file != null) {
                name = file.getName();
            }
            if (name != null) {
                if (name.indexOf(".jar") != -1) {
                    File deleteFile = new File(Platform.getPluginDir(), name + ".delete");
                    try {
                        deleteFile.createNewFile();
                    }
                    catch (Exception ex) {
                        AppLogger.warn((Throwable)ex);
                    }
                    this.updateTableData();
                    this.mango.showWarningDialog("Please restart Mango to remove the selected plugin.  ", "Plugin Updated");
                } else if (name.indexOf(".atlas") != -1) {
                    File deleteFile = new File(Platform.getAtlasDir(), name);
                    FileUtilities.deleteFolder((String)deleteFile.toString());
                    this.updateTableData();
                    this.mango.showWarningDialog("Please restart Mango to remove the deleted atlas.  ", "Plugin Updated");
                }
            }
        }
    }

    public void setAddButton(JButton button) {
        this.addButton = button;
    }

    public void setRemoveButton(JButton button) {
        this.removeButton = button;
        this.removeButton.setEnabled(false);
    }

    public void showAddOptions() {
        long timeSinceCancel = new Date().getTime() - this.popupTimeCanceled;
        if (timeSinceCancel > 250L) {
            this.popup.show(this.addButton, 2, 35);
        }
    }

    private void addAtlas() {
        File selectedFile = OpenFileDialog.showOpenFolderChooser(this.mango.getToolBox(), this.mango.getLoadFileDirectory());
        if (selectedFile != null) {
            Mango.addAtlas(selectedFile);
            this.updateTableData();
            this.mango.setLastAccessedDirectory(selectedFile.toString());
            this.updateTableData();
        }
    }

    private void addPlugin() {
        File selectedFile = ViewerMenuAction.makeOpenFileChooser(new String[]{".jar", ".zip"}, this.mango.getLoadFileDirectory(), "All JAR Files");
        if (selectedFile != null) {
            boolean success = Mango.addPlugin(selectedFile, true);
            if (success) {
                this.mango.setLastAccessedDirectory(selectedFile.getParent());
                this.updateTableData();
            } else {
                Mango.getInstance().showErrorDialog("There was a problem loading this plugin!  See the console...", "Plugin Error");
            }
        }
    }

    private void checkVersionInfo() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (Vector vec : PluginManagerDialog.this.data) {
                    Object plugin = vec.get(0);
                    boolean isOldPlugin = PluginManagerDialog.isOldPlugin(plugin);
                    boolean hasNewVersion = PluginManagerDialog.hasNewVersion(plugin);
                    boolean supportsMangoVersion = PluginManagerDialog.supportsCurrentMangoVersion(plugin);
                    if (isOldPlugin) {
                        vec.set(3, " Please update this plugin");
                    } else if (plugin instanceof AtlasFSL) {
                        vec.set(3, " ");
                    } else if (hasNewVersion) {
                        vec.set(3, " New version available!");
                    } else if (!supportsMangoVersion) {
                        vec.set(3, " Requires Mango " + PluginManagerDialog.getMinimumSupportedMangoVersion(plugin));
                    } else {
                        vec.set(3, "");
                    }
                    SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PluginManagerDialog.this.table.repaint();
                        }
                    });
                }
            }
        }, "PluginManager.checkVersionInfo() Thread");
        workThread.start();
    }

    private void makePopupMenu() {
        this.popup = new JPopupMenu();
        for (int ctr = 0; ctr < ACTIONS.size(); ++ctr) {
            JMenuItem mi = new JMenuItem(ACTIONS.get(ctr));
            mi.setActionCommand("show" + ctr);
            mi.addActionListener(this);
            this.popup.add(mi);
        }
        this.popup.addPopupMenuListener(this);
    }

    private void updateRemoveButton() {
        this.removeButton.setEnabled(true);
    }

    private void updateTableData() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Name");
        columnNames.add("Version");
        columnNames.add("Support");
        columnNames.add("Status");
        this.model.getDataVector().removeAllElements();
        this.data = PluginManagerDialog.makeData(this.pluginFileMap);
        this.model.setDataVector(this.data, columnNames);
        TableColumnModel cm = this.table.getColumnModel();
        CustomTableCellRenderer ctcr = new CustomTableCellRenderer();
        cm.getColumn(0).setPreferredWidth(200);
        cm.getColumn(1).setPreferredWidth(65);
        cm.getColumn(2).setPreferredWidth(125);
        cm.getColumn(3).setPreferredWidth(175);
        cm.getColumn(0).setCellRenderer(ctcr);
        cm.getColumn(1).setCellRenderer(ctcr);
        cm.getColumn(2).setCellRenderer(ctcr);
        cm.getColumn(3).setCellRenderer(ctcr);
        this.checkVersionInfo();
    }

    static class PluginDataComparator
    implements Comparator<Vector<Object>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        PluginDataComparator() {
        }

        @Override
        public int compare(Vector<Object> o1, Vector<Object> o2) {
            return PluginManagerDialog.getPluginName(o1.get(0)).compareTo(PluginManagerDialog.getPluginName(o2.get(0)));
        }
    }

    class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        CustomTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable aTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel cell = null;
            String pluginName = PluginManagerDialog.getPluginName(value);
            if (pluginName != null) {
                cell = (JLabel)super.getTableCellRendererComponent(aTable, PluginManagerDialog.getPluginName(value), isSelected, hasFocus, row, column);
            } else {
                if (value instanceof JButton) {
                    return (JButton)value;
                }
                cell = (JLabel)super.getTableCellRendererComponent(aTable, value, isSelected, hasFocus, row, column);
            }
            if (column == 3) {
                if (cell.getText().indexOf(PluginManagerDialog.MESSAGE_UPDATE) != -1) {
                    cell.setForeground(Color.RED);
                } else if (cell.getText().indexOf(PluginManagerDialog.MESSAGE_VERSION) != -1) {
                    cell.setForeground(Color.RED);
                } else {
                    cell.setForeground(Color.BLACK);
                }
            } else {
                cell.setForeground(Color.BLACK);
            }
            cell.setBorder(null);
            if (isSelected) {
                cell.setBackground(SELECTED_COLOR);
            } else {
                cell.setBackground(Color.WHITE);
            }
            if (column == 0 && pluginName != null) {
                cell.setToolTipText(((File)PluginManagerDialog.this.pluginFileMap.get(pluginName)).toString());
            }
            return cell;
        }
    }
}

