/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.modal;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.platform.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class NavigationReferenceDialog
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int NUM_COLS = 40;

    public static void showInFrame(Mango mango) {
        JFrame licenseFrame = new JFrame();
        NavigationReferenceDialog navRef = new NavigationReferenceDialog(licenseFrame);
        licenseFrame.setResizable(false);
        licenseFrame.setBackground(Color.WHITE);
        licenseFrame.setContentPane(navRef);
        licenseFrame.setIconImage(MangoStyle.ICON_APP.getImage());
        licenseFrame.setDefaultCloseOperation(2);
        licenseFrame.setTitle("Mouse & Keyboard Reference");
        licenseFrame.validate();
        licenseFrame.pack();
        licenseFrame.setLocation(DisplayUtils.getCenterDialogLocation(mango.getToolBox(), licenseFrame.getSize()));
        licenseFrame.setVisible(true);
    }

    private NavigationReferenceDialog(final JFrame frame) {
        String meta = Platform.getDefaultMetaKeyName();
        JLabel navLabel = new JLabel("Keyboard Navigation");
        navLabel.setFont(new Font("SansSerif", 1, 14));
        navLabel.setBackground(Color.WHITE);
        JPanel navLabelPanel = new JPanel();
        navLabelPanel.setLayout(new BoxLayout(navLabelPanel, 0));
        navLabelPanel.add(navLabel);
        navLabelPanel.add(Box.createHorizontalGlue());
        navLabelPanel.setBackground(Color.WHITE);
        String navNotes = "[Spacebar] Cycle the main slice view in a clockwise rotation.\n[Page Up] or ['] Increment the axial slice.\n[Page Down] or [/] Decrement the axial slice.\n[Arrow Up] and [Arrow Down] Increment/decrement the coronal slice.\n[Arrow Right] and [Arrow Left] Increment/decrement the sagittal slice.\n[g] and [v] Increment/decrement main slice, regardless of slice direction.\n[<] or [,] Decrement the series point.\n[>] or [.] Increment the series point.\n[Esc] Navigate to exact coordinate.\n[Tab] Moves cursor to same location in next viewer.\n[o] Navigate viewer to the image origin.\n[c] Navigate viewer to the center of the image.\n[z] Toggle zoom.";
        JTextArea navText = new JTextArea("[Spacebar] Cycle the main slice view in a clockwise rotation.\n[Page Up] or ['] Increment the axial slice.\n[Page Down] or [/] Decrement the axial slice.\n[Arrow Up] and [Arrow Down] Increment/decrement the coronal slice.\n[Arrow Right] and [Arrow Left] Increment/decrement the sagittal slice.\n[g] and [v] Increment/decrement main slice, regardless of slice direction.\n[<] or [,] Decrement the series point.\n[>] or [.] Increment the series point.\n[Esc] Navigate to exact coordinate.\n[Tab] Moves cursor to same location in next viewer.\n[o] Navigate viewer to the image origin.\n[c] Navigate viewer to the center of the image.\n[z] Toggle zoom.");
        navText.setFont(new Font("SansSerif", 0, 12));
        navText.setBackground(Color.WHITE);
        navText.setLineWrap(true);
        navText.setWrapStyleWord(true);
        navText.setEditable(false);
        navText.setColumns(40);
        JPanel navPanel = new JPanel();
        navPanel.setLayout(new BoxLayout(navPanel, 1));
        navPanel.add(navLabelPanel);
        navPanel.add(navText);
        JLabel fastLabel = new JLabel("Quick Toggle Keys");
        fastLabel.setFont(new Font("SansSerif", 1, 14));
        fastLabel.setBackground(Color.WHITE);
        JPanel fastLabelPanel = new JPanel();
        fastLabelPanel.setLayout(new BoxLayout(fastLabelPanel, 0));
        fastLabelPanel.add(fastLabel);
        fastLabelPanel.add(Box.createHorizontalGlue());
        fastLabelPanel.setBackground(Color.WHITE);
        String fastNotes = "[f] Toggle between two specified ROI tools set in Preferences.\n[Shift][f] Cycle through recently selected tools.\n[d] Cycle through used ROI mask colors.\n[s] Toggle ROI display on/off.\n[a] Toggle main crosshairs on/off.";
        JTextArea fastText = new JTextArea("[f] Toggle between two specified ROI tools set in Preferences.\n[Shift][f] Cycle through recently selected tools.\n[d] Cycle through used ROI mask colors.\n[s] Toggle ROI display on/off.\n[a] Toggle main crosshairs on/off.");
        fastText.setFont(new Font("SansSerif", 0, 12));
        fastText.setBackground(Color.WHITE);
        fastText.setLineWrap(true);
        fastText.setWrapStyleWord(true);
        fastText.setEditable(false);
        fastText.setColumns(40);
        JPanel fastPanel = new JPanel();
        fastPanel.setLayout(new BoxLayout(fastPanel, 1));
        fastPanel.add(fastLabelPanel);
        fastPanel.add(fastText);
        JLabel mouseLabel = new JLabel("Mouse Navigation");
        mouseLabel.setFont(new Font("SansSerif", 1, 14));
        mouseLabel.setBackground(Color.WHITE);
        JPanel mouseLabelPanel = new JPanel();
        mouseLabelPanel.setLayout(new BoxLayout(mouseLabelPanel, 0));
        mouseLabelPanel.add(mouseLabel);
        mouseLabelPanel.add(Box.createHorizontalGlue());
        mouseLabelPanel.setBackground(Color.WHITE);
        String mouseNotes = "(Left-click and drag) Change current coordinate.\n[Shift](Left-click and drag) ROI selection box.\n[Alt](Left-click and drag) Zoom in and out.";
        mouseNotes = mouseNotes + "\n[Alt](Double left-click) Reset zoom.";
        mouseNotes = mouseNotes + "\n[Alt][Shift](Left-click and drag) Pan zoomed image.";
        mouseNotes = mouseNotes + "\n(Right-click and drag) Window level controls.";
        if (Platform.MAC) {
            mouseNotes = mouseNotes + "\n[Command](Left-click and drag) Window level controls.";
        }
        final String mouseNotesF = mouseNotes;
        JTextArea mouseText = new JTextArea(mouseNotes);
        mouseText.setFont(new Font("SansSerif", 0, 12));
        mouseText.setBackground(Color.WHITE);
        mouseText.setLineWrap(true);
        mouseText.setWrapStyleWord(true);
        mouseText.setEditable(false);
        mouseText.setColumns(40);
        JPanel mousePanel = new JPanel();
        mousePanel.setLayout(new BoxLayout(mousePanel, 1));
        mousePanel.add(mouseLabelPanel);
        mousePanel.add(mouseText);
        JLabel otherLabel = new JLabel("Other Commands");
        otherLabel.setFont(new Font("SansSerif", 1, 14));
        otherLabel.setBackground(Color.WHITE);
        JPanel otherLabelPanel = new JPanel();
        otherLabelPanel.setLayout(new BoxLayout(otherLabelPanel, 0));
        otherLabelPanel.add(otherLabel);
        otherLabelPanel.add(Box.createHorizontalGlue());
        otherLabelPanel.setBackground(Color.WHITE);
        final String otherNotes = "[" + meta + "][0] Fill outside of the union of all selected ROIs with 0.\n[" + meta + "][Shift][0] Fill inside of the union of all selected ROIs with 0.\n[Shift]+[Arrow Keys] Move ROIs one voxel in any direction in main slice.\n[" + meta + "][p] Save a snapshot of the main view.\n[" + meta + "][Shift][p] Open a file dialog before saving snapshot.\n[Minus] Decrease the size of the ROI tool.\n[Plus] Increase the size of the ROI tool.\n[r] While being pressed, reduces the size of the ROI tool by 75%.\n[t] Bring the toolbox to the top of the window stack.";
        JTextArea otherText = new JTextArea(otherNotes);
        otherText.setFont(new Font("SansSerif", 0, 12));
        otherText.setBackground(Color.WHITE);
        otherText.setLineWrap(true);
        otherText.setWrapStyleWord(true);
        otherText.setEditable(false);
        otherText.setColumns(40);
        JPanel otherPanel = new JPanel();
        otherPanel.setLayout(new BoxLayout(otherPanel, 1));
        otherPanel.add(otherLabelPanel);
        otherPanel.add(otherText);
        JPanel mainPanelIn = new JPanel();
        mainPanelIn.setLayout(new BoxLayout(mainPanelIn, 1));
        mainPanelIn.add(mousePanel);
        mainPanelIn.add(Box.createVerticalStrut(8));
        mainPanelIn.add(navPanel);
        mainPanelIn.add(Box.createVerticalStrut(8));
        mainPanelIn.add(fastPanel);
        mainPanelIn.add(Box.createVerticalStrut(8));
        mainPanelIn.add(otherPanel);
        mainPanelIn.setBackground(Color.WHITE);
        mainPanelIn.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(mainPanelIn);
        mainPanel.setBackground(Color.WHITE);
        mainPanel.setBorder(BorderFactory.createBevelBorder(1, Color.LIGHT_GRAY, Color.GRAY));
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        this.setBackground(new Color(0xEEEEEE));
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JButton buttonCancel = new JButton("Done");
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                frame.setVisible(false);
                frame.dispose();
            }
        });
        JButton buttonDefaults = new JButton("Copy All");
        buttonDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String myString = "Keyboard Navigation\n[Spacebar] Cycle the main slice view in a clockwise rotation.\n[Page Up] or ['] Increment the axial slice.\n[Page Down] or [/] Decrement the axial slice.\n[Arrow Up] and [Arrow Down] Increment/decrement the coronal slice.\n[Arrow Right] and [Arrow Left] Increment/decrement the sagittal slice.\n[g] and [v] Increment/decrement main slice, regardless of slice direction.\n[<] or [,] Decrement the series point.\n[>] or [.] Increment the series point.\n[Esc] Navigate to exact coordinate.\n[Tab] Moves cursor to same location in next viewer.\n[o] Navigate viewer to the image origin.\n[c] Navigate viewer to the center of the image.\n[z] Toggle zoom.\n\nQuick Toggle Keys\n[f] Toggle between two specified ROI tools set in Preferences.\n[Shift][f] Cycle through recently selected tools.\n[d] Cycle through used ROI mask colors.\n[s] Toggle ROI display on/off.\n[a] Toggle main crosshairs on/off.\n\nMouse Navigation\n" + mouseNotesF + "\n\nOther Commands\n" + otherNotes;
                StringSelection stringSelection = new StringSelection(myString);
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                clpbrd.setContents(stringSelection, null);
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(buttonDefaults);
        buttonsPanel.add(buttonCancel);
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.add((Component)buttonsPanel, "South");
    }
}

