/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.modal;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.ExpressionEditorDialog;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.operations.calculation.ImageOperationTreeNode;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilter;
import edu.uthscsa.ric.volume.operations.filter.FilterException;
import edu.uthscsa.ric.volume.operations.filter.FilterManager;
import edu.uthscsa.ric.volume.operations.filter.FilterSlice;
import edu.uthscsa.ric.volume.operations.filter.FilterTime;
import edu.uthscsa.ric.volume.operations.filter.FilterVolume;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public final class FilterManagerDialog
extends JPanel
implements ActionListener,
MouseMotionListener,
MouseListener {
    private BufferedImage freqRespImageFiltered;
    private double max;
    private double min;
    private double range;
    private double ratio;
    private double value;
    private float[] filterKernelTime;
    private float[][] filterKernelSlice;
    private float[][][] filterKernelVolume;
    private int slice3rd;
    private int slice4th;
    private boolean freezeLutBox;
    private JButton deleteButton;
    private AffineTransform transform;
    private CardLayout cardLayout;
    private JButton openCalc1D;
    private JButton openCalc2D;
    private JButton openCalc3D;
    private JButton openCalc;
    private JCheckBox normalizeB;
    private JCheckBox separableB;
    private JLabel valueLabel;
    private JPanel filterPanel;
    private JPanel pointSpreadPanel;
    private JRadioButton equationB;
    private JRadioButton sliceB;
    private JRadioButton timeB;
    private JRadioButton valuesB;
    private JRadioButton volumeB;
    private JTextArea filterDataNS;
    private JTextField filterData1D;
    private JTextField filterData2D;
    private JTextField filterData3D;
    private JTextField kernelSize;
    private JTextField name;
    private MangoComboBox<String> allFilters;
    private Point2D.Double pointTransform;
    public static final String CARD_FIRST = "first";
    public static final String CARD_SECOND = "second";
    private static final LookupTableManager LUT = LookupTableManager.createLookupTableManager("Grayscale", true);
    private static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(1);
    private static final String DEFAULT_NAME = "New Filter";
    private static final String DEFAULT_NAME_BOX = "(New Filter)";
    private static final int DEFAULT_SIZE = 3;
    private static final int IMAGE_DIMS = 100;
    private static final int OFFSET_IMAGE_X = 10;
    private static final int OFFSET_IMAGE_Y = 8;
    private static final long serialVersionUID = 1L;

    public FilterManagerDialog() {
        this.createUI();
    }

    private void createUI() {
        JLabel dimLabel = new JLabel("Dimensions: ");
        this.timeB = new JRadioButton("Time");
        this.timeB.setActionCommand("updateTime");
        this.timeB.addActionListener(this);
        this.sliceB = new JRadioButton("Slice");
        this.sliceB.setActionCommand("updateSlice");
        this.sliceB.addActionListener(this);
        this.volumeB = new JRadioButton("Volume");
        this.volumeB.setActionCommand("updateVolume");
        this.volumeB.addActionListener(this);
        ButtonGroup groupDim = new ButtonGroup();
        groupDim.add(this.timeB);
        groupDim.add(this.sliceB);
        groupDim.add(this.volumeB);
        this.sliceB.setSelected(true);
        JPanel dimPanelTop = new JPanel();
        dimPanelTop.setLayout(new BoxLayout(dimPanelTop, 0));
        dimPanelTop.add(dimLabel);
        dimPanelTop.add(this.timeB);
        dimPanelTop.add(this.sliceB);
        dimPanelTop.add(this.volumeB);
        this.kernelSize = new MangoTextField("", 2);
        this.kernelSize.setText(String.valueOf(3));
        this.kernelSize.addActionListener(this);
        this.kernelSize.setActionCommand("kernel size");
        this.kernelSize.setMaximumSize(this.kernelSize.getPreferredSize());
        this.kernelSize.setMinimumSize(this.kernelSize.getPreferredSize());
        this.slice3rd = this.getKernelSizeInt() / 2;
        this.slice4th = this.getKernelSizeInt() / 2;
        JLabel kernelLabel = new JLabel("Size: ");
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new BoxLayout(sizePanel, 0));
        sizePanel.add(kernelLabel);
        sizePanel.add(this.kernelSize);
        JLabel typeLabel = new JLabel("Type: ");
        this.valuesB = new JRadioButton("Kernel");
        this.valuesB.setActionCommand("updateKernel");
        this.valuesB.addActionListener(this);
        this.valuesB.setSelected(true);
        this.equationB = new JRadioButton("Expression");
        this.equationB.setActionCommand("updateFormula");
        this.equationB.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.valuesB);
        buttonGroup.add(this.equationB);
        this.separableB = new JCheckBox("Separable");
        this.separableB.setActionCommand("updateSeparable");
        this.separableB.addActionListener(this);
        this.separableB.setSelected(true);
        this.normalizeB = new JCheckBox("Normalize");
        this.normalizeB.setActionCommand("updateNormalize");
        this.normalizeB.addActionListener(this);
        JPanel filterDataTypePanel1 = new JPanel();
        filterDataTypePanel1.setLayout(new BoxLayout(filterDataTypePanel1, 0));
        filterDataTypePanel1.add(sizePanel);
        filterDataTypePanel1.add(Box.createHorizontalStrut(6));
        filterDataTypePanel1.add(typeLabel);
        filterDataTypePanel1.add(this.valuesB);
        filterDataTypePanel1.add(this.equationB);
        JPanel filterDataTypePanel2 = new JPanel();
        filterDataTypePanel2.setLayout(new BoxLayout(filterDataTypePanel2, 0));
        filterDataTypePanel2.add(new JLabel("Options:"));
        filterDataTypePanel2.add(this.separableB);
        filterDataTypePanel2.add(this.normalizeB);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.add(Box.createVerticalStrut(12));
        optionsPanel.add(dimPanelTop);
        optionsPanel.add(Box.createVerticalStrut(12));
        optionsPanel.add(filterDataTypePanel1);
        optionsPanel.add(Box.createVerticalStrut(12));
        optionsPanel.add(filterDataTypePanel2);
        JLabel nameLabel = new JLabel("Name: ");
        this.name = new JTextField(14);
        this.allFilters = new MangoComboBox<String>((T[])Mango.getInstance().getFilterManager().getAllFilterNames());
        this.allFilters.insertItemAt(DEFAULT_NAME_BOX, 0);
        this.allFilters.setSelectedIndex(0);
        this.allFilters.addActionListener(this);
        this.allFilters.setActionCommand("filter chosen");
        this.allFilters.setPrototypeDisplayValue("                                       ");
        JPanel currentPanel = new JPanel();
        currentPanel.add(nameLabel);
        currentPanel.add(this.name);
        currentPanel.add(this.allFilters);
        currentPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.filterDataNS = new JTextArea(5, 30);
        this.filterDataNS.setLineWrap(true);
        this.filterDataNS.setWrapStyleWord(true);
        this.filterDataNS.addKeyListener(new KeyAdapter(){

            @Override
            public final void keyReleased(KeyEvent ke) {
                FilterManagerDialog.this.updatePointSpreadImage();
            }
        });
        JScrollPane filterDataScroller = new JScrollPane(this.filterDataNS, 20, 31);
        this.openCalc = new JButton(MangoStyle.ICON_OPEN_CALC);
        this.openCalc.setDisabledIcon(MangoStyle.ICON_OPEN_CALC_DISABLED);
        this.openCalc.setActionCommand("calculator NS");
        this.openCalc.addActionListener(this);
        this.openCalc.setPreferredSize(new Dimension(25, 22));
        this.openCalc.setBackground(Color.WHITE);
        this.openCalc.setForeground(Color.LIGHT_GRAY);
        this.openCalc.setContentAreaFilled(false);
        this.openCalc.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel filterDataNSPanel = new JPanel();
        filterDataNSPanel.add(filterDataScroller);
        filterDataNSPanel.add(this.openCalc);
        this.filterData1D = new JTextField("", 30);
        this.filterData1D.addKeyListener(new KeyAdapter(){

            @Override
            public final void keyReleased(KeyEvent ke) {
                FilterManagerDialog.this.updatePointSpreadImage();
            }
        });
        this.openCalc1D = new JButton(MangoStyle.ICON_OPEN_CALC);
        this.openCalc1D.setDisabledIcon(MangoStyle.ICON_OPEN_CALC_DISABLED);
        this.openCalc1D.setActionCommand("calculator 1D");
        this.openCalc1D.addActionListener(this);
        this.openCalc1D.setPreferredSize(new Dimension(25, 22));
        this.openCalc1D.setBackground(Color.WHITE);
        this.openCalc1D.setForeground(Color.LIGHT_GRAY);
        this.openCalc1D.setContentAreaFilled(false);
        this.openCalc1D.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel filterData1DPanel = new JPanel();
        filterData1DPanel.add(this.filterData1D);
        filterData1DPanel.add(this.openCalc1D);
        this.filterData2D = new JTextField("", 30);
        this.filterData2D.addKeyListener(new KeyAdapter(){

            @Override
            public final void keyReleased(KeyEvent ke) {
                FilterManagerDialog.this.updatePointSpreadImage();
            }
        });
        this.openCalc2D = new JButton(MangoStyle.ICON_OPEN_CALC);
        this.openCalc2D.setDisabledIcon(MangoStyle.ICON_OPEN_CALC_DISABLED);
        this.openCalc2D.setActionCommand("calculator 2D");
        this.openCalc2D.addActionListener(this);
        this.openCalc2D.setPreferredSize(new Dimension(25, 22));
        this.openCalc2D.setBackground(Color.WHITE);
        this.openCalc2D.setForeground(Color.LIGHT_GRAY);
        this.openCalc2D.setContentAreaFilled(false);
        this.openCalc2D.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel filterData2DPanel = new JPanel();
        filterData2DPanel.add(this.filterData2D);
        filterData2DPanel.add(this.openCalc2D);
        this.filterData3D = new JTextField("", 30);
        this.filterData3D.addKeyListener(new KeyAdapter(){

            @Override
            public final void keyReleased(KeyEvent ke) {
                FilterManagerDialog.this.updatePointSpreadImage();
            }
        });
        this.openCalc3D = new JButton(MangoStyle.ICON_OPEN_CALC);
        this.openCalc3D.setDisabledIcon(MangoStyle.ICON_OPEN_CALC_DISABLED);
        this.openCalc3D.setActionCommand("calculator 3D");
        this.openCalc3D.addActionListener(this);
        this.openCalc3D.setPreferredSize(new Dimension(25, 22));
        this.openCalc3D.setBackground(Color.WHITE);
        this.openCalc3D.setForeground(Color.LIGHT_GRAY);
        this.openCalc3D.setContentAreaFilled(false);
        this.openCalc3D.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel filterData3DPanel = new JPanel();
        filterData3DPanel.add(this.filterData3D);
        filterData3DPanel.add(this.openCalc3D);
        JPanel filterPanelSeparable = new JPanel();
        filterPanelSeparable.setLayout(new BoxLayout(filterPanelSeparable, 1));
        filterPanelSeparable.add(filterData1DPanel);
        filterPanelSeparable.add(filterData2DPanel);
        filterPanelSeparable.add(filterData3DPanel);
        this.filterPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.filterPanel.setLayout(this.cardLayout);
        TitledBorder tb = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Filter Data");
        if (Platform.WINDOWS) {
            tb.setTitleColor(Color.BLACK);
        }
        this.filterPanel.setBorder(tb);
        this.cardLayout.addLayoutComponent(filterPanelSeparable, CARD_FIRST);
        this.cardLayout.addLayoutComponent(filterDataNSPanel, CARD_SECOND);
        this.filterPanel.add((Component)filterPanelSeparable, CARD_FIRST);
        this.filterPanel.add((Component)filterDataNSPanel, CARD_SECOND);
        JPanel filterPanelOut = new JPanel();
        filterPanelOut.add(this.filterPanel);
        this.transform = new AffineTransform();
        this.pointTransform = new Point2D.Double();
        JPanel imagePanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                double size = FilterManagerDialog.this.getKernelSizeInt();
                FilterManagerDialog.this.transform.setTransform(100.0 / size, 0.0, 0.0, 100.0 / size, 10.0, 8.0);
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                g2d.drawImage(FilterManagerDialog.this.freqRespImageFiltered, FilterManagerDialog.this.transform, null);
                if (FilterManagerDialog.this.volumeB.isSelected()) {
                    g2d.setColor(Color.BLACK);
                    g2d.drawLine(114, 8, 114, 107);
                    g2d.drawLine(115, 8, 115, 107);
                    g2d.setColor(Color.WHITE);
                    g2d.drawLine(114, (int)(8.0 + 100.0 / size * (double)FilterManagerDialog.this.slice3rd), 114, (int)(8.0 + 100.0 / size * (double)(FilterManagerDialog.this.slice3rd + 1) - 1.0));
                    g2d.drawLine(115, (int)(8.0 + 100.0 / size * (double)FilterManagerDialog.this.slice3rd), 115, (int)(8.0 + 100.0 / size * (double)(FilterManagerDialog.this.slice3rd + 1) - 1.0));
                }
            }
        };
        imagePanel.addMouseMotionListener(this);
        imagePanel.addMouseListener(this);
        this.valueLabel = new JLabel("Value = 0");
        this.valueLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pointSpreadPanel = new JPanel();
        this.pointSpreadPanel.setLayout(new BoxLayout(this.pointSpreadPanel, 1));
        this.pointSpreadPanel.add(imagePanel);
        this.pointSpreadPanel.add(this.valueLabel);
        this.pointSpreadPanel.setPreferredSize(new Dimension(125, 125));
        LUT.initLUT();
        this.updateDefaultFilterData();
        this.updateCalculatorButtons();
        this.updatePointSpreadImage();
        JPanel topRowPanel = new JPanel();
        topRowPanel.add(optionsPanel);
        topRowPanel.add(this.pointSpreadPanel);
        this.setLayout(new BoxLayout(this, 1));
        this.add(topRowPanel);
        this.add(filterPanelOut);
        this.add(currentPanel);
        this.setDefaultState();
    }

    public void doDelete() {
        this.freezeLutBox = true;
        AbstractFilter filter = FilterManager.getFilter((String)this.allFilters.getSelectedItem());
        if (!filter.isNonEditable()) {
            Mango.getInstance().getFilterManager().deleteFilter(filter.getName());
            Mango.getInstance().getFilterManager().reloadFilters();
        }
        this.updateFilters();
        this.freezeLutBox = false;
        this.allFilters.setSelectedIndex(0);
    }

    public void setDeleteButton(JButton deleteButton) {
        this.deleteButton = deleteButton;
    }

    private void updateFilters() {
        this.allFilters.removeAllItems();
        this.allFilters.addItem(DEFAULT_NAME_BOX);
        for (String name : Mango.getInstance().getFilterManager().getAllFilterNames()) {
            this.allFilters.addItem(name);
        }
    }

    public void doSave() {
        this.freezeLutBox = true;
        AbstractFilter filter = null;
        try {
            filter = FilterManager.makeFilter(this.getName(), this.getDimensionsString(), this.isNormalize() ? "true" : "false", String.valueOf(this.getKernelSize()), this.isKernel() ? this.getFilterData() : null, this.isFormula() ? this.getFilterData() : null);
            Mango.getInstance().addFilter(filter);
            this.updateFilters();
            this.allFilters.setSelectedItem(filter.getName());
        }
        catch (FilterException ex) {
            AppLogger.error((Throwable)ex);
            Mango.showErrorDialogStatic("Not a valid filter!", "Add Filter Error");
        }
        this.freezeLutBox = false;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().indexOf("calculator") != -1) {
            String input;
            boolean is3D;
            String command = ae.getActionCommand();
            boolean is1D = command.indexOf("1D") != -1;
            boolean is2D = command.indexOf("2D") != -1;
            boolean bl = is3D = command.indexOf("3D") != -1;
            int dim = is1D ? 0 : (is2D ? 1 : (is3D ? 2 : -1));
            ExpressionEditorDialog dialog = new ExpressionEditorDialog();
            dialog.setResultsText(this.getFilterDataText(dim));
            int selection = JOptionPane.showConfirmDialog(this.getParent(), dialog, "Expression Editor", 2, -1, null);
            if (selection == 0 && (input = dialog.getResults()) != null && input.length() > 0 && this.checkFormula(input)) {
                this.setFilterDataText(dim, input);
            }
        } else if (ae.getActionCommand().equals("filter chosen")) {
            if (!this.freezeLutBox) {
                AbstractFilter filter = FilterManager.getFilter((String)this.allFilters.getSelectedItem());
                this.setFilter(filter);
                this.deleteButton.setEnabled(filter == null || !filter.isNonEditable());
            }
        } else if (ae.getActionCommand().equals("updateSlice")) {
            this.updateDefaultFilterData();
        } else if (ae.getActionCommand().equals("updateVolume")) {
            this.updateDefaultFilterData();
        } else if (ae.getActionCommand().equals("updateTime")) {
            this.updateDefaultFilterData();
        } else if (ae.getActionCommand().equals("updateS")) {
            this.updateDefaultFilterData();
        } else if (ae.getActionCommand().equals("updateL")) {
            this.updateDefaultFilterData();
        } else if (ae.getActionCommand().equals("updateKernel")) {
            this.updateDefaultFilterData();
            this.updateCalculatorButtons();
        } else if (ae.getActionCommand().equals("updateFormula")) {
            this.updateDefaultFilterData();
            this.updateCalculatorButtons();
        } else if (ae.getActionCommand().equals("kernel size")) {
            this.slice3rd = this.getKernelSizeInt() / 2;
            this.slice4th = this.getKernelSizeInt() / 2;
            if (!this.equationB.isSelected()) {
                this.updateDefaultFilterData();
            }
        } else if (ae.getActionCommand().equals("updateSeparable")) {
            if (this.separableB.isSelected()) {
                this.cardLayout.show(this.filterPanel, CARD_FIRST);
            } else {
                this.cardLayout.show(this.filterPanel, CARD_SECOND);
            }
            this.updateDefaultFilterData();
            this.updateCalculatorButtons();
        }
        this.updatePointSpreadImage();
    }

    public String getDimensionsString() {
        if (this.timeB.isSelected()) {
            return "TIME";
        }
        if (this.sliceB.isSelected()) {
            return "SLICE";
        }
        if (this.volumeB.isSelected()) {
            return "VOLUME";
        }
        return null;
    }

    public String getFilterData() {
        if (this.separableB.isSelected()) {
            if (this.timeB.isSelected()) {
                return "(" + this.getFilterDataText(0) + ")";
            }
            if (this.sliceB.isSelected()) {
                return "(" + this.getFilterDataText(0) + ") | (" + this.getFilterDataText(1) + ")";
            }
            return "(" + this.getFilterDataText(0) + ") | (" + this.getFilterDataText(1) + ") | (" + this.getFilterDataText(2) + ")";
        }
        return "(" + this.getFilterDataText(-1) + ")";
    }

    public int getKernelSize() {
        return this.getKernelSizeInt();
    }

    @Override
    public String getName() {
        return this.name.getText();
    }

    public boolean isFormula() {
        return this.equationB.isSelected();
    }

    public boolean isKernel() {
        return this.valuesB.isSelected();
    }

    public boolean isNormalize() {
        return this.normalizeB.isSelected();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int size = this.getKernelSizeInt();
        Point point = me.getPoint();
        int xIndexScreen = point.x;
        int yIndexScreen = point.y;
        try {
            this.transform.inverseTransform(new Point2D.Double(xIndexScreen, yIndexScreen), this.pointTransform);
            int slice3rdNew = (int)this.pointTransform.getY();
            int slice4thNew = (int)this.pointTransform.getX();
            if (slice3rdNew != this.slice3rd || slice4thNew != this.slice4th) {
                if (slice3rdNew >= 0 && slice3rdNew < size) {
                    this.slice3rd = slice3rdNew;
                }
                if (slice4thNew >= 0 && slice4thNew < size) {
                    this.slice4th = slice4thNew;
                }
                this.updatePointSpreadImage();
            }
        }
        catch (NoninvertibleTransformException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.value = 0.0;
        this.valueLabel.setText("Value = 0");
        this.pointSpreadPanel.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        Point point = me.getPoint();
        int xIndexScreen = point.x;
        int yIndexScreen = point.y;
        try {
            this.transform.inverseTransform(new Point2D.Double(xIndexScreen, yIndexScreen), this.pointTransform);
            int xIndexImage = (int)this.pointTransform.getX();
            int yIndexImage = (int)this.pointTransform.getY();
            if (this.filterKernelTime != null) {
                this.value = xIndexScreen >= 10 && xIndexScreen < 110 && yIndexScreen >= 8 && yIndexScreen < 108 ? (double)this.filterKernelTime[xIndexImage] : 0.0;
            } else if (this.filterKernelSlice != null) {
                this.value = xIndexScreen >= 10 && xIndexScreen < 110 && yIndexScreen >= 8 && yIndexScreen < 108 ? (double)this.filterKernelSlice[yIndexImage][xIndexImage] : 0.0;
            } else if (this.filterKernelVolume != null) {
                this.value = xIndexScreen >= 10 && xIndexScreen < 110 && yIndexScreen >= 8 && yIndexScreen < 108 ? (double)this.filterKernelVolume[this.slice3rd][yIndexImage][xIndexImage] : 0.0;
            }
            this.valueLabel.setText("Value = " + FORMATTER.format(this.value));
            this.pointSpreadPanel.repaint();
        }
        catch (NoninvertibleTransformException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    public void setFilter(AbstractFilter aFilter) {
        if (aFilter != null) {
            this.name.setText(aFilter.getName());
            this.name.setCaretPosition(0);
            int type = aFilter.getType();
            this.timeB.setSelected((type & 1) != 0);
            this.sliceB.setSelected((type & 2) != 0);
            this.volumeB.setSelected((type & 4) != 0);
            this.valuesB.setSelected(true);
            this.equationB.setSelected(aFilter.isFormula());
            this.separableB.setSelected(aFilter.isSeparable());
            this.normalizeB.setSelected(aFilter.isNormalize());
            if (this.separableB.isSelected()) {
                this.cardLayout.show(this.filterPanel, CARD_FIRST);
            } else {
                this.cardLayout.show(this.filterPanel, CARD_SECOND);
            }
            this.updateDefaultFilterData();
            this.updateCalculatorButtons();
            if (this.separableB.isSelected()) {
                if (this.timeB.isSelected()) {
                    this.setFilterDataText(0, aFilter.getStringFormattedFilter());
                } else if (this.sliceB.isSelected()) {
                    String token;
                    StringTokenizer tokenizer = new StringTokenizer(aFilter.getStringFormattedFilter(), "|");
                    if (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextToken();
                        if (token != null && token.length() > 0) {
                            token = token.trim();
                            if (!aFilter.isFormula()) {
                                if (token.indexOf(40) != -1) {
                                    token = token.substring(token.indexOf(40) + 1);
                                }
                                if (token.indexOf(41) != -1) {
                                    token = token.substring(0, token.indexOf(41));
                                }
                            }
                        }
                        this.setFilterDataText(0, token);
                    }
                    if (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextToken();
                        if (token != null && token.length() > 0) {
                            token = token.trim();
                            if (!aFilter.isFormula()) {
                                if (token.indexOf(40) != -1) {
                                    token = token.substring(token.indexOf(40) + 1);
                                }
                                if (token.indexOf(41) != -1) {
                                    token = token.substring(0, token.indexOf(41));
                                }
                            }
                        }
                        this.setFilterDataText(1, token);
                    }
                } else {
                    String token;
                    StringTokenizer tokenizer = new StringTokenizer(aFilter.getStringFormattedFilter(), "|");
                    if (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextToken();
                        if (token != null && token.length() > 0) {
                            token = token.trim();
                            if (!aFilter.isFormula()) {
                                if (token.indexOf(40) != -1) {
                                    token = token.substring(token.indexOf(40) + 1);
                                }
                                if (token.indexOf(41) != -1) {
                                    token = token.substring(0, token.indexOf(41));
                                }
                            }
                        }
                        this.setFilterDataText(0, token);
                    }
                    if (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextToken();
                        if (token != null && token.length() > 0) {
                            token = token.trim();
                            if (!aFilter.isFormula()) {
                                if (token.indexOf(40) != -1) {
                                    token = token.substring(token.indexOf(40) + 1);
                                }
                                if (token.indexOf(41) != -1) {
                                    token = token.substring(0, token.indexOf(41));
                                }
                            }
                        }
                        this.setFilterDataText(1, token);
                    }
                    if (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextToken();
                        if (token != null && token.length() > 0) {
                            token = token.trim();
                            if (!aFilter.isFormula()) {
                                if (token.indexOf(40) != -1) {
                                    token = token.substring(token.indexOf(40) + 1);
                                }
                                if (token.indexOf(41) != -1) {
                                    token = token.substring(0, token.indexOf(41));
                                }
                            }
                        }
                        this.setFilterDataText(2, token);
                    }
                }
            } else {
                String token = aFilter.getStringFormattedFilter();
                if (token != null && token.length() > 0) {
                    token = token.trim();
                    if (!aFilter.isFormula()) {
                        if (token.indexOf(40) != -1) {
                            token = token.substring(token.indexOf(40) + 1);
                        }
                        if (token.indexOf(41) != -1) {
                            token = token.substring(0, token.indexOf(41));
                        }
                    }
                }
                this.setFilterDataText(-1, token);
            }
            this.kernelSize.setText(String.valueOf(aFilter.getSize()));
            this.slice3rd = this.getKernelSizeInt() / 2;
            this.slice4th = this.getKernelSizeInt() / 2;
        } else {
            this.updateDefaultFilterData();
            this.updateCalculatorButtons();
            this.slice3rd = this.getKernelSizeInt() / 2;
            this.slice4th = this.getKernelSizeInt() / 2;
            this.name.setText(DEFAULT_NAME);
        }
        this.updatePointSpreadImage();
    }

    private boolean checkFormula(String input) {
        boolean valid = true;
        if (!ImageOperationTreeNode.hasValidParentheses(input)) {
            Mango.showErrorDialogStatic("Not all parentheses close in that expression!", "Formula Failed");
            valid = false;
        } else {
            StringBuffer operationString = new StringBuffer(input);
            double[] parsedValues = ImageOperationTreeNode.makeReplacements(operationString);
            ImageOperationTreeNode startNode = ImageOperationTreeNode.makeOperationTree(operationString.toString(), parsedValues, null, null, true);
            valid = ImageOperationTreeNode.isValidStartNode(startNode);
        }
        if (!valid) {
            Mango.showErrorDialogStatic("Could not process that expression!", "Formula Failed");
        }
        return valid;
    }

    private String getFilterDataText(int dim) {
        if (dim == 0) {
            return this.filterData1D.getText();
        }
        if (dim == 1) {
            return this.filterData2D.getText();
        }
        if (dim == 2) {
            return this.filterData3D.getText();
        }
        return this.filterDataNS.getText();
    }

    private int getKernelSizeInt() {
        int kernelSizeIntNew = 3;
        try {
            kernelSizeIntNew = Integer.parseInt(this.kernelSize.getText());
            if (kernelSizeIntNew < 0) {
                this.kernelSize.setText(String.valueOf(kernelSizeIntNew *= -1));
            }
            if (kernelSizeIntNew < 3) {
                kernelSizeIntNew = 3;
                this.kernelSize.setText(String.valueOf(kernelSizeIntNew));
            }
            if (kernelSizeIntNew % 2 == 0) {
                this.kernelSize.setText(String.valueOf(++kernelSizeIntNew));
            }
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
            kernelSizeIntNew = 3;
            this.kernelSize.setText(String.valueOf(kernelSizeIntNew));
        }
        return kernelSizeIntNew;
    }

    private String makeDefaultFilterData(int dim) {
        StringBuffer sb = new StringBuffer();
        if (this.equationB.isSelected()) {
            if (this.separableB.isSelected()) {
                if (this.timeB.isSelected()) {
                    sb.append("(time==0)");
                } else if (this.sliceB.isSelected()) {
                    if (dim == 0) {
                        sb.append("(col==0)");
                    } else {
                        sb.append("(row==0)");
                    }
                } else if (this.volumeB.isSelected()) {
                    if (dim == 0) {
                        sb.append("(col==0)");
                    } else if (dim == 1) {
                        sb.append("(row==0)");
                    } else {
                        sb.append("(slice==0)");
                    }
                }
            } else if (this.timeB.isSelected()) {
                sb.append("(time==0)");
            } else if (this.sliceB.isSelected()) {
                sb.append("((col==0) and (row==0))");
            } else if (this.volumeB.isSelected()) {
                sb.append("((col==0) and (row==0) and (slice==0))");
            }
        } else if (this.valuesB.isSelected()) {
            int size = 0;
            int halfSize = 0;
            size = this.getKernelSizeInt();
            halfSize = size / 2;
            if (this.separableB.isSelected()) {
                int iterations = 0;
                iterations = 1;
                for (int ctrIt = 0; ctrIt < iterations; ++ctrIt) {
                    StringBuffer sbStringNew = new StringBuffer();
                    for (int ctr = 0; ctr < size; ++ctr) {
                        if (ctr == halfSize) {
                            sbStringNew.append("1 ");
                            continue;
                        }
                        sbStringNew.append("0 ");
                    }
                    sb.append(sbStringNew.toString().trim());
                }
            } else {
                int numDims = 0;
                if (this.timeB.isSelected()) {
                    numDims = 1;
                } else if (this.sliceB.isSelected()) {
                    numDims = 2;
                } else if (this.volumeB.isSelected()) {
                    numDims = 3;
                }
                int total = (int)MathUtilities.pow((double)size, (double)numDims);
                int halfTotal = total / 2;
                StringBuffer sbStringNew = new StringBuffer();
                for (int ctr = 0; ctr < total; ++ctr) {
                    if (ctr == halfTotal) {
                        sbStringNew.append("1 ");
                        continue;
                    }
                    sbStringNew.append("0 ");
                }
                sb.append(sbStringNew.toString().trim());
            }
        }
        return sb.toString();
    }

    private void setDefaultState() {
        this.sliceB.setSelected(true);
        this.volumeB.setSelected(false);
        this.kernelSize.setText(String.valueOf(3));
        this.valuesB.setSelected(true);
        this.equationB.setSelected(false);
        this.separableB.setSelected(true);
        this.normalizeB.setSelected(true);
        this.normalizeB.setEnabled(true);
        this.name.setText(DEFAULT_NAME);
        this.setFilterDataText(0, this.makeDefaultFilterData(0));
    }

    private void setFilterDataText(int dim, String text) {
        if (dim == 0) {
            this.filterData1D.setText(text);
        } else if (dim == 1) {
            this.filterData2D.setText(text);
        } else if (dim == 2) {
            this.filterData3D.setText(text);
        } else {
            this.filterDataNS.setText(text);
        }
    }

    private void updateCalculatorButtons() {
        if (this.equationB.isSelected()) {
            if (this.separableB.isSelected()) {
                this.openCalc1D.setEnabled(true);
                this.openCalc2D.setEnabled(this.filterData2D.isEnabled());
                this.openCalc3D.setEnabled(this.filterData3D.isEnabled());
            } else {
                this.openCalc.setEnabled(true);
            }
        } else {
            this.openCalc.setEnabled(false);
            this.openCalc1D.setEnabled(false);
            this.openCalc2D.setEnabled(false);
            this.openCalc3D.setEnabled(false);
        }
    }

    private void updateDefaultFilterData() {
        if (this.separableB.isSelected()) {
            this.setFilterDataText(0, this.makeDefaultFilterData(0));
            this.setFilterDataText(1, this.makeDefaultFilterData(1));
            this.setFilterDataText(2, this.makeDefaultFilterData(2));
            if (this.timeB.isSelected()) {
                this.filterData1D.setEditable(true);
                this.filterData2D.setText("");
                this.filterData2D.setEditable(false);
                this.filterData3D.setText("");
                this.filterData3D.setEditable(false);
            } else if (this.sliceB.isSelected()) {
                this.filterData1D.setEditable(true);
                this.filterData2D.setEditable(true);
                this.filterData3D.setText("");
                this.filterData3D.setEditable(false);
            } else {
                this.filterData1D.setEditable(true);
                this.filterData2D.setEditable(true);
                this.filterData3D.setEditable(true);
            }
        } else {
            this.setFilterDataText(-1, this.makeDefaultFilterData(-1));
        }
    }

    private void updatePointSpreadImage() {
        int size = this.getKernelSizeInt();
        AbstractFilter currentFilter = null;
        BufferedImage freqRespImage = new BufferedImage(size, size, 2);
        this.freqRespImageFiltered = new BufferedImage(size, size, 2);
        int[] imageData = ((DataBufferInt)freqRespImage.getRaster().getDataBuffer()).getData();
        try {
            String filterDataString = this.getFilterData();
            currentFilter = FilterManager.makeFilter("", this.getDimensionsString(), this.isNormalize() ? "true" : "false", String.valueOf(size), this.isKernel() ? filterDataString : null, this.isFormula() ? filterDataString : null);
        }
        catch (FilterException ex) {
            AppLogger.warn((Throwable)ex);
        }
        if (currentFilter != null) {
            if (currentFilter.isNormalize()) {
                currentFilter.normalize();
            }
            if (currentFilter instanceof FilterTime) {
                this.filterKernelTime = (float[])currentFilter.getFullFilterArray();
                this.filterKernelSlice = null;
                this.filterKernelVolume = null;
                this.max = Double.MIN_VALUE;
                this.min = Double.MAX_VALUE;
                for (int ctr = 0; ctr < size; ++ctr) {
                    if ((double)this.filterKernelTime[ctr] > this.max) {
                        this.max = this.filterKernelTime[ctr];
                    }
                    if (!((double)this.filterKernelTime[ctr] < this.min)) continue;
                    this.min = this.filterKernelTime[ctr];
                }
                this.range = this.max - this.min;
                if (this.range == 0.0) {
                    this.range = 1.0;
                    this.min = 0.0;
                }
                this.ratio = 255.0 / this.range;
                int pixelValue = 0;
                for (int ctrOut = 0; ctrOut < size; ++ctrOut) {
                    for (int ctrIn = 0; ctrIn < size; ++ctrIn) {
                        pixelValue = (int)(this.ratio * ((double)this.filterKernelTime[ctrIn] - this.min));
                        imageData[ctrOut * size + ctrIn] = pixelValue | pixelValue << 8 | pixelValue << 16 | 0xFF000000;
                    }
                }
            } else if (currentFilter instanceof FilterSlice) {
                this.filterKernelTime = null;
                this.filterKernelSlice = (float[][])((FilterSlice)currentFilter).getFullFilterArray();
                this.filterKernelVolume = null;
                this.max = Double.MIN_VALUE;
                this.min = Double.MAX_VALUE;
                for (int ctrOut = 0; ctrOut < size; ++ctrOut) {
                    for (int ctrIn = 0; ctrIn < size; ++ctrIn) {
                        if ((double)this.filterKernelSlice[ctrOut][ctrIn] > this.max) {
                            this.max = this.filterKernelSlice[ctrOut][ctrIn];
                        }
                        if (!((double)this.filterKernelSlice[ctrOut][ctrIn] < this.min)) continue;
                        this.min = this.filterKernelSlice[ctrOut][ctrIn];
                    }
                }
                this.range = this.max - this.min;
                if (this.range == 0.0) {
                    this.range = 1.0;
                    this.min = 0.0;
                }
                this.ratio = 255.0 / this.range;
                int pixelValue = 0;
                for (int ctrOut = 0; ctrOut < size; ++ctrOut) {
                    for (int ctrIn = 0; ctrIn < size; ++ctrIn) {
                        pixelValue = (int)(this.ratio * ((double)this.filterKernelSlice[ctrOut][ctrIn] - this.min));
                        imageData[ctrOut * size + ctrIn] = pixelValue | pixelValue << 8 | pixelValue << 16 | 0xFF000000;
                    }
                }
            } else if (currentFilter instanceof FilterVolume) {
                this.filterKernelTime = null;
                this.filterKernelSlice = null;
                this.filterKernelVolume = (float[][][])((FilterVolume)currentFilter).getFullFilterArray();
                this.max = Double.MIN_VALUE;
                this.min = Double.MAX_VALUE;
                for (int ctrOut = 0; ctrOut < size; ++ctrOut) {
                    for (int ctrIn = 0; ctrIn < size; ++ctrIn) {
                        for (int ctrInIn = 0; ctrInIn < size; ++ctrInIn) {
                            if ((double)this.filterKernelVolume[ctrOut][ctrIn][ctrInIn] > this.max) {
                                this.max = this.filterKernelVolume[ctrOut][ctrIn][ctrInIn];
                            }
                            if (!((double)this.filterKernelVolume[ctrOut][ctrIn][ctrInIn] < this.min)) continue;
                            this.min = this.filterKernelVolume[ctrOut][ctrIn][ctrInIn];
                        }
                    }
                }
                this.range = this.max - this.min;
                if (this.range == 0.0) {
                    this.range = 1.0;
                    this.min = 0.0;
                }
                this.ratio = 255.0 / this.range;
                int pixelValue = 0;
                for (int ctrOut = 0; ctrOut < size; ++ctrOut) {
                    for (int ctrIn = 0; ctrIn < size; ++ctrIn) {
                        pixelValue = (int)(this.ratio * ((double)this.filterKernelVolume[this.slice3rd][ctrOut][ctrIn] - this.min));
                        imageData[ctrOut * size + ctrIn] = pixelValue | pixelValue << 8 | pixelValue << 16 | 0xFF000000;
                    }
                }
            } else {
                for (int ctrOut = 0; ctrOut < size; ++ctrOut) {
                    for (int ctrIn = 0; ctrIn < size; ++ctrIn) {
                        imageData[ctrOut * size + ctrIn] = -16777216;
                    }
                }
            }
        }
        LUT.getOp().filter(freqRespImage, this.freqRespImageFiltered);
        this.pointSpreadPanel.repaint();
    }
}

