/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.modal;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.dialogs.modal.file.OpenFileDialog;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.ExpressionEditorDialog;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LUT;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableKnot;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.operations.calculation.ImageOperationTreeNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class ColorTableManagerDialog
extends JPanel
implements ActionListener {
    private BufferedImage arrow;
    private BufferedImage arrowSelected;
    private Color currentColor;
    private JButton deleteLUTButton;
    private JColorChooser colorChooser;
    private LookupTableKnot grabbedKnot;
    private LookupTableKnot[] knots;
    private Rectangle[] knotRects;
    private String lastExpressionTry;
    private boolean freezeLutBox;
    private int knotRangeMax;
    private int knotRangeMin;
    private int selectedArrow;
    private final BufferedImage lutImage;
    private final BufferedImage lutImageFiltered;
    private final JButton addButton;
    private final JButton expressionButton;
    private final JButton removeButton;
    private final JCheckBox gradient;
    private final JRadioButton rgbButton;
    private final JTextField blue;
    private final JTextField green;
    private final JTextField name;
    private final JTextField percent;
    private final JTextField red;
    private final LookupTableManager lutManager;
    private final Mango mango;
    private final float[] floatColors;
    private final int[] lutData;
    private final MangoComboBox<String> lutBox;
    private static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(0);
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_EXPRESSION = "(value)";
    public static final String DEFAULT_NAME = "New Color Table";
    public static final String DEFAULT_NAME_BOX = "(New Color Table)";
    public static final String TITLE = "Color Table Manager";
    public static final int IMAGE_HEIGHT = 40;
    public static final int IMAGE_LENGTH_MAC = 320;
    public static final int IMAGE_LENGTH_WIN = 255;
    public static final int IMAGE_PANEL_HEIGHT_MARGIN = 10;
    public static final int IMAGE_PANEL_LENGTH_MARGIN = 20;
    public static final int OFFSET_ARROW_X = 6;
    public static final int OFFSET_ARROW_Y = 3;
    public static final int SIZE_ARROW_HEIGHT = 17;
    public static final int SIZE_ARROW_WIDTH = 11;

    public ColorTableManagerDialog(Mango mango) {
        this.mango = mango;
        this.currentColor = Color.BLACK;
        this.lastExpressionTry = DEFAULT_EXPRESSION;
        this.floatColors = new float[3];
        this.lutImage = new BufferedImage(this.getImageLength(), 40, 2);
        this.lutImageFiltered = new BufferedImage(this.getImageLength(), 40, 2);
        this.lutData = ((DataBufferInt)this.lutImage.getRaster().getDataBuffer()).getData();
        this.lutManager = new LookupTableManager(DEFAULT_NAME, true, new LookupTableKnot[]{new LookupTableKnot(0.0, 0.0, 0.0, 0.0, true), new LookupTableKnot(1.0, 1.0, 1.0, 1.0, false)});
        this.lutManager.initLUT();
        this.initializeLUTImage();
        try {
            this.arrow = ImageIO.read(Mango.class.getResourceAsStream("images/arrow_add_lut.gif"));
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
        try {
            this.arrowSelected = ImageIO.read(Mango.class.getResourceAsStream("images/arrow_add_lut_selected.gif"));
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
        JLabel percentLabel = new JLabel("Level");
        JPanel percentLabelPanel = new JPanel();
        percentLabelPanel.setLayout(new BoxLayout(percentLabelPanel, 0));
        percentLabelPanel.add(percentLabel);
        percentLabelPanel.add(Box.createHorizontalGlue());
        this.percent = new MangoTextField("0", 4);
        this.percent.setMaximumSize(this.percent.getPreferredSize());
        this.percent.setMinimumSize(this.percent.getPreferredSize());
        this.percent.addActionListener(this);
        this.percent.setActionCommand("Percent Changed");
        JPanel percentTextPanel = new JPanel();
        percentTextPanel.setLayout(new BoxLayout(percentTextPanel, 0));
        percentTextPanel.add(this.percent);
        percentTextPanel.add(Box.createHorizontalGlue());
        JPanel percentPanel = new JPanel();
        percentPanel.setLayout(new BoxLayout(percentPanel, 1));
        percentPanel.add(percentLabelPanel);
        percentPanel.add(percentTextPanel);
        JLabel redLabel = new JLabel("Red");
        JPanel redLabelPanel = new JPanel();
        redLabelPanel.setLayout(new BoxLayout(redLabelPanel, 0));
        redLabelPanel.add(redLabel);
        redLabelPanel.add(Box.createHorizontalGlue());
        this.red = new MangoTextField("0", 4);
        this.red.setMaximumSize(this.red.getPreferredSize());
        this.red.setMinimumSize(this.red.getPreferredSize());
        JPanel redTextPanel = new JPanel();
        redTextPanel.setLayout(new BoxLayout(redTextPanel, 0));
        redTextPanel.add(this.red);
        redTextPanel.add(Box.createHorizontalGlue());
        JPanel redPanel = new JPanel();
        redPanel.setLayout(new BoxLayout(redPanel, 1));
        redPanel.add(redLabelPanel);
        redPanel.add(redTextPanel);
        JLabel greenLabel = new JLabel("Green");
        JPanel greenLabelPanel = new JPanel();
        greenLabelPanel.setLayout(new BoxLayout(greenLabelPanel, 0));
        greenLabelPanel.add(greenLabel);
        greenLabelPanel.add(Box.createHorizontalGlue());
        this.green = new MangoTextField("0", 4);
        this.green.setMaximumSize(this.green.getPreferredSize());
        this.green.setMinimumSize(this.green.getPreferredSize());
        JPanel greenTextPanel = new JPanel();
        greenTextPanel.setLayout(new BoxLayout(greenTextPanel, 0));
        greenTextPanel.add(this.green);
        greenTextPanel.add(Box.createHorizontalGlue());
        JPanel greenPanel = new JPanel();
        greenPanel.setLayout(new BoxLayout(greenPanel, 1));
        greenPanel.add(greenLabelPanel);
        greenPanel.add(greenTextPanel);
        JLabel blueLabel = new JLabel("Blue");
        JPanel blueLabelPanel = new JPanel();
        blueLabelPanel.setLayout(new BoxLayout(blueLabelPanel, 0));
        blueLabelPanel.add(blueLabel);
        blueLabelPanel.add(Box.createHorizontalGlue());
        this.blue = new MangoTextField("0", 4);
        this.blue.setMaximumSize(this.blue.getPreferredSize());
        this.blue.setMinimumSize(this.blue.getPreferredSize());
        JPanel blueTextPanel = new JPanel();
        blueTextPanel.setLayout(new BoxLayout(blueTextPanel, 0));
        blueTextPanel.add(this.blue);
        blueTextPanel.add(Box.createHorizontalGlue());
        JPanel bluePanel = new JPanel();
        bluePanel.setLayout(new BoxLayout(bluePanel, 1));
        bluePanel.add(blueLabelPanel);
        bluePanel.add(blueTextPanel);
        JPanel textFieldPanel = new JPanel();
        textFieldPanel.setLayout(new BoxLayout(textFieldPanel, 0));
        textFieldPanel.add(Box.createHorizontalGlue());
        textFieldPanel.add(percentPanel);
        textFieldPanel.add(Box.createHorizontalStrut(4));
        textFieldPanel.add(redPanel);
        textFieldPanel.add(Box.createHorizontalStrut(4));
        textFieldPanel.add(greenPanel);
        textFieldPanel.add(Box.createHorizontalStrut(4));
        textFieldPanel.add(bluePanel);
        textFieldPanel.add(Box.createHorizontalGlue());
        this.rgbButton = new JRadioButton("0 to 255");
        this.rgbButton.setFocusable(false);
        this.rgbButton.setActionCommand("RGB Type");
        this.rgbButton.addActionListener(this);
        JRadioButton percentButton = new JRadioButton("0 to 1");
        percentButton.setFocusable(false);
        percentButton.setActionCommand("RGB Type");
        percentButton.addActionListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rgbButton);
        bg.add(percentButton);
        this.rgbButton.setSelected(true);
        this.gradient = new JCheckBox("Gradient Fill");
        this.gradient.setFocusable(false);
        this.gradient.setSelected(true);
        this.gradient.setHorizontalAlignment(0);
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BoxLayout(colorPanel, 0));
        colorPanel.add(Box.createHorizontalGlue());
        colorPanel.add(this.rgbButton);
        colorPanel.add(Box.createHorizontalStrut(4));
        colorPanel.add(percentButton);
        colorPanel.add(Box.createHorizontalGlue());
        colorPanel.add(this.gradient);
        colorPanel.add(Box.createHorizontalGlue());
        JButton colorButton = new JButton("Select Color...");
        colorButton.addActionListener(this);
        colorButton.setActionCommand("Choose Color");
        colorButton.setFocusable(false);
        colorButton.setFont(MangoStyle.FONT_REGULAR);
        this.expressionButton = new JButton("Expression...");
        this.expressionButton.addActionListener(this);
        this.expressionButton.setActionCommand("expression");
        this.expressionButton.setFocusable(false);
        this.expressionButton.setFont(MangoStyle.FONT_REGULAR);
        JPanel colorButtonPanel = new JPanel();
        colorButtonPanel.setLayout(new BoxLayout(colorButtonPanel, 1));
        colorButtonPanel.add(Box.createVerticalGlue());
        colorButtonPanel.add(colorButton);
        colorButtonPanel.add(this.expressionButton);
        colorButtonPanel.add(Box.createVerticalGlue());
        JPanel colorOptionsPanel = new JPanel();
        colorOptionsPanel.setLayout(new BoxLayout(colorOptionsPanel, 1));
        colorOptionsPanel.add(Box.createVerticalStrut(8));
        colorOptionsPanel.add(textFieldPanel);
        colorOptionsPanel.add(colorPanel);
        colorOptionsPanel.add(Box.createVerticalGlue());
        JPanel allColorOptionsPanel = new JPanel();
        allColorOptionsPanel.setLayout(new BoxLayout(allColorOptionsPanel, 0));
        allColorOptionsPanel.add(Box.createHorizontalGlue());
        allColorOptionsPanel.add(colorOptionsPanel);
        allColorOptionsPanel.add(colorButtonPanel);
        allColorOptionsPanel.add(Box.createHorizontalGlue());
        this.addButton = new JButton("Update Knot");
        this.addButton.addActionListener(this);
        this.addButton.setActionCommand("Add Knot");
        this.addButton.setFocusable(false);
        this.addButton.setFont(MangoStyle.FONT_SMALL);
        this.removeButton = new JButton("Remove Knot");
        this.removeButton.addActionListener(this);
        this.removeButton.setActionCommand("Remove Knot");
        this.removeButton.setFocusable(false);
        this.removeButton.setFont(MangoStyle.FONT_SMALL);
        this.updateRemoveButton();
        JPanel imagePanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                ColorTableManagerDialog.this.updateKnots();
                ColorTableManagerDialog.this.updateLUTImage();
                g2d.drawImage(ColorTableManagerDialog.this.lutImageFiltered, null, ColorTableManagerDialog.this.getImagePanelLengthOffset(), ColorTableManagerDialog.this.getImagePanelHeightOffset());
                for (int ctr = 0; ctr < ColorTableManagerDialog.this.knotRects.length; ++ctr) {
                    if (ctr == ColorTableManagerDialog.this.selectedArrow) {
                        g2d.drawImage(ColorTableManagerDialog.this.arrowSelected, null, ((ColorTableManagerDialog)ColorTableManagerDialog.this).knotRects[ctr].x, ((ColorTableManagerDialog)ColorTableManagerDialog.this).knotRects[ctr].y);
                        continue;
                    }
                    g2d.drawImage(ColorTableManagerDialog.this.arrow, null, ((ColorTableManagerDialog)ColorTableManagerDialog.this).knotRects[ctr].x, ((ColorTableManagerDialog)ColorTableManagerDialog.this).knotRects[ctr].y);
                }
            }
        };
        imagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                Point point = me.getPoint();
                boolean endKnotGrabbed = false;
                for (int ctr = 0; ctr < ColorTableManagerDialog.this.knotRects.length; ++ctr) {
                    if (!ColorTableManagerDialog.this.knotRects[ctr].contains(point)) continue;
                    ColorTableManagerDialog.this.updateFields(ctr);
                    ColorTableManagerDialog.this.selectedArrow = ctr;
                    ColorTableManagerDialog.this.updateRemoveButton();
                    ColorTableManagerDialog.this.updateGradientButton();
                    if (ctr != 0 && ctr != ColorTableManagerDialog.this.knotRects.length - 1) {
                        ColorTableManagerDialog.this.grabbedKnot = ColorTableManagerDialog.this.lutManager.getKnots()[ctr];
                        ColorTableManagerDialog.this.knotRangeMin = (int)(((ColorTableManagerDialog)ColorTableManagerDialog.this).lutManager.getKnots()[ctr - 1].val * (double)ColorTableManagerDialog.this.getImageLength() + 0.5);
                        ColorTableManagerDialog.this.knotRangeMax = (int)(((ColorTableManagerDialog)ColorTableManagerDialog.this).lutManager.getKnots()[ctr + 1].val * (double)ColorTableManagerDialog.this.getImageLength() + 0.5);
                        continue;
                    }
                    endKnotGrabbed = true;
                }
                if (ColorTableManagerDialog.this.grabbedKnot == null && !endKnotGrabbed) {
                    Color grabbedColor = new Color(ColorTableManagerDialog.this.lutImageFiltered.getRGB(me.getPoint().x - ColorTableManagerDialog.this.getImagePanelLengthOffset(), 0));
                    grabbedColor.getRGBColorComponents(ColorTableManagerDialog.this.floatColors);
                    int imagePoint = me.getPoint().x - ColorTableManagerDialog.this.getImagePanelLengthOffset();
                    if (ColorTableManagerDialog.this.rgbButton.isSelected()) {
                        ColorTableManagerDialog.this.percent.setText(String.valueOf((int)Math.round((double)imagePoint / (double)ColorTableManagerDialog.this.getImageLength() * 255.0)));
                    } else {
                        ColorTableManagerDialog.this.percent.setText(FORMATTER.format((double)imagePoint / (double)ColorTableManagerDialog.this.getImageLength()));
                    }
                    ColorTableManagerDialog.this.red.setText(ColorTableManagerDialog.this.rgbButton.isSelected() ? String.valueOf(grabbedColor.getRed()) : FORMATTER.format(ColorTableManagerDialog.this.floatColors[0]));
                    ColorTableManagerDialog.this.green.setText(ColorTableManagerDialog.this.rgbButton.isSelected() ? String.valueOf(grabbedColor.getGreen()) : FORMATTER.format(ColorTableManagerDialog.this.floatColors[1]));
                    ColorTableManagerDialog.this.blue.setText(ColorTableManagerDialog.this.rgbButton.isSelected() ? String.valueOf(grabbedColor.getBlue()) : FORMATTER.format(ColorTableManagerDialog.this.floatColors[2]));
                    ColorTableManagerDialog.this.grabbedKnot = ColorTableManagerDialog.this.addKnot(true);
                    ColorTableManagerDialog.this.gradient.setSelected(true);
                    ColorTableManagerDialog.access$2602(ColorTableManagerDialog.this, ColorTableManagerDialog.this.lutManager.getKnots());
                    for (int ctr = 0; ctr < ColorTableManagerDialog.this.knots.length; ++ctr) {
                        if (ColorTableManagerDialog.this.knots[ctr] != ColorTableManagerDialog.this.grabbedKnot) continue;
                        ColorTableManagerDialog.this.selectedArrow = ctr;
                        ColorTableManagerDialog.this.knotRangeMin = (int)(((ColorTableManagerDialog)ColorTableManagerDialog.this).knots[ctr - 1].val * (double)ColorTableManagerDialog.this.getImageLength() + 0.5);
                        ColorTableManagerDialog.this.knotRangeMax = (int)(((ColorTableManagerDialog)ColorTableManagerDialog.this).knots[ctr + 1].val * (double)ColorTableManagerDialog.this.getImageLength() + 0.5);
                    }
                }
                ColorTableManagerDialog.this.updateAddButtonText();
                ColorTableManagerDialog.this.updateRemoveButton();
                ColorTableManagerDialog.this.updateGradientButton();
                ColorTableManagerDialog.this.updateExpressionButton();
                ColorTableManagerDialog.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                ColorTableManagerDialog.this.grabbedKnot = null;
                ColorTableManagerDialog.this.repaint();
            }
        });
        imagePanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                if (ColorTableManagerDialog.this.grabbedKnot != null) {
                    int imagePoint = me.getPoint().x - ColorTableManagerDialog.this.getImagePanelLengthOffset();
                    double value = (double)imagePoint / (double)ColorTableManagerDialog.this.getImageLength();
                    if (imagePoint > ColorTableManagerDialog.this.knotRangeMin && imagePoint < ColorTableManagerDialog.this.knotRangeMax) {
                        ((ColorTableManagerDialog)ColorTableManagerDialog.this).grabbedKnot.val = value;
                        if (ColorTableManagerDialog.this.rgbButton.isSelected()) {
                            ColorTableManagerDialog.this.percent.setText(String.valueOf((int)Math.round(value * 255.0)));
                        } else {
                            ColorTableManagerDialog.this.percent.setText(FORMATTER.format(value));
                        }
                        ColorTableManagerDialog.this.repaint();
                    }
                }
            }
        });
        imagePanel.setPreferredSize(new Dimension(this.getImageLength() + 20, 50));
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1));
        buttonPanel.add(this.removeButton, 0, 0);
        buttonPanel.add(this.addButton, 1, 0);
        JPanel imagePanelOut = new JPanel();
        imagePanelOut.add(imagePanel);
        imagePanelOut.add(buttonPanel);
        JLabel nameLabel = new JLabel("Name: ");
        this.name = new MangoTextField("", 16);
        this.name.setText(this.lutManager.getName());
        this.lutBox = new MangoComboBox();
        this.lutBox.setSelectedItem(0);
        this.lutBox.setMaximumRowCount(20);
        this.lutBox.setFocusable(false);
        this.lutBox.addActionListener(this);
        this.lutBox.setActionCommand("Combo Box Selected");
        this.updateLUTBox(null);
        JPanel lowerPanel = new JPanel();
        lowerPanel.add(nameLabel);
        lowerPanel.add(this.name);
        lowerPanel.add(this.lutBox);
        this.setLayout(new BoxLayout(this, 1));
        this.add(allColorOptionsPanel);
        this.add(imagePanelOut);
        this.add(lowerPanel);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("Percent Changed")) {
            double valDbl = 0.0;
            try {
                valDbl = Double.parseDouble(this.percent.getText());
            }
            catch (NumberFormatException ex) {
                AppLogger.info((Throwable)ex);
            }
            int valInt = this.rgbButton.isSelected() ? (int)(valDbl + 0.5) : (int)(255.0 * valDbl + 0.5);
            this.selectedArrow = -1;
            for (int ctr = 0; ctr < this.knots.length; ++ctr) {
                if ((int)(255.0 * this.knots[ctr].val + 0.5) != valInt) continue;
                this.selectedArrow = ctr;
            }
            this.updateAddButtonText();
        } else if (ae.getActionCommand().equals("expression")) {
            ExpressionEditorDialog dialog = new ExpressionEditorDialog(true);
            String tempExpression = this.lutManager.getExpression();
            if (tempExpression != null) {
                dialog.setResultsText(tempExpression);
            } else {
                dialog.setResultsText(this.lastExpressionTry);
            }
            int selection = JOptionPane.showConfirmDialog(this.getParent(), dialog, "Expression Editor", 2, -1, null);
            if (selection == 0) {
                this.lastExpressionTry = dialog.getResults();
                if (this.lastExpressionTry != null && this.lastExpressionTry.length() > 0) {
                    if (this.checkFormula(this.lastExpressionTry)) {
                        this.lutManager.setExpression(this.lastExpressionTry);
                    } else {
                        this.lutManager.setExpression(null);
                    }
                } else {
                    this.lutManager.setExpression(null);
                }
            }
        } else if (command.equals("Add Knot")) {
            this.addKnot();
        } else if (command.equals("Remove Knot")) {
            if (this.selectedArrow > 0 && this.selectedArrow < this.knots.length - 1) {
                LookupTableKnot[] allNewKnots = new LookupTableKnot[this.knots.length - 1];
                int ctrNewKnots = 0;
                for (int ctr = 0; ctr < this.knots.length; ++ctr) {
                    if (ctr == this.selectedArrow) continue;
                    allNewKnots[ctrNewKnots++] = this.knots[ctr];
                }
                this.lutManager.replaceKnots(allNewKnots);
                this.selectedArrow = 0;
            }
        } else if (command.equals("Combo Box Selected")) {
            if (this.freezeLutBox) {
                return;
            }
            String itemName = (String)this.lutBox.getSelectedItem();
            if (itemName.equals(DEFAULT_NAME_BOX)) {
                this.lutManager.replaceKnots(new LookupTableKnot[]{new LookupTableKnot(0.0, 0.0, 0.0, 0.0, true), new LookupTableKnot(1.0, 1.0, 1.0, 1.0, false)});
                this.lutManager.setExpression(null);
                this.name.setText(DEFAULT_NAME);
            } else {
                this.lutManager.replaceKnots(LookupTableManager.getLUTKnotsCopy(itemName));
                this.lutManager.setExpression(LookupTableManager.getLUTExpression(itemName));
                this.name.setText(itemName);
            }
            this.selectedArrow = 0;
            this.updateDeleteButton();
        } else if (command.equals("Choose Color")) {
            this.colorChooser = new JColorChooser(this.currentColor);
            JDialog dialog = JColorChooser.createDialog(this, "Colors", true, this.colorChooser, this, this);
            dialog.setVisible(true);
        } else if (command.equals("OK")) {
            this.currentColor = this.colorChooser.getColor();
            if (this.rgbButton.isSelected()) {
                this.red.setText(String.valueOf(this.currentColor.getRed()));
                this.green.setText(String.valueOf(this.currentColor.getGreen()));
                this.blue.setText(String.valueOf(this.currentColor.getBlue()));
            } else {
                this.red.setText(FORMATTER.format((double)this.currentColor.getRed() / 255.0));
                this.green.setText(FORMATTER.format((double)this.currentColor.getGreen() / 255.0));
                this.blue.setText(FORMATTER.format((double)this.currentColor.getBlue() / 255.0));
            }
            this.addKnot();
        } else if (command.equals("RGB Type")) {
            this.updateFields();
        }
        this.knots = this.lutManager.getKnots();
        this.updateKnots();
        this.lutManager.updateLUT();
        this.updateRemoveButton();
        this.updateGradientButton();
        this.updateExpressionButton();
        if (this.selectedArrow != -1) {
            this.updateFields(this.selectedArrow);
        }
        this.repaint();
    }

    public void doDelete() {
        String nameStr = this.name.getText();
        LookupTableManager.removeLUT(nameStr);
        this.updateLUTBox(DEFAULT_NAME_BOX);
        this.lutBox.setSelectedIndex(0);
        this.updateDeleteButton();
    }

    public void doExport(JDialog parentFrame) {
        File selectedFile = null;
        String fileName = this.getLookupTableManager().getName() + ".lut";
        selectedFile = SaveFileDialog.showSaveFileChooser(parentFrame, this.mango.getLoadFileDirectory(), fileName);
        if (selectedFile != null) {
            LookupTableManager lut = this.getLUT();
            String name = selectedFile.getName();
            if (name.indexOf(46) != -1) {
                name = name.substring(0, name.indexOf(46));
            }
            LUT lutTemp = new LUT(lut.getKnots(), this.getLookupTableManager().getName(), lut.getExpression());
            LookupTableManager.writeLUT(name, lutTemp, selectedFile);
        }
    }

    public void doImport(JDialog parentFrame) {
        LookupTableManager lut;
        File selectedFile = OpenFileDialog.showOpenFileChooser(parentFrame, this.mango.getLoadFileDirectory(), new String[]{".lut"}, "Color Table Files");
        if (selectedFile != null && (lut = LookupTableManager.readLUT(selectedFile.toURI())) != null) {
            this.setLUT(lut);
        }
    }

    public void doSave() {
        LookupTableManager lutNew = this.getLookupTableManager();
        StringBuffer sbName = new StringBuffer(lutNew.getName());
        for (String element : LookupTableManager.NAMES) {
            if (!sbName.toString().equals(element)) continue;
            sbName.append(" New");
        }
        if (sbName.toString().equals(DEFAULT_NAME)) {
            sbName = new StringBuffer("New Color Table 1");
        }
        String sbNameString = sbName.toString();
        LookupTableManager.addLUT(sbNameString, lutNew.getExpression(), lutNew.getKnots());
        SliceViewer currentViewer = this.mango.getToolBox().getCurrentViewer();
        if (currentViewer != null) {
            this.mango.getToolBox().setLUT(sbNameString);
        }
        this.updateLUTBox(sbNameString);
        this.name.setText(sbNameString);
        this.updateDeleteButton();
    }

    public LookupTableManager getLookupTableManager() {
        this.lutManager.setName(this.name.getText().trim());
        return this.lutManager;
    }

    public LookupTableManager getLUT() {
        return this.lutManager;
    }

    public void setDeleteButton(JButton deleteButton) {
        this.deleteLUTButton = deleteButton;
    }

    public void setLUT(LookupTableManager aLUT) {
        this.lutManager.replaceKnots(aLUT.getKnots());
        this.lutManager.setExpression(aLUT.getExpression());
        this.name.setText(aLUT.getName());
        this.knots = this.lutManager.getKnots();
        this.updateKnots();
        this.lutManager.updateLUT();
        this.updateRemoveButton();
        this.updateGradientButton();
        if (this.selectedArrow != -1) {
            this.updateFields(this.selectedArrow);
        }
        this.repaint();
    }

    private LookupTableKnot addKnot() {
        return this.addKnot(false);
    }

    private LookupTableKnot addKnot(boolean forceAddGradation) {
        int blueNew;
        boolean success = true;
        int currentArrow = -1;
        LookupTableKnot editedKnot = null;
        int percentNewInt = this.rgbButton.isSelected() ? (int)(Double.parseDouble(this.percent.getText()) + 0.5) : (int)(255.0 * Double.parseDouble(this.percent.getText()) + 0.5);
        double percentNew = (double)percentNewInt / 255.0;
        int redNew = this.rgbButton.isSelected() ? (int)(Double.parseDouble(this.red.getText()) + 0.5) : (int)(255.0 * Double.parseDouble(this.red.getText()) + 0.5);
        int greenNew = this.rgbButton.isSelected() ? (int)(Double.parseDouble(this.green.getText()) + 0.5) : (int)(255.0 * Double.parseDouble(this.green.getText()) + 0.5);
        int n = blueNew = this.rgbButton.isSelected() ? (int)(Double.parseDouble(this.blue.getText()) + 0.5) : (int)(255.0 * Double.parseDouble(this.blue.getText()) + 0.5);
        if (percentNew < 0.0 || percentNew > 1.0 || redNew < 0 || redNew > 255 || greenNew < 0 || greenNew > 255 || blueNew < 0 || blueNew > 255) {
            success = false;
        }
        if (success) {
            int foundIndex = -1;
            for (int ctr = 0; ctr < this.knots.length; ++ctr) {
                if ((int)(255.0 * this.knots[ctr].val + 0.5) != percentNewInt) continue;
                foundIndex = ctr;
            }
            if (foundIndex >= 0) {
                this.knots[foundIndex].setRed(redNew);
                this.knots[foundIndex].setGreen(greenNew);
                this.knots[foundIndex].setBlue(blueNew);
                this.knots[foundIndex].useGradation = this.gradient.isSelected();
                currentArrow = foundIndex;
                editedKnot = this.knots[foundIndex];
            } else {
                LookupTableKnot knotNew;
                this.lutManager.setExpression(null);
                editedKnot = knotNew = new LookupTableKnot(percentNew, redNew, greenNew, blueNew);
                knotNew.setGradient(this.gradient.isSelected() || forceAddGradation);
                ArrayList<LookupTableKnot> list = new ArrayList<LookupTableKnot>(Arrays.asList(this.knots));
                list.add(knotNew);
                Collections.sort(list);
                this.knots = list.toArray(new LookupTableKnot[list.size()]);
                this.lutManager.replaceKnots(this.knots);
            }
        }
        if (success) {
            this.selectedArrow = currentArrow;
        } else {
            this.updateFields(0);
            this.selectedArrow = 0;
        }
        return editedKnot;
    }

    private boolean checkFormula(String input) {
        boolean valid = true;
        if (!ImageOperationTreeNode.hasValidParentheses(input)) {
            Mango.showErrorDialogStatic("Not all parentheses close in that expression!", "Formula Failed");
            valid = false;
        } else {
            StringBuffer operationString = new StringBuffer(input);
            double[] parsedValues = ImageOperationTreeNode.makeReplacements(operationString);
            ImageOperationTreeNode startNode = ImageOperationTreeNode.makeOperationTree(operationString.toString(), parsedValues, null, null, true);
            valid = ImageOperationTreeNode.isValidStartNode(startNode);
        }
        if (!valid) {
            Mango.showErrorDialogStatic("Could not process that expression!", "Formula Failed");
        }
        return valid;
    }

    private int getImageLength() {
        if (Platform.MAC) {
            return 320;
        }
        return 255;
    }

    private int getImagePanelHeightOffset() {
        return (int)Math.round(5.0);
    }

    private int getImagePanelLengthOffset() {
        return (int)Math.round(10.0) + 1;
    }

    private void initializeLUTImage() {
        double ratio = 255.0 / (double)this.getImageLength();
        int value = 0;
        for (int ctr = 0; ctr < 40; ++ctr) {
            for (int ctrIn = 0; ctrIn < this.getImageLength(); ++ctrIn) {
                value = (int)(ratio * (double)ctrIn + 0.5);
                this.lutData[ctr * this.getImageLength() + ctrIn] = value | value << 8 | value << 16 | 0xFF000000;
            }
        }
    }

    private void updateAddButtonText() {
        if (this.selectedArrow == -1) {
            this.addButton.setText("Add Knot");
        } else {
            this.addButton.setText("Update Knot");
        }
    }

    private void updateDeleteButton() {
        this.deleteLUTButton.setEnabled(true);
        String nameStr = this.name.getText();
        for (String element : LookupTableManager.NAMES) {
            if (!nameStr.equals(element)) continue;
            this.deleteLUTButton.setEnabled(false);
            break;
        }
        if (nameStr.equals(DEFAULT_NAME)) {
            this.deleteLUTButton.setEnabled(false);
        }
    }

    private void updateExpressionButton() {
        this.expressionButton.setEnabled(this.knots.length == 2);
    }

    private void updateFields() {
        this.updateFields(this.selectedArrow);
    }

    private void updateFields(int index) {
        this.currentColor = new Color(this.knots[index].rVal, this.knots[index].gVal, this.knots[index].bVal);
        if (this.rgbButton.isSelected()) {
            this.percent.setText(String.valueOf((int)(this.knots[index].val * 255.0 + 0.5)));
            this.red.setText(String.valueOf(this.knots[index].rVal));
            this.green.setText(String.valueOf(this.knots[index].gVal));
            this.blue.setText(String.valueOf(this.knots[index].bVal));
        } else {
            this.percent.setText(FORMATTER.format(this.knots[index].val * 1.0));
            this.red.setText(FORMATTER.format((double)this.knots[index].rVal / 255.0 * 1.0));
            this.green.setText(FORMATTER.format((double)this.knots[index].gVal / 255.0 * 1.0));
            this.blue.setText(FORMATTER.format((double)this.knots[index].bVal / 255.0 * 1.0));
        }
        this.percent.setCaretPosition(0);
        this.red.setCaretPosition(0);
        this.green.setCaretPosition(0);
        this.blue.setCaretPosition(0);
        this.gradient.setSelected(this.knots[index].useGradation);
    }

    private void updateGradientButton() {
        if (this.selectedArrow == this.knots.length - 1) {
            this.gradient.setEnabled(false);
        } else {
            this.gradient.setEnabled(true);
        }
    }

    private void updateKnots() {
        this.knots = this.lutManager.getKnots();
        this.knotRects = new Rectangle[this.knots.length];
        for (int ctr = 0; ctr < this.knots.length; ++ctr) {
            this.knotRects[ctr] = new Rectangle((int)(this.knots[ctr].val * (double)this.getImageLength()) + 6, 3, 11, 17);
        }
    }

    private void updateLUTBox(String selectedItem) {
        this.freezeLutBox = true;
        String lastSelected = selectedItem;
        if (lastSelected == null) {
            lastSelected = (String)this.lutBox.getSelectedItem();
        }
        this.lutBox.removeAllItems();
        String[] lutNames = LookupTableManager.getAllLUTNames();
        this.lutBox.addItem(DEFAULT_NAME_BOX);
        for (String lutName : lutNames) {
            this.lutBox.addItem(lutName);
        }
        if (StringUtils.isBlank((CharSequence)lastSelected)) {
            this.lutBox.setSelectedItem(DEFAULT_NAME_BOX);
        } else {
            this.lutBox.setSelectedItem(lastSelected);
        }
        this.freezeLutBox = false;
    }

    private void updateLUTImage() {
        if (this.lutManager != null) {
            this.lutManager.updateLUT();
            this.lutManager.getOp().filter(this.lutImage, this.lutImageFiltered);
        }
    }

    private void updateRemoveButton() {
        if (this.selectedArrow > 0 && this.selectedArrow < this.knots.length - 1) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    static /* synthetic */ LookupTableKnot[] access$2602(ColorTableManagerDialog x0, LookupTableKnot[] x1) {
        x0.knots = x1;
        return x1;
    }
}

