/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.modal;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoColorButton;
import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPicker;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPickerPopupManager;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.roi.ColorManager;
import edu.uthscsa.ric.roi.ROIDefaultLabels;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.formats.nifti.NIFTI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;

public class AddImageDialog
extends JPanel
implements ActionListener,
MangoColorSelectedListener,
ColorManager,
MangoColorPickerPopupManager {
    private JCheckBox useROI;
    private JCheckBox useViewer;
    private JLabel timepointsLabel;
    private JLabel trLabel;
    private JTextField colSize;
    private JTextField cols;
    private JTextField imageName;
    private JTextField rowSize;
    private JTextField rows;
    private JTextField sliceSize;
    private JTextField slices;
    private JTextField timepoints;
    private JTextField tr;
    private MangoColorButton roiButton;
    private MangoComboBox<SliceViewer> compatibleBox;
    private MangoComboBox<String> spatialUnits;
    private MangoComboBox<String> temporalUnits;
    private Popup popupROI;
    private boolean freezeViewerBox;
    private final Mango mango;
    private static ImageBounds roiBounds;
    private static ImageDimensions lastViewerDims;
    private static ImageType lastViewerType;
    private static String lastViewerOrientation;
    private static VoxelDimensions lastViewerVox;
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_IMAGE_DIMENSION = "100";
    public static final String DEFAULT_IMAGE_DIMENSION_TIME = "1";
    public static final String DEFAULT_NAME = "myNewImage";
    public static final String DEFAULT_VOXEL_DIMENSION = "1.0";
    public static final String DEFAULT_VOXEL_DIMENSION_TIME = "0";
    public static final int SPATIAL_UNITS_INDEX = 2;
    public static final int TEMPORAL_UNITS_INDEX = 1;
    public static final String ACTION_UPDATE_IMAGE_SIZE = "updateImageSize";

    public static ImageType getImageType() {
        int numBytes = 4;
        int byteType = 4;
        return new ImageType(4, 4, 32, false);
    }

    public static void setLastViewerParams(ImageDimensions id, VoxelDimensions vd, ImageType it, String orientationString) {
        lastViewerDims = id;
        lastViewerVox = vd;
        lastViewerType = it;
        lastViewerOrientation = orientationString;
    }

    public AddImageDialog(Mango mango) {
        this.mango = mango;
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("restore")) {
            this.cols.setText(DEFAULT_IMAGE_DIMENSION);
            this.rows.setText(DEFAULT_IMAGE_DIMENSION);
            this.slices.setText(DEFAULT_IMAGE_DIMENSION);
            this.timepoints.setText(DEFAULT_IMAGE_DIMENSION);
            this.colSize.setText(DEFAULT_VOXEL_DIMENSION);
            this.rowSize.setText(DEFAULT_VOXEL_DIMENSION);
            this.sliceSize.setText(DEFAULT_VOXEL_DIMENSION);
            this.tr.setText(DEFAULT_VOXEL_DIMENSION);
            this.spatialUnits.setSelectedIndex(2);
            this.temporalUnits.setSelectedIndex(1);
            this.roiButton.setEnabled(false);
            this.setROIBounds(null);
            this.useViewer.setSelected(false);
        } else if (command.equals("roiButtonToggle")) {
            if (this.popupROI != null) {
                this.popupROI.hide();
                this.popupROI = null;
            } else {
                this.showROIColorPicker();
            }
        } else if (command.equals("useviewer")) {
            this.closePopups();
            if (this.useViewer.isSelected()) {
                this.compatibleBox.setEnabled(true);
                this.updateParametersFromViewer((SliceViewer)this.compatibleBox.getSelectedItem());
                SliceViewer lastViewer = (SliceViewer)this.compatibleBox.getSelectedItem();
                if (!lastViewer.isDead()) {
                    this.useROI.setEnabled(lastViewer.getROIManager().hasROI());
                }
            } else {
                this.compatibleBox.setEnabled(false);
                this.useROI.setEnabled(false);
                this.useROI.setSelected(false);
                this.roiButton.setEnabled(false);
            }
        } else if (command.equals("copy roi only")) {
            this.closePopups();
            if (this.useROI.isSelected()) {
                this.roiButton.setEnabled(true);
                SliceViewer viewer = (SliceViewer)this.compatibleBox.getSelectedItem();
                ROIManager roiManager = viewer.getROIManager();
                for (int ctr = 0; ctr < roiManager.getBuffer().getMaximumColors(); ++ctr) {
                    if (!((SliceViewer)this.compatibleBox.getSelectedItem()).getROIManager().hasROI(ctr)) continue;
                    this.roiButton.setColor(ctr, viewer.getROIManager().getLabel(ctr, ROIDefaultLabels.getDefaultLabelBitPlaneOrder(ctr, roiManager.getBuffer().getMaximumColors())));
                    this.doROIButtonChosen(ctr);
                    break;
                }
            } else {
                this.roiButton.setEnabled(false);
                this.updateParametersFromViewer((SliceViewer)this.compatibleBox.getSelectedItem());
            }
        } else if (command.equals("Viewer Selected") && !this.freezeViewerBox) {
            SliceViewer lastViewer = (SliceViewer)this.compatibleBox.getSelectedItem();
            if (lastViewer == null) {
                this.compatibleBox.setSelectedIndex(0);
                lastViewer = (SliceViewer)this.compatibleBox.getSelectedItem();
            }
            this.updateParametersFromViewer((SliceViewer)this.compatibleBox.getSelectedItem());
            if (lastViewer != null && !lastViewer.isDead()) {
                this.useROI.setEnabled(lastViewer.getROIManager().hasROI());
                this.roiButton.setEnabled(lastViewer.getROIManager().hasROI());
                this.useROI.setSelected(false);
            }
        }
        this.timepoints.setEnabled(!this.useViewer.isSelected());
        this.tr.setEnabled(!this.useViewer.isSelected());
        this.timepointsLabel.setEnabled(!this.useViewer.isSelected());
        this.trLabel.setEnabled(!this.useViewer.isSelected());
        if (this.useViewer.isSelected()) {
            this.timepoints.setText(DEFAULT_IMAGE_DIMENSION_TIME);
            this.tr.setText(DEFAULT_VOXEL_DIMENSION_TIME);
        }
    }

    public boolean addImage() {
        String error = this.doValidate();
        if (error != null) {
            JOptionPane.showMessageDialog(this, error + " ", "Error", 0);
            return false;
        }
        ImageDimensions id = this.getImageDimensions();
        ImageType it = ImageType.getWorkBufferImageType();
        VoxelDimensions vd = this.getVoxelDimensions();
        if (this.useViewer.isSelected()) {
            SliceViewer lastViewer = (SliceViewer)this.compatibleBox.getSelectedItem();
            String filename = this.getImageName();
            File selectedFile = new File(lastViewer.getLoadedFile().getParent(), filename);
            int ctr = 2;
            while (selectedFile.exists()) {
                selectedFile = new File(lastViewer.getLoadedFile().getParent(), filename + "_" + ctr);
                ++ctr;
            }
            Header header = new Header(it, id, vd, lastViewer.getVolume().getImageRange());
            header.setImageFile(selectedFile);
            ImageBounds ib = null;
            if (roiBounds == null) {
                ImageDimensions imageDims = lastViewer.getVolume().getImageDimensions();
                ib = new ImageBounds(0, imageDims.getX() - 1, 0, imageDims.getY() - 1, 0, imageDims.getZ() - 1);
            } else {
                ib = new ImageBounds(roiBounds.getMinX(), roiBounds.getMaxX(), roiBounds.getMinY(), roiBounds.getMaxY(), roiBounds.getMinZ(), roiBounds.getMaxZ());
            }
            header.setOrientation(lastViewer.getVolume().getOrientationString());
            header.setOrientationCertainty(2);
            ib.setRangeT(lastViewer.getVolume().getCurrentTimepoint(), lastViewer.getVolume().getCurrentTimepoint());
            header.setOrigin(lastViewer.getVolume().getOriginNative());
            header.setOriginOriginal(lastViewer.getVolume().getOriginNative());
            this.mango.addViewer(header, selectedFile, lastViewer.getVolume(), ib);
        } else {
            String filename = this.getImageName();
            File selectedFile = new File(this.mango.getLoadFileDirectory(), filename);
            int ctr = 2;
            while (selectedFile.exists()) {
                selectedFile = new File(this.mango.getLoadFileDirectory(), filename + "_" + ctr);
                ++ctr;
            }
            Header header = new Header(it, id, vd);
            SliceViewer lastViewer = (SliceViewer)this.compatibleBox.getSelectedItem();
            if (lastViewer != null) {
                header.setOrientation(lastViewer.getVolume().getOrientationString());
            } else {
                header.setOrientation("XYZ+--");
            }
            header.setOrientationCertainty(2);
            header.setImageFile(selectedFile);
            this.mango.addViewer(header, selectedFile, null, null);
        }
        return true;
    }

    @Override
    public void closeColorPickerPopup() {
        this.closePopups();
    }

    public void colorSelected(int colorNum) {
        this.closePopups();
        this.doROIButtonChosen(colorNum);
    }

    public String getImageName() {
        String name = this.imageName.getText();
        if (name == null || name.length() == 0) {
            name = DEFAULT_NAME;
        }
        name = name.trim();
        return name;
    }

    public int getMaximumColors() {
        SliceViewer lastViewer = (SliceViewer)this.compatibleBox.getSelectedItem();
        if (lastViewer != null) {
            return lastViewer.getROIManager().getMaximumColors();
        }
        return -1;
    }

    public boolean isSelected(int color) {
        return false;
    }

    public boolean isUsed(int color) {
        return false;
    }

    private void closePopups() {
        if (this.popupROI != null) {
            this.popupROI.hide();
            this.popupROI = null;
        }
    }

    private void createUI() {
        JLabel dimX = new JLabel("Cols");
        dimX.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        JLabel dimY = new JLabel("Rows");
        dimY.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        JLabel dimZ = new JLabel("Slices");
        dimZ.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        JLabel sizeX = new JLabel("Cols");
        sizeX.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        JLabel sizeY = new JLabel("Rows");
        sizeY.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        JLabel sizeZ = new JLabel("Slices");
        sizeZ.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        this.timepointsLabel = new JLabel("Vols");
        this.timepointsLabel.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        this.trLabel = new JLabel("Time");
        this.trLabel.setBackground(MangoStyle.COLOR_PANEL_INSIDE);
        this.rows = new MangoTextField(DEFAULT_IMAGE_DIMENSION, 4);
        this.rows.addActionListener(this);
        this.rows.setActionCommand(ACTION_UPDATE_IMAGE_SIZE);
        this.rows.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.rows.getPreferredSize().height));
        this.cols = new MangoTextField(DEFAULT_IMAGE_DIMENSION, 4);
        this.cols.addActionListener(this);
        this.cols.setActionCommand(ACTION_UPDATE_IMAGE_SIZE);
        this.cols.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.cols.getPreferredSize().height));
        this.slices = new MangoTextField(DEFAULT_IMAGE_DIMENSION, 4);
        this.slices.addActionListener(this);
        this.slices.setActionCommand(ACTION_UPDATE_IMAGE_SIZE);
        this.slices.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.slices.getPreferredSize().height));
        this.rowSize = new MangoTextField(DEFAULT_VOXEL_DIMENSION, 4);
        this.rowSize.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.rowSize.getPreferredSize().height));
        this.colSize = new MangoTextField(DEFAULT_VOXEL_DIMENSION, 4);
        this.colSize.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.colSize.getPreferredSize().height));
        this.sliceSize = new MangoTextField(DEFAULT_VOXEL_DIMENSION, 4);
        this.sliceSize.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.sliceSize.getPreferredSize().height));
        this.timepoints = new MangoTextField(DEFAULT_IMAGE_DIMENSION_TIME, 4);
        this.timepoints.addActionListener(this);
        this.timepoints.setActionCommand(ACTION_UPDATE_IMAGE_SIZE);
        this.timepoints.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.timepoints.getPreferredSize().height));
        this.tr = new MangoTextField(DEFAULT_VOXEL_DIMENSION_TIME, 4);
        this.tr.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.tr.getPreferredSize().height));
        JPanel imageDimPanel = new JPanel();
        imageDimPanel.setLayout(new BoxLayout(imageDimPanel, 0));
        imageDimPanel.add(Box.createHorizontalStrut(4));
        imageDimPanel.add(dimX);
        imageDimPanel.add(Box.createHorizontalStrut(2));
        imageDimPanel.add(this.cols);
        imageDimPanel.add(Box.createHorizontalStrut(10));
        imageDimPanel.add(dimY);
        imageDimPanel.add(Box.createHorizontalStrut(2));
        imageDimPanel.add(this.rows);
        imageDimPanel.add(Box.createHorizontalStrut(10));
        imageDimPanel.add(dimZ);
        imageDimPanel.add(Box.createHorizontalStrut(2));
        imageDimPanel.add(this.slices);
        imageDimPanel.add(Box.createHorizontalStrut(10));
        imageDimPanel.add(this.timepointsLabel);
        imageDimPanel.add(Box.createHorizontalStrut(2));
        imageDimPanel.add(this.timepoints);
        imageDimPanel.add(Box.createHorizontalStrut(4));
        imageDimPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Image Dimensions"));
        JLabel spatialUnitsLabel = new JLabel("Spatial:");
        this.spatialUnits = new MangoComboBox<String>((T[])new String[]{NIFTI.getNiftiUnitString(0), NIFTI.getNiftiUnitString(3), NIFTI.getNiftiUnitString(2), NIFTI.getNiftiUnitString(1)});
        this.spatialUnits.setSelectedIndex(2);
        JLabel temporalUnitsLabel = new JLabel("Temporal:");
        this.temporalUnits = new MangoComboBox<String>((T[])new String[]{NIFTI.getNiftiUnitString(0), NIFTI.getNiftiUnitString(8), NIFTI.getNiftiUnitString(16), NIFTI.getNiftiUnitString(24)});
        this.temporalUnits.setSelectedIndex(1);
        this.temporalUnits.setMaximumSize(this.temporalUnits.getPreferredSize());
        this.temporalUnits.setMinimumSize(this.temporalUnits.getPreferredSize());
        this.spatialUnits.setMaximumSize(this.temporalUnits.getPreferredSize());
        this.spatialUnits.setMinimumSize(this.temporalUnits.getPreferredSize());
        JPanel unitsPanel = new JPanel();
        unitsPanel.setLayout(new BoxLayout(unitsPanel, 0));
        unitsPanel.add(Box.createHorizontalGlue());
        unitsPanel.add(Box.createHorizontalStrut(4));
        unitsPanel.add(spatialUnitsLabel);
        unitsPanel.add(Box.createHorizontalStrut(2));
        unitsPanel.add(this.spatialUnits);
        unitsPanel.add(Box.createHorizontalGlue());
        unitsPanel.add(Box.createHorizontalStrut(20));
        unitsPanel.add(Box.createHorizontalGlue());
        unitsPanel.add(temporalUnitsLabel);
        unitsPanel.add(Box.createHorizontalStrut(2));
        unitsPanel.add(this.temporalUnits);
        unitsPanel.add(Box.createHorizontalStrut(4));
        unitsPanel.add(Box.createHorizontalGlue());
        JPanel voxDimPanel = new JPanel();
        voxDimPanel.setLayout(new BoxLayout(voxDimPanel, 0));
        voxDimPanel.add(Box.createHorizontalStrut(4));
        voxDimPanel.add(sizeX);
        voxDimPanel.add(Box.createHorizontalStrut(2));
        voxDimPanel.add(this.colSize);
        voxDimPanel.add(Box.createHorizontalStrut(10));
        voxDimPanel.add(sizeY);
        voxDimPanel.add(Box.createHorizontalStrut(2));
        voxDimPanel.add(this.rowSize);
        voxDimPanel.add(Box.createHorizontalStrut(10));
        voxDimPanel.add(sizeZ);
        voxDimPanel.add(Box.createHorizontalStrut(2));
        voxDimPanel.add(this.sliceSize);
        voxDimPanel.add(Box.createHorizontalStrut(10));
        voxDimPanel.add(this.trLabel);
        voxDimPanel.add(Box.createHorizontalStrut(2));
        voxDimPanel.add(this.tr);
        voxDimPanel.add(Box.createHorizontalStrut(4));
        JPanel voxPanel = new JPanel();
        voxPanel.setLayout(new BoxLayout(voxPanel, 1));
        voxPanel.add(voxDimPanel);
        voxPanel.add(Box.createVerticalStrut(4));
        voxPanel.add(unitsPanel);
        voxPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Voxel Dimensions & Units"));
        this.useViewer = new JCheckBox("Copy Data:");
        this.useViewer.setActionCommand("useviewer");
        this.useViewer.addActionListener(this);
        this.compatibleBox = new MangoComboBox();
        this.compatibleBox.setMaximumRowCount(20);
        this.compatibleBox.setActionCommand("Viewer Selected");
        this.compatibleBox.addActionListener(this);
        this.compatibleBox.setPreferredSize(new Dimension(200, this.compatibleBox.getPreferredSize().height));
        this.compatibleBox.setMaximumSize(this.compatibleBox.getPreferredSize());
        this.compatibleBox.setMinimumSize(this.compatibleBox.getPreferredSize());
        this.useROI = new JCheckBox("Use ROI Bounds:");
        this.useROI.setActionCommand("copy roi only");
        this.useROI.addActionListener(this);
        this.roiButton = new MangoColorButton(-1, (ColorManager)this, this.mango);
        this.roiButton.setActionCommand("roiButtonToggle");
        this.roiButton.addActionListener(this);
        JPanel roiButtonPanel = new JPanel();
        roiButtonPanel.setLayout(new BoxLayout(roiButtonPanel, 0));
        roiButtonPanel.add(this.roiButton);
        roiButtonPanel.setBackground(Color.WHITE);
        JPanel useViewerPanel = new JPanel();
        useViewerPanel.setLayout(new BoxLayout(useViewerPanel, 0));
        useViewerPanel.add(Box.createHorizontalStrut(4));
        useViewerPanel.add(this.useViewer);
        useViewerPanel.add(this.compatibleBox);
        useViewerPanel.add(Box.createHorizontalStrut(8));
        useViewerPanel.add(this.useROI);
        useViewerPanel.add(roiButtonPanel);
        useViewerPanel.add(Box.createHorizontalStrut(4));
        this.imageName = new MangoTextField(DEFAULT_NAME, 25);
        this.imageName.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.imageName.getPreferredSize().height));
        this.imageName.setMinimumSize(new Dimension(0, this.imageName.getPreferredSize().height));
        JLabel nameLabel = new JLabel("Name:");
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 0));
        namePanel.add(Box.createHorizontalStrut(4));
        namePanel.add(nameLabel);
        namePanel.add(Box.createHorizontalStrut(2));
        namePanel.add(this.imageName);
        namePanel.add(Box.createHorizontalStrut(4));
        JPanel fileOpenPanel = new JPanel();
        fileOpenPanel.setLayout(new BoxLayout(fileOpenPanel, 1));
        fileOpenPanel.add(Box.createHorizontalGlue());
        fileOpenPanel.add(namePanel);
        fileOpenPanel.add(Box.createVerticalStrut(4));
        fileOpenPanel.add(useViewerPanel);
        fileOpenPanel.add(Box.createHorizontalGlue());
        fileOpenPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "New Image"));
        this.setLayout(new BoxLayout(this, 1));
        this.add(imageDimPanel);
        this.add(voxPanel);
        this.add(fileOpenPanel);
        this.updateDialog();
    }

    private void doROIButtonChosen(int roiColor) {
        SliceViewer lastViewer = (SliceViewer)this.compatibleBox.getSelectedItem();
        if (roiColor > -1) {
            this.roiButton.setColor(roiColor, lastViewer.getROIManager().getLabel(roiColor, ROIDefaultLabels.getDefaultLabelBitPlaneOrder(roiColor, lastViewer.getROIManager().getBuffer().getMaximumColors())));
            this.setROIBounds(lastViewer.getROIManager().getROIBounds(1L << roiColor));
            String orientation = lastViewer.getVolume().getOrientationString();
            int minCol = 0;
            int maxCol = 0;
            int minRow = 0;
            int maxRow = 0;
            int minSlice = 0;
            int maxSlice = 0;
            if (orientation.charAt(0) == 'X') {
                minCol = roiBounds.getMinX();
                maxCol = roiBounds.getMaxX();
            } else if (orientation.charAt(0) == 'Y') {
                minCol = roiBounds.getMinY();
                maxCol = roiBounds.getMaxY();
            } else if (orientation.charAt(0) == 'Z') {
                minCol = roiBounds.getMinZ();
                maxCol = roiBounds.getMaxZ();
            }
            if (orientation.charAt(1) == 'X') {
                minRow = roiBounds.getMinX();
                maxRow = roiBounds.getMaxX();
            } else if (orientation.charAt(1) == 'Y') {
                minRow = roiBounds.getMinY();
                maxRow = roiBounds.getMaxY();
            } else if (orientation.charAt(1) == 'Z') {
                minRow = roiBounds.getMinZ();
                maxRow = roiBounds.getMaxZ();
            }
            if (orientation.charAt(2) == 'X') {
                minSlice = roiBounds.getMinX();
                maxSlice = roiBounds.getMaxX();
            } else if (orientation.charAt(2) == 'Y') {
                minSlice = roiBounds.getMinY();
                maxSlice = roiBounds.getMaxY();
            } else if (orientation.charAt(2) == 'Z') {
                minSlice = roiBounds.getMinZ();
                maxSlice = roiBounds.getMaxZ();
            }
            this.cols.setText(String.valueOf(maxCol - minCol + 1));
            this.rows.setText(String.valueOf(maxRow - minRow + 1));
            this.slices.setText(String.valueOf(maxSlice - minSlice + 1));
        } else {
            this.roiButton.setEnabled(false);
            this.setROIBounds(null);
            if (lastViewer != null) {
                ImageDimensions lastViewerDims = lastViewer.getVolume().getImageDimensions();
                this.rows.setText(String.valueOf(lastViewerDims.getRows()));
                this.cols.setText(String.valueOf(lastViewerDims.getCols()));
                this.slices.setText(String.valueOf(lastViewerDims.getSlices()));
            }
        }
    }

    private String doValidate() {
        int colsVal = 0;
        try {
            colsVal = Integer.parseInt(this.cols.getText().trim());
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
            return "Cols (Image Dimensions) must be an integer!";
        }
        if (colsVal <= 0) {
            return "Cols (Image Dimensions) must be greater than zero!";
        }
        int rowsVal = 0;
        try {
            rowsVal = Integer.parseInt(this.rows.getText().trim());
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
            return "Rows (Image Dimensions) must be an integer!";
        }
        if (rowsVal <= 0) {
            return "Rows (Image Dimensions) must be greater than zero!";
        }
        int slicesVal = 0;
        try {
            slicesVal = Integer.parseInt(this.slices.getText().trim());
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
            return "Slices (Image Dimensions) must be an integer!";
        }
        if (slicesVal <= 0) {
            return "Slices (Image Dimensions) must be greater than zero!";
        }
        int timepointsVal = 0;
        try {
            timepointsVal = Integer.parseInt(this.timepoints.getText().trim());
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
            return "Vols (Image Dimensions) must be an integer!";
        }
        if (timepointsVal <= 0) {
            return "Vols (Image Dimensions) must be greater than zero!";
        }
        double colsSizeVal = 0.0;
        try {
            colsSizeVal = Double.parseDouble(this.colSize.getText().trim());
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
            return "Cols (Voxel Dimensions) must be a number!";
        }
        if (colsSizeVal <= 0.0) {
            return "Cols (Voxel Dimensions) must be greater than zero!";
        }
        double rowsSizeVal = 0.0;
        try {
            rowsSizeVal = Double.parseDouble(this.rowSize.getText().trim());
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
            return "Rows (Voxel Dimensions) must be a number!";
        }
        if (rowsSizeVal <= 0.0) {
            return "Rows (Voxel Dimensions) must be greater than zero!";
        }
        double slicesSizeVal = 0.0;
        try {
            slicesSizeVal = Double.parseDouble(this.sliceSize.getText().trim());
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
            return "Slices (Voxel Dimensions) must be a number!";
        }
        if (slicesSizeVal <= 0.0) {
            return "Slices (Voxel Dimensions) must be greater than zero!";
        }
        double trVal = 0.0;
        try {
            trVal = Double.parseDouble(this.tr.getText().trim());
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
            return "Time (Voxel Dimensions) must be a number!";
        }
        if (timepointsVal > 1) {
            if (trVal <= 0.0) {
                return "Time (Voxel Dimensions) must be greater than zero!";
            }
        } else if (trVal < 0.0) {
            return "Time (Voxel Dimensions) cannot be negative!";
        }
        return null;
    }

    private ImageDimensions getImageDimensions() {
        ImageDimensions id = null;
        try {
            int time = Integer.parseInt(this.timepoints.getText().trim());
            if (time < 1) {
                time = 1;
            }
            id = new ImageDimensions(Integer.parseInt(this.cols.getText().trim()), Integer.parseInt(this.rows.getText().trim()), Integer.parseInt(this.slices.getText().trim()), time);
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return id;
    }

    private VoxelDimensions getVoxelDimensions() {
        VoxelDimensions vd = null;
        try {
            vd = new VoxelDimensions(Double.parseDouble(this.colSize.getText().trim()), Double.parseDouble(this.rowSize.getText().trim()), Double.parseDouble(this.sliceSize.getText().trim()), Double.parseDouble(this.tr.getText().trim()));
            vd.setSpatialUnit((String)this.spatialUnits.getSelectedItem());
            vd.setTemporalUnit((String)this.temporalUnits.getSelectedItem());
        }
        catch (NumberFormatException ex) {
            AppLogger.error((Throwable)ex);
        }
        return vd;
    }

    private synchronized void setROIBounds(ImageBounds roiBounds) {
        AddImageDialog.roiBounds = roiBounds;
    }

    private void showROIColorPicker() {
        SliceViewer lastViewer = (SliceViewer)this.compatibleBox.getSelectedItem();
        if (lastViewer != null && lastViewer.getROIManager().hasROI()) {
            this.popupROI = PopupFactory.getSharedInstance().getPopup(this.roiButton, new MangoColorPicker((ColorManager)lastViewer.getROIManager(), this, lastViewer.getROIManager(), lastViewer.getROIManager().getBuffer().getMaximumColors(), false), this.roiButton.getLocationOnScreen().x, this.roiButton.getLocationOnScreen().y + 35);
            this.popupROI.show();
        }
    }

    private void updateDialog() {
        this.updateParametersFromViewer(this.mango.getCurrentSliceViewer());
        this.useViewer.setEnabled(this.mango.getNumViewers() > 0);
        this.useViewer.setSelected(false);
        this.compatibleBox.setEnabled(false);
        SliceViewer[] viewers = Mango.getAllSliceViewers();
        this.freezeViewerBox = true;
        this.compatibleBox.removeAllItems();
        if (viewers != null) {
            for (SliceViewer viewer : viewers) {
                this.compatibleBox.addItem(viewer);
            }
        }
        this.freezeViewerBox = false;
        this.useROI.setEnabled(false);
        this.useROI.setSelected(false);
        this.roiButton.setEnabled(false);
        this.setROIBounds(null);
    }

    private void updateParametersFromViewer(SliceViewer lastViewer) {
        if (lastViewer != null && !lastViewer.isDead()) {
            lastViewerDims = lastViewer.getVolume().getImageDimensions();
            lastViewerVox = lastViewer.getVolume().getVoxelDimensions();
            lastViewerType = lastViewer.getVolume().getImageType();
            lastViewerOrientation = lastViewer.getVolume().getOrientationString();
        }
        if (lastViewerDims != null && lastViewerVox != null && lastViewerType != null && lastViewerOrientation != null) {
            this.rows.setText(String.valueOf(lastViewerDims.getRows()));
            this.cols.setText(String.valueOf(lastViewerDims.getCols()));
            this.slices.setText(String.valueOf(lastViewerDims.getSlices()));
            this.rowSize.setText(String.valueOf(lastViewerVox.getRowSize(true)));
            this.colSize.setText(String.valueOf(lastViewerVox.getColSize(true)));
            this.sliceSize.setText(String.valueOf(lastViewerVox.getSliceThickness(true)));
            this.tr.setText(String.valueOf(lastViewerVox.getTR()));
            this.rows.setCaretPosition(0);
            this.cols.setCaretPosition(0);
            this.slices.setCaretPosition(0);
            this.rowSize.setCaretPosition(0);
            this.colSize.setCaretPosition(0);
            this.sliceSize.setCaretPosition(0);
            int spatialUnitsVox = lastViewerVox.getSpatialUnit();
            if (spatialUnitsVox == 0) {
                this.spatialUnits.setSelectedIndex(0);
            } else if (spatialUnitsVox == 3) {
                this.spatialUnits.setSelectedIndex(1);
            } else if (spatialUnitsVox == 2) {
                this.spatialUnits.setSelectedIndex(2);
            } else if (spatialUnitsVox == 1) {
                this.spatialUnits.setSelectedIndex(3);
            }
            int temporalUnitsVox = lastViewerVox.getTemporalUnit();
            if (temporalUnitsVox == 0) {
                this.temporalUnits.setSelectedIndex(0);
            } else if (temporalUnitsVox == 8) {
                this.temporalUnits.setSelectedIndex(1);
            } else if (temporalUnitsVox == 16) {
                this.temporalUnits.setSelectedIndex(2);
            } else if (temporalUnitsVox == 24) {
                this.temporalUnits.setSelectedIndex(3);
            }
        }
    }
}

