/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.imagebrowser;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.FileNode;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.HeaderInfo;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.ImagePreviewData;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.ImagePreviewPanel;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.SurfaceInfo;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Orientation;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.formats.dicom.DICOM;
import edu.uthscsa.ric.volume.formats.dicom.Series;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PreviewPanel
extends JPanel {
    private FileNode currentPreviewNode;
    private final ImagePreviewPanel imagePreviewPanel;
    private final JLabel imageDimsLabel;
    private final JLabel imageNameLabel;
    private final JLabel imageTypeLabel;
    private final JLabel voxelDimsLabel;
    private final JLabel otherInfoLabel;
    private final JPanel imageDimsPanel;
    private final JPanel imageNamePanel;
    private final JPanel imageTypePanel;
    private final JPanel voxelDimsPanel;
    private final JPanel otherInfoPanel;
    private final Vector<ImagePreviewData> previews = new Vector();
    private static final long serialVersionUID = 1L;
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter();
    public static final String DND_MESSAGE = "<html><center>To load overlays, surfaces and ROIs,<br>drag and drop them onto a viewer.</center></html>";
    public static final int MAX_FOLDER_NAME_PREFIX_SIZE = 15;
    public static final int MAX_FOLDER_NAME_SIZE = 25;
    public static final int MAX_FOLDER_NAME_SUFFIX_SIZE = 5;
    public static final int PREVIEW_SIZE = 260;
    public static final int START_HEIGHT = 500;
    public static final int START_WIDTH = 275;
    public static final String TEXT_BY = " x ";

    public PreviewPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(12));
        this.imageNameLabel = new JLabel();
        this.imageNameLabel.setFont(this.imageNameLabel.getFont().deriveFont(this.imageNameLabel.getFont().getSize2D() * 1.25f));
        this.imageNameLabel.setFont(this.imageNameLabel.getFont().deriveFont(1));
        this.imageNamePanel = new JPanel();
        this.imageNamePanel.setLayout(new BoxLayout(this.imageNamePanel, 0));
        this.imageNamePanel.add(Box.createHorizontalGlue());
        this.imageNamePanel.add(this.imageNameLabel);
        this.imageNamePanel.add(Box.createHorizontalGlue());
        this.add(this.imageNamePanel);
        this.add(Box.createVerticalStrut(8));
        this.imagePreviewPanel = new ImagePreviewPanel(this);
        this.imagePreviewPanel.setPreferredSize(new Dimension(260, 260));
        this.imagePreviewPanel.setMaximumSize(this.imagePreviewPanel.getPreferredSize());
        this.imagePreviewPanel.setMinimumSize(this.imagePreviewPanel.getPreferredSize());
        this.add(this.imagePreviewPanel);
        this.add(Box.createVerticalStrut(15));
        this.imageTypeLabel = new JLabel();
        this.imageTypePanel = new JPanel();
        this.imageTypePanel.setLayout(new BoxLayout(this.imageTypePanel, 0));
        this.imageTypePanel.add(Box.createHorizontalGlue());
        this.imageTypePanel.add(this.imageTypeLabel);
        this.imageTypePanel.add(Box.createHorizontalGlue());
        this.add(this.imageTypePanel);
        this.add(Box.createVerticalStrut(8));
        this.imageDimsLabel = new JLabel();
        this.imageDimsPanel = new JPanel();
        this.imageDimsPanel.setLayout(new BoxLayout(this.imageDimsPanel, 0));
        this.imageDimsPanel.add(Box.createHorizontalGlue());
        this.imageDimsPanel.add(this.imageDimsLabel);
        this.imageDimsPanel.add(Box.createHorizontalGlue());
        this.add(this.imageDimsPanel);
        this.add(Box.createVerticalStrut(8));
        this.voxelDimsLabel = new JLabel();
        this.voxelDimsPanel = new JPanel();
        this.voxelDimsPanel.setLayout(new BoxLayout(this.voxelDimsPanel, 0));
        this.voxelDimsPanel.add(Box.createHorizontalGlue());
        this.voxelDimsPanel.add(this.voxelDimsLabel);
        this.voxelDimsPanel.add(Box.createHorizontalGlue());
        this.add(this.voxelDimsPanel);
        this.add(Box.createVerticalStrut(8));
        this.otherInfoLabel = new JLabel();
        this.otherInfoPanel = new JPanel();
        this.otherInfoPanel.setLayout(new BoxLayout(this.otherInfoPanel, 0));
        this.otherInfoPanel.add(Box.createHorizontalGlue());
        this.otherInfoPanel.add(this.otherInfoLabel);
        this.otherInfoPanel.add(Box.createHorizontalGlue());
        this.add(this.otherInfoPanel);
        this.add(Box.createVerticalStrut(8));
        JLabel dndMessage = new JLabel(DND_MESSAGE, 0);
        dndMessage.setForeground(Color.GRAY);
        JPanel dndMessagePanel = new JPanel();
        dndMessagePanel.setLayout(new BoxLayout(dndMessagePanel, 0));
        dndMessagePanel.add(Box.createHorizontalGlue());
        dndMessagePanel.add(dndMessage);
        dndMessagePanel.add(Box.createHorizontalGlue());
        dndMessagePanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.add(Box.createVerticalGlue());
        this.add(dndMessagePanel);
        this.add(Box.createVerticalStrut(8));
        this.clearPreview();
    }

    public FileNode getCurrentPreviewNode() {
        return this.currentPreviewNode;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(275, 500);
    }

    protected final void clearPreview() {
        this.currentPreviewNode = null;
        this.imagePreviewPanel.setVisible(false);
        this.imageNamePanel.setVisible(false);
        this.imageTypePanel.setVisible(false);
        this.imageDimsPanel.setVisible(false);
        this.voxelDimsPanel.setVisible(false);
        this.otherInfoPanel.setVisible(false);
    }

    protected void updatePreview(FileNode node, File headerFile, HeaderInfo header) {
        if (headerFile != null && header != null) {
            this.currentPreviewNode = node;
            this.imagePreviewPanel.setVisible(true);
            this.imageNamePanel.setVisible(true);
            this.imageTypePanel.setVisible(true);
            this.imageDimsPanel.setVisible(true);
            this.voxelDimsPanel.setVisible(true);
            this.otherInfoPanel.setVisible(true);
            this.imageNameLabel.setText(this.makeNiceName(this.imageNameLabel, header.getImageName()));
            this.imageTypeLabel.setText("Image Type: " + header.getHeaderTypeDes());
            ImageDimensions id = header.getImageDims();
            if (id != null) {
                this.imageDimsLabel.setText("Image Dims (X, Y, Z): " + id.getX() + TEXT_BY + id.getY() + TEXT_BY + id.getZ());
            } else {
                this.imageDimsLabel.setText("Image Dims (X, Y, Z): ? x ? x ?");
            }
            VoxelDimensions vd = header.getVoxelDims();
            if (vd != null) {
                this.voxelDimsLabel.setText("Voxel Dims (X, Y, Z): " + FORMATTER.format(vd.getXSize()) + TEXT_BY + FORMATTER.format(vd.getYSize()) + TEXT_BY + FORMATTER.format(vd.getZSize()));
            } else {
                this.voxelDimsLabel.setText("Voxel Dims (X, Y, Z): ? x ? x ?");
            }
            this.otherInfoLabel.setText(String.format("<html><div style=\"width:%dpx;text-align:center;\">%s</div><html>", 200, header.getOtherInfo()));
            StringBuffer sb = new StringBuffer(32);
            sb.append("<html>");
            ImageType it = header.getImageType();
            if (it != null) {
                sb.append("Data Type: " + header.getImageType().getBitsStored() + "-Bit " + header.getImageType().getByteTypeString());
            } else {
                sb.append("Data Type: ?");
            }
            sb.append("<br>Data Orientation: ").append(Orientation.getOrientationDescription(header.getOrientation())).append("</html>");
            if (id != null && vd != null) {
                this.updateImagePreview(header);
                this.imagePreviewPanel.setToolTip(sb.toString());
            } else {
                this.clearPreview();
            }
        } else {
            this.clearPreview();
        }
        this.repaint();
    }

    protected void updatePreview(FileNode node, File headerFile, SurfaceInfo surfaceInfo) {
        if (headerFile != null && surfaceInfo != null) {
            this.currentPreviewNode = node;
            this.imagePreviewPanel.setVisible(true);
            this.imageNamePanel.setVisible(true);
            this.imageTypePanel.setVisible(true);
            this.imageDimsPanel.setVisible(true);
            this.voxelDimsPanel.setVisible(true);
            this.otherInfoPanel.setVisible(true);
            this.imageNameLabel.setText(this.makeNiceName(this.imageNameLabel, surfaceInfo.getSurfaceName()));
            this.imageTypeLabel.setText("Surface Type: " + surfaceInfo.getHeaderTypeDes());
            this.imageDimsLabel.setText("Reference: " + (surfaceInfo.getReference() != null ? surfaceInfo.getReference() : "(unknown)"));
            this.voxelDimsLabel.setText("Threshold: " + (!MathUtilities.essentiallyEqual((float)surfaceInfo.getThreshold(), (float)Float.MIN_VALUE) ? FORMATTER.format(surfaceInfo.getThreshold()) : "(unknown)"));
            int numPoints = surfaceInfo.getNumPoints();
            if (numPoints > 0) {
                this.otherInfoLabel.setText("Points: " + NumberFormat.getNumberInstance(Locale.US).format(numPoints));
            } else {
                this.otherInfoLabel.setText("Points: (unknown)");
            }
            BufferedImage previewImage = surfaceInfo.getPreviewImage();
            this.imagePreviewPanel.setImageToPreview(previewImage);
            if (previewImage != null) {
                this.updateTransform(previewImage.getWidth(), previewImage.getHeight(), 1.0, 1.0);
            }
            this.imagePreviewPanel.setToolTip(surfaceInfo.getOtherInfo());
        } else {
            this.clearPreview();
        }
        this.repaint();
    }

    private String makeNiceName(JLabel label, String str) {
        label.setToolTipText(str);
        if (str.length() > 25) {
            String prefix = str.substring(0, 15);
            String suffix = str.substring(str.length() - 5);
            return prefix + "..." + suffix;
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImagePreview(HeaderInfo header) {
        ImagePreviewData image = null;
        int numSlices = header.getImageDims().getSlices();
        int width = header.getImageDims().getCols();
        int height = header.getImageDims().getRows();
        int rowMul = 0;
        int rowSubtract = 0;
        int colMul = 0;
        int colSubtract = 0;
        int byteType = header.getImageType().getByteType();
        int numBytes = header.getImageType().getNumBytesPerVoxel();
        long bitMask = header.getImageType().createBitMask();
        boolean isLittleEndian = header.getImageType().isLittleEndian();
        boolean isMultiFile = header.getMultiFiles() != null && header.getMultiFiles().length > 1;
        boolean isDICOM = header.getHeaderTypeDes().equals("DICOM");
        boolean flipCols = false;
        boolean flipRows = false;
        boolean flipZ = false;
        boolean flipY = false;
        boolean flipX = false;
        boolean compressed = header.isUsingCompression();
        float[] previewImage = header.getPreviewImage();
        String orient = header.getOrientation();
        if (Orientation.isValidOrientationString(orient)) {
            orient = orient.toUpperCase();
            flipX = orient.charAt(orient.indexOf(88) + 3) != (Mango.getInstance().isRadiologicalMode() ? (char)'-' : '+');
            flipY = orient.charAt(orient.indexOf(89) + 3) != '-';
            boolean bl = flipZ = orient.charAt(orient.indexOf(90) + 3) != '-';
            if (orient.charAt(0) == 'X') {
                flipCols = flipX;
            } else if (orient.charAt(0) == 'Y') {
                flipCols = flipY;
            } else if (orient.charAt(0) == 'Z') {
                flipCols = flipZ;
            }
            if (orient.charAt(1) == 'X') {
                flipRows = flipX;
            } else if (orient.charAt(1) == 'Y') {
                flipRows = flipY;
            } else if (orient.charAt(1) == 'Z') {
                flipRows = flipZ;
            }
            if (flipCols) {
                colSubtract = width - 1;
                colMul = -1;
            } else {
                colSubtract = 0;
                colMul = 1;
            }
            if (flipRows) {
                rowSubtract = height - 1;
                rowMul = -1;
            } else {
                rowSubtract = 0;
                rowMul = 1;
            }
        }
        Enumeration<ImagePreviewData> en = this.previews.elements();
        while (en.hasMoreElements()) {
            ImagePreviewData anImage = en.nextElement();
            if (anImage.getWidth() != width || anImage.getHeight() != height || anImage.getNumBytes() != numBytes) continue;
            image = anImage;
            break;
        }
        if (image == null) {
            image = new ImagePreviewData(width, height, numBytes);
            this.previews.add(image);
        }
        byte[] fileData = image.getImageData();
        byte[] previewData = image.getPreviewData();
        File imageFile = header.getImageFile();
        URI[] multiFiles = header.getMultiFiles();
        int numVoxels = width * height;
        int sliceSize = numVoxels * numBytes;
        int imageOffset = header.getImageDims().getImageOffset() + sliceSize * (numSlices / 2);
        if (isMultiFile) {
            int numTimepoints = header.getImageDims().getTimepoints();
            int numSlicesTotal = numSlices * numTimepoints;
            if (numTimepoints > 1) {
                if (numTimepoints == multiFiles.length) {
                    imageFile = new File(multiFiles[0]);
                    imageOffset = sliceSize * (numSlices / 2);
                } else if (numSlicesTotal == multiFiles.length) {
                    imageFile = new File(multiFiles[numSlices / 2]);
                    imageOffset = header.getMultiOffsets()[numSlices / 2];
                } else {
                    imageFile = new File(multiFiles[multiFiles.length / 2]);
                    imageOffset = header.getMultiOffsets()[multiFiles.length / 2];
                }
            } else if (numSlices <= multiFiles.length) {
                imageFile = new File(multiFiles[numSlices / 2]);
                imageOffset = header.getMultiOffsets()[numSlices / 2];
            } else {
                imageFile = new File(multiFiles[multiFiles.length / 2]);
                imageOffset = header.getMultiOffsets()[multiFiles.length / 2];
            }
        }
        BufferedInputStream fileIn = null;
        if (CollectionUtilities.isNotEmpty((Object)previewImage)) {
            double max = 0.0;
            double min = 0.0;
            max = min = (double)previewImage[0];
            for (int ctr = 1; ctr < previewImage.length; ++ctr) {
                double temp = previewImage[ctr];
                if (temp < min) {
                    min = temp;
                    continue;
                }
                if (!(temp > max)) continue;
                max = temp;
            }
            double range = 255.0 / (max - min);
            for (int ctrH = 0; ctrH < height; ++ctrH) {
                int offsetFileH = ctrH * width;
                int offsetH = (ctrH - rowSubtract) * rowMul * width;
                for (int ctrW = 0; ctrW < width; ++ctrW) {
                    int offsetFile = offsetFileH + (ctrW - colSubtract) * colMul;
                    int offset = offsetH + ctrW;
                    previewData[offset] = (byte)(((double)previewImage[offsetFile] - min) * range);
                }
            }
            if (!MathUtilities.essentiallyEqual((double)min, (double)max)) {
                this.imagePreviewPanel.setImageToPreview(image.getImage());
            } else {
                this.imagePreviewPanel.setImageToPreview(null);
            }
            double colSize = header.getVoxelDims().getColSize(true);
            double rowSize = header.getVoxelDims().getRowSize(true);
            int cols = header.getImageDims().getCols();
            int rows = header.getImageDims().getRows();
            this.updateTransform(cols, rows, colSize, rowSize);
        } else if (imageFile == null || !imageFile.exists()) {
            this.imagePreviewPanel.setImageToPreview(null);
        } else if (isDICOM) {
            try {
                DICOM dicom = new DICOM(imageFile.toURI());
                ArrayList<DICOM> dicoms = new ArrayList<DICOM>();
                dicoms.add(dicom);
                Series series = new Series();
                series.buildDCM(dicom, dicoms);
                double min = 0.0;
                double max = 0.0;
                FloatBuffer buffer = ((ByteBuffer)series.getImageBuffers(true)[0].rewind()).asFloatBuffer();
                max = min = (double)buffer.get(0);
                for (int ctr = 1; ctr < numVoxels; ++ctr) {
                    double temp = buffer.get(ctr);
                    if (temp < min) {
                        min = temp;
                        continue;
                    }
                    if (!(temp > max)) continue;
                    max = temp;
                }
                double range = 255.0 / (max - min);
                for (int ctrH = 0; ctrH < height; ++ctrH) {
                    int offsetFileH = ctrH * width;
                    int offsetH = (ctrH - rowSubtract) * rowMul * width;
                    for (int ctrW = 0; ctrW < width; ++ctrW) {
                        byte val;
                        int offsetFile = offsetFileH + (ctrW - colSubtract) * colMul;
                        int offset = offsetH + ctrW;
                        previewData[offset] = val = (byte)(((double)buffer.get(offsetFile) - min) * range);
                    }
                }
                if (!MathUtilities.essentiallyEqual((double)min, (double)max)) {
                    this.imagePreviewPanel.setImageToPreview(image.getImage());
                } else {
                    this.imagePreviewPanel.setImageToPreview(null);
                }
                double colSize = header.getVoxelDims().getColSize(true);
                double rowSize = header.getVoxelDims().getRowSize(true);
                int cols = header.getImageDims().getCols();
                int rows = header.getImageDims().getRows();
                this.updateTransform(cols, rows, colSize, rowSize);
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (InvalidHeaderException ex) {
                AppLogger.error((Throwable)ex);
            }
        } else if (header.isUsingCompression() && !header.isUsingPreviewCompatibleCompression()) {
            this.imagePreviewPanel.setImageToPreview(null);
        } else if (header.getImageDims().isTiled()) {
            this.imagePreviewPanel.setImageToPreview(null);
        } else {
            try {
                long bytesSkipped;
                fileIn = compressed ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(imageFile))) : new BufferedInputStream(new FileInputStream(imageFile));
                long bytesToSkip = imageOffset;
                for (long totalBytesSkipped = bytesSkipped = fileIn.skip(bytesToSkip); totalBytesSkipped < bytesToSkip; totalBytesSkipped += bytesSkipped) {
                    bytesSkipped = fileIn.skip(bytesToSkip - totalBytesSkipped);
                }
                FileUtilities.readFully((InputStream)fileIn, (byte[])fileData);
                double max = 0.0;
                double min = 0.0;
                if (numBytes == 1 && (byteType == 3 || byteType == 2)) {
                    max = min = (double)((long)fileData[0] & bitMask);
                    for (int ctr = 1; ctr < numVoxels; ++ctr) {
                        double temp = (long)fileData[ctr] & bitMask;
                        if (temp < min) {
                            min = temp;
                            continue;
                        }
                        if (!(temp > max)) continue;
                        max = temp;
                    }
                    double range = 255.0 / (max - min);
                    for (int ctrH = 0; ctrH < height; ++ctrH) {
                        int offsetFileH = ctrH * width;
                        int offsetH = (ctrH - rowSubtract) * rowMul * width;
                        for (int ctrW = 0; ctrW < width; ++ctrW) {
                            byte val;
                            int offsetFile = offsetFileH + (ctrW - colSubtract) * colMul;
                            int offset = offsetH + ctrW;
                            previewData[offset] = val = (byte)(((double)((long)fileData[offsetFile] & bitMask) - min) * range);
                        }
                    }
                } else if (numBytes == 2 && (byteType == 3 || byteType == 2)) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(fileData);
                    byteBuffer.order(isLittleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                    ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                    max = min = (double)shortBuffer.get(0);
                    for (int ctr = 1; ctr < numVoxels; ++ctr) {
                        double temp = (long)shortBuffer.get(ctr) & bitMask;
                        if (temp < min) {
                            min = temp;
                            continue;
                        }
                        if (!(temp > max)) continue;
                        max = temp;
                    }
                    double range = 255.0 / (max - min);
                    shortBuffer.position(0);
                    for (int ctrH = 0; ctrH < height; ++ctrH) {
                        int offsetFileH = ctrH * width;
                        int offsetH = (ctrH - rowSubtract) * rowMul * width;
                        for (int ctrW = 0; ctrW < width; ++ctrW) {
                            int offsetFile = offsetFileH + (ctrW - colSubtract) * colMul;
                            int offset = offsetH + ctrW;
                            offset = offsetH + ctrW;
                            previewData[offset] = (byte)(((double)((long)shortBuffer.get(offsetFile) & bitMask) - min) * range);
                        }
                    }
                } else if (numBytes == 4 && (byteType == 3 || byteType == 2)) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(fileData);
                    byteBuffer.order(isLittleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                    IntBuffer intBuffer = byteBuffer.asIntBuffer();
                    max = min = (double)intBuffer.get(0);
                    for (int ctr = 1; ctr < numVoxels; ++ctr) {
                        double temp = (long)intBuffer.get(ctr) & bitMask;
                        if (temp < min) {
                            min = temp;
                            continue;
                        }
                        if (!(temp > max)) continue;
                        max = temp;
                    }
                    double range = 255.0 / (max - min);
                    intBuffer.position(0);
                    for (int ctrH = 0; ctrH < height; ++ctrH) {
                        int offsetFileH = ctrH * width;
                        int offsetH = (ctrH - rowSubtract) * rowMul * width;
                        for (int ctrW = 0; ctrW < width; ++ctrW) {
                            int offsetFile = offsetFileH + (ctrW - colSubtract) * colMul;
                            int offset = offsetH + ctrW;
                            offset = offsetH + ctrW;
                            previewData[offset] = (byte)(((double)((long)intBuffer.get(offsetFile) & bitMask) - min) * range);
                        }
                    }
                } else if (numBytes == 4 && byteType == 4) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(fileData);
                    byteBuffer.order(isLittleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    max = min = (double)floatBuffer.get(0);
                    for (int ctr = 1; ctr < numVoxels; ++ctr) {
                        double temp = floatBuffer.get(ctr);
                        if (temp < min) {
                            min = temp;
                            continue;
                        }
                        if (!(temp > max)) continue;
                        max = temp;
                    }
                    double range = 255.0 / (max - min);
                    floatBuffer.position(0);
                    for (int ctrH = 0; ctrH < height; ++ctrH) {
                        int offsetFileH = ctrH * width;
                        int offsetH = (ctrH - rowSubtract) * rowMul * width;
                        for (int ctrW = 0; ctrW < width; ++ctrW) {
                            int offsetFile = offsetFileH + (ctrW - colSubtract) * colMul;
                            int offset = offsetH + ctrW;
                            offset = offsetH + ctrW;
                            previewData[offset] = (byte)(((double)floatBuffer.get(offsetFile) - min) * range);
                        }
                    }
                } else if (byteType == 6) {
                    max = min = (double)((long)fileData[0] & bitMask);
                    for (int ctr = 1; ctr < numVoxels; ++ctr) {
                        long temp1 = (long)(0xFF & fileData[ctr * numBytes]) & bitMask;
                        long temp2 = (long)(0xFF & fileData[ctr * numBytes + 1]) & bitMask;
                        long temp3 = (long)(0xFF & fileData[ctr * numBytes + 2]) & bitMask;
                        double temp = (double)(temp1 + temp2 + temp3) / 3.0;
                        if (temp < min) {
                            min = temp;
                            continue;
                        }
                        if (!(temp > max)) continue;
                        max = temp;
                    }
                    double range = 255.0 / (max - min);
                    for (int ctrH = 0; ctrH < height; ++ctrH) {
                        int offsetFileH = ctrH * numBytes * width;
                        int offsetH = (ctrH - rowSubtract) * rowMul * width;
                        for (int ctrW = 0; ctrW < width; ++ctrW) {
                            byte val;
                            int offsetFile = offsetFileH + (ctrW * numBytes - colSubtract) * colMul;
                            int offset = offsetH + ctrW;
                            long temp1 = (long)(0xFF & fileData[offsetFile]) & bitMask;
                            long temp2 = (long)(0xFF & fileData[offsetFile + 1]) & bitMask;
                            long temp3 = (long)(0xFF & fileData[offsetFile + 2]) & bitMask;
                            double temp = (double)(temp1 + temp2 + temp3) / 3.0;
                            previewData[offset] = val = (byte)((temp - min) * range);
                        }
                    }
                }
                if (!MathUtilities.essentiallyEqual((double)min, (double)max)) {
                    this.imagePreviewPanel.setImageToPreview(image.getImage());
                } else {
                    this.imagePreviewPanel.setImageToPreview(null);
                }
                double colSize = header.getVoxelDims().getColSize(true);
                double rowSize = header.getVoxelDims().getRowSize(true);
                int cols = header.getImageDims().getCols();
                int rows = header.getImageDims().getRows();
                this.updateTransform(cols, rows, colSize, rowSize);
            }
            catch (FileNotFoundException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
            finally {
                try {
                    if (fileIn != null) {
                        fileIn.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
    }

    private void updateTransform(double cols, double rows, double colSize, double rowSize) {
        double scaleY;
        double scaleX;
        double width = cols * colSize;
        double height = rows * rowSize;
        if (width > height) {
            scaleX = 260.0 / cols;
            scaleY = 260.0 / cols * (rowSize / colSize);
        } else {
            scaleX = 260.0 / rows * (colSize / rowSize);
            scaleY = 260.0 / rows;
        }
        double transX = (260.0 - cols * scaleX) / 2.0;
        this.imagePreviewPanel.getPreviewTransform().setTransform(scaleX, 0.0, 0.0, scaleY, transX, 0.0);
    }
}

