/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.imagebrowser;

import edu.uthscsa.ric.mango.dialogs.imagebrowser.FileNode;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.NodesTransferable;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.PreviewPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImagePreviewPanel
extends JPanel
implements DragGestureListener,
DragSourceListener {
    private AffineTransform previewTransform = new AffineTransform();
    private BufferedImage imageToPreview;
    private final DragSource dragSource;
    private final PreviewPanel previewPanel;
    private static final long serialVersionUID = 1L;

    protected ImagePreviewPanel(PreviewPanel previewPanel) {
        this.previewPanel = previewPanel;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent evt) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent evt) {
    }

    @Override
    public void dragExit(DragSourceEvent evt) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent evt) {
        this.dragSource.startDrag(evt, DragSource.DefaultCopyDrop, new NodesTransferable(new FileNode[]{this.previewPanel.getCurrentPreviewNode()}), this);
    }

    @Override
    public void dragOver(DragSourceDragEvent evt) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent evt) {
    }

    public BufferedImage getImageToPreview() {
        return this.imageToPreview;
    }

    public AffineTransform getPreviewTransform() {
        return this.previewTransform;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        if (this.imageToPreview != null) {
            g2d.drawImage(this.imageToPreview, this.previewTransform, null);
        } else {
            g2d.setColor(Color.BLACK);
            g2d.fill(new Rectangle(0, 0, 260, 260));
            Font font = g2d.getFont().deriveFont(1);
            g2d.setFont(font);
            FontMetrics metrics = g2d.getFontMetrics(font);
            String noPreview = "No preview available.";
            Rectangle2D bounds = metrics.getStringBounds("No preview available.", g2d);
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.drawString("No preview available.", (int)(130.0 - bounds.getWidth() / 2.0), 130);
        }
    }

    public void setImageToPreview(BufferedImage imageToPreview) {
        this.imageToPreview = imageToPreview;
    }

    public void setPreviewTransform(AffineTransform previewTransform) {
        this.previewTransform = previewTransform;
    }

    public void setToolTip(String text) {
        this.setToolTipText(text);
    }
}

