/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.imagebrowser;

import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class ImageFileFilter
implements FileFilter {
    private String extensionFilter;
    private WildcardFileFilter wildcardNameFilter;
    public static final String DEFAULT_FILTER = "*";

    protected ImageFileFilter(String nameFilter, String extFilter) {
        this.wildcardNameFilter = new WildcardFileFilter(this.validateNameFilter(nameFilter));
        this.extensionFilter = this.validateExtensionFilter(extFilter);
    }

    @Override
    public boolean accept(File file) {
        return this.accept(file.getParentFile(), file.getName());
    }

    protected void setFilter(String nameFilter, String extFilter) {
        this.wildcardNameFilter = new WildcardFileFilter(this.validateNameFilter(nameFilter));
        this.extensionFilter = this.validateExtensionFilter(extFilter);
    }

    private boolean accept(File dir, String name) {
        if (name.charAt(0) == '.') {
            return false;
        }
        if (name.charAt(0) == '_') {
            return false;
        }
        if (name.equals("Thumbs.db")) {
            return false;
        }
        if (name.equals("DICOMDIR")) {
            return false;
        }
        if (name.endsWith(".zip")) {
            return false;
        }
        if (name.endsWith(".tar")) {
            return false;
        }
        File file = new File(dir, name);
        if (file.isHidden()) {
            return false;
        }
        String nameWithoutExt = name;
        int dotIndex = nameWithoutExt.indexOf(46);
        if (dotIndex != -1) {
            nameWithoutExt = nameWithoutExt.substring(0, dotIndex);
        }
        if (this.wildcardNameFilter.accept(dir, nameWithoutExt)) {
            if (this.extensionFilter.length() > 0) {
                if (dotIndex != -1) {
                    return name.substring(dotIndex + 1).indexOf(this.extensionFilter) != -1;
                }
                return file.isDirectory();
            }
            return true;
        }
        return false;
    }

    private String validateExtensionFilter(String str) {
        return str.replaceAll("[^A-Za-z0-9\\.]", "");
    }

    private String validateNameFilter(String strVal) {
        String str = strVal;
        if (!str.startsWith(DEFAULT_FILTER)) {
            str = DEFAULT_FILTER + str;
        }
        if (!str.endsWith(DEFAULT_FILTER)) {
            str = str + DEFAULT_FILTER;
        }
        return str;
    }
}

