/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.imagebrowser;

import edu.uthscsa.ric.mango.dialogs.imagebrowser.FileNode;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.HeaderInfo;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.SurfaceInfo;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class FileTreeRenderer
implements TreeCellRenderer {
    private final Color backgroundNonSelectionColor;
    private final DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();
    private final JLabel imageDesLabel;
    private final JLabel imageNameLabel;
    private final JLabel imageTypeLabel;
    private final JPanel renderer = new JPanel();
    public static final Color ERROR_COLOR = Color.RED;
    public static final Color ROI_COLOR = Color.RED.darker();
    public static final Color SELECTED_COLOR = new Color(3700183);
    public static final Color SURFACE_COLOR = new Color(0x116600);
    public static final Color VOLUME_COLOR = Color.BLUE.darker();

    public FileTreeRenderer() {
        this.renderer.setLayout(new BoxLayout(this.renderer, 0));
        this.imageNameLabel = new JLabel("");
        this.renderer.add(this.imageNameLabel);
        this.renderer.add(Box.createHorizontalStrut(8));
        this.imageTypeLabel = new JLabel(" ");
        this.renderer.add(this.imageTypeLabel);
        this.renderer.add(Box.createHorizontalStrut(8));
        this.imageDesLabel = new JLabel(" ");
        this.imageDesLabel.setFont(this.imageDesLabel.getFont().deriveFont((float)Math.round(this.imageDesLabel.getFont().getSize2D() * 0.8f)));
        this.renderer.add(this.imageDesLabel);
        this.backgroundNonSelectionColor = this.defaultRenderer.getBackgroundNonSelectionColor();
        this.renderer.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        FileNode fileNode;
        boolean isDirectory;
        Component returnValue = null;
        if (value != null && value instanceof FileNode && !(isDirectory = (fileNode = (FileNode)value).isDirectory())) {
            HeaderInfo headerInfo = fileNode.getHeaderInfo();
            SurfaceInfo surfaceInfo = fileNode.getSurfaceInfo();
            this.imageNameLabel.setText(fileNode.toString());
            this.imageTypeLabel.setText(fileNode.getImageType());
            this.imageDesLabel.setText(fileNode.getImageDescription());
            if (selected) {
                this.renderer.setBackground(SELECTED_COLOR);
                this.imageNameLabel.setForeground(Color.WHITE);
                this.imageTypeLabel.setForeground(Color.WHITE);
                this.imageDesLabel.setForeground(Color.WHITE);
            } else {
                this.renderer.setBackground(this.backgroundNonSelectionColor);
                this.imageNameLabel.setForeground(Color.BLACK);
                this.imageDesLabel.setForeground(Color.GRAY);
                if (headerInfo != null) {
                    if (headerInfo.isError()) {
                        this.imageNameLabel.setForeground(Color.LIGHT_GRAY);
                        this.imageDesLabel.setForeground(Color.LIGHT_GRAY);
                        this.imageTypeLabel.setForeground(ERROR_COLOR);
                    } else if (headerInfo.isRoi()) {
                        this.imageTypeLabel.setForeground(ROI_COLOR);
                    } else {
                        this.imageTypeLabel.setForeground(VOLUME_COLOR);
                    }
                } else if (surfaceInfo != null) {
                    this.imageTypeLabel.setForeground(SURFACE_COLOR);
                }
            }
            this.renderer.setEnabled(tree.isEnabled());
            returnValue = this.renderer;
        }
        if (returnValue == null) {
            returnValue = this.defaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        return returnValue;
    }
}

