/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.imagebrowser;

import edu.uthscsa.ric.mango.core.StringComparator;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.HeaderInfo;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.ImageBrowser;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.SurfaceInfo;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceData;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceReader;
import edu.uthscsa.ric.roi.Metadata;
import edu.uthscsa.ric.roi.lines.manager.LOIManager;
import edu.uthscsa.ric.roi.points.manager.POIManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.visualization.surface.primitives.Overlay;
import edu.uthscsa.ric.visualization.surface.primitives.Shape;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Orientation;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeIOException;
import edu.uthscsa.ric.volume.formats.dicom.DICOM;
import edu.uthscsa.ric.volume.formats.dicom.Series;
import edu.uthscsa.ric.volume.formats.nifti.NIFTI;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class FileNode
implements TreeNode {
    private HeaderInfo headerInfo;
    private SurfaceInfo surfaceInfo;
    private boolean childrenLoaded;
    private boolean scanning;
    private final File file;
    private final Vector<FileNode> children = new Vector();
    private final boolean directory;
    private static final Vector<String> LOADED_FORMATS;
    private static final Vector<String> LOADED_SURFACE_FORMATS;
    public static final String OLD_ROI_EXT = "roi.gz";
    public static final String SCANNING_LABEL = "Scanning...";
    public static final List<String> KNOWN_HEADER_EXTENSIONS;
    public static final int MINIMUM_LENGTH;

    private static String makeNiceImageName(File file) {
        String name = file.getName();
        for (int ctrExt = 0; ctrExt < LOADED_FORMATS.size(); ++ctrExt) {
            if (!name.endsWith(LOADED_FORMATS.get(ctrExt))) continue;
            return name.substring(0, name.indexOf(LOADED_FORMATS.get(ctrExt)));
        }
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            return name.substring(0, dotIndex);
        }
        return name;
    }

    protected FileNode(File file) {
        this.file = file;
        this.directory = file.isDirectory();
    }

    private FileNode(File file, HeaderInfo headerInfo) {
        this(file);
        this.headerInfo = headerInfo;
    }

    private FileNode(File file, SurfaceInfo surfaceInfo) {
        this(file);
        this.surfaceInfo = surfaceInfo;
    }

    public Enumeration<FileNode> children() {
        return this.children.elements();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileNode other = (FileNode)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }

    @Override
    public boolean getAllowsChildren() {
        return this.file.isDirectory();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    public File getFile() {
        return this.file;
    }

    public HeaderInfo getHeaderInfo() {
        return this.headerInfo;
    }

    public String getImageDescription() {
        if (this.headerInfo != null) {
            ImageDimensions id = this.headerInfo.getImageDims();
            if (id != null) {
                int timepoints = id.getTimepoints();
                String orientationString = this.headerInfo.getOrientation();
                String direction = null;
                direction = orientationString != null && orientationString.length() == 6 ? (orientationString.charAt(2) == 'X' ? "Sagittal" : (orientationString.charAt(2) == 'Y' ? "Coronal" : (orientationString.charAt(2) == 'Z' ? "Axial" : "Unknown"))) : "Unknown";
                String dataString = " (" + id.getX() + " x " + id.getY() + " x " + id.getZ() + "  " + direction + ") ";
                if (timepoints > 1) {
                    dataString = dataString + " (" + timepoints + " Series Points) ";
                }
                return dataString;
            }
            return "";
        }
        if (this.surfaceInfo != null) {
            return "";
        }
        return "";
    }

    public String getImageType() {
        if (this.headerInfo != null) {
            return this.headerInfo.getHeaderTypeDes();
        }
        if (this.surfaceInfo != null) {
            return this.surfaceInfo.getHeaderTypeDes();
        }
        return "";
    }

    @Override
    public int getIndex(TreeNode node) {
        FileNode child = (FileNode)node;
        Enumeration<FileNode> children = this.children();
        int index = -1;
        while (children.hasMoreElements()) {
            ++index;
            if (!child.getFile().equals(children.nextElement())) continue;
            return index;
        }
        return index;
    }

    @Override
    public TreeNode getParent() {
        File parent = this.file.getParentFile();
        if (parent != null) {
            return new FileNode(parent);
        }
        return null;
    }

    public TreePath getPath() {
        Vector<TreeNode> nodes = new Vector<TreeNode>();
        TreeNode parent = this.getParent();
        while (parent != null) {
            nodes.insertElementAt(parent, 0);
            parent = this.getParent();
        }
        return new TreePath(nodes.toArray(new TreePath[nodes.size()]));
    }

    public SurfaceInfo getSurfaceInfo() {
        return this.surfaceInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean isChildrenLoaded() {
        return this.childrenLoaded;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public boolean isLeaf() {
        return !this.file.isDirectory();
    }

    public boolean isScanning() {
        return this.scanning;
    }

    public void setScanning(boolean scanning) {
        this.scanning = scanning;
    }

    public String toString() {
        String name;
        if (this.headerInfo != null) {
            return this.headerInfo.getImageName();
        }
        if (this.scanning) {
            return SCANNING_LABEL;
        }
        if (this.getAllowsChildren() && (name = this.file.getName()).length() < MINIMUM_LENGTH) {
            return StringUtils.rightPad((String)name, (int)MINIMUM_LENGTH);
        }
        return this.file.getName();
    }

    protected void loadImages() {
        if (this.childrenLoaded) {
            return;
        }
        this.childrenLoaded = true;
        File[] files = this.file.listFiles(ImageBrowser.FILE_FILTER);
        Vector<File> allFiles = new Vector<File>();
        Vector<File> allFilesRemaining = new Vector<File>();
        if (files != null) {
            for (File file2 : files) {
                allFiles.add(file2);
                allFilesRemaining.add(file2);
            }
            Iterator it = allFiles.iterator();
            boolean processedDicomFolder = false;
            while (it.hasNext()) {
                Object[] obs;
                Collection<Vector<DICOM>> values;
                int ctrExt;
                File file = (File)it.next();
                if (file.isDirectory()) {
                    this.children.add(new FileNode(file));
                    allFilesRemaining.remove(file);
                    continue;
                }
                if (!allFilesRemaining.contains(file)) continue;
                allFilesRemaining.remove(file);
                String filename = file.getName();
                boolean processed = false;
                for (ctrExt = 0; ctrExt < LOADED_FORMATS.size(); ++ctrExt) {
                    if (!filename.endsWith(LOADED_FORMATS.get(ctrExt))) continue;
                    try {
                        Header header = new Header(file);
                        File imageFile = new File(header.getImageFile());
                        allFilesRemaining.remove(imageFile);
                        URI[] multiURIs = header.getMultiImageFiles();
                        File[] multiFiles = null;
                        if (multiURIs != null) {
                            multiFiles = new File[multiURIs.length];
                            for (int ctrM = 0; ctrM < multiURIs.length; ++ctrM) {
                                multiFiles[ctrM] = new File(multiURIs[ctrM]);
                                allFilesRemaining.remove(multiFiles[ctrM]);
                            }
                        }
                        HeaderInfo headerInfoChild = this.makeHeaderInfo(header, file, imageFile);
                        this.children.add(new FileNode(file, headerInfoChild));
                        header = null;
                        processed = true;
                    }
                    catch (InvalidHeaderException ex) {
                        AppLogger.warn((Throwable)ex);
                    }
                    catch (Exception ex) {
                        AppLogger.warn((Throwable)ex);
                    }
                    break;
                }
                for (ctrExt = 0; ctrExt < LOADED_SURFACE_FORMATS.size(); ++ctrExt) {
                    if (!filename.endsWith(LOADED_SURFACE_FORMATS.get(ctrExt))) continue;
                    SurfaceReader sr = new SurfaceReader();
                    Vector<Shape> shapes = new Vector<Shape>();
                    StringBuffer type = new StringBuffer();
                    Surface[] surfaces = sr.readHeader(file, shapes, type);
                    if (surfaces != null && surfaces.length > 0) {
                        SurfaceInfo surfaceInfoChild = this.makeSurfaceInfo(file, surfaces, shapes, type.toString());
                        this.children.add(new FileNode(file, surfaceInfoChild));
                    }
                    processed = true;
                }
                if (filename.endsWith(OLD_ROI_EXT)) {
                    HeaderInfo headerInfoChild = new HeaderInfo();
                    headerInfoChild.setHeaderFile(file);
                    headerInfoChild.setHeaderTypeDes("ROI");
                    headerInfoChild.setImageName(FileNode.makeNiceImageName(file));
                    headerInfoChild.setRoi(true);
                    this.children.add(new FileNode(file, headerInfoChild));
                    processed = true;
                }
                if (processed || processedDicomFolder || !FileUtilities.extensionMatches((String)FileUtilities.getExtension((File)file), (String[])CollectionUtilities.array((List)Series.COMMON_EXTENSIONS)) && !"DICOM".equals(Header.detectHeaderType(file))) continue;
                Header header = null;
                processedDicomFolder = true;
                TreeMap<String, Vector<DICOM>> dicomMap = new TreeMap<String, Vector<DICOM>>();
                try {
                    Header.doReadDICOMFolder(file.getParentFile(), dicomMap, 3);
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
                if ((values = dicomMap.values()).size() <= 0) continue;
                for (Object ob : obs = values.toArray()) {
                    Vector chosenDICOM = (Vector)ob;
                    int size = chosenDICOM.size();
                    DICOM[] dicomArray = new DICOM[size];
                    File[] multiFiles = new File[size];
                    for (int ctrD = 0; ctrD < size; ++ctrD) {
                        dicomArray[ctrD] = (DICOM)chosenDICOM.elementAt(ctrD);
                        dicomArray[ctrD].clearPrivateTagData();
                        multiFiles[ctrD] = new File(dicomArray[ctrD].getImageFile());
                        allFilesRemaining.remove(multiFiles[ctrD]);
                    }
                    File chosenFile = new File(dicomArray[0].getImageFile());
                    header = new Header();
                    try {
                        header.createFromDICOMHeaders(dicomArray);
                        HeaderInfo headerInfoChild = this.makeHeaderInfo(header, chosenFile, chosenFile);
                        this.children.add(new FileNode(chosenFile, headerInfoChild));
                    }
                    catch (InvalidHeaderException ex) {
                        AppLogger.errorMinimal((Throwable)ex);
                    }
                    catch (VolumeIOException ex) {
                        AppLogger.errorMinimal((Throwable)ex);
                    }
                    catch (IOException ex) {
                        AppLogger.errorMinimal((Throwable)ex);
                    }
                    header = null;
                    processed = true;
                }
            }
        }
        Collections.sort(this.children, new StringComparator());
    }

    private HeaderInfo makeHeaderInfo(Header header, File headerFile, File imageFile) {
        boolean valid = header.isValid();
        boolean isMangoROI = false;
        HeaderInfo headerInfoChild = new HeaderInfo();
        headerInfoChild.setHeaderFile(headerFile);
        headerInfoChild.setImageFile(imageFile);
        if (valid) {
            String description;
            new Orientation(header.getOrientationString(), header.getImageDimensions(), header.getVoxelDimensions(), header.getOrigin());
            headerInfoChild.setImageDims(header.getImageDimensions());
            headerInfoChild.setVoxelDims(header.getVoxelDimensions());
            headerInfoChild.setImageType(header.getImageType());
            headerInfoChild.setImageDes(header.getImageDescription());
            headerInfoChild.setOrientation(header.getOrientationString());
            headerInfoChild.setMultiFiles(header.getMultiImageFiles());
            headerInfoChild.setMultiOffsets(header.getMultiImageOffsets());
            headerInfoChild.setOtherInfo(header.getAllDescriptiveData(-1));
            boolean bl = isMangoROI = header.hasExtension(NIFTI.getHeaderExtensionMagicNumberOld()[0]) || header.hasExtension(NIFTI.getHeaderExtensionMagicNumber1()[0]);
            if (!isMangoROI && (description = header.getImageDescription().getDescription()) != null) {
                isMangoROI = description.startsWith("Mango ROI");
            }
            isMangoROI &= header.getImageType().getByteType() == 3;
        } else {
            headerInfoChild.setError(true);
        }
        headerInfoChild.setRoi(isMangoROI);
        if (!valid) {
            headerInfoChild.setHeaderTypeDes("BAD HEADER");
            headerInfoChild.setImageName(FileNode.makeNiceImageName(headerFile));
        } else if (isMangoROI) {
            headerInfoChild.setHeaderTypeDes("ROI");
            headerInfoChild.setImageName(FileNode.makeNiceImageName(headerFile));
            byte[] extension = null;
            if (header.isNIFTI()) {
                extension = header.getNIFTIObject().getExtension();
            }
            if (CollectionUtilities.isNotEmpty(extension)) {
                int[] counts = this.readROIData(extension, header.getImageDimensions(), header.getImageType().isLittleEndian());
                StringBuffer sb = new StringBuffer();
                if (counts[2] >= 0) {
                    if (counts[2] == 0) {
                        sb.append("Masks: None");
                    } else if (counts[2] == 1) {
                        sb.append("Masks: 1 Color");
                    } else {
                        sb.append("Masks: " + counts[2] + " Colors");
                    }
                }
                if (counts[1] > 0) {
                    if (sb.toString().length() > 0) {
                        sb.append("<br>");
                    }
                    sb.append("Lines: " + counts[1]);
                }
                if (counts[0] > 0) {
                    if (sb.toString().length() > 0) {
                        sb.append("<br>");
                    }
                    sb.append("Points: " + counts[0]);
                }
                headerInfoChild.setOtherInfo(sb.toString());
            }
        } else if (header.getReadable() != null) {
            ReadableHeader readable = header.getReadable();
            headerInfoChild.setHeaderTypeDes(readable.getPluginName());
            headerInfoChild.setImageName(FileNode.makeNiceImageName(headerFile));
            try {
                headerInfoChild.setPreviewImage(readable.getPreviewImage());
            }
            catch (AbstractMethodError err) {
                AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
            }
            catch (NoSuchMethodError err) {
                AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
            }
        }
        header.clear();
        return headerInfoChild;
    }

    public int[] readROIData(byte[] vectorData, ImageDimensions id, boolean littleEndian) {
        String xmlStr = null;
        int[] counts = new int[3];
        counts[2] = -1;
        if (vectorData != null && vectorData.length > 0) {
            ByteBuffer vecBuffer = ByteBuffer.wrap(vectorData);
            vecBuffer.order(littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            boolean readOldMetaData = false;
            int poiStart = 8;
            vecBuffer.position(8);
            int poiSize = vecBuffer.getInt();
            int loiAxialStart = 8 + poiSize + 4;
            vecBuffer.position(loiAxialStart);
            int loiAxialSize = vecBuffer.getInt();
            int loiCoronalStart = loiAxialStart + loiAxialSize + 4;
            vecBuffer.position(loiCoronalStart);
            int loiCoronalSize = vecBuffer.getInt();
            int loiSagittalStart = loiCoronalStart + loiCoronalSize + 4;
            vecBuffer.position(loiSagittalStart);
            int loiSagittalSize = vecBuffer.getInt();
            int labelStaticStart = loiSagittalStart + loiSagittalSize + 4;
            vecBuffer.position(labelStaticStart);
            int labelStaticSize = 0;
            int remaining = vecBuffer.limit() - vecBuffer.position();
            if (remaining >= 4) {
                labelStaticSize = vecBuffer.getInt();
            }
            if (poiSize > 0) {
                readOldMetaData = true;
                byte[] poiData = new byte[poiSize];
                System.arraycopy(vectorData, 12, poiData, 0, poiData.length);
                counts[0] = counts[0] + POIManager.countPoints(poiData);
            }
            if (loiAxialSize > 0) {
                readOldMetaData = true;
                byte[] loiAxialData = new byte[loiAxialSize];
                System.arraycopy(vectorData, loiAxialStart + 4, loiAxialData, 0, loiAxialData.length);
                counts[1] = counts[1] + LOIManager.countData(loiAxialData);
            }
            if (loiCoronalSize > 0) {
                readOldMetaData = true;
                byte[] loiCoronalData = new byte[loiCoronalSize];
                System.arraycopy(vectorData, loiCoronalStart + 4, loiCoronalData, 0, loiCoronalData.length);
                counts[1] = counts[1] + LOIManager.countData(loiCoronalData);
            }
            if (loiSagittalSize > 0) {
                readOldMetaData = true;
                byte[] loiSagittalData = new byte[loiSagittalSize];
                System.arraycopy(vectorData, loiSagittalStart + 4, loiSagittalData, 0, loiSagittalData.length);
                counts[1] = counts[1] + LOIManager.countData(loiSagittalData);
            }
            if (labelStaticSize > 0) {
                readOldMetaData = true;
                byte[] labelData = new byte[labelStaticSize];
                System.arraycopy(vectorData, labelStaticStart + 4, labelData, 0, labelData.length);
            }
            if (!readOldMetaData) {
                int headerSize = 28;
                int xmlSize = vectorData.length - 28;
                byte[] xmlData = new byte[xmlSize];
                System.arraycopy(vectorData, 28, xmlData, 0, xmlSize);
                try {
                    xmlStr = new String(xmlData, "utf-8");
                    counts = Metadata.readMetadata(null, false, xmlStr);
                }
                catch (UnsupportedEncodingException ex) {
                    AppLogger.error((Throwable)ex);
                }
                catch (ParserConfigurationException ex) {
                    AppLogger.error((Throwable)ex);
                }
                catch (SAXException ex) {
                    AppLogger.error((Throwable)ex);
                }
                catch (IOException ex) {
                    AppLogger.error((Throwable)ex);
                }
            }
        }
        return counts;
    }

    private SurfaceInfo makeSurfaceInfo(File headerFile, Surface[] surfaces, Vector<Shape> shapes, String typeName) {
        SurfaceInfo surfaceInfoChild = new SurfaceInfo();
        surfaceInfoChild.setHeaderTypeDes(typeName);
        surfaceInfoChild.setSurfaceName(FileNode.makeNiceImageName(headerFile));
        surfaceInfoChild.setReference(surfaces[0].getName());
        surfaceInfoChild.setNumPoints(surfaces[0].getNumPoints());
        surfaceInfoChild.setNumTriangles(surfaces[0].getNumTriangles());
        surfaceInfoChild.setNumShapes(surfaces.length - 1 + shapes.size());
        surfaceInfoChild.setOtherInfo(surfaces[0].getDescription());
        surfaceInfoChild.setThreshold(surfaces[0].getThreshold());
        Overlay[] overlays = surfaces[0].getOverlays();
        surfaceInfoChild.setNumOverlays(overlays != null ? overlays.length : 0);
        if (surfaces[0] instanceof SurfaceData) {
            surfaceInfoChild.setPreviewImage(((SurfaceData)surfaces[0]).getPreviewImage());
        }
        return surfaceInfoChild;
    }

    static {
        String[] surfaceFormatExtensions;
        LOADED_FORMATS = new Vector();
        LOADED_SURFACE_FORMATS = new Vector();
        KNOWN_HEADER_EXTENSIONS = CollectionUtilities.immutable((String[])new String[]{".nii", ".nii.gz", ".mnc.gz", ".hdr", ".des"});
        MINIMUM_LENGTH = SCANNING_LABEL.length() + 5;
        Volume.loadFormats();
        Vector<ReadableHeader> loadedReadableFormats = Header.LOADED_READABLE_FORMATS;
        Enumeration<ReadableHeader> en = loadedReadableFormats.elements();
        while (en.hasMoreElements()) {
            ReadableHeader rh = en.nextElement();
            if (rh instanceof Series) continue;
            String ext = rh.getPreferredFileExtension();
            if (ext.charAt(0) != '.') {
                ext = "." + ext;
            }
            LOADED_FORMATS.add(ext);
        }
        for (String element : KNOWN_HEADER_EXTENSIONS) {
            LOADED_FORMATS.add(element);
        }
        for (String surfaceFormatExtension : surfaceFormatExtensions = SurfaceReader.getFormatExtensions()) {
            LOADED_SURFACE_FORMATS.add(surfaceFormatExtension);
        }
    }
}

