/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.faq;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.dialogs.faq.GettingStartedPanel;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GettingStarted
extends JPanel
implements ActionListener {
    private JButton nextButton;
    private JButton previousButton;
    private GettingStartedPanel imagePanel;
    private JFrame frame;
    public static final String ACTION_PREVIOUS = "ACTION_PREVIOUS";
    public static final String ACTION_NEXT = "ACTION_NEXT";
    public static final String ACTION_DONE = "ACTION_DONE";
    public static final int MAX_SLIDES = 4;
    private static final long serialVersionUID = 1L;

    public GettingStarted() {
        this.createUI();
    }

    private void createUI() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.nextButton = new JButton("Next >");
        this.nextButton.setActionCommand(ACTION_NEXT);
        this.nextButton.addActionListener(this);
        this.previousButton = new JButton("< Previous");
        this.previousButton.setActionCommand(ACTION_PREVIOUS);
        this.previousButton.addActionListener(this);
        JButton doneButton = new JButton("Done");
        doneButton.setActionCommand(ACTION_DONE);
        doneButton.addActionListener(this);
        buttonPanel.add(Box.createHorizontalStrut(8));
        buttonPanel.add(this.previousButton);
        buttonPanel.add(Box.createHorizontalStrut(8));
        buttonPanel.add(this.nextButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(doneButton);
        buttonPanel.add(Box.createHorizontalStrut(8));
        this.imagePanel = new GettingStartedPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.imagePanel, "Center");
        this.add((Component)buttonPanel, "South");
        this.frame = new JFrame();
    }

    public static void showInFrame(Mango mango) {
        GettingStarted gs = new GettingStarted();
        JFrame frame = gs.frame;
        frame.setResizable(false);
        frame.setBackground(Color.WHITE);
        frame.setContentPane(gs);
        frame.setIconImage(MangoStyle.ICON_APP.getImage());
        frame.setDefaultCloseOperation(2);
        frame.setTitle("Getting Started with Mango");
        frame.validate();
        frame.pack();
        frame.setLocation(DisplayUtils.getCenterDialogLocation(mango.getToolBox(), frame.getSize()));
        frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_DONE)) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (command.equals(ACTION_NEXT)) {
            this.imagePanel.setIndex(this.imagePanel.getIndex() + 1);
        } else if (command.equals(ACTION_PREVIOUS)) {
            this.imagePanel.setIndex(this.imagePanel.getIndex() - 1);
        }
        this.updateEnabledState();
        this.imagePanel.repaint();
    }

    private void updateEnabledState() {
        this.previousButton.setEnabled(this.imagePanel.getIndex() != 0);
        this.nextButton.setEnabled(this.imagePanel.getIndex() != 3);
    }
}

