/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.dicomchooser;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerListener;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.formats.dicom.DICOM;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class DicomChooserTable
extends JPanel
implements ActionListener,
ViewerListener {
    private Vector[] viewers;
    private boolean[] headerColPrimed;
    private boolean[] isOpen;
    private boolean[] openAttempt;
    private int descriptionIndex;
    private int dimensionsIndex;
    private int slicesIndex;
    private final JTable table;
    private final Mango mango;
    private final String[][] descriptions;
    private final String[][] dimensions;
    private final String[][] slices;
    private final Vector<DICOM>[] dicoms;
    private static final Color IS_OPEN_COLOR = new Color(50, 151, 255);
    private static final Color OPEN_ATTEMPT_COLOR = new Color(195, 238, 255);
    private static final Font FONT = new Font("SansSerif", 1, 12);
    private static final String[] DESCRIPTION_NAMES = new String[]{"Series Description", "Study Description", "Patient Name", "Patient ID", "Study Date", "Filename"};
    private static final String[] DIMENSION_NAMES = new String[]{"Image Dimensions", "Voxel Dimensions"};
    private static final String[] SLICE_NAMES = new String[]{"Slices", "Slice Size", "Direction"};
    private static final int NUM_DESCRIPTION_ELEMENTS = 6;
    private static final int NUM_DIMENSION_ELEMENTS = 2;
    private static final int NUM_SLICE_ELEMENTS = 3;
    private static final long serialVersionUID = 1L;
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(0);
    public static final String TEXT_BY = " x ";

    protected DicomChooserTable(Mango parent, Collection<Vector<DICOM>> values) {
        this.mango = parent;
        Object[] obs = values.toArray();
        this.dicoms = new Vector[obs.length];
        for (int ctr = 0; ctr < obs.length; ++ctr) {
            this.dicoms[ctr] = (Vector)obs[ctr];
        }
        this.openAttempt = new boolean[obs.length];
        this.isOpen = new boolean[obs.length];
        this.viewers = new Vector[obs.length];
        this.headerColPrimed = new boolean[3];
        this.descriptions = new String[obs.length][6];
        this.dimensions = new String[obs.length][2];
        this.slices = new String[obs.length][3];
        this.descriptionIndex = 0;
        this.dimensionsIndex = 0;
        this.slicesIndex = 0;
        JToggleButton[] buttons = new JToggleButton[obs.length];
        DefaultTableModel model = new DefaultTableModel();
        this.table = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }

            @Override
            public boolean isCellSelected(int row, int col) {
                return false;
            }
        };
        this.table.setModel(model);
        this.table.setDragEnabled(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        CustomCellRenderer cellRenderer = new CustomCellRenderer();
        CustomHeaderRenderer headerRenderer = new CustomHeaderRenderer();
        model.addColumn("col1");
        model.addColumn("col2");
        model.addColumn("col3");
        model.addColumn("col4");
        this.table.getColumn("col1").setCellRenderer(cellRenderer);
        this.table.getColumn("col2").setCellRenderer(cellRenderer);
        this.table.getColumn("col3").setCellRenderer(cellRenderer);
        this.table.getColumn("col4").setCellRenderer(cellRenderer);
        this.table.getColumn("col1").setHeaderRenderer(headerRenderer);
        this.table.getColumn("col2").setHeaderRenderer(headerRenderer);
        this.table.getColumn("col3").setHeaderRenderer(headerRenderer);
        this.table.getColumn("col4").setHeaderRenderer(headerRenderer);
        this.table.getTableHeader().getColumnModel().getColumn(0).setHeaderValue(DESCRIPTION_NAMES[this.descriptionIndex]);
        this.table.getTableHeader().getColumnModel().getColumn(1).setHeaderValue(DIMENSION_NAMES[this.dimensionsIndex]);
        this.table.getTableHeader().getColumnModel().getColumn(2).setHeaderValue(SLICE_NAMES[this.slicesIndex]);
        this.table.getTableHeader().getColumnModel().getColumn(3).setHeaderValue(" ");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(225);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(125);
        JTableHeader tableHeader = this.table.getTableHeader();
        final JTable tableF = this.table;
        final JToggleButton[] buttonsF = buttons;
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent me) {
                for (JToggleButton element : buttonsF) {
                    element.setSelected(false);
                }
                tableF.repaint();
            }

            @Override
            public void mousePressed(MouseEvent me) {
                if (tableF.rowAtPoint(me.getPoint()) != -1 && tableF.columnAtPoint(me.getPoint()) == tableF.convertColumnIndexToView(3)) {
                    JToggleButton button = (JToggleButton)tableF.getValueAt(tableF.rowAtPoint(me.getPoint()), tableF.convertColumnIndexToView(3));
                    button.setSelected(true);
                    tableF.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (tableF.rowAtPoint(me.getPoint()) != -1) {
                    JToggleButton button = (JToggleButton)tableF.getValueAt(tableF.rowAtPoint(me.getPoint()), tableF.convertColumnIndexToView(3));
                    if (button.isSelected()) {
                        button.doClick();
                    }
                    for (JToggleButton element : buttonsF) {
                        element.setSelected(false);
                    }
                    tableF.repaint();
                }
            }
        });
        final JTableHeader tableHeaderF = tableHeader;
        tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent me) {
                ((DicomChooserTable)DicomChooserTable.this).headerColPrimed[2] = false;
                ((DicomChooserTable)DicomChooserTable.this).headerColPrimed[1] = false;
                ((DicomChooserTable)DicomChooserTable.this).headerColPrimed[0] = false;
                tableHeaderF.repaint();
            }

            @Override
            public void mousePressed(MouseEvent me) {
                int columnNum = tableHeaderF.columnAtPoint(me.getPoint());
                if (columnNum == tableF.convertColumnIndexToView(0)) {
                    DicomChooserTable.this.descriptionIndex++;
                    DicomChooserTable.this.descriptionIndex = DicomChooserTable.this.descriptionIndex % 6;
                    tableHeaderF.repaint();
                    tableF.repaint();
                } else if (columnNum == tableF.convertColumnIndexToView(1)) {
                    DicomChooserTable.this.dimensionsIndex++;
                    DicomChooserTable.this.dimensionsIndex = DicomChooserTable.this.dimensionsIndex % 2;
                    tableHeaderF.repaint();
                    tableF.repaint();
                } else if (columnNum == tableF.convertColumnIndexToView(2)) {
                    DicomChooserTable.this.slicesIndex++;
                    DicomChooserTable.this.slicesIndex = DicomChooserTable.this.slicesIndex % 3;
                    tableHeaderF.repaint();
                    tableF.repaint();
                }
            }
        });
        tableHeaderF.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                int columnNum = tableHeaderF.columnAtPoint(me.getPoint());
                ((DicomChooserTable)DicomChooserTable.this).headerColPrimed[0] = columnNum == tableF.convertColumnIndexToView(0);
                ((DicomChooserTable)DicomChooserTable.this).headerColPrimed[1] = columnNum == tableF.convertColumnIndexToView(1);
                ((DicomChooserTable)DicomChooserTable.this).headerColPrimed[2] = columnNum == tableF.convertColumnIndexToView(2);
                tableHeaderF.repaint();
            }
        });
        for (int ctr = 0; ctr < this.dicoms.length; ++ctr) {
            int numFrames;
            int numSlices;
            if (this.dicoms[ctr] == null) continue;
            DICOM dcm = this.dicoms[ctr].elementAt(0);
            this.descriptions[ctr][0] = dcm.getSeriesDescription();
            this.descriptions[ctr][1] = dcm.getStudyDescription();
            this.descriptions[ctr][2] = dcm.getPatientName();
            this.descriptions[ctr][3] = dcm.getPatientID();
            this.descriptions[ctr][4] = dcm.getStudyDate();
            this.descriptions[ctr][5] = dcm.getImageFilename();
            this.dimensions[ctr][0] = dcm.isMosaic() ? dcm.getAcquisitionMatrix()[0] + TEXT_BY + dcm.getAcquisitionMatrix()[1] : dcm.getCols() + TEXT_BY + dcm.getRows();
            this.dimensions[ctr][1] = FORMATTER.format(dcm.getColSpacing()) + TEXT_BY + FORMATTER.format(dcm.getRowSpacing());
            if (dcm.isMosaic()) {
                int[] matSize = dcm.getAcquisitionMatrix();
                int cols = dcm.getCols();
                int rows = dcm.getRows();
                numSlices = cols / matSize[1] * (rows / matSize[0]);
                numFrames = this.dicoms[ctr].size();
            } else {
                numSlices = this.dicoms[ctr].size();
                numFrames = 0;
            }
            this.slices[ctr][0] = numSlices + (numFrames > 1 ? " (" + numFrames + " frames)" : "");
            this.slices[ctr][1] = FORMATTER.format(dcm.getSliceThickness());
            String dirString = dcm.makeImageOrientationLabelFromImageOrientationPatient().toLowerCase();
            if (dirString != null) {
                dirString = String.valueOf(dirString.charAt(0)).toUpperCase() + dirString.substring(1);
            }
            this.slices[ctr][2] = dirString;
            int rows = dcm.getRows();
            int cols = dcm.getCols();
            buttons[ctr] = new JToggleButton("Open");
            buttons[ctr].setActionCommand("Open: " + ctr);
            buttons[ctr].addActionListener(this);
            buttons[ctr].setMargin(new Insets(0, 0, 0, 0));
            model.addRow(new Object[]{this.descriptions[ctr][0], rows + TEXT_BY + cols, this.slices, buttons[ctr]});
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.table.getTableHeader());
        mainPanel.add(this.table);
        JScrollPane scroller = new JScrollPane(mainPanel);
        this.setLayout(new BoxLayout(this, 1));
        this.add(scroller);
        if (this.dicoms.length > 15) {
            this.setPreferredSize(new Dimension(625, 200));
        }
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.indexOf("Open:") != -1) {
            int index = Integer.parseInt(command.substring(6));
            Vector<DICOM> chosenDICOM = this.dicoms[index];
            if (chosenDICOM.elementAt(0).isFileSet()) {
                URI[] files = new URI[chosenDICOM.size()];
                int fileIndex = 0;
                Enumeration<DICOM> en = chosenDICOM.elements();
                while (en.hasMoreElements()) {
                    try {
                        files[fileIndex++] = new File(en.nextElement().getImageFile()).getCanonicalFile().toURI();
                    }
                    catch (IOException ex) {
                        AppLogger.warn((Throwable)ex);
                    }
                }
                this.openAttempt[index] = true;
                if (this.viewers[index] == null) {
                    this.viewers[index] = new Vector();
                }
                this.viewers[index].add(this.mango.addViewer(files, this));
                this.updateTable();
            } else {
                int size = chosenDICOM.size();
                DICOM[] dicomArray = new DICOM[size];
                for (int ctr = 0; ctr < size; ++ctr) {
                    dicomArray[ctr] = chosenDICOM.elementAt(ctr);
                }
                File chosenFile = new File(dicomArray[0].getImageFile());
                this.openAttempt[index] = true;
                if (this.viewers[index] == null) {
                    this.viewers[index] = new Vector();
                }
                this.viewers[index].add(this.mango.addViewer(dicomArray, chosenFile, this));
                this.updateTable();
            }
        }
    }

    public JTable getTable() {
        return this.table;
    }

    @Override
    public void viewerClosing(SliceViewer ov) {
        for (Vector viewer : this.viewers) {
            if (viewer == null || !viewer.contains(ov)) continue;
            viewer.remove(ov);
        }
        this.updateTable();
    }

    protected void parentIsClosing() {
        for (Vector viewer : this.viewers) {
            if (viewer == null) continue;
            Enumeration en = viewer.elements();
            while (en.hasMoreElements()) {
                ((SliceViewer)en.nextElement()).removeListener(this);
            }
        }
    }

    private void updateTable() {
        for (int ctr = 0; ctr < this.viewers.length; ++ctr) {
            if (this.viewers[ctr] == null) continue;
            Enumeration en = this.viewers[ctr].elements();
            while (en.hasMoreElements()) {
                SliceViewer ov = (SliceViewer)en.nextElement();
                if (!ov.isDead()) continue;
                this.viewers[ctr].remove(ov);
            }
            this.isOpen[ctr] = this.viewers[ctr].size() > 0;
        }
        this.table.repaint();
    }

    class CustomHeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        CustomHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable aTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(aTable, value, isSelected, hasFocus, row, column);
            this.setBorder(BorderFactory.createLineBorder(Color.WHITE));
            if (column == 0) {
                this.setText(DESCRIPTION_NAMES[DicomChooserTable.this.descriptionIndex]);
            } else if (column == 1) {
                this.setText(DIMENSION_NAMES[DicomChooserTable.this.dimensionsIndex]);
            } else if (column == 2) {
                this.setText(SLICE_NAMES[DicomChooserTable.this.slicesIndex]);
            }
            if (column < 3) {
                if (DicomChooserTable.this.headerColPrimed[column]) {
                    this.setText(this.getText() + (Platform.MAC ? " \u25be" : " \u2794"));
                } else {
                    this.setText(this.getText() + (Platform.MAC ? " \u25bf" : " \u27a4"));
                }
            }
            if (value.toString().equals(" ")) {
                cell.setBackground(Color.WHITE);
            } else {
                cell.setBackground(Color.LIGHT_GRAY);
            }
            cell.setFont(FONT);
            return cell;
        }
    }

    class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable aTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof JToggleButton) {
                return (JToggleButton)value;
            }
            Component cell = super.getTableCellRendererComponent(aTable, value, isSelected, hasFocus, row, column);
            if (column == 0) {
                this.setText(DicomChooserTable.this.descriptions[row][DicomChooserTable.this.descriptionIndex]);
            } else if (column == 1) {
                this.setText(DicomChooserTable.this.dimensions[row][DicomChooserTable.this.dimensionsIndex]);
            } else if (column == 2) {
                this.setText(DicomChooserTable.this.slices[row][DicomChooserTable.this.slicesIndex]);
            }
            if (DicomChooserTable.this.isOpen[row]) {
                this.setBackground(IS_OPEN_COLOR);
            } else if (DicomChooserTable.this.openAttempt[row]) {
                this.setBackground(OPEN_ATTEMPT_COLOR);
            } else {
                this.setBackground(Color.WHITE);
            }
            this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            return cell;
        }
    }
}

