/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.dicomchooser;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBar;
import edu.uthscsa.ric.mango.dialogs.dicomchooser.DicomChooserTable;
import edu.uthscsa.ric.mango.window.ToolboxAssociated;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.formats.dicom.DICOM;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class DicomChooser
extends JFrame
implements ToolboxAssociated {
    private DicomChooserTable[] allTables;
    private TreeMap<String, Vector<DICOM>> map;
    private boolean isDicomDir;
    private final File selectedFile;
    private final Mango mango;
    private static final long serialVersionUID = 1L;

    public DicomChooser(Mango mango, File selectedFile) {
        this.mango = mango;
        this.selectedFile = selectedFile;
        this.setIconImage(MangoStyle.ICON_APP.getImage());
    }

    @Override
    public String getDescription() {
        return this.getTitle();
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    public void readDICOM() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProgressBar pbIndeterminate = new ProgressBar(Mango.getInstance().getToolBox(), "");
                pbIndeterminate.init(0, 0, 100);
                pbIndeterminate.setValue(1);
                pbIndeterminate.setIndeterminateMode(true);
                try {
                    DicomChooser.this.map = Header.readDICOMFolder(DicomChooser.this.selectedFile);
                }
                catch (IOException ex) {
                    AppLogger.error((Throwable)ex);
                    DicomChooser.this.mango.showErrorDialog("Could not read that DICOM folder:\n" + ex.getMessage(), "DICOM Folder Error");
                }
                pbIndeterminate.setIndeterminateMode(false);
                pbIndeterminate.setValue(100);
                DicomChooser.this.readDICOMFinished();
            }
        }, "DicomChooserOld.readDicom() Thread");
        workThread.start();
    }

    public void setDicoms(TreeMap<String, Vector<DICOM>> aMap) {
        this.map = aMap;
    }

    private void createUI() {
        Collection<Vector<DICOM>> values = this.map.values();
        if (values.size() <= 0) {
            Mango.showErrorDialogStatic("No DICOM files were found in that folder!", "DICOM Load Failed");
            return;
        }
        Object[] obs = values.toArray();
        Vector[] dicoms = new Vector[obs.length];
        for (int ctr = 0; ctr < obs.length; ++ctr) {
            dicoms[ctr] = (Vector)obs[ctr];
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                for (DicomChooserTable allTable : DicomChooser.this.allTables) {
                    allTable.parentIsClosing();
                }
            }

            @Override
            public void windowClosing(WindowEvent we) {
                for (DicomChooserTable allTable : DicomChooser.this.allTables) {
                    allTable.parentIsClosing();
                }
            }
        });
        TreeMap tabMap = new TreeMap();
        for (Vector dicom : dicoms) {
            String currentID = ((DICOM)dicom.elementAt(0)).getStudyUID();
            if (currentID == null) continue;
            if (tabMap.containsKey(currentID)) {
                Vector value = (Vector)tabMap.get(currentID);
                value.add(dicom);
                continue;
            }
            Vector<Vector> vectorNew = new Vector<Vector>();
            vectorNew.add(dicom);
            tabMap.put(currentID, vectorNew);
        }
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setFocusable(false);
        Set keySet = tabMap.keySet();
        int keySetSize = keySet.size();
        this.allTables = new DicomChooserTable[keySetSize];
        int allTablesCtr = 0;
        for (Map.Entry entry : tabMap.entrySet()) {
            Collection data = (Collection)entry.getValue();
            String sessionName = ((DICOM)((Vector)data.iterator().next()).elementAt(0)).getPatientName();
            if (sessionName != null && (sessionName = sessionName.trim()).equals("")) {
                sessionName = ((DICOM)((Vector)data.iterator().next()).elementAt(0)).getStudyDescription();
            }
            if (sessionName != null && (sessionName = sessionName.trim()).equals("")) {
                sessionName = "<No Name>";
            }
            DicomChooserTable aTable = new DicomChooserTable(this.mango, data);
            this.allTables[allTablesCtr++] = aTable;
            if (keySetSize == 1) {
                tabbedPane.addTab(sessionName, aTable);
                continue;
            }
            tabbedPane.addTab(allTablesCtr + ": " + sessionName, aTable);
        }
        this.setTitle((this.isDicomDir ? "DICOMDIR: " : "DICOM Folder: ") + this.selectedFile.getName());
        this.getContentPane().add((Component)tabbedPane, "Center");
        this.setBackground(MangoStyle.COLOR_PANEL_OUTSIDE);
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setLocation(Mango.getInstance().getToolBox().getNextAssociatedWindowLocation(this));
        this.setVisible(true);
        this.validate();
        this.toFront();
        this.repaint();
    }

    private void readDICOMFinished() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                DicomChooser.this.createUI();
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }
}

