/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.core;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.URLUtilities;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class LoadItem
implements Comparable<LoadItem> {
    private File file;
    private SliceViewer baseImage;
    private String baseImageName;
    private URI baseImageUri;
    private URI uri;
    private List<URI> uris;
    private boolean overlay;
    private boolean refresh;
    private boolean roi;
    private boolean surface;
    private boolean parametric;
    public static final String KEY_BASE_IMAGE_REF = "baseimage";
    public static final String KEY_PARAMETERS = "params";
    public static final String PARAM_OVERLAY = "o";
    public static final String PARAM_REFRESH = "r";

    public LoadItem(File file) {
        this.file = file;
    }

    public LoadItem(List<URI> uris) {
        this.setUris(uris);
    }

    public LoadItem(URI uri) {
        this.uri = uri;
        if (!FileUtilities.uriIsFile((URI)uri)) {
            this.parseQueryString();
            this.removeQueryString();
        }
    }

    public SliceViewer getBaseImage() {
        if (this.baseImage != null) {
            return this.baseImage;
        }
        if (this.baseImageUri != null) {
            return Mango.findViewerByFile(this.baseImageUri);
        }
        if (this.baseImageName != null) {
            return Mango.findViewerByName(this.baseImageName);
        }
        return null;
    }

    public String getBaseImageName() {
        return this.baseImageName;
    }

    public File getFile() {
        return this.file;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public boolean isRoi() {
        return this.roi;
    }

    public boolean isSurface() {
        return this.surface;
    }

    public void setBaseImage(SliceViewer aViewer) {
        this.baseImage = aViewer;
    }

    public void setBaseImageName(String baseImageName) {
        this.baseImageName = baseImageName;
    }

    public void setBaseImageUri(URI aURI) {
        this.baseImageUri = aURI;
    }

    public void setOverlay(boolean overlay) {
        this.overlay = overlay;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public void setRoi(boolean roi) {
        this.roi = roi;
    }

    public void setSurface(boolean surface) {
        this.surface = surface;
    }

    public String toString() {
        if (this.file != null) {
            return this.file.toString();
        }
        if (this.uri != null) {
            return this.uri.toString();
        }
        return "No Name";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadItem other = (LoadItem)obj;
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    private void parseQueryString() {
        try {
            String query = this.uri.getQuery();
            if (StringUtils.isNotBlank((CharSequence)query)) {
                if (AppLogger.isDebugEnabled()) {
                    AppLogger.debug((String)query);
                }
                Map fields = URLUtilities.splitQuery((String)this.uri.getQuery());
                if (AppLogger.isDebugEnabled()) {
                    AppLogger.debug((String)fields.toString());
                }
                if (fields.containsKey(KEY_BASE_IMAGE_REF)) {
                    this.baseImageName = (String)fields.get(KEY_BASE_IMAGE_REF);
                }
                if (fields.containsKey(KEY_PARAMETERS)) {
                    String params = (String)fields.get(KEY_PARAMETERS);
                    if (params.indexOf(PARAM_OVERLAY) != -1) {
                        this.overlay = true;
                    }
                    if (params.indexOf(PARAM_REFRESH) != -1) {
                        this.refresh = true;
                    }
                }
                if (AppLogger.isDebugEnabled()) {
                    AppLogger.debug((String)(this.baseImageName + " " + this.overlay + " " + this.refresh));
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    private void removeQueryString() {
        String uriStr = this.uri.toString();
        int queryIndex = uriStr.indexOf(63);
        if (queryIndex != -1) {
            uriStr = uriStr.substring(0, queryIndex);
            try {
                this.uri = new URI(uriStr);
            }
            catch (URISyntaxException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    @Override
    public int compareTo(LoadItem that) {
        String stringA = this.toString().toLowerCase();
        String stringB = that.toString().toLowerCase();
        return stringA.compareTo(stringB);
    }

    public List<URI> getUris() {
        return this.uris;
    }

    public void setUris(List<URI> uris) {
        this.uris = uris;
    }

    public boolean isParametric() {
        return this.parametric;
    }

    public void setParametric(boolean parametric) {
        this.parametric = parametric;
    }
}

