/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components.transparencyslider;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.transparencyslider.MangoTransparencySliderUI;
import edu.uthscsa.ric.mango.components.transparencyslider.MangoTransparencySliderUser;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import javax.swing.JMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;

public class MangoTransparencySlider
extends JSlider {
    private JMenu menu;
    private ScreenVolume screenVolume;
    private boolean mouseIn;
    private final DecimalFormat decimalFormat = new DecimalFormat("0.0");
    private final MangoTransparencySliderUser user;
    private final Rectangle thumbRect;
    private final Rectangle trackRect;
    private final boolean hoverMode;
    private static final Font MENU_FONT = new Font("SansSerif", 0, 10);
    private static final long serialVersionUID = 1L;
    protected BufferedImage arrowSelectorImage;
    protected BufferedImage arrowSelectorNotFocusedImage;

    public MangoTransparencySlider(int orient, int min, int max, int val, MangoTransparencySliderUser user, boolean hoverMode) {
        super(orient, min, max, val);
        this.setUI(new MangoTransparencySliderUI(this));
        this.user = user;
        this.hoverMode = hoverMode;
        try {
            this.arrowSelectorImage = ImageIO.read(Mango.class.getResourceAsStream("images/arrow.gif"));
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
        try {
            this.arrowSelectorNotFocusedImage = ImageIO.read(Mango.class.getResourceAsStream("images/arrow_not_focused.gif"));
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
        this.thumbRect = ((MangoTransparencySliderUI)this.getUI()).getThumbRect();
        this.trackRect = ((MangoTransparencySliderUI)this.getUI()).getTrackRect();
        this.setEnabled(user.canEnable(this));
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                MangoTransparencySlider.this.repaint();
                MangoTransparencySlider.this.user.sliderChanged(MangoTransparencySlider.this);
            }
        });
        if (hoverMode) {
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent me) {
                    int oldValue = MangoTransparencySlider.this.getValue();
                    int newValue = ((BasicSliderUI)MangoTransparencySlider.this.getUI()).valueForXPosition(me.getPoint().x);
                    if (MangoTransparencySlider.this.isEnabled() && oldValue != newValue) {
                        MangoTransparencySlider.this.setValue(newValue);
                    }
                }
            });
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                MangoTransparencySlider.this.mouseIn = true;
                MangoTransparencySlider.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent me) {
                MangoTransparencySlider.this.mouseIn = false;
                MangoTransparencySlider.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                MangoTransparencySlider.this.user.sliderControlReleased(MangoTransparencySlider.this);
            }
        });
    }

    public JMenu getMenu() {
        return this.menu;
    }

    public ScreenVolume getScreenVolume() {
        return this.screenVolume;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(MENU_FONT);
        if (this.isEnabled()) {
            g2d.setColor(Color.BLACK);
        } else {
            g2d.setColor(Color.GRAY);
        }
        if (this.mouseIn || this.hoverMode) {
            g2d.drawString(this.decimalFormat.format((double)this.getValue() / (double)(this.getMaximum() - this.getMinimum())), this.thumbRect.x - 2, this.thumbRect.y + 2);
        } else {
            g2d.drawString("Transparency", this.trackRect.x, this.trackRect.y + 2);
        }
    }

    public void setMenu(JMenu menu) {
        this.menu = menu;
    }

    public void setScreenVolume(ScreenVolume screenVolume) {
        this.screenVolume = screenVolume;
    }
}

