/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components.titledcheckboxborder;

import edu.uthscsa.ric.mango.components.titledcheckboxborder.MangoTitledCheckboxBorderListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class MangoTitledCheckboxBorder
extends AbstractBorder {
    private Rectangle rect;
    private final Border border;
    private final JCheckBox checkBox;
    private final JComponent container;
    private final MangoTitledCheckboxBorderListener listener;
    private final String title;
    private static final int X_OFFSET = 10;
    private static final long serialVersionUID = 1L;

    public MangoTitledCheckboxBorder(JComponent container, MangoTitledCheckboxBorderListener listener, String title) {
        this.listener = listener;
        this.container = container;
        this.title = title;
        this.checkBox = new JCheckBox(title);
        this.border = BorderFactory.createEtchedBorder();
        this.checkBox.setSelected(true);
        if (container != null) {
            container.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.dispatchEvent(e);
                }

                private void dispatchEvent(MouseEvent event) {
                    Point p = event.getPoint();
                    if (MangoTitledCheckboxBorder.this.rect != null && MangoTitledCheckboxBorder.this.rect.contains(p) && MangoTitledCheckboxBorder.this.listener != null) {
                        MangoTitledCheckboxBorder.this.checkBox.setSelected(!MangoTitledCheckboxBorder.this.checkBox.isSelected());
                        if (MangoTitledCheckboxBorder.this.checkBox.isSelected()) {
                            MangoTitledCheckboxBorder.this.listener.checkboxBorderSelected(MangoTitledCheckboxBorder.this.title);
                        } else {
                            MangoTitledCheckboxBorder.this.listener.checkboxBorderDeselected(MangoTitledCheckboxBorder.this.title);
                        }
                        MangoTitledCheckboxBorder.this.container.repaint();
                    }
                }
            });
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        if (this.border != null) {
            if (this.border instanceof AbstractBorder) {
                ((AbstractBorder)this.border).getBorderInsets(c, insets);
            } else {
                Insets i = this.border.getBorderInsets(c);
                insets.top = i.top;
                insets.right = i.right;
                insets.bottom = i.bottom;
                insets.left = i.left;
            }
        }
        if (c == null || this.checkBox == null) {
            return insets;
        }
        Dimension size = this.checkBox.getPreferredSize();
        insets.top = Math.max(size.height, insets.top);
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets insets = this.getBorderInsets(c);
        if (this.border != null) {
            Insets borderInsets = this.border.getBorderInsets(c);
            int halfTop = (insets.top - borderInsets.top) / 2;
            this.border.paintBorder(c, g, x, y + halfTop, width, height - halfTop);
        }
        this.rect = new Rectangle(this.checkBox.getPreferredSize());
        this.rect.x = 10;
        SwingUtilities.paintComponent(g, this.checkBox, (Container)c, this.rect);
    }

    public void setSelected(boolean bool) {
        this.checkBox.setSelected(bool);
        this.container.repaint();
    }
}

