/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components.progressbar;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBarListener;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import java.awt.Component;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressBar
extends JPanel
implements ProgressMeter {
    private String description;
    private boolean finished;
    private boolean forceStart;
    private boolean notified;
    private boolean started;
    private int current;
    private int max;
    private int min;
    private long timeStarted;
    private final JProgressBar progressBar;
    private final ProgressBarListener listener;
    private static final long serialVersionUID = 1L;
    public static final double SHOW_PROGRESS_AFTER_DELAY_THRESH = 0.5;
    public static final long DELAY = 250L;

    public ProgressBar(ProgressBarListener listener, String descriptionVal) {
        String description = descriptionVal;
        this.listener = listener;
        this.description = description;
        if (description == null) {
            description = "";
        }
        this.progressBar = new JProgressBar(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getString() {
                return ProgressBar.this.description + " " + super.getString();
            }
        };
        if (listener != null) {
            this.setBackground(listener.getProgressBarBackgroundColor());
            this.progressBar.setPreferredSize(listener.getProgressBarDimensions());
        }
        this.progressBar.setStringPainted(true);
        this.add((Component)this.progressBar, "Center");
    }

    public int getCurrent() {
        return this.current;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public void init(final int min, final int current, final int max) {
        this.min = min;
        this.current = current;
        this.max = max;
        this.notified = false;
        this.started = false;
        this.finished = false;
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressBar.this.progressBar.setMinimum(min);
                ProgressBar.this.progressBar.setValue(current);
                ProgressBar.this.progressBar.setMaximum(max);
            }
        });
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
        if (this.description == null) {
            this.description = "";
        }
    }

    public void setForceStart() {
        this.forceStart = true;
    }

    public void setIndeterminateMode(final boolean bool) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressBar.this.progressBar.setIndeterminate(bool);
                if (bool) {
                    if (!ProgressBar.this.notified && ProgressBar.this.listener != null) {
                        ProgressBar.this.listener.progressBarStarted(ProgressBar.this);
                    }
                    ProgressBar.this.started = (ProgressBar.this.notified = true);
                }
                ProgressBar.this.progressBar.setStringPainted(!bool);
            }
        });
    }

    public void setStringPainted(boolean bool) {
        this.progressBar.setStringPainted(bool);
    }

    public void setValue(final int num) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                long timeDiff;
                ProgressBar.this.current = num;
                ProgressBar.this.progressBar.setValue(ProgressBar.this.current);
                if (!ProgressBar.this.started) {
                    ProgressBar.this.timeStarted = new Date().getTime();
                    ProgressBar.this.started = true;
                    if (ProgressBar.this.forceStart) {
                        if (ProgressBar.this.listener != null) {
                            ProgressBar.this.listener.progressBarStarted(ProgressBar.this);
                        }
                        ProgressBar.this.notified = true;
                    }
                } else if (!ProgressBar.this.notified && (timeDiff = new Date().getTime() - ProgressBar.this.timeStarted) > 250L && (double)ProgressBar.this.current < (double)(ProgressBar.this.max - ProgressBar.this.min) * 0.5 + (double)ProgressBar.this.min) {
                    if (ProgressBar.this.listener != null) {
                        ProgressBar.this.listener.progressBarStarted(ProgressBar.this);
                    }
                    ProgressBar.this.notified = true;
                }
                if (ProgressBar.this.current >= ProgressBar.this.max) {
                    if (ProgressBar.this.listener != null && !ProgressBar.this.finished && ProgressBar.this.started && ProgressBar.this.notified) {
                        ProgressBar.this.listener.progressBarFinished(ProgressBar.this);
                    }
                    ProgressBar.this.finished = true;
                }
            }
        });
    }

    public void start(int min, int current, int max) {
        this.init(min, current, max);
    }

    public void start(int min, int current, int max, boolean forceStart) {
        if (forceStart) {
            this.setForceStart();
        }
        this.init(min, current, max);
    }
}

