/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components.menus;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.UIManager;

public final class MangoSquareMenu
extends JMenu {
    private Color currentColor;
    private Image image;
    private int iconHeight;
    private int iconWidth;
    private static final Color ARMED = ((Color)UIManager.getDefaults().get("Menu.background")).darker();
    private static final Color BACKGROUND = (Color)UIManager.getDefaults().get("Menu.background");
    private static final long serialVersionUID = 1L;

    public MangoSquareMenu(ImageIcon icon) {
        super("");
        this.setIcon(icon);
        this.getPopupMenu().setLightWeightPopupEnabled(false);
        this.currentColor = BACKGROUND;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                MangoSquareMenu.this.currentColor = ARMED;
                MangoSquareMenu.this.getParent().repaint();
            }

            @Override
            public void mouseExited(MouseEvent me) {
                MangoSquareMenu.this.currentColor = BACKGROUND;
                MangoSquareMenu.this.getParent().repaint();
            }

            @Override
            public void mousePressed(MouseEvent me) {
                MangoSquareMenu.this.currentColor = BACKGROUND;
                MangoSquareMenu.this.getParent().repaint();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.currentColor);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.image != null) {
            g.drawImage(this.image, (this.getSize().width - this.iconWidth) / 2, (this.getSize().height - this.iconHeight) / 2, null);
        }
    }

    public void setIcon(ImageIcon icon) {
        if (icon != null) {
            this.image = icon.getImage();
            this.iconWidth = icon.getIconWidth();
            this.iconHeight = icon.getIconHeight();
        }
    }
}

