/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components;

import edu.uthscsa.ric.utilities.MathUtilities;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class MangoNumberFormatter {
    private DecimalFormat scientificNotationFormat;
    private DecimalFormat valueFormat;
    private final int type;
    public static final int FIXED = 2;
    public static final int LONG = 1;
    public static final int SHORT = 0;
    public static final int TRANSFORM = 3;

    private static int countAlphaNumericNegativeChars(String string) {
        int count = 0;
        int length = string.length();
        for (int ctr = 0; ctr < length; ++ctr) {
            char current = string.charAt(ctr);
            if (!Character.isLetterOrDigit(current) && current != '-') continue;
            ++count;
        }
        return count;
    }

    private static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = MathUtilities.pow((double)10.0, (double)power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public MangoNumberFormatter() {
        this(0, false);
    }

    public MangoNumberFormatter(int val) {
        this(val, false);
    }

    public MangoNumberFormatter(int val, boolean showDecimalAlways) {
        this.type = val;
        if (this.type == 1) {
            this.valueFormat = new DecimalFormat("0.#####", new DecimalFormatSymbols(Locale.US));
            this.valueFormat.setDecimalSeparatorAlwaysShown(showDecimalAlways);
            this.scientificNotationFormat = new DecimalFormat("0.000E0", new DecimalFormatSymbols(Locale.US));
        } else if (this.type == 0) {
            this.valueFormat = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
            this.valueFormat.setDecimalSeparatorAlwaysShown(showDecimalAlways);
            this.scientificNotationFormat = new DecimalFormat("0.0E0", new DecimalFormatSymbols(Locale.US));
        } else if (this.type == 2) {
            this.valueFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
            this.valueFormat.setDecimalSeparatorAlwaysShown(showDecimalAlways);
            this.scientificNotationFormat = new DecimalFormat("0.0E0", new DecimalFormatSymbols(Locale.US));
        } else if (this.type == 3) {
            this.valueFormat = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
            this.valueFormat.setDecimalSeparatorAlwaysShown(true);
            this.scientificNotationFormat = new DecimalFormat("0.000E0", new DecimalFormatSymbols(Locale.US));
        }
    }

    public String format(double value) {
        String string = String.valueOf(value);
        int count = MangoNumberFormatter.countAlphaNumericNegativeChars(string);
        if (value == 0.0) {
            string = "0";
        } else if (Double.isInfinite(value)) {
            string = "Infinity";
        } else if (Double.isNaN(value)) {
            string = "NaN";
        } else if (this.type == 1) {
            if (value > 9999999.0 || value < -999999.0) {
                string = this.scientificNotationFormat.format(value);
                if (string.indexOf(69) != string.length() - 2) {
                    string = string.substring(0, string.indexOf(69) - 1) + string.substring(string.indexOf(69));
                }
                if (string.indexOf(".E") != -1) {
                    string = string.substring(0, string.indexOf(46)) + string.substring(string.indexOf(69));
                }
            } else {
                string = this.valueFormat.format(value);
                count = MangoNumberFormatter.countAlphaNumericNegativeChars(string);
                if (count > 7 && (string = string.substring(0, 7)).charAt(6) == '.') {
                    string = string.substring(0, 6);
                }
            }
        } else if (this.type == 3) {
            string = value == 0.0 ? "0" : (value < 0.1 & value > -0.1 ? this.scientificNotationFormat.format(value) : String.valueOf(MangoNumberFormatter.roundToSignificantFigures(value, 4)));
        } else if (this.type == 0) {
            if (value > 99999.0 || value < -9999.0) {
                string = this.scientificNotationFormat.format(value);
                if (string.indexOf(69) != string.length() - 2) {
                    string = string.substring(0, string.indexOf(46)) + string.substring(string.indexOf(69));
                }
            } else {
                string = this.valueFormat.format(value);
                count = MangoNumberFormatter.countAlphaNumericNegativeChars(string);
                if (count > 5 && (string = string.substring(0, 5)).charAt(4) == '.') {
                    string = string.substring(0, 4);
                }
            }
        } else if (this.type == 2) {
            if (value > 9999.0 || value < -999.0) {
                string = this.scientificNotationFormat.format(value);
                if (string.indexOf(69) != string.length() - 2) {
                    string = string.substring(0, string.indexOf(46)) + string.substring(string.indexOf(69));
                }
            } else {
                string = this.valueFormat.format(value);
                count = MangoNumberFormatter.countAlphaNumericNegativeChars(string);
                if (count > 5 && (string = string.substring(0, 5)).charAt(4) == '.') {
                    string = string.substring(0, 4);
                }
            }
        }
        return string;
    }
}

