/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.mango.components.MangoSquareButton;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPicker;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPickerPopupManager;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.roi.ColorManager;
import edu.uthscsa.ric.roi.ROIColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Popup;
import javax.swing.PopupFactory;

public class MangoColorButton
extends MangoSquareButton
implements MouseListener,
ActionListener,
MangoColorSelectedListener,
MangoColorPickerPopupManager {
    private MangoColorSelectedListener listener;
    private SliceViewer viewer;
    private boolean showPicker;
    private boolean showUsedOnly;
    private int colorNum;
    private final transient ColorManager manager;
    private static final long serialVersionUID = 1L;
    private transient Popup popup;
    public static final int PADDING = 6;

    public MangoColorButton(int colorNum, ColorManager manager, Mango mango) {
        super(mango);
        this.manager = manager;
        this.colorNum = colorNum;
        this.createUI();
    }

    public MangoColorButton(int colorNum, ColorManager manager, SliceViewer viewer) {
        super(viewer.getMango());
        this.viewer = viewer;
        this.manager = manager;
        this.colorNum = colorNum;
        this.createUI();
    }

    public MangoColorButton(SliceViewer viewer, MangoColorSelectedListener listener, boolean showUsedOnly) {
        super(viewer.getMango());
        this.viewer = viewer;
        this.listener = listener;
        this.manager = viewer.getROIManager();
        this.colorNum = viewer.getROIManager().getCurrentROI();
        this.showPicker = true;
        this.showUsedOnly = showUsedOnly;
        this.createUI();
    }

    private void createUI() {
        this.addMouseListener(this);
        this.addActionListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isEnabled() && this.colorNum != -1) {
            g.setColor(ROIColor.getColor(this.colorNum));
        } else {
            g.setColor(Color.GRAY);
        }
        g.fillRect(6, 6, this.getSize().width - 12, this.getSize().height - 12);
    }

    public void setColor(int colorNum) {
        this.colorNum = colorNum;
        this.setToolTipText(this.viewer.getROIManager().getROILabel(colorNum));
        this.repaint();
    }

    public void setColor(int colorNum, String label) {
        this.colorNum = colorNum;
        this.setToolTipText(label);
        this.repaint();
    }

    public int getColor() {
        return this.colorNum;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        if (this.colorNum != -1) {
            int maxColors = this.manager.getMaximumColors();
            if (maxColors != -1) {
                if (this.viewer != null) {
                    this.setToolTipText(this.viewer.getROIManager().getROILabel(this.colorNum));
                }
            } else {
                this.setToolTipText(null);
            }
        } else {
            this.setToolTipText(null);
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.showPicker) {
            if (this.popup != null) {
                this.closePopup();
            } else if (this.viewer != null) {
                this.popup = PopupFactory.getSharedInstance().getPopup(this, new MangoColorPicker((ColorManager)this.viewer.getROIManager(), this, this.viewer.getROIManager(), this.viewer.getROIManager().getBuffer().getMaximumColors(), !this.showUsedOnly), this.getLocationOnScreen().x, this.getLocationOnScreen().y + 35);
                this.popup.show();
            }
        }
    }

    private void closePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    public void colorSelected(int colorNum) {
        this.closePopup();
        this.setColor(colorNum);
        if (this.listener != null) {
            this.listener.colorSelected(colorNum);
        }
    }

    @Override
    public void closeColorPickerPopup() {
        this.closePopup();
    }
}

