/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.core.LoadItem;
import edu.uthscsa.ric.mango.core.StringComparator;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.JVMUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.TreeSet;

public class MangoServer
extends Thread {
    private BufferedReader input;
    private PrintWriter fileOutput;
    private ServerSocket serviceSocket;
    private Socket socket;
    private final Mango mango;
    public static final String PORT_FILENAME = "port_number";
    public static final int QUIT_TYPE_IMMEDIATE = 2;
    public static final int QUIT_TYPE_NONE = 0;
    public static final int QUIT_TYPE_NORMAL = 1;

    protected static int makeLoadSet(TreeSet<LoadItem> treeSet, String command) {
        URI previousFile = null;
        boolean isOverlay = false;
        boolean isRefresh = false;
        int startIndex = command.indexOf(91) + 1;
        int endIndex = command.indexOf(44);
        if (endIndex == -1) {
            endIndex = command.indexOf(93);
        }
        while (startIndex < endIndex) {
            String current = command.substring(startIndex, endIndex).trim();
            if (current.equals("-o")) {
                isOverlay = true;
            } else if (current.equals("-r")) {
                isRefresh = true;
            } else {
                if (current.equals("-q")) {
                    return 1;
                }
                if (current.equals("-k")) {
                    return 2;
                }
                if (Mango.isCustomURL(current) || current.startsWith("http://")) {
                    try {
                        LoadItem item = new LoadItem(new URI(Mango.convertFromCustomURL(current)));
                        treeSet.add(item);
                    }
                    catch (URISyntaxException ex) {
                        AppLogger.warn((Throwable)ex);
                    }
                    isRefresh = false;
                    isOverlay = false;
                } else {
                    File file = new File(current);
                    if (file.exists()) {
                        LoadItem item = new LoadItem(file);
                        item.setOverlay(isOverlay);
                        item.setRefresh(isRefresh);
                        if (isOverlay) {
                            item.setBaseImageUri(previousFile);
                        } else {
                            previousFile = file.toURI();
                        }
                        treeSet.add(item);
                    }
                    isRefresh = false;
                    isOverlay = false;
                }
            }
            if ((endIndex = command.indexOf(44, startIndex = endIndex + 1)) != -1) continue;
            endIndex = command.indexOf(93, startIndex);
        }
        return 0;
    }

    protected MangoServer(Mango mango) {
        this.mango = mango;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.serviceSocket = new ServerSocket(Mango.getInstance().getPort(), 0, InetAddress.getByName("127.0.0.1"));
            File portFile = new File(Platform.getTempDir(), PORT_FILENAME);
            this.fileOutput = new PrintWriter(portFile);
            this.fileOutput.println(String.valueOf(this.serviceSocket.getLocalPort()));
            this.fileOutput.close();
            while (true) {
                this.socket = this.serviceSocket.accept();
                this.input = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                TreeSet<Object> treeSet = new TreeSet<Object>(new StringComparator());
                String command = this.input.readLine();
                if (command == null) continue;
                int quitType = MangoServer.makeLoadSet(treeSet, command);
                if (quitType == 1) {
                    this.mango.exitProgram();
                } else if (quitType == 2) {
                    JVMUtilities.forceExit();
                } else if (treeSet.size() > 0) {
                    this.mango.addToLoadSet(treeSet);
                }
                try {
                    this.input.close();
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
                try {
                    this.socket.close();
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        catch (SocketException se) {
            if (AppLogger.isDebugEnabled()) {
                AppLogger.debug((String)se.getMessage());
            }
            this.stopServer();
        }
        catch (IOException ex) {
            try {
                AppLogger.error((Throwable)ex);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.stopServer();
            }
        }
    }

    protected void stopServer() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
        if (this.fileOutput != null) {
            this.fileOutput.close();
        }
        try {
            if (this.serviceSocket != null) {
                this.serviceSocket.close();
            }
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
    }
}

