/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.platform.FireFoxFix;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;

public final class MangoPreferences {
    public static final String BROWSER_FOLDER = "BrowserFolder";
    public static final String CALCULATOR_HISTORY = "CalculatorHistory";
    public static final String CAPTURE_DESKTOP = "ScreenCaptureDesktop";
    public static final String CHECK_UPDATE = "CheckForUpdate";
    public static final String CHECK_UPDATE_LAST = "LastCheckForUpdate";
    public static final String DICOM_NATIVE_SUPPORT = "DicomNativeSupport";
    public static final String DISPLAY_TYPE = "Display";
    public static final String DISPLAY_TYPE_NEUROLOGICAL = "Neurological";
    public static final String DISPLAY_TYPE_RADIOLOGICAL = "Radiological";
    public static final String F_KEY_POST = "Action";
    public static final String F_KEY_PRE = "Function";
    public static final String IMAGE_INDEX_ORIGIN = "ImageIndexOrigin";
    public static final String LISTEN_FOR_FILES = "ListenForFiles";
    public static final String MAIN_SLICE_DIRECTION = "MainSliceDirection";
    public static final String MANGO_PREFERENCES = "Mango Preferences File";
    public static final String MANGO_VERSION = "MangoVersion";
    public static final String NEAREST_NEIGHBOR = "NearestNeighbor";
    public static final String NEAREST_NEIGHBOR_OPTION_HYBRID = "Hybrid";
    public static final String NEAREST_NEIGHBOR_OPTION_SMOOTH = "Smooth";
    public static final String NEAREST_NEIGHBOR_OPTION_VOXEL = "Voxel";
    public static final String OPEN_GL_BETTER_GRAPHICS = "OpenGLBetterGraphics";
    public static final String OPEN_GL_SHADERS = "OpenGLShaders";
    public static final String OVERLAY_COLOR_TABLE1 = "OverlayColorTable1";
    public static final String OVERLAY_COLOR_TABLE2 = "OverlayColorTable2";
    public static final String OVERLAY_COLOR_TABLE3 = "OverlayColorTable3";
    public static final String PORT_NUMBER = "PortNumber";
    public static final String QUICK_KEY_FIRST = "QuickKeyFirst";
    public static final String QUICK_KEY_SECOND = "QuickKeySecond";
    public static final String RECENT_FILE = "RecentFile";
    public static final String RETINA_DISPLAY_MODE = "RetinaDisplay";
    public static final String SCROLLWHEEL_DIRECTION_FLIP = "ScrollwheelDirectionFlip";
    public static final String SCROLLWHEEL_SLICES = "ScrollwheelSlices";
    public static final String TOOLBOX_COORDINATE_SLICE = "ToolboxCoordinateCurrentSlice";
    public static final String TOOLBOX_LOCATION = "ToolBoxLocation";
    public static final String VIEW_LABELS = "ViewLabels";
    public static final String VIEW_DICOM_OVERLAY = "ViewDicomOverlay";
    public static final String VIEW_LOWER_CROSSHAIRS = "ViewLowerCrosshairs";
    public static final String VIEW_MAIN_CROSSHAIRS = "ViewMainCrosshairs";
    public static final String VIEW_MODE = "ViewMode";
    public static final String VIEW_ORIENTATION = "ViewOrientation";
    public static final String VIEW_OVERLAY_CURRENT = "ViewOverlayCurrent";
    public static final String VIEW_ROI_EDGE = "ViewROIEdge";
    public static final String VIEW_ROI_MASK = "ViewROIMask";
    public static final String VIEW_ROI_STATS = "ViewROIStats";
    public static final String VIEW_SURFACE_ALL_PLANES = "ViewSurfaceAllPlanes";
    public static final String VIEW_SURFACE_CROSSHAIRS = "ViewSurfaceCrosshairs";
    public static final String VIEW_SURFACE_MAIN_PLANE = "ViewSurfaceMainPlane";
    public static final String VIEW_SURFACE_ORIENTATION = "ViewSurfaceOrientation";
    public static final String WARNINGS_DISABLED = "WarningsDisabled";
    public static final String JRE7_OSX_WARNING = "JRE7OSXWarning";
    public static final String RGB_WARNING = "RGBWarning";
    public static final String RGB_MODE_ENABLE = "RGBModeEnable";
    public static final int MAX_BROWSER_FOLDERS = 5;
    public static final int MAX_CALC_HISTORY = 10;
    public static final int MAX_RECENT_FILES = 10;
    public static final List<Integer> FUNCTION_KEY_CODES = CollectionUtilities.immutable((Integer[])new Integer[]{113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 61440, 61441, 61442, 61443, 61444, 61445, 61446, 61447, 61448, 61449, 61450, 61451});

    private MangoPreferences() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean readPreferences() {
        boolean loadedBrowserFolder;
        boolean prefFileFound;
        block50: {
            FileInputStream input = null;
            prefFileFound = false;
            loadedBrowserFolder = false;
            try {
                File prefFile = Platform.getPreferencesFile();
                if (prefFile.exists()) {
                    String str;
                    int ctr;
                    prefFileFound = true;
                    input = new FileInputStream(prefFile);
                    Properties props = new Properties();
                    props.load(input);
                    String version = props.getProperty(MANGO_VERSION);
                    if (version == null || !version.equals(Mango.getVersionString())) {
                        Mango.getInstance().setNewVersion(true);
                        FireFoxFix.fixIt();
                    }
                    boolean setRecentDir = false;
                    for (ctr = 0; ctr < 10; ++ctr) {
                        str = props.getProperty(RECENT_FILE + ctr);
                        if (str == null) continue;
                        URI uri = new URI(str);
                        Mango.getInstance().addToRecentFilesList(uri);
                        if (setRecentDir || !FileUtilities.uriIsFile((URI)uri)) continue;
                        File file = new File(uri);
                        Mango.getInstance().setLastAccessedDirectory(file.getParent());
                        setRecentDir = true;
                    }
                    for (ctr = 0; ctr < 5; ++ctr) {
                        str = props.getProperty(BROWSER_FOLDER + ctr);
                        if (str == null) continue;
                        loadedBrowserFolder |= Mango.getInstance().getImageBrowser().addFolder(new File(str));
                    }
                    for (ctr = 0; ctr < 10; ++ctr) {
                        str = props.getProperty(CALCULATOR_HISTORY + ctr);
                        if (str == null) continue;
                        Mango.getInstance().getCalculatorHistory().add(str);
                    }
                    Mango.setVoxelDisplayMode(Boolean.valueOf(props.getProperty(NEAREST_NEIGHBOR)));
                    Mango.setRetinaDisplayMode(Boolean.valueOf(props.getProperty(RETINA_DISPLAY_MODE)));
                    Mango.getInstance().setAutoCheck(Boolean.valueOf(props.getProperty(CHECK_UPDATE)));
                    long lastCheck = 0L;
                    try {
                        lastCheck = Long.parseLong(props.getProperty(CHECK_UPDATE_LAST));
                    }
                    catch (Exception ex) {
                        AppLogger.info((Throwable)ex);
                    }
                    Mango.getInstance().setLastCheckForUpdate(lastCheck);
                    Mango.getInstance().setListenForFiles(Boolean.valueOf(props.getProperty(LISTEN_FOR_FILES)));
                    int portNum = 63086;
                    try {
                        portNum = Integer.parseInt(props.getProperty(PORT_NUMBER));
                    }
                    catch (Exception ex) {
                        AppLogger.info((Throwable)ex);
                    }
                    Mango.getInstance().setPort(portNum);
                    int imageIndexOrigin = 0;
                    try {
                        imageIndexOrigin = Integer.parseInt(props.getProperty(IMAGE_INDEX_ORIGIN));
                    }
                    catch (Exception ex) {
                        AppLogger.info((Throwable)ex);
                    }
                    Mango.getInstance().setImageIndexOrigin(imageIndexOrigin);
                    Mango.getInstance().setCaptureToDesktop(Boolean.valueOf(props.getProperty(CAPTURE_DESKTOP)));
                    Mango.getInstance().setViewROIStats(Boolean.valueOf(props.getProperty(VIEW_ROI_STATS)));
                    Mango.getInstance().setViewLabels(Boolean.valueOf(props.getProperty(VIEW_LABELS)));
                    Mango.getInstance().setViewDicomOverlay(Boolean.valueOf(props.getProperty(VIEW_DICOM_OVERLAY)));
                    Mango.getInstance().setViewMainCrosshairs(Boolean.valueOf(props.getProperty(VIEW_MAIN_CROSSHAIRS)));
                    Mango.getInstance().setViewLowerCrosshairs(Boolean.valueOf(props.getProperty(VIEW_LOWER_CROSSHAIRS)));
                    Mango.getInstance().setViewROIEdge(Boolean.valueOf(props.getProperty(VIEW_ROI_EDGE)));
                    Mango.getInstance().setViewROIMask(Boolean.valueOf(props.getProperty(VIEW_ROI_MASK)));
                    Mango.getInstance().setScrollwheelSlices(Boolean.valueOf(props.getProperty(SCROLLWHEEL_SLICES)));
                    Mango.getInstance().setScrollwheelDirectionFlip(Boolean.valueOf(props.getProperty(SCROLLWHEEL_DIRECTION_FLIP)));
                    Mango.getInstance().setViewOverlayCurrent(Boolean.valueOf(props.getProperty(VIEW_OVERLAY_CURRENT)));
                    Mango.getInstance().setViewOrientation(Boolean.valueOf(props.getProperty(VIEW_ORIENTATION)));
                    Mango.getInstance().setViewMode(0);
                    Mango.setAllowRGBMode(Boolean.valueOf(props.getProperty(RGB_MODE_ENABLE)));
                    try {
                        Mango.getInstance().setViewMode(Integer.parseInt(props.getProperty(VIEW_MODE)));
                    }
                    catch (Exception ex) {
                        AppLogger.info((Throwable)ex);
                    }
                    Mango.setViewStateAllPlanesStatic(Boolean.valueOf(props.getProperty(VIEW_SURFACE_ALL_PLANES)));
                    Mango.setViewStateOrientationSurfaceStatic(Boolean.valueOf(props.getProperty(VIEW_SURFACE_ORIENTATION)));
                    Mango.setViewStateMainPlaneStatic(Boolean.valueOf(props.getProperty(VIEW_SURFACE_MAIN_PLANE)));
                    Mango.setViewStateCrosshairsStatic(Boolean.valueOf(props.getProperty(VIEW_SURFACE_CROSSHAIRS)));
                    SurfaceViewer.setUseShaders(Boolean.valueOf(props.getProperty(OPEN_GL_SHADERS)));
                    SurfaceViewer.setAlreadyWarnedAboutUsingBetterGraphics(Boolean.valueOf(props.getProperty(OPEN_GL_BETTER_GRAPHICS)));
                    Mango.setJre7MacWarning(Boolean.valueOf(props.getProperty(JRE7_OSX_WARNING)));
                    Mango.setRgbWarning(Boolean.valueOf(props.getProperty(RGB_WARNING)));
                    int sliceDir = 0;
                    try {
                        sliceDir = Integer.parseInt(props.getProperty(MAIN_SLICE_DIRECTION));
                    }
                    catch (Exception ex) {
                        AppLogger.info((Throwable)ex);
                    }
                    Mango.getInstance().setMainSliceDirection(sliceDir);
                    String toolBoxLoc = props.getProperty(TOOLBOX_LOCATION);
                    StringTokenizer tokenizer = new StringTokenizer(toolBoxLoc);
                    Point defaultLoc = DisplayUtils.getDefaultLocation();
                    int xLoc = defaultLoc.x;
                    try {
                        xLoc = Integer.parseInt(tokenizer.nextToken());
                    }
                    catch (Exception ex) {
                        AppLogger.info((Throwable)ex);
                    }
                    int yLoc = defaultLoc.y;
                    try {
                        yLoc = Integer.parseInt(tokenizer.nextToken());
                    }
                    catch (Exception ex) {
                        AppLogger.info((Throwable)ex);
                    }
                    Mango.getInstance().setToolBoxLocation(new Point(xLoc, yLoc));
                    String[] fActions = Mango.getInstance().getAllFunctionKeyActions();
                    for (int ctr2 = 0; ctr2 < fActions.length; ++ctr2) {
                        String str2 = props.getProperty(F_KEY_PRE + (ctr2 + 2) + F_KEY_POST);
                        if (str2 == null) continue;
                        fActions[ctr2] = str2;
                    }
                    int quickKeyFirst = 0;
                    try {
                        quickKeyFirst = Integer.parseInt(props.getProperty(QUICK_KEY_FIRST));
                    }
                    catch (Exception ex) {
                        AppLogger.info((Throwable)ex);
                    }
                    Mango.getInstance().setQuickKeyFirst(quickKeyFirst);
                    int quickKeySecond = 0;
                    try {
                        quickKeySecond = Integer.parseInt(props.getProperty(QUICK_KEY_SECOND));
                    }
                    catch (Exception ex) {
                        AppLogger.info((Throwable)ex);
                    }
                    Mango.getInstance().setQuickKeySecond(quickKeySecond);
                    if (DISPLAY_TYPE_RADIOLOGICAL.equals(props.getProperty(DISPLAY_TYPE))) {
                        Mango.getInstance().setRadiologicalMode(true);
                    }
                    Mango.getInstance().setOverlayColorTable1(props.getProperty(OVERLAY_COLOR_TABLE1));
                    Mango.getInstance().setOverlayColorTable2(props.getProperty(OVERLAY_COLOR_TABLE2));
                    Mango.getInstance().setOverlayColorTable3(props.getProperty(OVERLAY_COLOR_TABLE3));
                    Mango.getInstance().setToolboxCoordinateCurrentSlice(Boolean.valueOf(props.getProperty(TOOLBOX_COORDINATE_SLICE)));
                    break block50;
                }
                Mango.getInstance().setNewVersion(true);
                FireFoxFix.fixIt();
            }
            catch (FileNotFoundException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (URISyntaxException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        if (!loadedBrowserFolder) {
            Mango.getInstance().getImageBrowser().addFolder();
        }
        return prefFileFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void savePreferences() {
        FileOutputStream output = null;
        try {
            boolean success;
            Properties props = new Properties();
            props.setProperty(MANGO_VERSION, Mango.getVersionString());
            LinkedList<URI> recentFiles = Mango.getInstance().getRecentFiles();
            ListIterator<URI> it = recentFiles.listIterator(recentFiles.size());
            int filesIndex = 0;
            while (it.hasPrevious()) {
                URI uri = it.previous();
                props.setProperty(RECENT_FILE + filesIndex, uri.toString());
                ++filesIndex;
            }
            File[] folders = Mango.getInstance().getImageBrowser().getAllFolders();
            for (int ctr = 0; ctr < folders.length; ++ctr) {
                if (ctr >= 5) continue;
                props.setProperty(BROWSER_FOLDER + ctr, folders[ctr].toString());
            }
            LinkedList<String> calcHistory = Mango.getInstance().getCalculatorHistory();
            int calcHistoryMax = Math.min(calcHistory.size(), 10);
            for (int ctr = 0; ctr < calcHistoryMax; ++ctr) {
                String str = calcHistory.get(ctr);
                if (str == null) continue;
                props.setProperty(CALCULATOR_HISTORY + ctr, str);
            }
            String[] fActions = Mango.getInstance().getAllFunctionKeyActions();
            for (int ctr = 0; ctr < fActions.length; ++ctr) {
                if (fActions[ctr].equals("(Not Assigned)")) continue;
                props.setProperty(F_KEY_PRE + (ctr + 2) + F_KEY_POST, fActions[ctr]);
            }
            props.setProperty(NEAREST_NEIGHBOR, String.valueOf(Mango.isVoxelDisplay()));
            props.setProperty(RGB_MODE_ENABLE, String.valueOf(Mango.isAllowRGBMode()));
            props.setProperty(RETINA_DISPLAY_MODE, String.valueOf(Mango.isRetinaDisplayMode()));
            props.setProperty(CAPTURE_DESKTOP, String.valueOf(Mango.getInstance().isCaptureToDesktop()));
            props.setProperty(CHECK_UPDATE, Mango.getInstance().isAutoCheck() ? "true" : "false");
            props.setProperty(CHECK_UPDATE_LAST, String.valueOf(Mango.getInstance().getLastCheckForUpdate()));
            props.setProperty(LISTEN_FOR_FILES, Mango.getInstance().isListenForFiles() ? "true" : "false");
            props.setProperty(PORT_NUMBER, String.valueOf(Mango.getInstance().getPort()));
            props.setProperty(QUICK_KEY_FIRST, String.valueOf(Mango.getInstance().getQuickKeyFirst()));
            props.setProperty(QUICK_KEY_SECOND, String.valueOf(Mango.getInstance().getQuickKeySecond()));
            props.setProperty(VIEW_ROI_STATS, String.valueOf(Mango.getInstance().isViewROIStats()));
            props.setProperty(VIEW_LABELS, String.valueOf(Mango.getInstance().isViewLabels()));
            props.setProperty(VIEW_DICOM_OVERLAY, String.valueOf(Mango.getInstance().isViewDicomOverlay()));
            props.setProperty(VIEW_MAIN_CROSSHAIRS, String.valueOf(Mango.getInstance().isViewMainCrosshairs()));
            props.setProperty(VIEW_LOWER_CROSSHAIRS, String.valueOf(Mango.getInstance().isViewLowerCrosshairs()));
            props.setProperty(VIEW_ROI_EDGE, String.valueOf(Mango.getInstance().isViewROIEdge()));
            props.setProperty(VIEW_ROI_MASK, String.valueOf(Mango.getInstance().isViewROIMask()));
            props.setProperty(SCROLLWHEEL_SLICES, String.valueOf(Mango.getInstance().isScrollwheelSlices()));
            props.setProperty(SCROLLWHEEL_DIRECTION_FLIP, String.valueOf(Mango.getInstance().isScrollwheelDirectionFlip()));
            props.setProperty(VIEW_OVERLAY_CURRENT, String.valueOf(Mango.getInstance().isViewOverlayCurrent()));
            props.setProperty(MAIN_SLICE_DIRECTION, String.valueOf(Mango.getInstance().getMainSliceDirection()));
            props.setProperty(VIEW_ORIENTATION, String.valueOf(Mango.getInstance().isViewOrientation()));
            props.setProperty(VIEW_MODE, String.valueOf(Mango.getInstance().getViewMode()));
            props.setProperty(TOOLBOX_LOCATION, Mango.getInstance().getToolBox().getLocation().x + " " + Mango.getInstance().getToolBox().getLocation().y);
            props.setProperty(DISPLAY_TYPE, Mango.getInstance().isRadiologicalMode() ? DISPLAY_TYPE_RADIOLOGICAL : DISPLAY_TYPE_NEUROLOGICAL);
            props.setProperty(VIEW_SURFACE_ALL_PLANES, String.valueOf(Mango.getInstance().isViewStateAllPlanes()));
            props.setProperty(VIEW_SURFACE_ORIENTATION, String.valueOf(Mango.getInstance().isViewStateOrientationSurface()));
            props.setProperty(VIEW_SURFACE_MAIN_PLANE, String.valueOf(Mango.getInstance().isViewStateMainPlane()));
            props.setProperty(VIEW_SURFACE_CROSSHAIRS, String.valueOf(Mango.getInstance().isViewStateCrosshairs()));
            props.setProperty(OPEN_GL_SHADERS, String.valueOf(SurfaceViewer.isUseShaders()));
            props.setProperty(OPEN_GL_BETTER_GRAPHICS, String.valueOf(SurfaceViewer.isAlreadyWarnedAboutUsingBetterGraphics()));
            props.setProperty(IMAGE_INDEX_ORIGIN, String.valueOf(Mango.getInstance().getImageIndexOrigin()));
            props.setProperty(JRE7_OSX_WARNING, String.valueOf(Mango.isJre7MacWarning()));
            props.setProperty(RGB_WARNING, String.valueOf(Mango.isRgbWarning()));
            props.setProperty(OVERLAY_COLOR_TABLE1, Mango.getInstance().getOverlayColorTable1());
            props.setProperty(OVERLAY_COLOR_TABLE2, Mango.getInstance().getOverlayColorTable2());
            props.setProperty(OVERLAY_COLOR_TABLE3, Mango.getInstance().getOverlayColorTable3());
            props.setProperty(TOOLBOX_COORDINATE_SLICE, String.valueOf(Mango.getInstance().isToolboxCoordinateCurrentSlice()));
            File prefFile = Platform.getPreferencesFile();
            File prefFileDir = prefFile.getParentFile();
            if (!prefFileDir.exists() && !(success = prefFileDir.mkdirs())) {
                AppLogger.warn((String)("Could not create directory " + prefFileDir));
            }
            output = new FileOutputStream(prefFile);
            props.store(output, MANGO_PREFERENCES);
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                output.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }
}

