/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango;

import com.apple.eawt.Application;
import edu.uthscsa.ric.cli.ScriptablePlugin;
import edu.uthscsa.ric.mango.Atlas;
import edu.uthscsa.ric.mango.ImageLoader;
import edu.uthscsa.ric.mango.MangoContext;
import edu.uthscsa.ric.mango.MangoPlugin;
import edu.uthscsa.ric.mango.MangoPluginType;
import edu.uthscsa.ric.mango.MangoPreferences;
import edu.uthscsa.ric.mango.MangoServer;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.ViewerController;
import edu.uthscsa.ric.mango.components.MangoColorButton;
import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBar;
import edu.uthscsa.ric.mango.core.Capturable;
import edu.uthscsa.ric.mango.core.LaunchListener;
import edu.uthscsa.ric.mango.core.LoadItem;
import edu.uthscsa.ric.mango.core.StringComparator;
import edu.uthscsa.ric.mango.core.Version;
import edu.uthscsa.ric.mango.dialogs.console.Console;
import edu.uthscsa.ric.mango.dialogs.faq.GettingStarted;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.ImageBrowser;
import edu.uthscsa.ric.mango.dialogs.modal.AddImageDialog;
import edu.uthscsa.ric.mango.dialogs.modal.CheckUpdateDialog;
import edu.uthscsa.ric.mango.dialogs.modal.LicenseDialog;
import edu.uthscsa.ric.mango.dialogs.modal.PluginManagerDialog;
import edu.uthscsa.ric.mango.dialogs.modal.headereditor.HeaderEditor;
import edu.uthscsa.ric.mango.dialogs.script.Recordable;
import edu.uthscsa.ric.mango.dialogs.script.ScriptManager;
import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.dialogs.stats.ResultsTool;
import edu.uthscsa.ric.mango.exceptions.WrongVersionException;
import edu.uthscsa.ric.mango.menus.AboutDialog;
import edu.uthscsa.ric.mango.menus.AppleMenus;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.plugin.atlases.atlasfsl.AtlasFSL;
import edu.uthscsa.ric.mango.plugin.atlases.atlasfsl.AtlasFormatException;
import edu.uthscsa.ric.mango.plugin.imageloaders.talairachloader.TalairachLoader;
import edu.uthscsa.ric.mango.viewerprojection.window.ProjectionFrame;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.SliceViewerSyncer;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerListener;
import edu.uthscsa.ric.mango.viewerslice.menus.ViewerMenuAction;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.mango.viewerslice.window.ViewerFrame;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewerSyncer;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceReader;
import edu.uthscsa.ric.mango.viewersurface.window.SurfaceFrame;
import edu.uthscsa.ric.mango.window.Toolbox;
import edu.uthscsa.ric.roi.lines.clipboard.LOIClipboard;
import edu.uthscsa.ric.roi.mask.clipboard.ROIClipboard;
import edu.uthscsa.ric.roi.points.clipboard.POIClipboard;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.ConsoleLogger;
import edu.uthscsa.ric.utilities.DesktopUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.utilities.URLUtilities;
import edu.uthscsa.ric.visualization.surface.SurfaceController;
import edu.uthscsa.ric.visualization.surface.SurfacePlugin;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormat;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormatException;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.AnalysisPoint;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.Transform;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.WritableHeader;
import edu.uthscsa.ric.volume.formats.dicom.DICOM;
import edu.uthscsa.ric.volume.operations.calculation.ImageCalcExpression;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilter;
import edu.uthscsa.ric.volume.operations.filter.FilterManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class Mango
implements KeyEventDispatcher,
MangoContext,
Recordable {
    private Console console;
    private ImageBrowser imageBrowser;
    private KeyboardFocusManager kfm;
    private MangoServer server;
    private Point toolBoxLocation;
    private ScriptManager scriptTool;
    private SliceViewer currentViewer;
    private SliceViewerSyncer viewerSyncer;
    private ResultsTool resultsManager;
    private String lastAccessedDirectory;
    private String overlayColorTable1;
    private String overlayColorTable2;
    private String overlayColorTable3;
    private SurfaceViewerSyncer surfaceSyncer;
    private ProgressBar pbIndeterminate;
    private boolean applet;
    private boolean autoCheck;
    private boolean captureToDesktop;
    private boolean isExiting;
    private boolean isLoading;
    private boolean isNewVersion;
    private boolean isRadiologicalMode;
    private boolean listenForFiles;
    private boolean rotateCenter;
    private boolean scrollwheelDirectionFlip;
    private boolean scrollwheelSlices;
    private boolean toolboxCoordinateCurrentSlice;
    private boolean useSmartROITools;
    private boolean useSmartToolsToggle;
    private boolean viewLabels;
    private boolean viewDicomOverlay;
    private boolean viewLowerCrosshairs;
    private boolean viewMainCrosshairs;
    private boolean viewOrientation;
    private boolean viewOverlayCurrent;
    private boolean viewROIEdge;
    private boolean viewROIMask;
    private boolean viewROIStats;
    private boolean viewStateAllPlanes;
    private boolean viewStateCrosshairs;
    private boolean viewStateMainPlane;
    private boolean viewStateOrientation;
    private boolean showGettingStarted;
    private double magicWandRange;
    private double roiToolSizeMultiplier;
    private double smartToolsRangeMax;
    private double smartToolsRangeMin;
    private int imageIndexOrigin;
    private int mainSliceDirection;
    private int mostRecentToolsGetIndex;
    private int mostRecentToolsSetIndex;
    private int portNumber;
    private int quickKeyFirst;
    private int quickKeySecond;
    private int roiToolSize;
    private int toolSliceAbove;
    private int toolSliceBelow;
    private int viewMode;
    private long equalsBugTimestamp;
    private long lastCheckForUpdate;
    private FilterManager filterManager = new FilterManager();
    private Map<String, Boolean> movedMenuMap = new HashMap<String, Boolean>();
    private static LinkedList<String> calculatorHistory = new LinkedList();
    private static LinkedList<URI> recentFiles = new LinkedList();
    private static Mango it;
    private static SortedSet<LoadItem> loadSet;
    private static TreeMap<String, String> fileAssociationsKnown;
    private static TreeMap<String, String> plugins;
    private static TreeMap<String, String> pluginsSurface;
    private static Vector<LaunchListener> launchListeners;
    private static Vector<SliceViewer> allViewers;
    private static WeakReference<JApplet> mangoApplet;
    private static boolean retinaDisplayMode;
    private static boolean voxelDisplayMode;
    private static boolean allowRGBMode;
    private static boolean jre7MacWarning;
    private static final LOIClipboard CLIPBOARD_LOI;
    private static final POIClipboard CLIPBOARD_POI;
    private static final ROIClipboard CLIPBOARD;
    private static final String[] FILE_ASSOCIATION_EXT;
    private static final String[] FILE_ASSOCIATION_NAMES;
    private static final String[] F_ACTIONS;
    private static final int NUM_RECENT_TOOLS = 4;
    private static final int[] MOST_RECENT_TOOLS;
    protected Toolbox toolBox;
    public static final Font FONT_HEADING;
    public static final List<String> DEPRECATED_INCLUDED_PLUGINS;
    public static final List<String> INCLUDED_ATLAS_FILES;
    public static final String BUILD_DATE_KEY = "mangobuilddate";
    public static final String BUILD_NUMBER_KEY = "mangobuildnumber";
    public static final String BUILD_PROPERTIES_PATH = "build.properties";
    public static final String BUILD_VERSION_KEY = "mangobuildversion";
    public static final String CUSTOM_PROTOCOL = "mango";
    public static final String EXT_JAR = ".jar";
    public static final String EXT_ZIP = ".zip";
    public static final String NOT_ASSIGNED_STRING = "(Not Assigned)";
    public static final String PLUGIN_LIBRARY = "lib/plugins/";
    public static final String PREFIX_REPLACE = "replace_";
    public static final String SAMPLE_IMAGE_NAME = "sample_image.nii.gz";
    public static final String SAMPLE_IMAGE_PATH = "data";
    public static final String VERSION_ID = "currentversion41";
    public static final String[] INCLUDED_PLUGINS;
    public static final boolean AUTO_CHECK = true;
    public static final boolean CAPTURE_TO_DESKTOP = false;
    public static final boolean RGB_MODE = false;
    public static final boolean DISPLAY_RADIOLOGICAL = false;
    public static final boolean LISTEN_FOR_FILES = true;
    public static final boolean SCROLLWHEEL_DIRECTION_FLIP = false;
    public static final boolean SCROLLWHEEL_SLICES = false;
    public static final boolean VIEW_ALL_PLANES = true;
    public static final boolean VIEW_CROSSHAIRS = true;
    public static final boolean VIEW_LABELS = true;
    public static final boolean VIEW_LOWER_CROSSHAIRS = true;
    public static final boolean VIEW_MAIN_CROSSHAIRS = true;
    public static final boolean VIEW_MAIN_PLANE = false;
    public static final boolean VIEW_ORIENTATION = false;
    public static final boolean VIEW_ORIENTATION_SURFACE = false;
    public static final boolean VIEW_OVERLAY_CURRENT_ONLY = false;
    public static final boolean VIEW_ROI_EDGE = true;
    public static final boolean VIEW_ROI_MASK = false;
    public static final boolean VIEW_ROI_STATS = false;
    public static final boolean VOXEL_DISPLAY_MODE = false;
    public static final boolean WARNINGS_DISABLE = false;
    public static final int BUFFER_SIZE = 2048;
    public static final int MAIN_SLICE_DIRECTION = 0;
    public static final int MAX_RECENT_FILES = 10;
    public static final int PORT_DEFAULT = 63086;
    public static final int QUICK_KEY_FIRST = 0;
    public static final int QUICK_KEY_SECOND = 0;
    public static final int TIMEOUT = 8000;
    public static final int VIEW_MODE_ORTHO_TALL = 0;
    public static final int VIEW_MODE_ORTHO_WIDE = 1;
    public static final int VIEW_MODE_SLICE = 2;
    public static final long ONE_DAY_MS = 86400000L;
    public static final long ONE_WEEK_MS = 604800000L;

    public ImageVolume makeNewVolume() {
        return new Volume();
    }

    public static void addAtlas(File file) {
        if (file.isDirectory() && file.toString().endsWith(".atlas")) {
            try {
                new AtlasFSL(file);
                String name = file.getName();
                File atlasDir = Platform.getAtlasDir();
                if (!atlasDir.exists()) {
                    FileUtilities.mkdirs((File)atlasDir);
                }
                File destinationFile = new File(Platform.getAtlasDir(), name);
                FileUtilities.renameTo((File)file, (File)destinationFile);
                AtlasFSL atlas = new AtlasFSL(destinationFile);
                Mango.getInstance().toolBox.addAtlas(atlas);
            }
            catch (AtlasFormatException ex) {
                AppLogger.error((Throwable)ex);
                Mango.showErrorDialogStatic("There was a problem loading this atlas!\n\n" + ex.getMessage(), "Atlas Error");
            }
        } else {
            AppLogger.error((String)"File is not an atlas.");
            Mango.showErrorDialogStatic("There was a problem loading this atlas!\nClick the 'Learn more about atlases' link for more information...", "Atlas Error");
        }
    }

    public static void addLaunchListener(LaunchListener listener) {
        launchListeners.add(listener);
    }

    public static boolean addPlugin(File aFile, boolean doMoveFile) {
        File originalLocation = new File(aFile.getParent(), aFile.getName());
        File movedFile = null;
        File pluginFile = null;
        boolean loadFailed = false;
        try {
            if (!aFile.exists()) {
                throw new FileNotFoundException();
            }
            File pluginDir = Platform.getPluginDir();
            if (Platform.MAC) {
                if (doMoveFile) {
                    if (!pluginDir.exists()) {
                        FileUtilities.mkdirs((File)pluginDir);
                    }
                    if ((movedFile = new File(Platform.getHomeDirectory() + "/Library/Application Support/Mango/Plugins", aFile.getName())).exists()) {
                        it.showWarningDialog("Please restart Mango to use the updated plugin.  ", "Plugin Updated");
                        movedFile = new File(Platform.getHomeDirectory() + "/Library/Application Support/Mango/Plugins", PREFIX_REPLACE + aFile.getName());
                    }
                    FileUtilities.renameTo((File)aFile, (File)movedFile);
                    pluginFile = movedFile;
                } else {
                    pluginFile = aFile;
                }
                Mango.loadPlugin(pluginFile);
            } else if (Platform.WINDOWS) {
                if (doMoveFile) {
                    if (!pluginDir.exists()) {
                        FileUtilities.mkdirs((File)pluginDir);
                    }
                    if ((movedFile = new File(Platform.getHomeDirectory() + "\\Application Data\\Mango\\Plugins", aFile.getName())).exists()) {
                        it.showWarningDialog("Please restart Mango to use the updated plugin.  ", "Plugin Updated");
                        movedFile = new File(Platform.getHomeDirectory() + "\\Application Data\\Mango\\Plugins", PREFIX_REPLACE + aFile.getName());
                    }
                    FileUtilities.renameTo((File)aFile, (File)movedFile);
                    pluginFile = movedFile;
                } else {
                    pluginFile = aFile;
                }
                Mango.loadPlugin(pluginFile);
            } else if (Platform.UNIX) {
                if (doMoveFile) {
                    if (!pluginDir.exists()) {
                        FileUtilities.mkdirs((File)pluginDir);
                    }
                    if ((movedFile = new File(Platform.getHomeDirectory() + "/Mango/Plugins", aFile.getName())).exists()) {
                        it.showWarningDialog("Please restart Mango to use the updated plugin.  ", "Plugin Updated");
                        movedFile = new File(Platform.getHomeDirectory() + "/Mango/Plugins", PREFIX_REPLACE + aFile.getName());
                    }
                    FileUtilities.renameTo((File)aFile, (File)movedFile);
                    pluginFile = movedFile;
                } else {
                    pluginFile = aFile;
                }
                Mango.loadPlugin(pluginFile);
            }
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
            loadFailed = true;
        }
        catch (IllegalAccessException ex) {
            if (doMoveFile) {
                FileUtilities.renameTo(movedFile, (File)originalLocation);
                plugins.remove(movedFile.toString());
            }
            AppLogger.error((Throwable)ex);
            loadFailed = true;
        }
        catch (Error err) {
            if (doMoveFile) {
                FileUtilities.renameTo(movedFile, (File)originalLocation);
                plugins.remove(movedFile.toString());
            }
            AppLogger.error((Throwable)err);
            loadFailed = true;
        }
        catch (IOException ex) {
            if (doMoveFile) {
                FileUtilities.renameTo(movedFile, (File)originalLocation);
                plugins.remove(movedFile.toString());
            }
            AppLogger.error((Throwable)ex);
            loadFailed = true;
        }
        catch (ClassNotFoundException ex) {
            if (doMoveFile) {
                FileUtilities.renameTo(movedFile, (File)originalLocation);
                plugins.remove(movedFile.toString());
            }
            AppLogger.error((Throwable)ex);
            loadFailed = true;
        }
        catch (InstantiationException ex) {
            if (doMoveFile) {
                FileUtilities.renameTo(movedFile, (File)originalLocation);
                plugins.remove(movedFile.toString());
            }
            AppLogger.error((Throwable)ex);
            loadFailed = true;
        }
        catch (WrongVersionException ex) {
            if (doMoveFile) {
                FileUtilities.renameTo(movedFile, (File)originalLocation);
                plugins.remove(movedFile.toString());
            }
            AppLogger.error((Throwable)ex);
            loadFailed = true;
        }
        catch (Exception ex) {
            if (doMoveFile) {
                FileUtilities.renameTo(movedFile, (File)originalLocation);
                plugins.remove(movedFile.toString());
            }
            AppLogger.error((Throwable)ex);
            loadFailed = true;
        }
        if (loadFailed && !doMoveFile) {
            File moveFile = new File(pluginFile.getParent(), pluginFile.getName() + ".move");
            FileUtilities.createNewFile((File)moveFile);
        }
        Mango.prepareKnownFileAssociations();
        return !loadFailed;
    }

    public static void calculateScreenSliceTransforms() {
        for (SliceViewer current : allViewers) {
            current.calculateScreenSliceTransforms();
        }
    }

    public static Mango createMangoInstance() {
        it = new Mango();
        return it;
    }

    public static Object findPlugin(String pluginName) {
        try {
            Set<String> pluginNames = plugins.keySet();
            for (String aPluginName : pluginNames) {
                if (!pluginName.equals(aPluginName)) continue;
                Class<?> aClass = Class.forName(plugins.get(pluginName));
                return aClass.newInstance();
            }
            pluginNames = pluginsSurface.keySet();
            for (String aPluginName : pluginNames) {
                if (!pluginName.equals(aPluginName)) continue;
                Class<?> aClass = Class.forName(pluginsSurface.get(pluginName));
                return aClass.newInstance();
            }
        }
        catch (ClassNotFoundException ex) {
            AppLogger.warn((Throwable)ex);
        }
        catch (InstantiationException ex) {
            AppLogger.warn((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            AppLogger.warn((Throwable)ex);
        }
        return null;
    }

    public static SliceViewer findViewerByFile(URI uri) {
        for (SliceViewer current : allViewers) {
            if (!current.getLoadedURI().equals(uri)) continue;
            return current;
        }
        return null;
    }

    public static SliceViewer findViewerByName(String name) {
        for (SliceViewer current : allViewers) {
            if (!name.equals(FilenameUtils.getName((String)current.getBaseScreenVolume().getURI().toString()))) continue;
            return current;
        }
        return null;
    }

    public static void forceImageUpdate() {
        for (SliceViewer current : allViewers) {
            current.forceImageUpdate();
        }
    }

    public static SliceViewer[] getAllSliceViewers() {
        return allViewers.toArray(new SliceViewer[allViewers.size()]);
    }

    public static SliceViewer[] getAllSliceViewers(SliceViewer viewer, boolean includeSelf) {
        int count = 0;
        for (SliceViewer current : allViewers) {
            if (viewer == current) continue;
            ++count;
        }
        if (includeSelf) {
            ++count;
        }
        SliceViewer[] compatible = null;
        if (count > 0) {
            compatible = new SliceViewer[count];
            int ctr = 0;
            for (SliceViewer current : allViewers) {
                if (viewer == current) continue;
                compatible[ctr] = current;
                ++ctr;
            }
            if (includeSelf) {
                compatible[ctr] = viewer;
            }
        }
        return compatible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBuildNumberString() {
        String buildNum = "";
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = Mango.class.getResourceAsStream(BUILD_PROPERTIES_PATH);
            props.load(is);
            buildNum = (String)props.get(BUILD_NUMBER_KEY);
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    AppLogger.error((Throwable)ex);
                }
            }
        }
        return buildNum;
    }

    public static LOIClipboard getClipboardLoi() {
        return CLIPBOARD_LOI;
    }

    public static POIClipboard getClipboardPoi() {
        return CLIPBOARD_POI;
    }

    public static ROIClipboard getClipboardRoi() {
        return CLIPBOARD;
    }

    public static String[] getFActions() {
        return Arrays.copyOf(F_ACTIONS, F_ACTIONS.length);
    }

    public static String getFunctionKeyAction(int index) {
        return F_ACTIONS[index];
    }

    public static Mango getInstance() {
        return it;
    }

    public static JApplet getMangoApplet() {
        if (mangoApplet != null) {
            return (JApplet)mangoApplet.get();
        }
        return null;
    }

    public static String[] getPluginClasses() {
        int numPlugins = plugins.size();
        if (numPlugins > 0) {
            String[] allPlugins = new String[numPlugins];
            Collection<String> pluginClasses = plugins.values();
            Object[] pluginClasseesArray = pluginClasses.toArray();
            for (int ctr = 0; ctr < numPlugins; ++ctr) {
                allPlugins[ctr] = (String)pluginClasseesArray[ctr];
            }
            return allPlugins;
        }
        return new String[0];
    }

    public static String[] getPluginNames() {
        int numPlugins = plugins.size();
        if (numPlugins > 0) {
            String[] allPlugins = new String[numPlugins];
            Set<String> pluginNames = plugins.keySet();
            Object[] pluginNamesArray = pluginNames.toArray();
            for (int ctr = 0; ctr < numPlugins; ++ctr) {
                allPlugins[ctr] = (String)pluginNamesArray[ctr];
            }
            return allPlugins;
        }
        return null;
    }

    public static String[] getScriptNames() {
        File[] files = ScriptManager.findScriptFiles();
        String[] names = null;
        if (CollectionUtilities.isNotEmpty((Object)files)) {
            names = new String[files.length];
            for (int ctr = 0; ctr < files.length; ++ctr) {
                names[ctr] = FileUtilities.removeExtension((String)files[ctr].getName());
            }
        }
        return names;
    }

    public static TreeMap<String, String> getSurfacePluginMap() {
        return pluginsSurface;
    }

    public static String[] getSurfacePluginNames() {
        int numPlugins = pluginsSurface.size();
        if (numPlugins > 0) {
            String[] allPlugins = new String[numPlugins];
            Set<String> pluginNames = pluginsSurface.keySet();
            Object[] pluginNamesArray = pluginNames.toArray();
            for (int ctr = 0; ctr < numPlugins; ++ctr) {
                allPlugins[ctr] = (String)pluginNamesArray[ctr];
            }
            return allPlugins;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersionString() {
        String buildNum = "";
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = Mango.class.getResourceAsStream(BUILD_PROPERTIES_PATH);
            props.load(is);
            buildNum = ((String)props.get(BUILD_VERSION_KEY)).replaceAll("'", "");
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    AppLogger.error((Throwable)ex);
                }
            }
        }
        return buildNum;
    }

    public static boolean hasOrthogonalViewer() {
        return allViewers.size() > 0;
    }

    public static void initializeGroupOverlay(SliceViewer aViewerVal) {
        SliceViewer aViewer = aViewerVal;
        boolean found = aViewer.initializeGroupOverlay();
        if (!found) {
            SliceViewer current;
            Iterator<SliceViewer> iterator = allViewers.iterator();
            while (iterator.hasNext() && !(found = (aViewer = (current = iterator.next())).initializeGroupOverlay())) {
            }
        }
        if (found) {
            ScreenVolume[] overlays = aViewer.getOverlayManager().getAllOverlays();
            double min = 0.0;
            double max = 0.0;
            int minLUT = 0;
            int maxLUT = 0;
            for (ScreenVolume overlay : overlays) {
                if (overlay == null) continue;
                min = overlay.getScreenMin();
                max = overlay.getScreenMax();
                minLUT = overlay.getMinLUT();
                maxLUT = overlay.getMaxLUT();
            }
            for (SliceViewer current : allViewers) {
                current.setOverlayGroupScreenMin(min);
                current.setOverlayGroupScreenMax(max);
                current.updateOverlayGroupLUT(maxLUT, minLUT);
                current.clearOverlayData();
                current.updateScreenSlices();
                current.repaint();
            }
        }
    }

    public static boolean isRetinaDisplayMode() {
        return retinaDisplayMode;
    }

    public static boolean isScriptablePlugin(String className) {
        Object obj = Mango.findPlugin(className);
        if (obj instanceof MangoPlugin && obj instanceof ScriptablePlugin) {
            return true;
        }
        return obj instanceof SurfacePlugin && obj instanceof ScriptablePlugin;
    }

    public static boolean isVoxelDisplay() {
        return voxelDisplayMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadPlugin(File aFile, boolean isAdding) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, WrongVersionException {
        MangoPluginType ob;
        block18: {
            String fileName = aFile.getName();
            String className = null;
            ob = null;
            ZipFile jFile = null;
            try {
                if (fileName.endsWith(EXT_JAR) || fileName.endsWith(EXT_ZIP)) {
                    String baseName = null;
                    baseName = fileName.endsWith(EXT_JAR) ? fileName.substring(0, fileName.indexOf(EXT_JAR)) : fileName.substring(0, fileName.indexOf(EXT_ZIP));
                    if (baseName.startsWith(PREFIX_REPLACE)) {
                        baseName = baseName.substring(8);
                    }
                    String pluginName = baseName + ".class";
                    jFile = new JarFile(aFile);
                    Manifest manifest = ((JarFile)jFile).getManifest();
                    className = manifest.getMainAttributes().getValue("MangoPlugin-Class");
                    if (className == null) {
                        Enumeration<JarEntry> jarEntries = ((JarFile)jFile).entries();
                        while (jarEntries.hasMoreElements()) {
                            ZipEntry entry = jarEntries.nextElement();
                            if (entry.isDirectory()) continue;
                            String originalName = entry.getName();
                            String pathName = originalName.substring(0, originalName.lastIndexOf(47) + 1);
                            pathName = pathName.replace('/', '.');
                            pathName = pathName.trim();
                            String name = originalName.substring(originalName.lastIndexOf(47) + 1);
                            if (!(name = name.replace('/', '.')).equals(pluginName)) continue;
                            className = pathName + baseName;
                        }
                    }
                    JVMUtilities.addFileToClassPath((File)aFile);
                    Class<?> aClass = Class.forName(className);
                    ob = (MangoPluginType)aClass.newInstance();
                    if (!isAdding) break block18;
                    try {
                        String minVersionSupported = ob.getMinimumVersionSupported();
                        if (StringUtils.isNotBlank((CharSequence)minVersionSupported)) {
                            Version minVersion = new Version(minVersionSupported);
                            Version currentVersion = new Version(Mango.getVersionString());
                            if (currentVersion.isLessThan(minVersion)) {
                                throw new WrongVersionException("This plugin requires Mango version " + minVersion + "!");
                            }
                        }
                    }
                    catch (AbstractMethodError err) {
                        AppLogger.info((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
                    }
                    catch (NoSuchMethodError err) {
                        AppLogger.info((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
                    }
                    boolean success = Mango.loadPluginClass(className, ob);
                    if (!success) {
                        throw new IllegalArgumentException("Class file not found! " + className);
                    }
                    break block18;
                }
                throw new IllegalArgumentException("File type is not recognized!");
            }
            finally {
                try {
                    if (jFile != null) {
                        jFile.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        return ob;
    }

    public static void main(String[] args) {
        Application application;
        AppLogger.createFileLogger((File)Platform.getLogDir());
        if (Platform.MAC && (application = Application.getApplication()) != null) {
            application.setDockIconImage(application.getDockIconImage());
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                AppLogger.error((Throwable)e);
            }
        });
        try {
            if (Platform.UNIX) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (ClassNotFoundException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (InstantiationException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            AppLogger.error((Throwable)ex);
        }
        final String[] argsF = args;
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        Mango.clearTempDir();
        if (Platform.getTempDir().exists()) {
            FileUtilities.delete((File)Platform.getTempDir());
        }
        FileUtilities.mkdirs((File)Platform.getTempDir());
        Mango.removeDeprecatedIncludedPlugins();
        Mango.prepPlugins();
        Mango.loadIncludedPlugins();
        Mango.prepIncludedAtlasFiles();
        File libDir = Platform.getLibDir();
        if (!libDir.exists()) {
            FileUtilities.mkdirs((File)libDir);
        }
        try {
            JVMUtilities.addLibraryDir((String)Platform.getLibDir().toString());
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                Mango.createMangoInstance();
                it.initialize(false);
                if (!Platform.getTempDir().exists()) {
                    it.showErrorDialog("A necessary temp directory could not be made!\n(" + Platform.getTempDir() + ")", "Error");
                }
                if (argsF.length > 0) {
                    StringBuffer sb = new StringBuffer();
                    for (String element : argsF) {
                        sb.append(element);
                        sb.append(' ');
                    }
                    String commands = sb.toString();
                    if (commands.length() > 0) {
                        TreeSet<Object> treeSet = new TreeSet<Object>(new StringComparator());
                        MangoServer.makeLoadSet(treeSet, commands);
                        if (treeSet.size() > 0) {
                            it.addToLoadSet(treeSet);
                        }
                    }
                }
            }
        });
    }

    public static void notifyLaunchListeners() {
        for (LaunchListener listener : launchListeners) {
            listener.finishedLaunching();
        }
    }

    public static void setMangoApplet(JApplet applet) {
        mangoApplet = new WeakReference<JApplet>(applet);
    }

    public static void setOverlayGroupScreenMax(double max) {
        for (SliceViewer current : allViewers) {
            current.setOverlayGroupScreenMax(max);
        }
    }

    public static void setOverlayGroupScreenMin(double min) {
        for (SliceViewer current : allViewers) {
            current.setOverlayGroupScreenMin(min);
        }
    }

    public static void setRetinaDisplayMode(boolean retinaDisplayMode) {
        Mango.retinaDisplayMode = retinaDisplayMode;
    }

    public static void setVoxelDisplayMode(boolean voxelDisplayMode) {
        Mango.voxelDisplayMode = voxelDisplayMode;
        Mango.setNearestNeighborState();
    }

    public static void showErrorDialogStatic(final String message, final String title) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Frame frame = Mango.getInstance().getDialogParentFrame();
                if (frame == null) {
                    frame = Mango.getInstance().getToolBox();
                }
                MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, message + " ", title, 0, null, -1);
                jopf.show(true);
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unpackStandardImage() {
        File tempDir = Platform.getTempDir();
        File standardFile = new File(tempDir, SAMPLE_IMAGE_NAME);
        if (!standardFile.exists()) {
            BufferedInputStream fileRead = null;
            FilterOutputStream fileWrite = null;
            try {
                fileRead = new BufferedInputStream(Mango.class.getResourceAsStream("data/sample_image.nii.gz"));
                fileWrite = new BufferedOutputStream(new FileOutputStream(standardFile));
                byte[] buffer = new byte[2048];
                int bytesRead = fileRead.read(buffer);
                while (bytesRead != -1) {
                    ((BufferedOutputStream)fileWrite).write(buffer, 0, bytesRead);
                    bytesRead = fileRead.read(buffer);
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
            finally {
                try {
                    if (fileRead != null) {
                        fileRead.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
                try {
                    if (fileWrite != null) {
                        fileWrite.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        return standardFile;
    }

    public static void updateAllSurfaces() {
        for (SliceViewer current : allViewers) {
            current.updateSurface();
        }
    }

    public static void updateAllViewerFrames() {
        for (SliceViewer current : allViewers) {
            current.updateWindowTitle();
        }
    }

    public static void updateAllViewers() {
        for (SliceViewer current : allViewers) {
            current.updateViewer();
        }
    }

    public static void resetZoom() {
        for (SliceViewer current : allViewers) {
            current.setZoomFactor(1.0, true);
        }
    }

    public static void updateOverlayGroupLUT(int max, int min) {
        for (SliceViewer current : allViewers) {
            current.updateOverlayGroupLUT(max, min);
        }
    }

    public static void updateScreenTransforms() {
        for (SliceViewer current : allViewers) {
            current.updateScreenSliceTransforms();
        }
    }

    public static void updateSurfaces(boolean updateScreenSlices) {
        for (SliceViewer current : allViewers) {
            if (updateScreenSlices) {
                current.updateSurfaceTextures(true);
            }
            current.updateSurface();
        }
    }

    public static Object usePlugin(SliceViewer viewer, String className) {
        Object obj = Mango.findPlugin(className);
        if (!(obj instanceof ScriptablePlugin)) {
            viewer.recordAction("runPlugin", new String[]{ScriptUtils.convertString(className), ScriptUtils.convertArray(new String[0])});
            viewer.recordAction("pauseScriptForUserInput");
        }
        if (obj instanceof MangoPlugin) {
            MangoPlugin mp = (MangoPlugin)obj;
            try {
                mp.doOperation((MangoContext)Mango.getInstance(), (VolumeManager)viewer);
            }
            catch (AbstractMethodError err) {
                AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
                mp.doOperation(viewer.getMangoData(), (ViewerController)viewer);
            }
            catch (NoSuchMethodError err) {
                AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
                mp.doOperation(viewer.getMangoData(), (ViewerController)viewer);
            }
        } else if (obj instanceof SurfacePlugin) {
            SurfacePlugin sp = (SurfacePlugin)obj;
            sp.doOperation((SurfaceController)viewer.getSurfaceRender());
        } else if (obj instanceof Atlas) {
            Atlas atlas = (Atlas)obj;
            Mango.getInstance().toolBox.setAtlas(atlas);
        }
        return obj;
    }

    protected static String convertFromCustomURL(String url) {
        if (Mango.isCustomURL(url)) {
            return "http" + url.substring(CUSTOM_PROTOCOL.length());
        }
        return url;
    }

    protected static boolean isCustomURL(String url) {
        return url.startsWith("mango://");
    }

    protected static void setViewStateAllPlanesStatic(boolean bool) {
        Mango.getInstance().setViewStateAllPlanes(bool);
    }

    protected static void setViewStateCrosshairsStatic(boolean bool) {
        Mango.getInstance().setViewStateCrosshairs(bool);
    }

    protected static void setViewStateMainPlaneStatic(boolean bool) {
        Mango.getInstance().setViewStateMainPlane(bool);
    }

    protected static void setViewStateOrientationSurfaceStatic(boolean bool) {
        Mango.getInstance().setViewStateOrientationSurface(bool);
    }

    private static void addAllPlugins() {
        File pluginDir = Platform.getPluginDir();
        File[] pluginFiles = pluginDir.listFiles();
        if (pluginFiles != null) {
            for (File file : pluginFiles) {
                if (file.getName().toString().startsWith(PREFIX_REPLACE)) {
                    String filename = file.getName().toString();
                    File fileToReplace = new File(file.getParent(), filename.substring(8));
                    FileUtilities.delete((File)fileToReplace);
                    FileUtilities.renameTo((File)file, (File)fileToReplace);
                    continue;
                }
                File deleteFile = new File(file.getParent(), file.getName() + ".delete");
                File moveFile = new File(file.getParent(), file.getName() + ".move");
                if (deleteFile.exists()) {
                    FileUtilities.delete((File)deleteFile);
                    FileUtilities.delete((File)file);
                    continue;
                }
                if (!moveFile.exists()) continue;
                FileUtilities.delete((File)moveFile);
                File unsupportedPluginDir = Platform.getUnsupportedPluginDir();
                if (!unsupportedPluginDir.exists()) {
                    FileUtilities.mkdirs((File)unsupportedPluginDir);
                }
                FileUtilities.renameTo((File)file, (File)new File(unsupportedPluginDir, file.getName()));
            }
        }
        if ((pluginFiles = pluginDir.listFiles()) != null) {
            for (File file : pluginFiles) {
                if (!file.toString().endsWith(EXT_JAR) && !file.toString().endsWith(EXT_ZIP)) continue;
                Mango.addPlugin(file, false);
            }
        }
    }

    private static void clearTempDir() {
        FileUtilities.deleteFolder((String)Platform.getTempDir().toString());
    }

    private static int getNumOrthogonalViewers() {
        return allViewers.size();
    }

    private static void loadAtlases() {
        File atlasDir = Platform.getAtlasDir();
        File[] atlasFiles = atlasDir.listFiles();
        if (atlasFiles != null) {
            for (File file : atlasFiles) {
                if (!file.isDirectory() || !file.toString().endsWith(".atlas")) continue;
                try {
                    AtlasFSL atlas = new AtlasFSL(file);
                    Mango.getInstance().toolBox.addAtlas(atlas);
                }
                catch (AtlasFormatException ex) {
                    AppLogger.error((Throwable)ex);
                }
            }
        }
    }

    private static void loadAtlasesFromFSLFolder() {
        try {
            File atlasDir = new File(Platform.getFslPath());
            Vector<Atlas> atlases = AtlasFSL.loadAtlasDirectory(atlasDir);
            for (int ctr = 0; ctr < atlases.size(); ++ctr) {
                Mango.getInstance().toolBox.addAtlas(atlases.get(ctr));
            }
        }
        catch (AtlasFormatException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    private static void loadIncludedAtlases() {
        try {
            Vector<Atlas> atlases = AtlasFSL.loadAtlasDirectory(Platform.getAtlasDir());
            for (int ctr = 0; ctr < atlases.size(); ++ctr) {
                Mango.getInstance().toolBox.addAtlas(atlases.get(ctr));
            }
        }
        catch (AtlasFormatException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    private static void loadIncludedPlugins() {
        for (String pluginClass : INCLUDED_PLUGINS) {
            try {
                Class<?> aClass = Class.forName(pluginClass);
                Object ob = aClass.newInstance();
                Mango.loadPluginClass(pluginClass, ob);
            }
            catch (ClassNotFoundException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (InstantiationException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    private static Object loadPlugin(File aFile) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, WrongVersionException {
        return Mango.loadPlugin(aFile, true);
    }

    private static boolean loadPluginClass(String className, Object ob) {
        boolean success = false;
        try {
            if (ob instanceof MangoPluginType && !PluginManagerDialog.supportsCurrentMangoVersion(ob)) {
                throw new SurfaceFormatException("Plugin not supported by this version of Mango!");
            }
            if (ob instanceof WritableHeader) {
                WritableHeader wh = (WritableHeader)ob;
                Volume.addWritableHeader(wh);
                ReadableHeader rh = (ReadableHeader)ob;
                Volume.addReadableHeader(rh);
                success = true;
            } else if (ob instanceof ReadableHeader) {
                ReadableHeader rf = (ReadableHeader)ob;
                Volume.addReadableHeader(rf);
                success = true;
            } else if (ob instanceof Atlas) {
                Atlas at = (Atlas)ob;
                Mango.getInstance().toolBox.addAtlas(at);
                success = true;
            } else if (ob instanceof ImageLoader) {
                ImageLoader il = (ImageLoader)ob;
                Mango.getInstance().toolBox.addLoader(il);
                success = true;
            } else if (ob instanceof SurfaceFormat) {
                SurfaceFormat il = (SurfaceFormat)ob;
                SurfaceReader.addFormat(il);
                success = true;
            } else if (ob instanceof SurfacePlugin) {
                SurfacePlugin sp = (SurfacePlugin)ob;
                String userName = sp.getPluginName();
                boolean sameName = pluginsSurface.containsValue(className);
                if (!sameName) {
                    pluginsSurface.put(userName, className);
                    for (SliceViewer current : allViewers) {
                        current.getSurfaceRender().getFrame().addPluginMenuItem(userName);
                    }
                }
                success = true;
            } else if (ob instanceof MangoPlugin) {
                MangoPlugin mp = (MangoPlugin)ob;
                String userName = mp.getPluginName();
                boolean sameName = plugins.containsValue(className);
                if (!sameName) {
                    plugins.put(userName, className);
                    for (SliceViewer current : allViewers) {
                        current.getViewerFrame().getViewerMenu().addPluginMenuItem(userName);
                    }
                }
                success = true;
            }
        }
        catch (SurfaceFormatException ex) {
            AppLogger.warn((Throwable)ex);
        }
        catch (Error err) {
            AppLogger.warn((Throwable)err);
        }
        return success;
    }

    private static void prepareKnownFileAssociations() {
        fileAssociationsKnown.clear();
        for (int ctr = 0; ctr < FILE_ASSOCIATION_EXT.length; ++ctr) {
            fileAssociationsKnown.put(FILE_ASSOCIATION_NAMES[ctr], FILE_ASSOCIATION_EXT[ctr]);
        }
        Vector<ReadableHeader> loadedReadableFormats = Header.LOADED_READABLE_FORMATS;
        Enumeration<ReadableHeader> en = loadedReadableFormats.elements();
        while (en.hasMoreElements()) {
            ReadableHeader rh = en.nextElement();
            String name = PluginManagerDialog.getPluginName(rh);
            if (name == null) continue;
            String ext = rh.getPreferredFileExtension();
            if (ext.charAt(0) == '.') {
                ext = ext.substring(1);
            }
            fileAssociationsKnown.put(name, ext);
        }
        Vector<WritableHeader> loadedWritableFormats = Header.LOADED_WRITABLE_FORMATS;
        en = loadedWritableFormats.elements();
        while (en.hasMoreElements()) {
            String ext;
            WritableHeader wh = (WritableHeader)en.nextElement();
            String name = PluginManagerDialog.getPluginName(wh);
            if (name == null || (ext = wh.getPreferredFileExtension()) == null) continue;
            if (ext.charAt(0) == '.') {
                ext = ext.substring(1);
            }
            fileAssociationsKnown.put(name, ext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepIncludedAtlasFiles() {
        File atlasDir = Platform.getAtlasDir();
        if (!atlasDir.exists()) {
            FileUtilities.mkdirs((File)atlasDir);
        }
        for (String element : INCLUDED_ATLAS_FILES) {
            BufferedInputStream fileRead = null;
            FilterOutputStream fileWrite = null;
            try {
                File atlasFile = new File(atlasDir, element);
                if (!atlasFile.getParentFile().exists()) {
                    FileUtilities.mkdirs((File)atlasFile.getParentFile());
                }
                fileRead = new BufferedInputStream(Mango.class.getResourceAsStream(PLUGIN_LIBRARY + element));
                fileWrite = new BufferedOutputStream(new FileOutputStream(atlasFile));
                byte[] buffer = new byte[2048];
                int bytesRead = fileRead.read(buffer);
                while (bytesRead != -1) {
                    ((BufferedOutputStream)fileWrite).write(buffer, 0, bytesRead);
                    bytesRead = fileRead.read(buffer);
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
            finally {
                try {
                    if (fileRead != null) {
                        fileRead.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
                try {
                    if (fileWrite == null) continue;
                    fileWrite.close();
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
    }

    private static void prepPlugins() {
        File pluginDir = Platform.getPluginDir();
        if (!pluginDir.exists()) {
            FileUtilities.mkdirs((File)pluginDir);
        }
    }

    private static void removeDeprecatedIncludedPlugins() {
        for (String element : DEPRECATED_INCLUDED_PLUGINS) {
            File pluginFile = new File(Platform.getPluginDir(), element);
            if (!pluginFile.exists()) continue;
            if (element.equals("CineTool.jar")) {
                Mango.showWarningDialogStatic("This plugin (" + element + ") has been merged with the application.\nSee \"Create Video\" in the Image menu.", "Moved Menu Item");
            }
            if (pluginFile.delete()) continue;
            pluginFile.deleteOnExit();
        }
    }

    private static void setNearestNeighborState() {
        Transform.setGlobalNearestNeighborState(voxelDisplayMode);
    }

    private static void showInfoDialogStatic(final String message, final String title) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Frame frame = null;
                if (Mango.getInstance() != null) {
                    frame = Mango.getInstance().getDialogParentFrame();
                }
                MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, message + " ", title, 1, null, -1);
                jopf.show(true);
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    private static void showWarningDialogStatic(final String message, final String title) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Frame frame = null;
                if (Mango.getInstance() != null) {
                    frame = Mango.getInstance().getDialogParentFrame();
                }
                MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, message + " ", title, 2, null, -1);
                jopf.show(true);
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    public void addFilter(AbstractFilter filter) {
        boolean addedNew = this.filterManager.addFilter(filter);
        if (addedNew) {
            for (SliceViewer current : allViewers) {
                current.getViewerFrame().getViewerMenu().addFilterMenuItem(filter.getName());
            }
        }
    }

    public void addToCalculatorList(String op) {
        if (!calculatorHistory.contains(op)) {
            calculatorHistory.addFirst(op);
        } else {
            calculatorHistory.remove(op);
            calculatorHistory.addFirst(op);
        }
        if (calculatorHistory.size() > 10) {
            for (int ctr = 10; ctr < calculatorHistory.size(); ++ctr) {
                calculatorHistory.remove(ctr);
            }
        }
    }

    public void addToLoadSet(TreeSet<LoadItem> aLoadSet) {
        if (aLoadSet != null && aLoadSet.size() > 0) {
            loadSet.addAll(aLoadSet);
        }
        this.loadNextViewer();
    }

    public void addToRecentFilesList(URI file) {
        if (FileUtilities.uriIsFile((URI)file)) {
            this.lastAccessedDirectory = new File(file).getParent();
        }
        if (!recentFiles.contains(file)) {
            recentFiles.addFirst(file);
        } else {
            recentFiles.remove(file);
            recentFiles.addFirst(file);
        }
        if (recentFiles.size() > 10) {
            for (int ctr = 10; ctr < recentFiles.size(); ++ctr) {
                recentFiles.remove(ctr);
            }
        }
    }

    public SliceViewer addViewer(DICOM[] dicoms, File file, ViewerListener vl) {
        SliceViewer tempViewer = new SliceViewer(this, this.getNextViewerLocation(), this.getNextViewerSize());
        this.addViewerToList(tempViewer);
        tempViewer.addListener(vl);
        tempViewer.loadImage(file.toURI(), null, dicoms, null, null, null, null, null);
        return tempViewer;
    }

    public SliceViewer addViewer(File file) {
        return this.addViewer(file, false);
    }

    public SliceViewer addViewer(File file, boolean sameThread) {
        if (!file.getParentFile().equals(this.getTemporaryDirectory())) {
            this.addToRecentFilesList(file.toURI());
        }
        SliceViewer tempViewer = null;
        if (this.isApplet()) {
            tempViewer = allViewers.firstElement();
        } else {
            tempViewer = new SliceViewer(this, this.getNextViewerLocation(), this.getNextViewerSize());
            this.addViewerToList(tempViewer);
        }
        if (sameThread) {
            tempViewer.doLoadImage(file.toURI(), null, null, null, null, null, null, null, true);
        } else {
            tempViewer.loadImage(file.toURI(), null, null, null, null, null, null, null);
        }
        this.recordAction("makeNewVolumeManager", new String[]{ScriptUtils.convertString(file.toString())}, true);
        return tempViewer;
    }

    public SliceViewer addViewer(URI[] dicoms, ViewerListener listener) {
        SliceViewer tempViewer = new SliceViewer(this, this.getNextViewerLocation(), this.getNextViewerSize());
        this.addViewerToList(tempViewer);
        if (listener != null) {
            tempViewer.addListener(listener);
        }
        tempViewer.loadImage(dicoms[0], null, null, dicoms, null, null, null, null);
        return tempViewer;
    }

    public SliceViewer addViewer(Header header, File file) {
        SliceViewer tempViewer = new SliceViewer(this, this.getNextViewerLocation(), this.getNextViewerSize());
        this.addViewerToList(tempViewer);
        tempViewer.loadImage(file.toURI(), header, null, null, null, null, null, null);
        return tempViewer;
    }

    public SliceViewer addViewer(Header header, File file, Volume copyVol, ImageBounds copyBounds) {
        SliceViewer tempViewer = new SliceViewer(this, this.getNextViewerLocation(), this.getNextViewerSize());
        this.addViewerToList(tempViewer);
        tempViewer.loadImage(file.toURI(), header, null, null, null, null, copyVol, copyBounds);
        return tempViewer;
    }

    public VolumeManager makeNewVolumeManager(ImageDimensions id, VoxelDimensions vd, ImageType imageType, ByteBuffer[] bufs, boolean readOnly, String name) {
        ImageType it = imageType;
        if (it == null) {
            it = AddImageDialog.getImageType();
        }
        URI loadingURI = null;
        try {
            loadingURI = File.createTempFile(name, null, Platform.getTempDir()).toURI();
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        Header header = new Header(it, id, vd, null);
        header.setOrientation("XYZ+--");
        header.setOrientationCertainty(2);
        header.setImageFile(loadingURI);
        SliceViewer tempViewer = new SliceViewer(this, this.getNextViewerLocation(), this.getNextViewerSize());
        tempViewer.setAsTemp();
        this.addViewerToList(tempViewer);
        tempViewer.doLoadImage(loadingURI, header, null, null, bufs, null, null, null, true);
        tempViewer.getVolume().setReadOnly(readOnly);
        return tempViewer;
    }

    public SliceViewer addViewer(ImageDimensions id, VoxelDimensions vd, ImageRange ir, ByteBuffer[] bufs, String orientation, String name) {
        ImageType it = AddImageDialog.getImageType();
        File selectedFile = new File(this.getLoadFileDirectory(), name + ".img");
        int ctr = 2;
        while (selectedFile.exists()) {
            selectedFile = new File(this.getLoadFileDirectory(), name + "_" + ctr + ".img");
            ++ctr;
        }
        Header header = new Header(it, id, vd, ir);
        header.setOrientation(orientation);
        header.setOrientationCertainty(2);
        header.setImageFile(selectedFile);
        SliceViewer tempViewer = new SliceViewer(this, this.getNextViewerLocation(), this.getNextViewerSize());
        tempViewer.setAsTemp();
        this.addViewerToList(tempViewer);
        tempViewer.doLoadImage(selectedFile.toURI(), header, null, null, bufs, null, null, null, true);
        return tempViewer;
    }

    public SliceViewer addViewer(ImageDimensions id, VoxelDimensions vd, String orientation, String name) {
        return this.addViewer(id, vd, null, null, orientation, name);
    }

    public SliceViewer addViewer(ImageCalcExpression operation, boolean newThread) {
        SliceViewer tempViewer = new SliceViewer(this, this.getNextViewerLocation(), this.getNextViewerSize());
        tempViewer.setAsTemp();
        this.addViewerToList(tempViewer);
        ImageRange ir = new ImageRange(0.0, 0.0, 0.0, 0.0);
        ImageDimensions id = operation.getOriginatingManager().getBaseVolume().getImageDimensions();
        ir.setGlobalDataScaleIntercept(id.getSlices() * id.getTimepoints(), 0.0f);
        ir.setGlobalDataScaleSlope(id.getSlices() * id.getTimepoints(), 1.0f);
        Header header = ((Volume)operation.getOriginatingManager().getBaseVolume()).getHeaderCopyAndReplace(ImageType.getWorkBufferImageType(), ir);
        header.setImageFile(FileUtilities.findUniqueFilename((File)new File(operation.getOriginatingManager().getLoadedURI()), (String)"-new", (String)".img"));
        if (!operation.isAllSeriesPoints()) {
            header.getImageDimensions().setTimepoints(1);
        }
        if (newThread) {
            tempViewer.loadImage(header.getImageFile(), header, null, null, null, operation, null, null);
        } else {
            tempViewer.doLoadImage(header.getImageFile(), header, null, null, null, operation, null, null, true);
        }
        return tempViewer;
    }

    public SliceViewer addViewer(URI uri, boolean newThread) {
        this.addToRecentFilesList(uri);
        SliceViewer tempViewer = new SliceViewer(this, this.getNextViewerLocation(), this.getNextViewerSize());
        this.addViewerToList(tempViewer);
        if (newThread) {
            tempViewer.loadImage(uri, null, null, null, null, null, null, null);
        } else {
            tempViewer.doLoadImage(uri, null, null, null, null, null, null, null, true);
        }
        try {
            this.recordAction("makeNewVolumeManagerURL", new String[]{uri.toURL().toString()}, true);
        }
        catch (MalformedURLException ex) {
            AppLogger.error((Throwable)ex);
        }
        return tempViewer;
    }

    public VolumeManager makeNewVolumeManagerURL(String url) throws InvalidHeaderException, IOException {
        SliceViewer manager = null;
        try {
            manager = this.addViewer(new URL(url).toURI(), false);
        }
        catch (URISyntaxException ex) {
            AppLogger.error((Throwable)ex);
        }
        return manager;
    }

    public boolean addViewerToList(SliceViewer tempViewer) {
        this.viewerSyncer.addViewer(tempViewer);
        return allViewers.add(tempViewer);
    }

    public void arrangeViewersToStack() {
        Point nextPoint = this.getDefaultViewerLocation();
        Dimension dims = this.getDefaultViewerSize();
        for (SliceViewer mv : allViewers) {
            ViewerFrame frame = mv.getViewerFrame();
            frame.changeSize(dims.width);
            frame.setLocation(nextPoint.x, nextPoint.y);
            frame.toFront();
            nextPoint.x += 20;
            nextPoint.y += 20;
        }
    }

    public void checkForUpdate() {
        this.checkForUpdate(true);
    }

    public void clearActivePolylines() {
        for (SliceViewer current : allViewers) {
            if (!current.isUpdatingPolyline()) continue;
            current.clearPolyLine();
        }
    }

    public void clearIsExiting() {
        this.isExiting = false;
    }

    public boolean closeAllViewers() {
        boolean closedWithoutCancel = true;
        SliceViewer[] allViewersArray = allViewers.toArray(new SliceViewer[allViewers.size()]);
        if (allViewersArray != null && allViewersArray.length > 0) {
            for (int ctr = allViewersArray.length - 1; ctr >= 0 && closedWithoutCancel; --ctr) {
                closedWithoutCancel = allViewersArray[ctr].close();
            }
        }
        return closedWithoutCancel;
    }

    public void closeNextViewer() {
        if (Mango.getNumOrthogonalViewers() > 0) {
            boolean isCancelled;
            SliceViewer mv = allViewers.lastElement();
            boolean bl = isCancelled = !mv.close();
            if (isCancelled) {
                this.clearIsExiting();
            }
        } else {
            this.doExit();
        }
    }

    public synchronized void coordinateTypeSelectionChanged(boolean forceSurfaceUpdate) {
        this.resultsManager.updateTables();
        for (SliceViewer current : allViewers) {
            current.coordinateTypeSelectionChanged(forceSurfaceUpdate);
        }
    }

    public void decreaseROIToolSize() {
        --this.roiToolSize;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent ke) {
        Object source = ke.getSource();
        if (this.dispatchGlobalKeyEvent(ke)) {
            return true;
        }
        if (source instanceof JTextComponent && ((JTextComponent)source).isEnabled() || source instanceof JTable) {
            return false;
        }
        if (this.currentViewer != null) {
            SurfaceFrame frame;
            SurfaceViewer renderer;
            if (ke.getModifiers() != 0 && (ke.getKeyCode() == 61 || ke.getKeyCode() == 45)) {
                long current;
                boolean consume = false;
                if (ke.getKeyChar() == '+') {
                    consume = true;
                }
                if ((current = new Date().getTime()) - this.equalsBugTimestamp < 250L) {
                    consume = true;
                }
                if (consume) {
                    return true;
                }
                this.equalsBugTimestamp = current;
            }
            if ((renderer = this.currentViewer.getSurfaceRenderer()) != null && (frame = renderer.getFrame()) != null && frame.isActive()) {
                this.kfm.redispatchEvent(frame.getRootPane(), ke);
                return true;
            }
            ProjectionFrame projection = this.currentViewer.getProjection();
            if (projection != null && projection.isActive()) {
                this.kfm.redispatchEvent(projection.getRootPane(), ke);
                return true;
            }
            this.kfm.redispatchEvent(this.currentViewer, ke);
            return true;
        }
        return false;
    }

    public void doCapture(boolean doUserSelectedDir, Capturable cap) {
        String name = cap.getCaptureName();
        String captureLoc = this.getCaptureLocation(cap);
        File captureFile = null;
        if (doUserSelectedDir) {
            captureFile = ViewerMenuAction.makeSaveFileChooser(captureLoc, name + ".png");
            if (captureFile == null) {
                return;
            }
        } else {
            captureFile = new File(captureLoc, name + ".png");
            int ctr = 2;
            while (captureFile.exists()) {
                captureFile = new File(captureLoc, name + ctr + ".png");
                ++ctr;
            }
        }
        try {
            ImageIO.write((RenderedImage)cap.captureImage(), "png", captureFile);
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
    }

    public void doOpenImageDialog(boolean openImageBrowser) {
        if (openImageBrowser) {
            new ViewerMenuAction(this).openImageBrowser();
        } else {
            new ViewerMenuAction(this).openFile();
        }
    }

    public synchronized void exitProgram() {
        this.isExiting = true;
        this.closeNextViewer();
    }

    public double findGlobalMax() {
        double max = allViewers.firstElement().getVolume().getImageMax();
        for (SliceViewer current : allViewers) {
            if (!(current.getVolume().getImageMax() > max)) continue;
            max = current.getVolume().getImageMax();
        }
        return max;
    }

    public double findGlobalMin() {
        double min = allViewers.firstElement().getVolume().getImageMin();
        for (SliceViewer current : allViewers) {
            if (!(current.getVolume().getImageMin() < min)) continue;
            min = current.getVolume().getImageMin();
        }
        return min;
    }

    @Override
    public Method findRecordableMethod(String name, int numArgs) {
        try {
            Method[] methods;
            for (Method method : methods = MangoContext.class.getMethods()) {
                if (!method.getName().equals(name) || numArgs != method.getParameterTypes().length) continue;
                return method;
            }
        }
        catch (SecurityException ex) {
            AppLogger.error((Throwable)ex);
        }
        return null;
    }

    public Frame getActiveViewerWindow() {
        for (SliceViewer mv : allViewers) {
            JFrame frame = mv.getFrame();
            if (frame != null && frame.isActive() && (frame.getState() & 1) == 0) {
                return frame;
            }
            ViewerAssociated[] associatedWins = mv.getAllAssociatedWindows();
            if (associatedWins == null) continue;
            for (ViewerAssociated associatedWin : associatedWins) {
                JFrame win = associatedWin.getWindow();
                if (!win.isActive() || (win.getState() & 1) != 0) continue;
                return win;
            }
        }
        return null;
    }

    public String[] getAllFunctionKeyActions() {
        return F_ACTIONS;
    }

    public Rectangle[] getAllViewerAndToolboxArea() {
        Vector<Rectangle> rects = new Vector<Rectangle>();
        rects.add(this.toolBox.getBounds());
        Iterator<SliceViewer> it = allViewers.iterator();
        while (it.hasNext()) {
            rects.add(it.next().getViewerContainer().getBounds());
        }
        return rects.toArray(new Rectangle[rects.size()]);
    }

    public Vector<SliceViewer> getAllViewers() {
        return allViewers;
    }

    public List<VolumeManager> getAllVolumeManagersFrom(VolumeManager viewer) {
        int ctr;
        ArrayList<VolumeManager> list = new ArrayList<VolumeManager>();
        int index = allViewers.indexOf(viewer);
        int num = allViewers.size();
        if (index == -1) {
            index = 0;
        }
        for (ctr = index; ctr < num; ++ctr) {
            list.add(allViewers.get(ctr));
        }
        for (ctr = 0; ctr < index; ++ctr) {
            list.add(allViewers.get(ctr));
        }
        return list;
    }

    public List<VolumeManager> getAllVolumeManagers() {
        ArrayList<VolumeManager> list = new ArrayList<VolumeManager>();
        list.addAll(allViewers);
        return list;
    }

    public List<VolumeManager> getOtherVolumeManagers(VolumeManager manager) {
        ArrayList<VolumeManager> list = new ArrayList<VolumeManager>();
        list.addAll(allViewers);
        list.remove(manager);
        return list;
    }

    public VolumeManager getCurrentVolumeManager() {
        return this.getCurrentSliceViewer();
    }

    public void setCurrentVolumeManager(final VolumeManager manager) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ((SliceViewer)manager).getFrame().toFront();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public int getCurrentVolumeManagerIndex() {
        return allViewers.indexOf(this.getCurrentViewer());
    }

    public void setCurrentVolumeManagerIndex(final int index) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ((SliceViewer)allViewers.get(index)).getFrame().toFront();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBuildDate() {
        String buildNumStr = "";
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = Mango.class.getResourceAsStream(BUILD_PROPERTIES_PATH);
            props.load(is);
            String buildNum = (String)props.get(BUILD_DATE_KEY);
            SimpleDateFormat sdf = new SimpleDateFormat("dd MMMMM yyyy");
            long num = 0L;
            try {
                num = Long.parseLong(buildNum);
            }
            catch (NumberFormatException nfe) {
                AppLogger.warn((Throwable)nfe);
            }
            Date buildDate = new Date(num);
            buildNumStr = sdf.format(buildDate);
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    AppLogger.error((Throwable)ex);
                }
            }
        }
        return buildNumStr;
    }

    public String getBuildNumber() {
        return Mango.getBuildNumberString();
    }

    public LinkedList<String> getCalculatorHistory() {
        return calculatorHistory;
    }

    public String getCapturableLocation(File imageDir) {
        boolean desktopDirIsWritable;
        File desktop = Platform.getDesktopDir();
        boolean imageDirIsWritable = imageDir.exists() && FileUtilities.writeTest((File)imageDir);
        boolean bl = desktopDirIsWritable = desktop.exists() && FileUtilities.writeTest((File)desktop);
        if (this.captureToDesktop && desktopDirIsWritable) {
            return desktop.toString();
        }
        if (!this.captureToDesktop && imageDirIsWritable) {
            return imageDir.toString();
        }
        if (desktopDirIsWritable) {
            return desktop.toString();
        }
        if (imageDirIsWritable) {
            return imageDir.toString();
        }
        return "";
    }

    public VolumeManager[] getCompatibleOpenVolumeManagers(int max, VolumeManager volManager) {
        int ctr = 0;
        VolumeManager[] allVolManagers = new VolumeManager[max];
        allVolManagers[ctr++] = volManager;
        for (SliceViewer current : allViewers) {
            if (current == volManager) continue;
            allVolManagers[ctr++] = current;
        }
        return allVolManagers;
    }

    public Console getConsole() {
        return this.console;
    }

    public SliceViewer getCurrentSliceViewer() {
        return this.currentViewer;
    }

    public SliceViewer getCurrentViewer() {
        return this.currentViewer;
    }

    public JFrame getCurrentViewerFrame() {
        if (it.getToolBox().getCurrentViewer() != null) {
            return it.getToolBox().getCurrentViewer().getFrame();
        }
        return null;
    }

    public Point getDefaultViewerLocation() {
        return DisplayUtils.getNextWindowLocation(this.toolBox, this.getDefaultViewerSize(), null);
    }

    public Dimension getDefaultViewerSize() {
        int displayIndex = DisplayUtils.findCurrentDisplayIndex(this.toolBox);
        Rectangle currentScreen = DisplayUtils.findBoundsOfDisplay(displayIndex);
        Insets currentInsets = DisplayUtils.findInsetsOfDisplay(displayIndex);
        int verticalInsets = currentInsets.top + currentInsets.bottom;
        int viewerHeight = (int)Math.round((double)(currentScreen.height - verticalInsets) * 0.75);
        int viewerWidth = (int)Math.round((double)viewerHeight / 1.5);
        if (this.viewMode == 1) {
            return new Dimension(viewerHeight, viewerWidth);
        }
        if (this.viewMode == 2) {
            return new Dimension(viewerWidth, viewerWidth);
        }
        return new Dimension(viewerWidth, viewerHeight);
    }

    public Frame getDialogParentFrame() {
        Frame frame = this.getActiveViewerWindow();
        if (frame == null) {
            frame = this.toolBox;
        }
        return frame;
    }

    public ROIClipboard getEditClipboard() {
        return CLIPBOARD;
    }

    public FilterManager getFilterManager() {
        return this.filterManager;
    }

    public synchronized ImageBrowser getImageBrowser() {
        return this.imageBrowser;
    }

    public int getImageIndexOrigin() {
        return this.imageIndexOrigin;
    }

    public synchronized long getLastCheckForUpdate() {
        return this.lastCheckForUpdate;
    }

    public String getLoadFileDirectory() {
        if (this.lastAccessedDirectory == null) {
            if (Platform.MAC || Platform.WINDOWS) {
                this.lastAccessedDirectory = Platform.getDesktopDir().toString();
            } else if (Platform.UNIX) {
                File lastAccessedDir = new File(System.getProperty("user.dir", ""));
                this.lastAccessedDirectory = lastAccessedDir.exists() ? lastAccessedDir.toString() : new File(Platform.getHomeDirectory()).toString();
            }
        }
        return this.lastAccessedDirectory;
    }

    public Point getLocationOnScreen() {
        return this.toolBox.getLocationOnScreen();
    }

    public double getMagicWandRange() {
        return this.magicWandRange;
    }

    public int getMainSliceDirection() {
        return this.mainSliceDirection;
    }

    public Map<String, Boolean> getMovedMenuMap() {
        return this.movedMenuMap;
    }

    public int getNextRecentTool() {
        int toolIndex = 0;
        for (int ctr = 0; ctr < 4 && MOST_RECENT_TOOLS[toolIndex = (this.mostRecentToolsGetIndex + ctr) % 4] == -1; ++ctr) {
        }
        int tool = MOST_RECENT_TOOLS[toolIndex];
        if (tool == -1) {
            tool = 0;
        }
        this.mostRecentToolsGetIndex = toolIndex;
        ++this.mostRecentToolsGetIndex;
        this.mostRecentToolsGetIndex %= 4;
        return tool;
    }

    public Point getNextViewerLocation() {
        boolean currentIsLeft;
        int displayIndex = DisplayUtils.findCurrentDisplayIndex(this.toolBox);
        Rectangle currentScreen = DisplayUtils.findBoundsOfDisplay(displayIndex);
        Point currentLoc = this.toolBox.getLocation();
        Dimension currentSize = this.toolBox.getSize();
        int currentCenterX = currentLoc.x + currentSize.width / 2;
        boolean bl = currentIsLeft = currentCenterX < currentScreen.x + currentScreen.width / 2;
        if (Mango.getNumOrthogonalViewers() == 0) {
            return DisplayUtils.getNextWindowLocation(this.toolBox, this.getDefaultViewerSize(), null, false, false, true);
        }
        SliceViewer lastViewer = allViewers.lastElement();
        ViewerFrame lastViewerFrame = lastViewer.getViewerFrame();
        JFrame comp = lastViewerFrame;
        if (comp == null) {
            comp = this.toolBox;
        }
        return DisplayUtils.getNextWindowLocation(comp, this.getNextViewerSize(), new Rectangle[]{this.toolBox.getBounds()}, currentIsLeft, !currentIsLeft, false);
    }

    public Dimension getNextViewerSize() {
        Dimension dim = null;
        dim = this.currentViewer == null ? this.getDefaultViewerSize() : this.currentViewer.getViewerSize();
        return dim;
    }

    public int getNumViewers() {
        return allViewers.size();
    }

    public int getNumViewersChanged() {
        int num = 0;
        for (SliceViewer current : allViewers) {
            if (!current.canBeSaved()) continue;
            ++num;
        }
        return num;
    }

    public String getOverlayColorTable1() {
        if (StringUtils.isBlank((CharSequence)this.overlayColorTable1)) {
            return "Red Overlay";
        }
        return this.overlayColorTable1;
    }

    public String getOverlayColorTable2() {
        if (StringUtils.isBlank((CharSequence)this.overlayColorTable2)) {
            return "Green Overlay";
        }
        return this.overlayColorTable2;
    }

    public String getOverlayColorTable3() {
        if (StringUtils.isBlank((CharSequence)this.overlayColorTable3)) {
            return "Blue Overlay";
        }
        return this.overlayColorTable3;
    }

    public Color getPanelInsideColor() {
        return MangoStyle.COLOR_PANEL_INSIDE;
    }

    public Color getPanelOutsideColor() {
        return MangoStyle.COLOR_PANEL_OUTSIDE;
    }

    public int getPort() {
        return this.portNumber;
    }

    public synchronized int getQuickKeyFirst() {
        return this.quickKeyFirst;
    }

    public synchronized int getQuickKeySecond() {
        return this.quickKeySecond;
    }

    public LinkedList<URI> getRecentFiles() {
        return recentFiles;
    }

    public synchronized ResultsTool getResultsManager() {
        return this.resultsManager;
    }

    public int getROIToolSize() {
        return this.roiToolSize;
    }

    public double getRoiToolSizeMultiplier() {
        return this.roiToolSizeMultiplier;
    }

    @Override
    public String getScriptObjectName() {
        return "m_Mango_mango";
    }

    public SliceViewer getSliceViewer() {
        return this.getCurrentSliceViewer();
    }

    public double getSmartToolsRangeMax() {
        return this.smartToolsRangeMax;
    }

    public double getSmartToolsRangeMin() {
        return this.smartToolsRangeMin;
    }

    public File getTemporaryDirectory() {
        return Platform.getTempDir();
    }

    public Toolbox getToolBox() {
        return this.toolBox;
    }

    public int getToolSliceRangeAbove() {
        return this.toolSliceAbove;
    }

    public int getToolSliceRangeBelow() {
        return this.toolSliceBelow;
    }

    public String getVersion() {
        return Mango.getVersionString();
    }

    public String getVersionDescriptor() {
        return "";
    }

    public SliceViewerSyncer getViewerSyncer() {
        return this.viewerSyncer;
    }

    public SurfaceViewerSyncer getSurfaceSyncer() {
        return this.surfaceSyncer;
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public synchronized boolean isViewStateAllPlanes() {
        return this.viewStateAllPlanes;
    }

    public synchronized boolean isViewStateCrosshairs() {
        return this.viewStateCrosshairs;
    }

    public synchronized boolean isViewStateMainPlane() {
        return this.viewStateMainPlane;
    }

    public synchronized boolean isViewStateOrientationSurface() {
        return this.viewStateOrientation;
    }

    public void increaseROIToolSize() {
        ++this.roiToolSize;
    }

    public void initialize(boolean applet) {
        long now;
        boolean preferencesFound;
        int ctr;
        this.applet = applet;
        if (!applet) {
            this.kfm = new DefaultKeyboardFocusManager(){

                @Override
                public void focusNextComponent(Component com) {
                    if (Mango.this.toolBox.isTextFieldMinTouched()) {
                        Mango.this.toolBox.updateTextFieldValues();
                        Mango.this.toolBox.textFieldMaxTouched();
                    } else if (Mango.this.toolBox.isTextFieldMaxTouched()) {
                        Mango.this.toolBox.updateTextFieldValues();
                        Mango.this.toolBox.textFieldMinTouched();
                    } else if (com instanceof ViewerFrame) {
                        ViewerFrame frame = (ViewerFrame)com;
                        if (!frame.isActive()) {
                            frame.toFront();
                        } else {
                            SliceViewer viewer = frame.getOrthogonalViewer();
                            SliceViewer nextViewer = Mango.this.getNextViewer(viewer);
                            nextViewer.getViewerFrame().toFront();
                        }
                    } else if (com instanceof SliceViewer) {
                        SliceViewer viewer = (SliceViewer)com;
                        ViewerFrame frame = viewer.getViewerFrame();
                        if (!frame.isActive()) {
                            frame.toFront();
                        } else {
                            SliceViewer nextViewer = Mango.this.getNextViewer(viewer);
                            nextViewer.getViewerFrame().toFront();
                        }
                    } else {
                        super.focusNextComponent(com);
                    }
                }
            };
            KeyboardFocusManager.setCurrentKeyboardFocusManager(this.kfm);
            this.kfm.addKeyEventDispatcher(this);
        }
        if (!applet) {
            this.console = Console.createConsole();
            AppLogger.setConsole((ConsoleLogger)this.console);
        }
        Mango.setVoxelDisplayMode(false);
        this.setViewMainCrosshairs(true);
        this.setViewLowerCrosshairs(true);
        this.setViewROIStats(false);
        this.setViewLabels(true);
        this.setViewROIEdge(true);
        this.setViewROIMask(false);
        this.setScrollwheelSlices(false);
        this.setViewOverlayCurrent(false);
        this.viewMode = 0;
        this.setViewOrientation(false);
        this.setMainSliceDirection(0);
        this.autoCheck = true;
        this.listenForFiles = true;
        this.portNumber = 63086;
        this.viewStateCrosshairs = true;
        this.viewStateAllPlanes = true;
        this.viewStateOrientation = false;
        this.viewStateMainPlane = false;
        this.toolBoxLocation = DisplayUtils.getDefaultLocation();
        if (!applet) {
            this.filterManager.loadUserFilters();
        }
        this.toolBox = new Toolbox(this, applet);
        if (!applet) {
            Mango.addAllPlugins();
        }
        if (!applet) {
            this.imageBrowser = new ImageBrowser(this);
        }
        for (ctr = 0; ctr < F_ACTIONS.length; ++ctr) {
            Mango.F_ACTIONS[ctr] = NOT_ASSIGNED_STRING;
        }
        if (!applet && !(preferencesFound = MangoPreferences.readPreferences())) {
            int result = JOptionPane.showOptionDialog(null, LicenseDialog.getDialog(), "License Agreement", 0, -1, null, new String[]{"Accept", "Exit"}, null);
            if (result != 0) {
                JVMUtilities.forceExit();
            }
            this.showGettingStarted = true;
        }
        this.resultsManager = new ResultsTool(this);
        if (!applet) {
            this.toolBox.createUI();
            this.toolBox.setLocation(this.toolBoxLocation);
            this.toolBox.setVisible(true);
            this.updateAllFunctionHotKeys();
        }
        this.viewerSyncer = new SliceViewerSyncer();
        this.surfaceSyncer = new SurfaceViewerSyncer();
        if (!applet && Platform.MAC) {
            new AppleMenus(this);
        }
        this.roiToolSize = 3;
        this.setRoiToolSizeMultiplier(1.0);
        Mango.MOST_RECENT_TOOLS[0] = 0;
        for (ctr = 1; ctr < 4; ++ctr) {
            Mango.MOST_RECENT_TOOLS[ctr] = -1;
        }
        this.mostRecentToolsGetIndex = 0;
        this.mostRecentToolsSetIndex = 1;
        if (!applet) {
            Mango.loadAtlasesFromFSLFolder();
            Mango.loadIncludedAtlases();
            Mango.loadAtlases();
            Mango.prepareKnownFileAssociations();
        }
        if (!applet && this.listenForFiles) {
            this.server = new MangoServer(this);
            this.server.start();
        }
        if (!applet && this.autoCheck && (now = new Date().getTime()) - this.lastCheckForUpdate > 604800000L) {
            this.checkForUpdate(false);
        }
        if (!applet) {
            this.toolBox.addLoader(new TalairachLoader());
        }
        if (this.console != null) {
            this.console.printPlatformInfo();
        }
        if (this.showGettingStarted) {
            Timer timer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            GettingStarted.showInFrame(Mango.getInstance());
                        }
                    });
                }
            };
            timer.schedule(task, 1000L);
        }
    }

    public boolean isApplet() {
        return this.applet;
    }

    public boolean isAutoCheck() {
        return this.autoCheck;
    }

    public boolean isCaptureToDesktop() {
        return this.captureToDesktop;
    }

    public boolean isCurrentActiveViewer(SliceViewer viewer) {
        if (this.applet) {
            return true;
        }
        boolean isCurrent = this.isCurrentViewer(viewer);
        return isCurrent && viewer.getViewerFrame().isActive();
    }

    public boolean isCurrentViewer(SliceViewer aViewer) {
        return this.currentViewer == aViewer;
    }

    public boolean isExiting() {
        return this.isExiting;
    }

    public boolean isListenForFiles() {
        return this.listenForFiles;
    }

    public boolean isMac() {
        return Platform.MAC;
    }

    public boolean isNewVersion() {
        return this.isNewVersion;
    }

    public boolean isPlayingScript() {
        return this.scriptTool != null && this.scriptTool.isPlaying();
    }

    public boolean isPlugin2() {
        return false;
    }

    public boolean isRadiologicalMode() {
        return this.isRadiologicalMode;
    }

    public boolean isRecordingScript() {
        return this.scriptTool != null && this.scriptTool.isRecording();
    }

    public boolean isRotateCenter() {
        return this.rotateCenter;
    }

    public boolean isScrollwheelDirectionFlip() {
        return this.scrollwheelDirectionFlip;
    }

    public boolean isScrollwheelSlices() {
        return this.scrollwheelSlices;
    }

    public boolean isShowingConsole() {
        return this.console != null && this.console.isVisible();
    }

    public boolean isToolboxCoordinateCurrentSlice() {
        return this.toolboxCoordinateCurrentSlice;
    }

    public boolean isUnix() {
        return Platform.UNIX;
    }

    public boolean isUsingSmartTools() {
        return this.useSmartROITools;
    }

    public boolean isUsingSmartToolsToggle() {
        return this.useSmartToolsToggle;
    }

    public boolean isViewLabels() {
        return this.viewLabels;
    }

    public boolean isViewDicomOverlay() {
        return this.viewDicomOverlay;
    }

    public boolean isViewLowerCrosshairs() {
        return this.viewLowerCrosshairs;
    }

    public boolean isViewMainCrosshairs() {
        return this.viewMainCrosshairs;
    }

    public boolean isViewOrientation() {
        return this.viewOrientation;
    }

    public boolean isViewOverlayCurrent() {
        return this.viewOverlayCurrent;
    }

    public boolean isViewROIEdge() {
        return this.viewROIEdge;
    }

    public boolean isViewROIMask() {
        return this.viewROIMask;
    }

    public boolean isViewROIStats() {
        return this.viewROIStats;
    }

    public boolean isWindows() {
        return Platform.WINDOWS;
    }

    public synchronized void loadNextViewer() {
        this.isLoading = false;
        this.loadNext();
    }

    public VolumeManager makeNewVolumeManager(String openLocation) throws InvalidHeaderException, IOException {
        return this.addViewer(new File(openLocation), true);
    }

    public VolumeManager makeNewVolumeManager(ImageVolume volume) {
        SliceViewer tempViewer = new SliceViewer(this, this.getNextViewerLocation(), this.getNextViewerSize());
        tempViewer.setAsTemp();
        this.addViewerToList(tempViewer);
        tempViewer.setVolume((Volume)volume);
        return tempViewer;
    }

    public ProgressMeter makeProgressMeter() {
        return new ProgressBar(this.toolBox, "");
    }

    public File makeSaveFileChooser(String dir, String filename) {
        return ViewerMenuAction.makeSaveFileChooser(dir, filename);
    }

    public void notifyBaseImageOverlayListeners() {
        for (SliceViewer current : allViewers) {
            current.getScreenVolume().notifyListenersOfChange(false);
        }
    }

    public void notifyOverlayImageOverlayListeners() {
        for (SliceViewer current : allViewers) {
            current.notifyOverlayListenersOfChange();
        }
    }

    public void openCustomURL(URI uri) {
        String uriStr = "[" + uri.toString() + "]";
        if (AppLogger.isDebugEnabled()) {
            AppLogger.debug((String)uriStr);
        }
        TreeSet<Object> treeSet = new TreeSet<Object>(new StringComparator());
        MangoServer.makeLoadSet(treeSet, uriStr);
        if (treeSet.size() > 0) {
            this.addToLoadSet(treeSet);
        }
    }

    public void openURL(String url) {
        DesktopUtilities.openURL((String)url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readSetting(String name) {
        File settingsDir = Platform.getSettingsDir();
        if (!settingsDir.exists()) {
            FileUtilities.mkdirs((File)settingsDir);
        }
        File saveFile = new File(settingsDir, name);
        Object obj = null;
        if (saveFile.exists()) {
            ObjectInputStream input = null;
            try {
                input = new ObjectInputStream(new FileInputStream(saveFile));
                obj = input.readObject();
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                AppLogger.warn((Throwable)ex);
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        return obj;
    }

    @Override
    public void recordAction(String name) {
        this.recordAction(name, null);
    }

    @Override
    public void recordAction(String name, String[] argValues) {
        this.recordAction(name, argValues, false, this);
    }

    @Override
    public void recordAction(String name, String[] argValues, boolean forceNeedsUserInput) {
        this.recordAction(name, argValues, forceNeedsUserInput, this);
    }

    @Override
    public void recordAction(String name, String[] argValues, boolean forceNeedsUserInput, Recordable recordable) {
        if (this.isRecordingScript()) {
            this.scriptTool.recordAction(name, recordable, argValues, forceNeedsUserInput);
        }
    }

    public synchronized void removeViewer(SliceViewer viewer) {
        viewer.setAsDead();
        if (!this.applet) {
            this.viewerSyncer.removeViewer(viewer);
            this.surfaceSyncer.removeViewer(viewer.getSurfaceRender());
            allViewers.remove(viewer);
            if (!Mango.hasOrthogonalViewer()) {
                this.toolBox.clearCurrentState();
                this.currentViewer = null;
                this.resultsManager.setVisible(false);
                if (this.imageBrowser.isVisible()) {
                    this.imageBrowser.toFront();
                }
                LookupTableManager.clearLastAlpha();
            }
            this.toolBox.updateEnabledItems();
            this.toolBox.updateFocusState();
        }
        JVMUtilities.clearGarbage();
    }

    public void repaintAllViewers() {
        for (SliceViewer current : allViewers) {
            current.repaint();
        }
    }

    public void resetBaseImageLUT() {
        for (SliceViewer current : allViewers) {
            current.getBaseScreenVolume().setNegativeState(false);
            current.getBaseScreenVolume().getLookupTableManager().updateLUT(255, 0, true);
        }
    }

    public void runScript(String scriptName) {
        ScriptManager.runScriptSilently(scriptName, this, null);
    }

    public void setAutoCheck(boolean bool) {
        this.autoCheck = bool;
    }

    public void setCaptureToDesktop(boolean bool) {
        this.captureToDesktop = bool;
    }

    public void setCurrentViewer(SliceViewer viewer) {
        if (this.currentViewer != viewer) {
            this.recordAction("setCurrentVolumeManager", new String[]{viewer.getScriptObjectName()});
        }
        this.currentViewer = viewer;
    }

    public void setFunctionKeyActions(String[] actions) {
        for (int ctr = 0; ctr < F_ACTIONS.length; ++ctr) {
            Mango.F_ACTIONS[ctr] = actions[ctr];
        }
    }

    public void setImageIndexOrigin(int imageIndexOrigin) {
        this.imageIndexOrigin = imageIndexOrigin;
    }

    public synchronized void setLastAccessedDirectory(String dir) {
        this.lastAccessedDirectory = dir;
    }

    public synchronized void setLastCheckForUpdate(long val) {
        this.lastCheckForUpdate = val;
    }

    public synchronized void setListenForFiles(boolean bool) {
        this.listenForFiles = bool;
    }

    public void setMagicWandRange(double val) {
        this.magicWandRange = val;
    }

    public void setMainSliceDirection(int mainSliceDirection) {
        this.mainSliceDirection = mainSliceDirection;
    }

    public void setMovedMenuMapItem(String name, boolean value) {
        this.movedMenuMap.put(name, value);
    }

    public void setNewVersion(boolean isNewVersion) {
        this.isNewVersion = isNewVersion;
    }

    public void setOverlayColorTable1(String overlayColorTable1) {
        this.overlayColorTable1 = overlayColorTable1;
    }

    public void setOverlayColorTable2(String overlayColorTable2) {
        this.overlayColorTable2 = overlayColorTable2;
    }

    public void setOverlayColorTable3(String overlayColorTable3) {
        this.overlayColorTable3 = overlayColorTable3;
    }

    public synchronized void setQuickKeyFirst(int val) {
        this.quickKeyFirst = val;
    }

    public synchronized void setQuickKeySecond(int val) {
        this.quickKeySecond = val;
    }

    public void setRadiologicalMode(boolean bool) {
        this.isRadiologicalMode = bool;
    }

    public void setRecentTool(int aTool) {
        boolean found = false;
        for (int ctr = 0; ctr < 4; ++ctr) {
            if (MOST_RECENT_TOOLS[ctr] != aTool) continue;
            found = true;
        }
        if (!found) {
            Mango.MOST_RECENT_TOOLS[this.mostRecentToolsSetIndex] = aTool;
            ++this.mostRecentToolsSetIndex;
            this.mostRecentToolsSetIndex %= 4;
            this.mostRecentToolsGetIndex = this.mostRecentToolsSetIndex + 1;
            this.mostRecentToolsGetIndex %= 4;
        }
    }

    public void setRoiToolSizeMultiplier(double roiToolSizeMultiplier) {
        this.roiToolSizeMultiplier = roiToolSizeMultiplier;
    }

    public void setRotateCenterState(boolean bool) {
        this.rotateCenter = bool;
    }

    public void setScrollwheelDirectionFlip(boolean scrollwheelDirectionFlip) {
        this.scrollwheelDirectionFlip = scrollwheelDirectionFlip;
        for (SliceViewer current : allViewers) {
            current.setScrollwheelDirectionFlip(scrollwheelDirectionFlip);
        }
    }

    public void setScrollwheelSlices(boolean scrollwheelSlices) {
        this.scrollwheelSlices = scrollwheelSlices;
        for (SliceViewer current : allViewers) {
            current.setScrollwheelslices(scrollwheelSlices);
        }
    }

    public synchronized void setServer(boolean bool, int value) {
        this.portNumber = value;
        this.listenForFiles = bool;
        if (this.server != null) {
            this.server.stopServer();
            this.server = null;
        }
        if (this.listenForFiles) {
            this.server = new MangoServer(this);
            this.server.start();
        }
    }

    public void setShowConsole(boolean bool) {
        if (bool) {
            this.console.setLocation(DisplayUtils.getCenterDialogLocation(this.toolBox, this.console.getSize()));
            this.console.setVisible(true);
        } else if (this.console != null) {
            this.console.setVisible(false);
        }
    }

    public void setSmartToolsRangeMax(double val) {
        this.smartToolsRangeMax = val;
    }

    public void setSmartToolsRangeMin(double val) {
        this.smartToolsRangeMin = val;
    }

    public void setSyncState(int type) {
        this.viewerSyncer.setType(type);
        if (type != 0 && this.currentViewer != null) {
            this.currentViewer.updateSync();
            this.currentViewer.updateSyncSeries();
        }
    }

    public void setSyncZoomState(boolean sync) {
        this.viewerSyncer.setZoom(sync);
        if (this.currentViewer != null) {
            this.currentViewer.updateSyncZoom();
        }
    }

    public void setSurfaceSyncState(boolean synced) {
        this.surfaceSyncer.setSynced(synced);
        if (synced && this.currentViewer != null && this.currentViewer.getSurfaceRender() != null) {
            this.surfaceSyncer.sync(this.currentViewer.getSurfaceRender());
        }
    }

    public void setToolboxCoordinateCurrentSlice(boolean toolboxCoordinateCurrentSlice) {
        this.toolboxCoordinateCurrentSlice = toolboxCoordinateCurrentSlice;
    }

    public void setToolSliceRange(int aboveNum, int belowNum) {
        this.toolSliceAbove = aboveNum;
        this.toolSliceBelow = belowNum;
    }

    public void setUseSmartROITools(boolean bool) {
        this.useSmartROITools = bool;
    }

    public void setUsingSmartToolsToggle(boolean bool) {
        this.useSmartToolsToggle = bool;
    }

    public void setViewLabels(boolean viewLabels) {
        this.viewLabels = viewLabels;
    }

    public void setViewDicomOverlay(boolean viewDicomOverlay) {
        this.viewDicomOverlay = viewDicomOverlay;
    }

    public void setViewLowerCrosshairs(boolean viewLowerCrosshairs) {
        this.viewLowerCrosshairs = viewLowerCrosshairs;
    }

    public void setViewMainCrosshairs(boolean viewMainCrosshairs) {
        this.viewMainCrosshairs = viewMainCrosshairs;
    }

    public void setViewMode(int val) {
        this.viewMode = val;
    }

    public void setViewOrientation(boolean viewOrientation) {
        this.viewOrientation = viewOrientation;
    }

    public void setViewOverlayCurrent(boolean viewOverlayCurrent) {
        this.viewOverlayCurrent = viewOverlayCurrent;
    }

    public void setViewROIEdge(boolean viewROIEdge) {
        this.viewROIEdge = viewROIEdge;
    }

    public void setViewROIMask(boolean viewROIMask) {
        this.viewROIMask = viewROIMask;
    }

    public void setViewROIStats(boolean viewROIStats) {
        this.viewROIStats = viewROIStats;
    }

    public synchronized void setViewStateAllPlanes(boolean bool) {
        this.viewStateAllPlanes = bool;
    }

    public synchronized void setViewStateCrosshairs(boolean bool) {
        this.viewStateCrosshairs = bool;
    }

    public synchronized void setViewStateMainPlane(boolean bool) {
        this.viewStateMainPlane = bool;
    }

    public synchronized void setViewStateOrientationSurface(boolean bool) {
        this.viewStateOrientation = bool;
    }

    public void showAbout() {
        AboutDialog aboutBox = new AboutDialog(this);
        aboutBox.setLocation(DisplayUtils.getCenterDialogLocation(this.toolBox, aboutBox.getSize()));
        this.toolBox.associateWindow(aboutBox);
        aboutBox.setVisible(true);
    }

    public void showErrorDialog(String message, String title) {
        Mango.showErrorDialogStatic(message, title);
    }

    public void showInfoDialog(String message, String title) {
        Mango.showInfoDialogStatic(message, title);
    }

    public void showOutOfMemoryMessage() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                String title = "Out of Memory Error";
                String message = null;
                message = Platform.isSystem64Bit() ? "Try installing a 64-bit version of Mango." : "Out of memory.";
                Frame frame = Mango.getInstance().getDialogParentFrame();
                MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, message, "Out of Memory Error", 2, null, -1);
                jopf.show(true);
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    public void showScriptTool(boolean startRecording, boolean withDialogs) {
        this.showScriptTool(startRecording, withDialogs, null);
    }

    public void showScriptTool(boolean startRecording, boolean withDialogs, SliceViewer viewer) {
        if (this.scriptTool == null) {
            this.scriptTool = new ScriptManager(this, viewer);
        }
        this.scriptTool.showTool(startRecording, withDialogs, viewer);
    }

    public void showWarningDialog(String message, String title) {
        Mango.showWarningDialogStatic(message, title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSetting(String name, Object obj) {
        File settingsDir = Platform.getSettingsDir();
        if (!settingsDir.exists()) {
            FileUtilities.mkdirs((File)settingsDir);
        }
        File saveFile = new File(settingsDir, name);
        ObjectOutputStream output = null;
        try {
            output = new ObjectOutputStream(new FileOutputStream(saveFile));
            output.writeObject(obj);
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    public void updateAllFunctionHotKeys() {
        for (SliceViewer viewer : allViewers) {
            viewer.updateAllAccelerators(F_ACTIONS);
        }
        this.toolBox.updateAllAccelerators(F_ACTIONS);
    }

    public synchronized void updateImageBrowser(File fileThatChanged) {
        if (this.imageBrowser != null) {
            this.imageBrowser.updateImageFolder(fileThatChanged, false);
        }
    }

    public void updateLUT(int maxLUTnew, int minLUTnew) {
        for (SliceViewer current : allViewers) {
            current.getScreenVolume().getLookupTableManager().updateLUT(maxLUTnew, minLUTnew);
        }
    }

    public void updateMenus() {
        for (SliceViewer current : allViewers) {
            current.updateFrameMenu();
        }
    }

    public void updateRadiologicalMode() {
        for (SliceViewer current : allViewers) {
            current.updateRadiologicalMode();
            current.setZoomFactor(1.0, true);
        }
    }

    public void updateScreenRatios() {
        for (SliceViewer current : allViewers) {
            current.updateScreenRatio();
        }
    }

    public void updateScreenSlices() {
        for (SliceViewer current : allViewers) {
            current.updateScreenSlices();
        }
    }

    public void updateScripts() {
        for (SliceViewer current : allViewers) {
            current.getViewerFrame().getViewerMenu().updateScriptsMenu();
        }
    }

    public void updateSurfaces() {
        Mango.updateSurfaces(false);
    }

    public void updateToolboxCoordinateCurrentSlice() {
        Mango.getInstance().toolBox.updateCoordinateType(this.toolboxCoordinateCurrentSlice);
        Mango.getInstance().toolBox.updateMouseLabelInfo();
        if (this.toolboxCoordinateCurrentSlice) {
            Mango.getInstance().toolBox.updateCoordinateDisplay();
        } else {
            Mango.getInstance().toolBox.updateMouseLabelOutOfBounds();
        }
    }

    public void updateViewers() {
        Mango.updateAllViewers();
    }

    protected void setPort(int val) {
        this.portNumber = val;
    }

    protected void setToolBoxLocation(Point locVal) {
        Point loc = locVal;
        if (!DisplayUtils.isValidLocation(loc)) {
            loc = DisplayUtils.getDefaultLocation();
        }
        this.toolBoxLocation = loc;
    }

    private void checkForUpdate(final boolean confirmIfCurrent) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Mango.this.lastCheckForUpdate = new Date().getTime();
                    if (!URLUtilities.urlExists((String)"http://rii.uthscsa.edu/mango/", (int)8000)) {
                        return;
                    }
                    String downloadFile = "http://rii.uthscsa.edu/mango//downloads/currentversion41";
                    final boolean isCurrentMango = URLUtilities.urlExists((String)"http://rii.uthscsa.edu/mango//downloads/currentversion41", (int)8000);
                    final boolean isPluginsCurrent = !PluginManagerDialog.hasNewVersionsAvailable();
                    Runnable runner = new Runnable(){

                        @Override
                        public void run() {
                            if (isCurrentMango && isPluginsCurrent) {
                                if (confirmIfCurrent) {
                                    Frame frame = Mango.getInstance().getDialogParentFrame();
                                    MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, "Everything is current!", "Check for Updates", -1, null, -1);
                                    jopf.show(true);
                                    if (Mango.getInstance().toolBox.getCurrentViewer() != null) {
                                        Mango.getInstance().toolBox.getCurrentViewer().toFront();
                                    }
                                    Mango.getInstance().toolBox.toFront();
                                    Mango.getInstance().toolBox.updateFocusState();
                                }
                            } else {
                                CheckUpdateDialog dialog = new CheckUpdateDialog(!confirmIfCurrent, !isCurrentMango, !isPluginsCurrent);
                                Frame frame = Mango.getInstance().getDialogParentFrame();
                                MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, dialog, "Check for Updates", -1, null);
                                final JOptionPane jop = jopf.getJOptionPane();
                                JButton buttonYes = new JButton("Yes");
                                buttonYes.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent ae) {
                                        jop.setValue(0);
                                        jop.setVisible(false);
                                    }
                                });
                                JButton buttonNo = new JButton("No");
                                buttonNo.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent ae) {
                                        jop.setValue(1);
                                        jop.setVisible(false);
                                    }
                                });
                                Object[] options = new Object[]{buttonYes, buttonNo};
                                jopf.setOptions(options);
                                jopf.setInitialValue(buttonYes);
                                int result = jopf.show(true);
                                if (result == 0) {
                                    if (!confirmIfCurrent) {
                                        Mango.this.autoCheck = !dialog.isDontAskAgain();
                                    }
                                    if (!isCurrentMango) {
                                        DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//mango.html");
                                    } else {
                                        new ViewerMenuAction(Mango.getInstance()).openPluginManager();
                                    }
                                } else if (result == 1 && !confirmIfCurrent) {
                                    Mango.this.autoCheck = !dialog.isDontAskAgain();
                                }
                            }
                        }
                    };
                    SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                    Runnable runner = new Runnable(){

                        @Override
                        public void run() {
                            if (confirmIfCurrent) {
                                Mango.this.showWarningDialog("Could not make connection.  Try again later.", "Check for Updates");
                            }
                        }
                    };
                    SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
                }
            }
        }, "Mango.checkForUpdate() Thread");
        workThread.start();
    }

    private synchronized void cleanUp() {
        this.cleanUp(false);
    }

    private synchronized void cleanUp(boolean force) {
        if (this.server != null) {
            this.server.stopServer();
            this.server = null;
        }
        if (this.console != null) {
            this.console.setVisible(false);
            this.console.dispose();
            this.console = null;
        }
        if (this.imageBrowser != null) {
            this.imageBrowser.setVisible(false);
            this.imageBrowser.dispose();
            this.imageBrowser = null;
        }
        if (this.toolBox != null) {
            this.toolBox.setVisible(false);
            this.toolBox.disposeAssociatedWindows();
            this.toolBox.dispose();
            if (force) {
                this.toolBox.forceDispose();
            }
            this.toolBox = null;
        }
        if (this.resultsManager != null) {
            this.resultsManager.setVisible(false);
            this.resultsManager.dispose();
            this.resultsManager = null;
        }
        allViewers = null;
        this.viewerSyncer = null;
        this.surfaceSyncer = null;
        JVMUtilities.clearGarbage();
        Mango.clearTempDir();
        if (Platform.getTempDir().exists() && !FileUtilities.delete((File)Platform.getTempDir())) {
            Platform.getTempDir().deleteOnExit();
        }
    }

    private boolean dispatchGlobalKeyEvent(KeyEvent ke) {
        int keyCode = ke.getKeyCode();
        int keyModifiers = ke.getModifiersEx();
        if (ke.getID() == 401) {
            Window window;
            if (keyCode == 112) {
                DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//userguide.html");
                return true;
            }
            if (keyCode == 79 && keyModifiers == 256) {
                Mango.getInstance().doOpenImageDialog(false);
                return true;
            }
            if (keyCode == 79 && keyModifiers == 512) {
                Mango.getInstance().doOpenImageDialog(true);
                return true;
            }
            if (keyCode == 87 && (Platform.MAC && keyModifiers == 256 || !Platform.MAC && keyModifiers == 128) && (window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()).isActive()) {
                window.dispatchEvent(new WindowEvent(window, 201));
                return true;
            }
            if (this.toolBox.usesFunctionKey(ke.getKeyCode())) {
                this.toolBox.clickFunctionKey(ke.getKeyCode());
                return true;
            }
        }
        return false;
    }

    public void exit() {
        this.isExiting = true;
        List<VolumeManager> allManagers = this.getAllVolumeManagers();
        for (VolumeManager manager : allManagers) {
            ((SliceViewer)manager).forceDispose();
        }
        CLIPBOARD.cleanUp();
        this.cleanUp(true);
        this.filterManager = new FilterManager();
        this.movedMenuMap = new HashMap<String, Boolean>();
        Mango.clearInstance();
        JVMUtilities.clearGarbage();
    }

    public static void clearInstance() {
        it = null;
        calculatorHistory = new LinkedList();
        recentFiles = new LinkedList();
        loadSet = Collections.synchronizedSortedSet(new TreeSet<Object>(new StringComparator()));
        fileAssociationsKnown = new TreeMap();
        plugins = new TreeMap();
        pluginsSurface = new TreeMap();
        launchListeners = new Vector();
        allViewers = new Vector();
    }

    private void doExit() {
        MangoPreferences.savePreferences();
        CLIPBOARD.cleanUp();
        this.cleanUp();
        System.exit(0);
    }

    private String getCaptureLocation(Capturable cap) {
        File imageDir = new File(cap.getCaptureDir().toString());
        return this.getCapturableLocation(imageDir);
    }

    private SliceViewer getNextViewer(SliceViewer aViewer) {
        Iterator<SliceViewer> it = allViewers.iterator();
        while (it.hasNext()) {
            SliceViewer mv = it.next();
            if (mv != aViewer || !it.hasNext()) continue;
            return it.next();
        }
        return allViewers.firstElement();
    }

    private synchronized void loadNext() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (Mango.this.isLoading) {
                    return;
                }
                if (loadSet.size() > 0) {
                    Mango.this.isLoading = true;
                    LoadItem loadItem = (LoadItem)loadSet.first();
                    loadSet.remove(loadItem);
                    if (loadItem.isSurface()) {
                        loadItem.getBaseImage().readSurface(loadItem.getFile());
                    } else if (loadItem.getUris() != null) {
                        if (Mango.this.applet) {
                            List<URI> uris = loadItem.getUris();
                            loadItem.getBaseImage().loadImage(uris.get(0), null, null, uris.toArray(new URI[uris.size()]), null, null, null, null);
                        }
                    } else if (loadItem.getURI() != null) {
                        URI uri = loadItem.getURI();
                        boolean isRefresh = loadItem.isRefresh();
                        boolean isOverlay = loadItem.isOverlay();
                        if (Mango.this.applet) {
                            if (isOverlay) {
                                loadItem.getBaseImage().loadOverlay(uri, loadItem.getBaseImage().getOverlayManager().getNextLUTType(), loadItem.isParametric());
                            } else {
                                loadItem.getBaseImage().loadImage(uri, null, null, null, null, null, null, null);
                            }
                        } else if (isRefresh) {
                            SliceViewer aViewer = Mango.findViewerByFile(uri);
                            if (aViewer != null) {
                                aViewer.reloadImage();
                            } else {
                                Mango.this.loadNextViewer();
                            }
                        } else if (isOverlay) {
                            if (loadItem.getBaseImage() != null && loadItem.getBaseImage().getOverlayManager() != null) {
                                loadItem.getBaseImage().loadOverlay(uri, loadItem.getBaseImage().getOverlayManager().getNextLUTType(), false);
                            } else {
                                Mango.this.addViewer(uri, true);
                            }
                        } else {
                            Mango.this.addViewer(uri, true);
                        }
                    } else {
                        File file = loadItem.getFile();
                        boolean isRefresh = loadItem.isRefresh();
                        boolean isOverlay = loadItem.isOverlay();
                        boolean isROI = loadItem.isRoi();
                        if (isRefresh) {
                            SliceViewer aViewer = Mango.findViewerByFile(file.toURI());
                            if (aViewer != null) {
                                aViewer.reloadImage();
                            } else {
                                Mango.this.loadNextViewer();
                            }
                        } else if (isOverlay) {
                            if (loadItem.getBaseImage() != null && loadItem.getBaseImage().getOverlayManager() != null) {
                                loadItem.getBaseImage().loadOverlay(file.toURI(), loadItem.getBaseImage().getOverlayManager().getNextLUTType(), false);
                            } else {
                                Mango.this.loadNextViewer();
                            }
                        } else if (isROI) {
                            if (loadItem.getBaseImage() != null) {
                                loadItem.getBaseImage().loadROI(file.toURI(), false);
                            } else {
                                Mango.this.loadNextViewer();
                            }
                        } else if (file.isDirectory()) {
                            new ViewerMenuAction(it).makeDICOMChooser(file);
                        } else {
                            Mango.this.addViewer(file);
                        }
                    }
                } else {
                    Mango.this.isLoading = false;
                    Mango.notifyLaunchListeners();
                }
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    public void setWorldMode(final boolean world) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (world) {
                    Mango.this.toolBox.updateCoordinate(4);
                } else {
                    Mango.this.toolBox.updateCoordinate(0);
                }
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setAtlas(final String name) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Mango.this.toolBox.setAtlasByName(name);
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setMultisliceMode(final boolean multislice) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Mango.this.toolBox.setVOIMode(multislice);
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setTool(final int code) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Mango.this.toolBox.setROIEditMode(code);
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setToolRange(final boolean useRange, final double min, final double max, final boolean onlyWhenShiftKeyPressed) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Mango.this.setSmartToolsRangeMin(min);
                Mango.this.setSmartToolsRangeMax(max);
                Mango.this.setUseSmartROITools(useRange);
                Mango.this.setUsingSmartToolsToggle(onlyWhenShiftKeyPressed);
                Mango.this.toolBox.updateAfterToolRangeChange();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setToolRelativeRange(final double range) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Mango.this.setMagicWandRange(range);
                Mango.this.toolBox.updateAfterToolRelativeRangeChnage();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void capture() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Mango.this.doCapture(false, Mango.this.currentViewer);
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public File getLibDir() {
        return Platform.getLibDir();
    }

    public JButton createColorPickerButton(VolumeManager manager, MangoColorSelectedListener listener, boolean showUsedOnly) {
        return new MangoColorButton((SliceViewer)manager, listener, showUsedOnly);
    }

    public boolean isMultisliceMode() {
        return this.toolBox.isVOIMode();
    }

    public boolean isWorldMode() {
        return this.toolBox.isWorldMode();
    }

    public int getTool() {
        return this.toolBox.getROIEditMode();
    }

    public List<Analysis> getAllAnalyses() {
        return this.resultsManager.getAllAnalyses();
    }

    public Atlas getCurrentAtlas() {
        return this.toolBox.getCurrentAtlas();
    }

    public static boolean isJre7MacWarning() {
        return jre7MacWarning;
    }

    public static void setJre7MacWarning(boolean jre7MacWarning) {
        Mango.jre7MacWarning = jre7MacWarning;
    }

    public static boolean isAllowRGBMode() {
        return allowRGBMode;
    }

    public static void setAllowRGBMode(boolean allowRGBMode) {
        Mango.allowRGBMode = allowRGBMode;
        Volume.setDisableRGB(!allowRGBMode);
    }

    public static boolean isRgbWarning() {
        return true;
    }

    public static void setRgbWarning(boolean rgbWarning) {
    }

    public void openHeaderEditor(File file, SliceViewer originatingViewer) {
        this.startIndeterminateProgressBar();
        final HeaderEditor editor = new HeaderEditor(file, originatingViewer);
        Thread workThread = new Thread(){

            @Override
            public void run() {
                try {
                    final ReadableHeader readable = editor.readFiles();
                    SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Mango.this.endIndeterminateProgressBar();
                                editor.createUI(readable);
                            }
                            catch (InvalidHeaderException ex) {
                                Mango.this.showErrorDialog(ex.getMessage(), "Header Editor Error");
                            }
                        }
                    });
                }
                catch (InvalidHeaderException ex) {
                    Mango.this.showErrorDialog(ex.getMessage(), "Header Editor Error");
                    Mango.this.endIndeterminateProgressBar();
                }
            }
        };
        workThread.start();
    }

    public void startIndeterminateProgressBar() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (Mango.this.pbIndeterminate != null) {
                    Mango.this.pbIndeterminate.setValue(100);
                }
                Mango.this.pbIndeterminate = new ProgressBar(Mango.this.toolBox, "");
                Mango.this.pbIndeterminate.init(0, 0, 100);
                Mango.this.pbIndeterminate.setValue(1);
                Mango.this.pbIndeterminate.setIndeterminateMode(true);
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    public void endIndeterminateProgressBar() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (Mango.this.pbIndeterminate != null) {
                    Mango.this.pbIndeterminate.setValue(100);
                }
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    public List<AnalysisPoint> getAllAnalysisPoints() {
        return this.resultsManager.getAllAnalysisPoints();
    }

    static {
        loadSet = Collections.synchronizedSortedSet(new TreeSet<Object>(new StringComparator()));
        fileAssociationsKnown = new TreeMap();
        plugins = new TreeMap();
        pluginsSurface = new TreeMap();
        launchListeners = new Vector();
        allViewers = new Vector();
        CLIPBOARD_LOI = new LOIClipboard();
        CLIPBOARD_POI = new POIClipboard();
        CLIPBOARD = new ROIClipboard();
        FILE_ASSOCIATION_EXT = new String[]{"nii " + (Platform.MAC ? "gz" : "nii.gz"), "hdr", "des", "dcm img dic"};
        FILE_ASSOCIATION_NAMES = new String[]{"NIFTI", "Analyze", "NEMA", "DICOM"};
        F_ACTIONS = new String[24];
        MOST_RECENT_TOOLS = new int[4];
        FONT_HEADING = new Font("SansSerif", 1, 14);
        DEPRECATED_INCLUDED_PLUGINS = CollectionUtilities.immutable((String[])new String[]{"AtlasTD.jar", "TIFF.jar", "AFNI.jar", "MicroPET.jar", "TalairachLoader.jar", "GenerateLayout.jar", "CineTool.jar"});
        INCLUDED_ATLAS_FILES = CollectionUtilities.immutable((String[])new String[]{"MNI.xml", "Talairach.xml", "Talairach-Daemon.xml", "Talairach/Talairach-labels-1mm.nii.gz", "Talairach/Talairach-daemon-1mm.nii.gz"});
        INCLUDED_PLUGINS = new String[0];
    }
}

