/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.cli.script;

import edu.uthscsa.ric.cli.CLIUtils;
import edu.uthscsa.ric.cli.Context;
import edu.uthscsa.ric.cli.Utility;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoContext;
import edu.uthscsa.ric.mango.dialogs.script.ScriptManager;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MangoScript
implements Utility {
    public static final String TEXT_LOADING_OVERLAY = "Loading overlay";
    public static final String COMMAND_LINE_NAME = "script";
    public static final String OPTION_ROI = "-r";
    public static final String OPTION_OVERLAY = "-o";
    public static final String OPTION_SURFACE = "-s";
    public static final String OPTION_FILE = "-f";
    public static final String OPTION_ATLAS = "-a";
    public static final String OPTION_PARAMETRIC = "-p";
    public static final String OPTION_BATCH = "-b";
    public static final String OPTION_OUTPUT = "-out";
    public static final String OPTION_EXPRESSION_ALL_VOXELS = "-e1";
    public static final String OPTION_EXPRESSION_INSIDE_ROI = "-e2";
    public static final String OPTION_EXPRESSION_OUTSIDE_ROI = "-e3";
    private boolean useFile;
    private boolean batchMode;
    private String expression;
    private int expressionRegion;
    private String scriptName;
    private String atlasName;
    private final List<List<LoadFile>> infiles = new ArrayList<List<LoadFile>>();

    public static void displayUsage() {
        AppLogger.error((String)new MangoScript().getUsage());
    }

    public static void main(String[] args) {
        try {
            CLIUtils.prepUtilityProgram();
            CLIUtils.addAllPlugins();
            JVMUtilities.addLibraryDir((String)Platform.getLibDir().toString());
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        MangoScript utility = new MangoScript();
        if (utility.readArgs(args)) {
            utility.process();
        } else {
            AppLogger.error((String)utility.getUsage());
        }
    }

    private void processNormal() {
        Context ctx = Context.getContext();
        try {
            if (StringUtils.isNotBlank((CharSequence)this.atlasName)) {
                ctx.setAtlas(this.atlasName);
            }
            VolumeManager originalManager = null;
            File outputFile = null;
            for (List<LoadFile> volMan : this.infiles) {
                VolumeManager manager = null;
                for (LoadFile file : volMan) {
                    String end = ")...";
                    if (file.getType() == 0) {
                        AppLogger.info((String)("Loading new volume manager (" + file.getFile().getName() + ")..."));
                        manager = ctx.makeNewVolumeManager(volMan.get(0).getFile().toString());
                        if (originalManager != null) continue;
                        originalManager = manager;
                        continue;
                    }
                    if (file.getType() == 1) {
                        AppLogger.info((String)("Loading overlay (" + file.getFile().getName() + ")..."));
                        manager.addOverlay(file.getFile().toString(), false);
                        continue;
                    }
                    if (file.getType() == 2) {
                        AppLogger.info((String)("Loading overlay (" + file.getFile().getName() + ")..."));
                        manager.addOverlay(file.getFile().toString(), true);
                        continue;
                    }
                    if (file.getType() == 3) {
                        AppLogger.info((String)("Loading ROI (" + file.getFile().getName() + ")..."));
                        manager.loadROI(file.getFile().toString());
                        continue;
                    }
                    if (file.getType() == 4) {
                        AppLogger.info((String)("Loading surface (" + file.getFile().getName() + ")..."));
                        manager.loadSurface(file.getFile().toString());
                        continue;
                    }
                    if (file.getType() != 5 || originalManager != manager) continue;
                    File tempFile = file.getFile();
                    if (tempFile.isAbsolute()) {
                        outputFile = tempFile;
                        continue;
                    }
                    outputFile = new File(new File(manager.getLoadedURI()).getParent(), tempFile.getName());
                }
            }
            AppLogger.info((String)"Running script...");
            if (this.useFile) {
                ScriptManager.runScriptConsole(new File(this.scriptName), (MangoContext)ctx, originalManager);
            } else if (StringUtils.isNotBlank((CharSequence)this.expression)) {
                ScriptManager.runScriptConsoleExpression(this.expression, this.expressionRegion, ctx, originalManager, outputFile == null);
            } else {
                ScriptManager.runScriptConsole(this.scriptName, (MangoContext)ctx, originalManager);
            }
            if (outputFile != null) {
                AppLogger.info((String)("Saving to " + outputFile.getName() + "..."));
                originalManager.saveWithName(outputFile.toString());
            }
            AppLogger.info((String)"Done!");
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    private void processBatch() {
        for (List<LoadFile> volMan : this.infiles) {
            try {
                Context ctx = Context.getContext();
                if (StringUtils.isNotBlank((CharSequence)this.atlasName)) {
                    ctx.setAtlas(this.atlasName);
                }
                VolumeManager manager = null;
                File outputFile = null;
                for (LoadFile file : volMan) {
                    String end = ")...";
                    if (file.getType() == 0) {
                        AppLogger.info((String)("Loading new volume manager (" + file.getFile().getName() + ")..."));
                        manager = ctx.makeNewVolumeManager(volMan.get(0).getFile().toString());
                        continue;
                    }
                    if (file.getType() == 1) {
                        AppLogger.info((String)("Loading overlay (" + file.getFile().getName() + ")..."));
                        manager.addOverlay(file.getFile().toString(), false);
                        continue;
                    }
                    if (file.getType() == 2) {
                        AppLogger.info((String)("Loading overlay (" + file.getFile().getName() + ")..."));
                        manager.addOverlay(file.getFile().toString(), true);
                        continue;
                    }
                    if (file.getType() == 3) {
                        AppLogger.info((String)("Loading ROI (" + file.getFile().getName() + ")..."));
                        manager.loadROI(file.getFile().toString());
                        continue;
                    }
                    if (file.getType() == 4) {
                        AppLogger.info((String)("Loading surface (" + file.getFile().getName() + ")..."));
                        manager.loadSurface(file.getFile().toString());
                        continue;
                    }
                    if (file.getType() != 5) continue;
                    File tempFile = file.getFile();
                    if (tempFile.isAbsolute()) {
                        outputFile = tempFile;
                        continue;
                    }
                    outputFile = new File(new File(manager.getLoadedURI()).getParent(), tempFile.getName());
                }
                AppLogger.info((String)"Running script...");
                if (this.useFile) {
                    ScriptManager.runScriptConsole(new File(this.scriptName), (MangoContext)ctx, manager);
                } else if (StringUtils.isNotBlank((CharSequence)this.expression)) {
                    ScriptManager.runScriptConsoleExpression(this.expression, this.expressionRegion, ctx, manager, outputFile == null);
                } else {
                    ScriptManager.runScriptConsole(this.scriptName, (MangoContext)ctx, manager);
                }
                if (outputFile != null) {
                    AppLogger.info((String)("Saving to " + outputFile.getName() + "..."));
                    manager.saveWithName(outputFile.toString());
                }
                ctx.exit();
            }
            catch (InvalidHeaderException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        AppLogger.info((String)"Done!");
    }

    private void process() {
        if (this.batchMode) {
            this.processBatch();
        } else {
            this.processNormal();
        }
    }

    @Override
    public String getUsage() {
        String usage = "";
        usage = usage + "Runs a Mango script (v" + Mango.getVersionString() + " b-" + Mango.getBuildNumberString() + ")\n";
        usage = usage + "Usage: script [-f] <name> <files> [-o file] [-p file] [-r file] [-s file] [-a atlas] [-out file] [-b]\n";
        usage = usage + "Usage: script [-e] <expression> <files> [-o file] [-p file] [-r file] [-s file] [-a atlas] [-out file] [-b]\n";
        usage = usage + "Option: -f   script file\n";
        usage = usage + "Option: -e1  image calculator expression, all voxels (e.g., \"this+1\")\n";
        usage = usage + "Option: -e2  image calculator expression, inside ROI (e.g., \"this+1\")\n";
        usage = usage + "Option: -e3  image calculator expression, outside ROI (e.g., \"this+1\")\n";
        usage = usage + "Option: -o   overlay file\n";
        usage = usage + "Option: -p   parametric overlay file\n";
        usage = usage + "Option: -r   roi file\n";
        usage = usage + "Option: -s   surface file\n";
        usage = usage + "Option: -a   atlas name\n";
        usage = usage + "Option: -out output file name\n";
        usage = usage + "Option: -b   batch mode (script is run on each individually loaded volume manager)\n";
        usage = usage + "Example: script \"My Script\" myFile -o myFileOvly myFile2 -o myFile2Ovly\n";
        usage = usage + "Example: script -f myScript.py myFile\n";
        return usage;
    }

    private boolean readArgs(String[] args) {
        ArrayList<LoadFile> currentVolMan = null;
        for (int ctr = 0; ctr < args.length; ++ctr) {
            File overlayFile;
            if (ctr == 0) {
                if (args[ctr].equals(OPTION_FILE)) {
                    this.useFile = true;
                    this.scriptName = args[ctr + 1];
                    ++ctr;
                    continue;
                }
                if (args[ctr].equals(OPTION_EXPRESSION_ALL_VOXELS)) {
                    this.expression = args[ctr + 1];
                    this.expressionRegion = 0;
                    ++ctr;
                    continue;
                }
                if (args[ctr].equals(OPTION_EXPRESSION_INSIDE_ROI)) {
                    this.expression = args[ctr + 1];
                    this.expressionRegion = 2;
                    ++ctr;
                    continue;
                }
                if (args[ctr].equals(OPTION_EXPRESSION_OUTSIDE_ROI)) {
                    this.expression = args[ctr + 1];
                    this.expressionRegion = 3;
                    ++ctr;
                    continue;
                }
                this.scriptName = args[ctr];
                continue;
            }
            if (args[ctr].equals(OPTION_OVERLAY)) {
                overlayFile = new File(args[ctr + 1]);
                currentVolMan.add(new LoadFile(overlayFile, 1));
                ++ctr;
                continue;
            }
            if (args[ctr].equals(OPTION_PARAMETRIC)) {
                overlayFile = new File(args[ctr + 1]);
                currentVolMan.add(new LoadFile(overlayFile, 2));
                ++ctr;
                continue;
            }
            if (args[ctr].equals(OPTION_ROI)) {
                File roiFile = new File(args[ctr + 1]);
                currentVolMan.add(new LoadFile(roiFile, 3));
                ++ctr;
                continue;
            }
            if (args[ctr].equals(OPTION_SURFACE)) {
                File surfaceFile = new File(args[ctr + 1]);
                currentVolMan.add(new LoadFile(surfaceFile, 4));
                ++ctr;
                continue;
            }
            if (args[ctr].equals(OPTION_OUTPUT)) {
                File outputFile = new File(args[ctr + 1]);
                currentVolMan.add(new LoadFile(outputFile, 5));
                ++ctr;
                continue;
            }
            if (args[ctr].equals(OPTION_ATLAS)) {
                this.atlasName = args[ctr + 1];
                ++ctr;
                continue;
            }
            if (args[ctr].equals(OPTION_BATCH)) {
                this.batchMode = true;
                continue;
            }
            currentVolMan = new ArrayList<LoadFile>();
            currentVolMan.add(new LoadFile(new File(args[ctr]), 0));
            this.infiles.add(currentVolMan);
        }
        return this.infiles.size() > 0;
    }

    @Override
    public String getCommandLineName() {
        return COMMAND_LINE_NAME;
    }

    static class LoadFile {
        public static final int TYPE_BASE = 0;
        public static final int TYPE_OVERLAY = 1;
        public static final int TYPE_PARAMETRIC = 2;
        public static final int TYPE_ROI = 3;
        public static final int TYPE_SURFACE = 4;
        public static final int TYPE_OUTPUT = 5;
        private final File file;
        private final int type;

        public LoadFile(File file, int type) {
            this.file = file;
            this.type = type;
        }

        public File getFile() {
            return this.file;
        }

        public int getType() {
            return this.type;
        }
    }
}

