/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.cli.newmat;

import edu.uthscsa.ric.cli.CLIUtils;
import edu.uthscsa.ric.cli.Utility;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeIOException;
import java.io.File;
import java.io.FileNotFoundException;
import org.apache.commons.lang3.StringUtils;

public class Newmat
implements Utility {
    public static final String COMMAND_LINE_NAME = "resizer";

    public static void displayUsage() {
        AppLogger.error((String)new Newmat().getUsage());
    }

    public static void main(String[] args) {
        CLIUtils.prepUtilityProgram();
        boolean option = false;
        boolean validNumArgs = false;
        boolean resliceOption = false;
        int numArgs = args.length;
        if (numArgs == 5) {
            option = true;
            validNumArgs = true;
        } else if (numArgs == 8) {
            validNumArgs = true;
        } else if (numArgs == 9) {
            validNumArgs = true;
            resliceOption = true;
        }
        if (!validNumArgs) {
            Newmat.displayUsage();
            System.exit(1);
        }
        try {
            int zAbove;
            int zBelow;
            int yAbove;
            int yBelow;
            int xAbove;
            int xBelow;
            boolean overwriting;
            File infile = new File(args[0]);
            String outputName = null;
            if (numArgs == 5) {
                outputName = args[4];
            } else if (numArgs == 8) {
                outputName = args[7];
            } else if (numArgs == 9) {
                outputName = args[8];
            }
            File outputFile = null;
            if (StringUtils.isNotBlank((CharSequence)outputName)) {
                File tempFile = new File(outputName);
                outputFile = tempFile.isAbsolute() ? tempFile : new File(infile.getParent(), outputName);
            }
            if (!(overwriting = infile.equals(outputFile = CLIUtils.makeOutputFile(infile, outputFile, null, null, ".nii.gz", false)))) {
                FileUtilities.createNewFile((File)outputFile);
            }
            if (!infile.exists()) {
                throw new FileNotFoundException("File does not exist: " + infile);
            }
            if (!infile.canRead()) {
                throw new FileNotFoundException("File cannot be read (check permissions): " + infile);
            }
            if (!outputFile.exists()) {
                throw new FileNotFoundException("File cannot be accessed (check permissions): " + outputFile);
            }
            Volume vol = new Volume();
            vol.readFiles(infile.toURI());
            ImageDimensions id = vol.getImageDimensions();
            int xDim = id.getX();
            int yDim = id.getY();
            int zDim = id.getZ();
            double xSize = vol.getXSize();
            double ySize = vol.getYSize();
            double zSize = vol.getZSize();
            if (option) {
                int xDiff = Integer.parseInt(args[1]) - xDim;
                int yDiff = Integer.parseInt(args[2]) - yDim;
                int zDiff = Integer.parseInt(args[3]) - zDim;
                xBelow = xDiff / 2;
                xAbove = xDiff > 0 ? (xDiff + 1) / 2 : (xDiff - 1) / 2;
                yBelow = yDiff / 2;
                yAbove = yDiff > 0 ? (yDiff + 1) / 2 : (yDiff - 1) / 2;
                zBelow = zDiff / 2;
                zAbove = zDiff > 0 ? (zDiff + 1) / 2 : (zDiff - 1) / 2;
            } else if (resliceOption) {
                xBelow = 0;
                xDim = Integer.parseInt(args[2]);
                xAbove = 0;
                yBelow = 0;
                yDim = Integer.parseInt(args[3]);
                yAbove = 0;
                zBelow = 0;
                zDim = Integer.parseInt(args[4]);
                zAbove = 0;
                xSize = Double.parseDouble(args[5]);
                ySize = Double.parseDouble(args[6]);
                zSize = Double.parseDouble(args[7]);
            } else {
                xBelow = Integer.parseInt(args[1]);
                xAbove = Integer.parseInt(args[2]);
                yBelow = Integer.parseInt(args[3]);
                yAbove = Integer.parseInt(args[4]);
                zBelow = Integer.parseInt(args[5]);
                zAbove = Integer.parseInt(args[6]);
            }
            if (xDim + (xBelow + xAbove) <= 0) {
                throw new IllegalArgumentException();
            }
            if (yDim + (yBelow + yAbove) <= 0) {
                throw new IllegalArgumentException();
            }
            if (zDim + (zBelow + zAbove) <= 0) {
                throw new IllegalArgumentException();
            }
            String orientation = vol.getOrientationString();
            int ibMinX = orientation.charAt(orientation.indexOf(88) + 3) == '+' ? 0 - xBelow : 0 - xAbove;
            int ibMaxX = orientation.charAt(orientation.indexOf(88) + 3) == '+' ? xDim - 1 + xAbove : xDim - 1 + xBelow;
            int ibMinY = orientation.charAt(orientation.indexOf(89) + 3) == '+' ? 0 - yBelow : 0 - yAbove;
            int ibMaxY = orientation.charAt(orientation.indexOf(89) + 3) == '+' ? yDim - 1 + yAbove : yDim - 1 + yBelow;
            int ibMinZ = orientation.charAt(orientation.indexOf(90) + 3) == '+' ? 0 - zBelow : 0 - zAbove;
            int ibMaxZ = orientation.charAt(orientation.indexOf(90) + 3) == '+' ? zDim - 1 + zAbove : zDim - 1 + zBelow;
            ImageBounds ib = new ImageBounds(ibMinX, ibMaxX, ibMinY, ibMaxY, ibMinZ, ibMaxZ);
            String outFormatName = Header.findWritableNameForExtension(outputFile);
            if (outFormatName == null) {
                outFormatName = "NIFTI";
            }
            vol.updateMaxMin(vol.findRangeInBounds(ib));
            vol.writeFilesAs(outputFile, vol.getImageType(), 0, vol.getOrientationString(), null, overwriting, outFormatName, false, false, null, false, -1, false, false, false, false, -1.0, false, false, false, ib, xSize, ySize, zSize, 1.0, true);
        }
        catch (NumberFormatException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    @Override
    public String getUsage() {
        String usage = "";
        usage = usage + "Resizes an image voxel array (v" + Mango.getVersionString() + " b-" + Mango.getBuildNumberString() + ")\n";
        usage = usage + "Usage: resizer <infile> <xImageDim> <yImageDim> <zImageDim> <outfile>\n";
        usage = usage + "Usage: resizer <infile> -reslice <xImageDim> <yImageDim> <zImageDim> <xVoxelDim> <yVoxelDim> <zVoxelDim> <outfile>\n";
        usage = usage + "Usage: resizer <infile> <xLeft> <xRight> <yPos> <yAnt> <zInf> <zSup> <outfile>\n";
        usage = usage + "Options:\n";
        usage = usage + "<xDim> <yDim> <zDim>  the desired output extent of each dimension (changes are symmetrical)\n";
        usage = usage + "-reslice <xImageDim> <yImageDim> <zImageDim> <xVoxelDim> <yVoxelDim> <zVoxelDim>   the desired output image and voxel dimensions\n";
        usage = usage + "<xLeft> <xRight> <yPos> <yAnt> <zInf> <zSup>  amount to add or subtract from each edge of image\n";
        return usage;
    }

    @Override
    public String getCommandLineName() {
        return COMMAND_LINE_NAME;
    }
}

