/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.cli.imageinfo;

import edu.uthscsa.ric.cli.CLIUtils;
import edu.uthscsa.ric.cli.Utility;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.dialogs.modal.PluginManagerDialog;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Orientation;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.formats.dicom.Series;
import edu.uthscsa.ric.volume.formats.nifti.NIFTI;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ImageInfo
implements Utility {
    private boolean headerDump;
    private final List<String> infiles = new ArrayList<String>();
    public static final String COMMAND_LINE_NAME = "imageinfo";
    public static final String OPTION_HEADER = "-d";
    public static final String OPTION_HEADER_OLD = "-f";
    public static final String TEXT_BY = " x ";
    public static final String TEXT_SEP = "-----";

    public static void displayUsage() {
        AppLogger.error((String)new ImageInfo().getUsage());
    }

    public static void main(String[] args) {
        try {
            CLIUtils.prepUtilityProgram();
            CLIUtils.addAllPlugins();
            JVMUtilities.addLibraryDir((String)Platform.getLibDir().toString());
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        ImageInfo info = new ImageInfo();
        if (info.readArgs(args)) {
            info.process();
        } else {
            AppLogger.error((String)info.getUsage());
        }
    }

    @Override
    public String getCommandLineName() {
        return COMMAND_LINE_NAME;
    }

    @Override
    public String getUsage() {
        String usage = "";
        usage = usage + "Prints a summary of image metadata (v" + Mango.getVersionString() + " b-" + Mango.getBuildNumberString() + ")\n";
        usage = usage + "Usage: imageinfo [-d] <header>\n";
        usage = usage + "Option: -d  dump header\n";
        return usage;
    }

    public void process() {
        MangoNumberFormatter formatter = new MangoNumberFormatter();
        HashSet<File> processedFiles = new HashSet<File>();
        for (String str : this.infiles) {
            File headerFile = new File(str);
            if (processedFiles.contains(headerFile)) continue;
            try {
                if (!headerFile.exists()) {
                    throw new FileNotFoundException("File not found: " + headerFile);
                }
                Series.setSkipFindAssociated((boolean)this.headerDump);
                Header header = new Header();
                headerFile = new File(header.readFile(headerFile, Platform.getTempDir()));
                String format = PluginManagerDialog.getPluginName(header.getReadable());
                URI[] files = header.getMultiImageFiles();
                if (files != null) {
                    for (URI file2 : files) {
                        processedFiles.add(new File(file2).getAbsoluteFile());
                    }
                }
                StringBuffer sb = new StringBuffer(32);
                sb.append(TEXT_SEP).append(format).append(": ").append(headerFile.getName()).append(TEXT_SEP).append('\n');
                if (this.headerDump) {
                    sb.append(header.toString().trim());
                } else {
                    ImageDimensions id = header.getImageDimensions();
                    VoxelDimensions vd = header.getVoxelDimensions();
                    ImageType it = header.getImageType();
                    ImageRange ir = header.getImageRange();
                    Orientation orientation = new Orientation(header.getOrientationString(), id, vd, header.getOrigin());
                    Coordinate origin = orientation.convertCoordinate(header.getOrigin());
                    File imageFile = new File(header.getImageFile());
                    sb.append("Header Filename: ").append(headerFile.getName());
                    sb.append("\nImage Filename: ").append(imageFile.getName());
                    sb.append("\nImage Dimensions (X, Y, Z): ").append(id.getX()).append(TEXT_BY).append(id.getY()).append(TEXT_BY).append(id.getZ());
                    sb.append("\nVoxel Dimensions (X, Y, Z): ").append(formatter.format(vd.getXSize())).append(TEXT_BY).append(formatter.format(vd.getYSize())).append(TEXT_BY).append(formatter.format(vd.getZSize()));
                    sb.append("\nNumber of Series Points: ").append(id.getTimepoints()).append("    TR: ").append(vd.getTR());
                    sb.append("\nByte Type: ").append(it.getNumBytesPerVoxel()).append("-Byte ").append(it.getByteTypeString());
                    if (it.getNumBytesPerVoxel() > 1) {
                        sb.append("\nByte Order: ").append(it.isLittleEndian() ? "Little Endian" : "Big Endian");
                    }
                    sb.append("\nCompressed: ").append(header.getImageType().isCompressed() ? "Yes" : "No");
                    sb.append("\nImage Min: ").append(formatter.format(ir.getImageMin())).append("    Image Max: ").append(formatter.format(ir.getImageMax()));
                    sb.append("\nOrigin: (").append(origin.xInt).append(", ").append(origin.yInt).append(", ").append(origin.zInt).append(')');
                    sb.append("\nData Orientation: ").append(header.getOrientationString());
                    sb.append("\nSpatial Unit: ").append(NIFTI.getNiftiUnitString(vd.getSpatialUnit()));
                    sb.append("\nTemporal Unit: ").append(NIFTI.getNiftiUnitString(vd.getTemporalUnit()));
                    sb.append("\nDescription: " + header.getAllDescriptiveData(0).trim());
                }
                sb.append('\n');
                AppLogger.info((String)sb.toString());
            }
            catch (InvalidHeaderException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (FileNotFoundException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    private boolean readArgs(String[] args) {
        for (String arg : args) {
            if (arg.equals(OPTION_HEADER_OLD)) {
                this.headerDump = true;
                continue;
            }
            if (arg.equals(OPTION_HEADER)) {
                this.headerDump = true;
                continue;
            }
            this.infiles.add(arg);
        }
        return this.infiles.size() > 0;
    }
}

