/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.cli.groupvolumes;

import edu.uthscsa.ric.cli.CLIUtils;
import edu.uthscsa.ric.cli.Utility;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.Image;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeIOException;
import edu.uthscsa.ric.volume.VoxelDimensions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class GroupVolumes
implements Utility {
    private String outputName;
    private boolean forceFloat;
    private boolean microsecond;
    private boolean millisecond;
    private double time;
    private final Vector<String> infiles;
    private final Vector<File> headerFiles = new Vector();
    public static final String COMMAND_LINE_NAME = "vols2series";
    public static final String OPTION_FORCE_FLOAT = "-f";
    public static final String OPTION_MICRO = "-u";
    public static final String OPTION_MILLI = "-m";
    public static final String OPTION_SECONDS = "-s";
    public static final String OPTION_OUTPUT = "-out";
    public static final String OPTION_OUTPUT2 = "-o";
    public static final String DEFAULT_NAME = "series.nii.gz";

    public static void main(String[] args) {
        try {
            CLIUtils.prepUtilityProgram();
            CLIUtils.addAllPlugins();
            JVMUtilities.addLibraryDir((String)Platform.getLibDir().toString());
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        GroupVolumes converter = new GroupVolumes();
        if (converter.readArgs(args)) {
            converter.process();
        } else {
            AppLogger.error((String)converter.getUsage());
        }
    }

    public GroupVolumes() {
        this.infiles = new Vector();
    }

    private void process() {
        int numTimepoints = 0;
        boolean foundDims = false;
        ImageDimensions id = null;
        VoxelDimensions vd = null;
        ImageType it = null;
        String orientation = null;
        HashSet<File> processedFiles = new HashSet<File>();
        for (String path : this.infiles) {
            File currentFile = new File(path).getAbsoluteFile();
            if (processedFiles.contains(currentFile)) continue;
            try {
                Header header = new Header();
                URI uri = header.readFile(currentFile);
                currentFile = new File(uri);
                URI[] files = header.getMultiImageFiles();
                if (files != null) {
                    for (URI file2 : files) {
                        processedFiles.add(new File(file2).getAbsoluteFile());
                    }
                }
                int timepoints = 0;
                if (!foundDims) {
                    id = header.getImageDimensions();
                    vd = header.getVoxelDimensions();
                    it = header.getImageType();
                    timepoints = id.getTimepoints();
                    orientation = header.getOrientationString();
                    foundDims = true;
                } else {
                    ImageDimensions currentId = header.getImageDimensions();
                    timepoints = currentId.getTimepoints();
                    if (!currentId.equals((Object)id)) {
                        throw new InvalidHeaderException("Image dimensions don't match!");
                    }
                    VoxelDimensions currentVd = header.getVoxelDimensions();
                    if (!currentVd.equals((Object)vd)) {
                        throw new InvalidHeaderException("Voxel dimensions don't match!");
                    }
                }
                this.headerFiles.add(currentFile);
                numTimepoints += timepoints;
            }
            catch (InvalidHeaderException ex) {
                AppLogger.error((String)("Problem reading file: " + currentFile));
                AppLogger.error((Throwable)ex);
            }
        }
        File outputFile = null;
        if (StringUtils.isNotBlank((CharSequence)this.outputName)) {
            File tempFile = new File(this.outputName);
            outputFile = tempFile.isAbsolute() ? tempFile : new File(new File(this.infiles.get(0)).getAbsoluteFile().getParent(), this.outputName);
        }
        outputFile = CLIUtils.makeOutputFile(new File(this.infiles.get(0)).getAbsoluteFile(), outputFile, null, "_series", ".nii.gz", "series", false);
        id.setTimepoints(numTimepoints);
        id.setImageOffset(0);
        vd.setTR(this.time);
        if (this.microsecond) {
            vd.setTemporalUnit(24);
        } else if (this.millisecond) {
            vd.setTemporalUnit(16);
        } else {
            vd.setTemporalUnit(8);
        }
        if (this.forceFloat) {
            it = new ImageType(4, 4, 32, it.isLittleEndian());
        }
        Header headerOut = new Header(it, id, vd);
        headerOut.setImageFile(outputFile);
        headerOut.setOrientation(orientation);
        ByteBuffer[] buffers = new ByteBuffer[numTimepoints];
        for (int ctr = 0; ctr < numTimepoints; ++ctr) {
            buffers[ctr] = Image.makeBuffer(headerOut.getImageDimensions().getNumVoxelsVolume() * 4);
        }
        try {
            AppLogger.info((String)"Creating series... ");
            Volume volumeNew = new Volume(headerOut, true, buffers);
            ImageDimensions idOut = volumeNew.getImageDimensions();
            int xDim = idOut.getX();
            int yDim = idOut.getY();
            int zDim = idOut.getZ();
            int timeIndex = 0;
            double imageMax = -1.7976931348623157E308;
            double imageMin = Double.MAX_VALUE;
            for (File currentFile : this.headerFiles) {
                AppLogger.info((String)("Adding... " + currentFile));
                Volume volume = new Volume();
                volume.readFiles(currentFile.toURI());
                int timepoints = Math.max(volume.getImageDimensions().getTimepoints(), 1);
                for (int ctrInnerT = 0; ctrInnerT < timepoints; ++ctrInnerT) {
                    for (int ctrZ = 0; ctrZ < zDim; ++ctrZ) {
                        for (int ctrY = 0; ctrY < yDim; ++ctrY) {
                            for (int ctrX = 0; ctrX < xDim; ++ctrX) {
                                double value = volume.getVoxelValueAtIndex(ctrX, ctrY, ctrZ, ctrInnerT);
                                if (value < imageMin) {
                                    imageMin = value;
                                }
                                if (value > imageMax) {
                                    imageMax = value;
                                }
                                volumeNew.putVoxelValueAtIndex(ctrX, ctrY, ctrZ, timeIndex, value);
                            }
                        }
                    }
                    ++timeIndex;
                }
            }
            AppLogger.info((String)("Writing... " + outputFile));
            volumeNew.updateMaxMin(imageMax, imageMin);
            volumeNew.writeFilesAs(outputFile, "NIFTI", it, null, true, it.getByteType() != 4);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    @Override
    public String getUsage() {
        String usage = "";
        usage = usage + "Concatenate volumes into a series (v" + Mango.getVersionString() + " b-" + Mango.getBuildNumberString() + ")\n";
        usage = usage + "Usage: vols2series [-f] [-u | -m | -s <time>] -out <output> <files>\n";
        usage = usage + "Options:\n";
        usage = usage + "-f  force output image to be floating-point\n";
        usage = usage + "-u  microseconds\n";
        usage = usage + "-m  milliseconds\n";
        usage = usage + "-s  seconds\n";
        usage = usage + "-out  specify output file\n";
        return usage;
    }

    private boolean readArgs(String[] args) {
        for (int ctr = 0; ctr < args.length; ++ctr) {
            if (args[ctr].equals(OPTION_FORCE_FLOAT)) {
                this.forceFloat = true;
                continue;
            }
            if (args[ctr].equals(OPTION_MICRO)) {
                this.microsecond = true;
                this.time = Double.parseDouble(args[ctr + 1]);
                ++ctr;
                continue;
            }
            if (args[ctr].equals(OPTION_MILLI)) {
                this.millisecond = true;
                this.time = Double.parseDouble(args[ctr + 1]);
                ++ctr;
                continue;
            }
            if (args[ctr].equals(OPTION_SECONDS)) {
                this.time = Double.parseDouble(args[ctr + 1]);
                ++ctr;
                continue;
            }
            if (args[ctr].equals(OPTION_OUTPUT) || args[ctr].equals(OPTION_OUTPUT2)) {
                this.outputName = args[ctr + 1];
                ++ctr;
                continue;
            }
            this.infiles.add(args[ctr]);
        }
        return this.infiles.size() > 0;
    }

    @Override
    public String getCommandLineName() {
        return COMMAND_LINE_NAME;
    }
}

