/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.cli.convert2nii;

import edu.uthscsa.ric.cli.CLIUtils;
import edu.uthscsa.ric.cli.Utility;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeIOException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class Convert2NIFTI
implements Utility {
    private String outputName;
    private boolean anonymize;
    private boolean nifti2;
    private final Vector<String> infiles = new Vector();
    public static final String COMMAND_LINE_NAME = "convert2nii";
    public static final String NIFTI_EXT = ".nii";
    public static final String OPTION_ANONYMIZE = "-a";
    public static final String OPTION_OUTPUT = "-out";
    public static final String OPTION_NIFTI2 = "-2";

    public static void main(String[] args) {
        try {
            CLIUtils.prepUtilityProgram();
            CLIUtils.addAllPlugins();
            JVMUtilities.addLibraryDir((String)Platform.getLibDir().toString());
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        Convert2NIFTI converter = new Convert2NIFTI();
        if (converter.readArgs(args)) {
            converter.process();
        } else {
            AppLogger.error((String)converter.getUsage());
        }
    }

    @Override
    public String getUsage() {
        String usage = "";
        usage = usage + "Converts recognized file formats to NIFTI format (v" + Mango.getVersionString() + " b-" + Mango.getBuildNumberString() + ")\n";
        usage = usage + "Usage: convert2nii [-a] [-out file] <files>\n";
        usage = usage + "Options:\n";
        usage = usage + "-a  anonymize metadata\n";
        usage = usage + "-2  output in NIFTI-2 format\n";
        usage = usage + "-out  specify output file\n";
        return usage;
    }

    private void process() {
        HashSet<File> processedFiles = new HashSet<File>();
        for (String path : this.infiles) {
            File file = new File(path).getAbsoluteFile();
            if (processedFiles.contains(file)) continue;
            try {
                Volume volume = new Volume();
                volume.readFiles(file.toURI());
                URI[] files = volume.getMultiImageFiles();
                if (files != null) {
                    for (URI file2 : files) {
                        processedFiles.add(new File(file2).getAbsoluteFile());
                    }
                }
                if (this.anonymize) {
                    volume.anonymize();
                }
                File outputFile = null;
                if (StringUtils.isNotBlank((CharSequence)this.outputName)) {
                    File tempFile = new File(this.outputName);
                    outputFile = tempFile.isAbsolute() ? tempFile : new File(file.getParent(), this.outputName);
                }
                File niiFile = CLIUtils.makeOutputFile(file, outputFile, volume, null, ".nii.gz", this.anonymize);
                ImageType it = volume.getImageType();
                volume.updateMaxMin(volume.findRangeSeriesSlowly());
                boolean hasGlobalDataScales = volume.hasGlobalDataScale();
                boolean applyDataScales = !hasGlobalDataScales;
                boolean fitPrecision = !hasGlobalDataScales && it.getByteType() != 4;
                it.setCompressionType(1);
                volume.setImageOffset(352);
                volume.setImageFileName(niiFile.getName());
                if (it.isRGBMode()) {
                    volume.setAsNativeIntegerBuffer();
                }
                if (this.nifti2) {
                    volume.writeFilesAs(niiFile, "NIFTI-2", it, null, applyDataScales, fitPrecision);
                    continue;
                }
                volume.writeFilesAs(niiFile, "NIFTI", it, null, applyDataScales, fitPrecision);
            }
            catch (InvalidHeaderException ex) {
                AppLogger.error((String)("Header could not be read: " + file));
            }
            catch (VolumeIOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    private boolean readArgs(String[] args) {
        for (int ctr = 0; ctr < args.length; ++ctr) {
            if (args[ctr].equals(OPTION_ANONYMIZE)) {
                this.anonymize = true;
                continue;
            }
            if (args[ctr].equals(OPTION_NIFTI2)) {
                this.nifti2 = true;
                continue;
            }
            if (args[ctr].equals(OPTION_OUTPUT)) {
                this.outputName = args[ctr + 1];
                ++ctr;
                continue;
            }
            this.infiles.add(args[ctr]);
        }
        return this.infiles.size() > 0;
    }

    @Override
    public String getCommandLineName() {
        return COMMAND_LINE_NAME;
    }
}

