/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.cli.convert2avw;

import edu.uthscsa.ric.cli.CLIUtils;
import edu.uthscsa.ric.cli.Utility;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeIOException;
import edu.uthscsa.ric.volume.formats.analyze.AVW;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class Convert2AVW
implements Utility {
    private String outputName;
    private boolean anonymize;
    private final Vector<String> infiles = new Vector();
    public static final String COMMAND_LINE_NAME = "convert2avw";
    public static final String EXT_HEADER = ".hdr";
    public static final String EXT_IMAGE = ".img";
    public static final String OPTION_ANONYMIZE = "-a";
    public static final String OPTION_FORCE_SIGNED = "-s";
    public static final String OPTION_OUTPUT = "-out";

    public static void main(String[] args) {
        try {
            CLIUtils.prepUtilityProgram();
            CLIUtils.addAllPlugins();
            JVMUtilities.addLibraryDir((String)Platform.getLibDir().toString());
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        Convert2AVW converter = new Convert2AVW();
        if (converter.readArgs(args)) {
            converter.process();
        } else {
            AppLogger.error((String)converter.getUsage());
        }
    }

    @Override
    public String getUsage() {
        String usage = "";
        usage = usage + "Converts recognized file formats to AVW format (v" + Mango.getVersionString() + " b-" + Mango.getBuildNumberString() + ")\n";
        usage = usage + "Usage: convert2avw [-a] [-out file] <files>\n";
        usage = usage + "Options:\n";
        usage = usage + "-a  anonymize metadata\n";
        usage = usage + "-out  specify output file\n";
        return usage;
    }

    private void process() {
        HashSet<File> processedFiles = new HashSet<File>();
        for (String path : this.infiles) {
            File file = new File(path).getAbsoluteFile();
            if (processedFiles.contains(file)) continue;
            try {
                Volume volume = new Volume();
                volume.readFiles(file.toURI());
                URI[] files = volume.getMultiImageFiles();
                if (files != null) {
                    for (URI file2 : files) {
                        processedFiles.add(new File(file2).getAbsoluteFile());
                    }
                }
                if (this.anonymize) {
                    volume.anonymize();
                }
                File outputFile = null;
                if (StringUtils.isNotBlank((CharSequence)this.outputName)) {
                    File tempFile = new File(this.outputName);
                    outputFile = tempFile.isAbsolute() ? tempFile : new File(file.getParent(), this.outputName);
                }
                File avwHeaderFile = CLIUtils.makeOutputFile(file, outputFile, volume, null, EXT_HEADER, this.anonymize);
                File avwImageFile = CLIUtils.makeOutputFile(file, outputFile, volume, null, EXT_IMAGE, this.anonymize);
                ImageType itCurrent = volume.getImageType();
                ImageType it = CLIUtils.verifyDatatype(new AVW(), itCurrent);
                boolean forceFitPrecision = false;
                if (it.getNumBytesPerVoxel() < itCurrent.getNumBytesPerVoxel() || it.getByteType() != 4 && itCurrent.getByteType() == 4) {
                    forceFitPrecision = true;
                }
                volume.updateMaxMin(volume.findRangeSeriesSlowly());
                boolean hasGlobalDataScales = volume.hasGlobalDataScale();
                boolean applyDataScales = !hasGlobalDataScales;
                boolean fitPrecision = !hasGlobalDataScales && it.getByteType() != 4 || forceFitPrecision;
                String orientation = CLIUtils.verifyOrientation(new AVW(), volume.getOrientationString());
                it.setCompressionType(0);
                volume.setImageFileName(avwImageFile.getName());
                volume.writeFilesAs(avwHeaderFile, "Analyze", it, orientation, applyDataScales, fitPrecision);
            }
            catch (InvalidHeaderException ex) {
                AppLogger.error((String)("Header could not be read: " + file));
            }
            catch (VolumeIOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    private boolean readArgs(String[] args) {
        for (int ctr = 0; ctr < args.length; ++ctr) {
            if (args[ctr].equals(OPTION_ANONYMIZE)) {
                this.anonymize = true;
                continue;
            }
            if (args[ctr].equals(OPTION_OUTPUT)) {
                this.outputName = args[ctr + 1];
                ++ctr;
                continue;
            }
            this.infiles.add(args[ctr]);
        }
        return this.infiles.size() > 0;
    }

    @Override
    public String getCommandLineName() {
        return COMMAND_LINE_NAME;
    }
}

