/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.cli.applytransform;

import Jama.Matrix;
import edu.uthscsa.ric.cli.CLIUtils;
import edu.uthscsa.ric.cli.Utility;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Transform;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeIOException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class ApplyTransform
implements Utility {
    private File imageFile;
    private File matrixFile;
    private String outputName;
    private boolean centerFlag;
    private boolean decompose;
    private boolean originFlag;
    public static final String COMMAND_LINE_NAME = "applytransform";
    public static final String DEFAULT_SUFFIX = "_trans";
    public static final String NIFTI_EXT = ".nii";
    public static final String OPTION_CENTER = "-c";
    public static final String OPTION_ORIGIN = "-o";
    public static final String OPTION_DECOMPOSE = "-d";

    public static void main(String[] args) {
        try {
            CLIUtils.prepUtilityProgram();
            CLIUtils.addAllPlugins();
            JVMUtilities.addLibraryDir((String)Platform.getLibDir().toString());
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        ApplyTransform processor = new ApplyTransform();
        if (processor.readArgs(args)) {
            try {
                processor.process();
            }
            catch (IllegalArgumentException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (InvalidHeaderException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (VolumeIOException ex) {
                AppLogger.error((Throwable)ex);
            }
        } else {
            AppLogger.error((String)processor.getUsage());
        }
    }

    @Override
    public String getUsage() {
        String usage = "";
        usage = usage + "Applies transform to image (v" + Mango.getVersionString() + " b-" + Mango.getBuildNumberString() + ")\n";
        usage = usage + "Usage: applytransform [-c | -o] <matrix file> <image file> [output file]\n";
        usage = usage + "Usage: applytransform -d <matrix file>\n";
        usage = usage + "Options:\n";
        usage = usage + "-c  apply as world transform (about image center)\n";
        usage = usage + "-o  apply as world transform (about image origin)\n";
        usage = usage + "-d  decompose transform\n";
        return usage;
    }

    private void process() throws InvalidHeaderException, VolumeIOException {
        double[] transformSingle = Volume.readTransformFile(this.matrixFile);
        if (transformSingle == null) {
            throw new IllegalArgumentException("The matrix file could not be read.");
        }
        double[][] transform = new double[4][4];
        for (int ctrR = 0; ctrR < 4; ++ctrR) {
            for (int ctrC = 0; ctrC < 4; ++ctrC) {
                transform[ctrR][ctrC] = transformSingle[ctrR * 4 + ctrC];
            }
        }
        if (this.decompose) {
            double[] decomp = Transform.decompose(transform);
            System.out.format("Trans: %12.5f  %12.5f  %12.5f%n", decomp[0], decomp[1], decomp[2]);
            System.out.format("Rot:   %12.5f  %12.5f  %12.5f%n", decomp[3], decomp[4], decomp[5]);
            System.out.format("Scale: %12.5f  %12.5f  %12.5f%n", decomp[6], decomp[7], decomp[8]);
            System.out.format("Skew:  %12.5f  %12.5f  %12.5f%n", decomp[9], decomp[10], decomp[11]);
        } else {
            Volume vol = new Volume(this.imageFile);
            File outputFile = null;
            if (StringUtils.isNotBlank((CharSequence)this.outputName)) {
                File tempFile = new File(this.outputName);
                outputFile = tempFile.isAbsolute() ? tempFile : new File(this.imageFile.getParent(), this.outputName);
            }
            outputFile = CLIUtils.makeOutputFile(this.imageFile, outputFile, null, DEFAULT_SUFFIX, ".nii.gz", false);
            if (this.centerFlag) {
                transform = vol.convertFromCoordinateTransform(transform, false, false, null);
                vol.loadTransform(new Matrix(transform), 0, null);
            } else if (this.originFlag) {
                transform = vol.convertFromCoordinateTransform(transform, true, false, null);
                Coordinate rotationCoord = vol.getOrigin();
                vol.loadTransform(new Matrix(transform), 1, rotationCoord);
            } else {
                transform = vol.convertToIndexTransform(transform);
                vol.loadTransform(new Matrix(transform), 0, null);
            }
            vol.writeFilesAs(outputFile, "NIFTI", vol.getImageType(), null, false, false, true);
        }
    }

    private boolean readArgs(String[] args) {
        for (String arg : args) {
            if (arg.equals(OPTION_CENTER)) {
                this.centerFlag = true;
                continue;
            }
            if (arg.equals(OPTION_ORIGIN)) {
                this.originFlag = true;
                continue;
            }
            if (arg.equals(OPTION_DECOMPOSE)) {
                this.decompose = true;
                continue;
            }
            if (this.matrixFile == null) {
                this.matrixFile = new File(arg).getAbsoluteFile();
                continue;
            }
            if (this.imageFile == null) {
                this.imageFile = new File(arg).getAbsoluteFile();
                continue;
            }
            if (this.outputName != null) continue;
            this.outputName = arg;
        }
        return this.matrixFile != null && (this.imageFile != null || this.decompose);
    }

    @Override
    public String getCommandLineName() {
        return COMMAND_LINE_NAME;
    }
}

