/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.cli;

import edu.uthscsa.ric.cli.Manager;
import edu.uthscsa.ric.cli.Progress;
import edu.uthscsa.ric.mango.Atlas;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoContext;
import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.mango.dialogs.modal.AddImageDialog;
import edu.uthscsa.ric.mango.dialogs.modal.PluginManagerDialog;
import edu.uthscsa.ric.mango.dialogs.script.ScriptManager;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.plugin.atlases.atlasfsl.AtlasFSL;
import edu.uthscsa.ric.mango.plugin.atlases.atlasfsl.AtlasFormatException;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.AnalysisPoint;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VoxelDimensions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;

public final class Context
implements MangoContext {
    private Atlas currentAtlas;
    private boolean multisliceMode = true;
    private boolean radiologicalMode;
    private boolean worldMode;
    private int currentVolumeManager;
    private final List<Analysis> analyses;
    private final List<AnalysisPoint> analysisPoints;
    private final List<VolumeManager> volumeManagers = new ArrayList<VolumeManager>();
    private static Context instance;
    private static boolean loadedAtlases;
    private static final Vector<Atlas> ATLASES;

    private Context() {
        this.analyses = new ArrayList<Analysis>();
        this.analysisPoints = new ArrayList<AnalysisPoint>();
    }

    public static synchronized Context getContext() {
        if (instance == null) {
            instance = new Context();
        }
        return instance;
    }

    public Analysis addAnalysis(Analysis analysis) {
        this.analyses.add(analysis);
        return analysis;
    }

    public List<Analysis> addAnalysis(List<Analysis> analysis) {
        this.analyses.addAll(analysis);
        return analysis;
    }

    public AnalysisPoint addAnalysisPoint(AnalysisPoint analysis) {
        this.analysisPoints.add(analysis);
        return analysis;
    }

    public void capture() {
    }

    public JButton createColorPickerButton(VolumeManager manager, MangoColorSelectedListener listener, boolean showUsedOnly) {
        return null;
    }

    public List<VolumeManager> getAllVolumeManagers() {
        ArrayList<VolumeManager> list = new ArrayList<VolumeManager>();
        list.addAll(this.volumeManagers);
        return list;
    }

    public void removeVolumeManager(VolumeManager manager) {
        this.volumeManagers.remove(manager);
    }

    public List<VolumeManager> getAllVolumeManagersFrom(VolumeManager viewer) {
        int ctr;
        ArrayList<VolumeManager> list = new ArrayList<VolumeManager>();
        int index = this.volumeManagers.indexOf(viewer);
        int num = this.volumeManagers.size();
        if (index == -1) {
            index = 0;
        }
        for (ctr = index; ctr < num; ++ctr) {
            list.add(this.volumeManagers.get(ctr));
        }
        for (ctr = 0; ctr < index; ++ctr) {
            list.add(this.volumeManagers.get(ctr));
        }
        return list;
    }

    public String getBuildNumber() {
        return Mango.getBuildNumberString();
    }

    public VolumeManager getCurrentVolumeManager() {
        return this.volumeManagers.get(this.currentVolumeManager);
    }

    public int getCurrentVolumeManagerIndex() {
        return this.currentVolumeManager;
    }

    public File getLibDir() {
        return Platform.getLibDir();
    }

    public List<VolumeManager> getOtherVolumeManagers(VolumeManager manager) {
        ArrayList<VolumeManager> list = new ArrayList<VolumeManager>();
        list.addAll(this.volumeManagers);
        list.remove(manager);
        return list;
    }

    public String getVersion() {
        return Mango.getVersionString();
    }

    public boolean isWorldMode() {
        return this.worldMode;
    }

    public ImageVolume makeNewVolume() {
        return new Volume();
    }

    public VolumeManager makeNewVolumeManager(String openLocation) throws InvalidHeaderException, IOException {
        Manager manager = new Manager();
        manager.addNewVolume(new File(openLocation).toURI());
        this.volumeManagers.add(manager);
        return manager;
    }

    public void addVolumeManager(VolumeManager manager) {
        this.volumeManagers.add(manager);
    }

    public VolumeManager makeNewVolumeManagerURL(String url) throws InvalidHeaderException, IOException {
        Manager manager = new Manager();
        try {
            manager.addNewVolume(new URL(url).toURI());
            this.volumeManagers.add(manager);
        }
        catch (URISyntaxException ex) {
            AppLogger.error((Throwable)ex);
        }
        return manager;
    }

    public ProgressMeter makeProgressMeter() {
        return new Progress();
    }

    public void runScript(String scriptName) {
        ScriptManager.runScriptSilently(scriptName, this, this.volumeManagers.get(this.currentVolumeManager));
    }

    public void setAtlas(String name) {
        Context.loadAtlases();
        Atlas atlas = null;
        if (name != null && !name.equals("None")) {
            Enumeration<Atlas> en = ATLASES.elements();
            while (en.hasMoreElements()) {
                Atlas aAtlas = en.nextElement();
                if (!name.equals(PluginManagerDialog.getPluginName(aAtlas))) continue;
                atlas = aAtlas;
                this.worldMode = true;
                atlas.loadAtlas(Platform.getTempDir());
                break;
            }
        }
        this.currentAtlas = atlas;
    }

    private static void loadAtlases() {
        if (loadedAtlases) {
            return;
        }
        loadedAtlases = true;
        try {
            File atlasDir = new File(Platform.getFslPath());
            Vector<Atlas> atlases = AtlasFSL.loadAtlasDirectory(atlasDir);
            for (int ctr = 0; ctr < atlases.size(); ++ctr) {
                Context.addAtlas(atlases.get(ctr));
            }
        }
        catch (AtlasFormatException ex) {
            AppLogger.error((Throwable)ex);
        }
        try {
            Vector<Atlas> atlases = AtlasFSL.loadAtlasDirectory(Platform.getAtlasDir());
            for (int ctr = 0; ctr < atlases.size(); ++ctr) {
                Context.addAtlas(atlases.get(ctr));
            }
        }
        catch (AtlasFormatException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    public static void addAtlas(Atlas atlas) {
        ATLASES.add(atlas);
    }

    public void setCurrentVolumeManager(VolumeManager manager) {
        this.currentVolumeManager = this.volumeManagers.indexOf(manager);
    }

    public void setCurrentVolumeManagerIndex(int index) {
        this.currentVolumeManager = index;
    }

    public void setMultisliceMode(boolean multisliceMode) {
        this.multisliceMode = multisliceMode;
    }

    public void setTool(int code) {
    }

    public void setToolRange(boolean useRange, double min, double max, boolean onlyWhenShiftKeyPressed) {
    }

    public void setToolRelativeRange(double range) {
    }

    public void setWorldMode(boolean world) {
        this.worldMode = world;
    }

    public void updateViewers() {
    }

    public boolean isMultisliceMode() {
        return this.multisliceMode;
    }

    public int getTool() {
        return 0;
    }

    public List<Analysis> getAllAnalyses() {
        return this.analyses;
    }

    public static void clearContext() {
        instance = null;
        JVMUtilities.clearGarbage();
    }

    public void exit() {
        List<VolumeManager> allManagers = Context.getContext().getAllVolumeManagers();
        for (VolumeManager manager : allManagers) {
            manager.disposeVolumeManager();
        }
        Context.clearContext();
    }

    public boolean isRadiologicalMode() {
        return this.radiologicalMode;
    }

    public void setRadiologicalMode(boolean radiologicalMode) {
        this.radiologicalMode = radiologicalMode;
    }

    public Atlas getCurrentAtlas() {
        return this.currentAtlas;
    }

    public VolumeManager makeNewVolumeManager(ImageDimensions imageDims, VoxelDimensions voxelDims, ImageType imageType, ByteBuffer[] buffers, boolean readOnly, String name) {
        ImageType it = imageType;
        if (it == null) {
            it = AddImageDialog.getImageType();
        }
        URI loadingURI = null;
        try {
            loadingURI = File.createTempFile(name, null, Platform.getTempDir()).toURI();
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        Header header = new Header(it, imageDims, voxelDims, null);
        header.setOrientation("XYZ+--");
        header.setOrientationCertainty(2);
        header.setImageFile(loadingURI);
        Manager manager = new Manager();
        Volume volume = null;
        try {
            volume = new Volume(header, false, buffers);
            manager.addNewVolume(volume, loadingURI);
            this.volumeManagers.add(manager);
            volume.setReadOnly(readOnly);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
        return manager;
    }

    public List<AnalysisPoint> getAllAnalysisPoints() {
        return this.analysisPoints;
    }

    static {
        ATLASES = new Vector();
    }
}

