/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.cli;

import edu.uthscsa.ric.cli.Context;
import edu.uthscsa.ric.cli.ScriptablePlugin;
import edu.uthscsa.ric.mango.Atlas;
import edu.uthscsa.ric.mango.MangoPlugin;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.volume.Image;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.WritableHeader;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.lang3.StringUtils;

public final class CLIUtils {
    private static final Map<String, String> PLUGINS = new TreeMap<String, String>();
    private static boolean ignoreAppLogger;
    public static final String EXT_JAR = ".jar";
    public static final String EXT_ZIP = ".zip";

    private CLIUtils() {
    }

    public static void addAllPlugins() {
        Volume.loadFormats();
        File pluginDir = Platform.getPluginDir();
        File[] pluginFiles = pluginDir.listFiles();
        if (pluginFiles != null) {
            for (File file : pluginFiles) {
                if (!file.toString().endsWith(EXT_JAR) && !file.toString().endsWith(EXT_ZIP)) continue;
                CLIUtils.addPlugin(file, false);
            }
        }
    }

    public static void addPlugin(File aFile, boolean doMoveFile) {
        try {
            if (!aFile.exists()) {
                throw new FileNotFoundException();
            }
            CLIUtils.loadPlugin(aFile);
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (Error err) {
            AppLogger.error((Throwable)err);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    public static void prepUtilityProgram() {
        Image.setCli(true);
        System.setProperty("java.awt.headless", "true");
        if (!CLIUtils.isIgnoreAppLogger()) {
            AppLogger.reset();
            AppLogger.createFileLogger((File)Platform.getLogDir());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Object loadPlugin(File aFile) throws IOException {
        String fileName = aFile.getName();
        String className = null;
        Object ob = null;
        if (!fileName.endsWith(EXT_JAR) && !fileName.endsWith(EXT_ZIP)) throw new IllegalArgumentException("File type is not recognized!");
        String baseName = null;
        baseName = fileName.endsWith(EXT_JAR) ? fileName.substring(0, fileName.indexOf(EXT_JAR)) : fileName.substring(0, fileName.indexOf(EXT_ZIP));
        if (baseName.startsWith("replace_")) {
            baseName = baseName.substring(8);
        }
        String pluginName = baseName + ".class";
        boolean found = false;
        try (JarFile jFile = null;){
            jFile = new JarFile(aFile);
            Manifest manifest = jFile.getManifest();
            className = manifest.getMainAttributes().getValue("MangoPlugin-Class");
            if (className == null) {
                Enumeration<JarEntry> jarEntries = jFile.entries();
                while (jarEntries.hasMoreElements() && !found) {
                    ZipEntry entry = jarEntries.nextElement();
                    if (entry.isDirectory()) continue;
                    String originalName = entry.getName();
                    String pathName = originalName.substring(0, originalName.lastIndexOf(47) + 1);
                    pathName = pathName.replace('/', '.');
                    pathName = pathName.trim();
                    String name = originalName.substring(originalName.lastIndexOf(47) + 1);
                    if (!(name = name.replace('/', '.')).equals(pluginName)) continue;
                    className = pathName + baseName;
                }
            }
            JVMUtilities.addFileToClassPath((File)aFile);
            Class<?> aClass = null;
            try {
                aClass = Class.forName(className);
                found = true;
                if (WritableHeader.class.isAssignableFrom(aClass)) {
                    ob = aClass.newInstance();
                    ReadableHeader rh = ob;
                    Volume.addReadableHeader(rh);
                    return ob;
                }
                if (ReadableHeader.class.isAssignableFrom(aClass)) {
                    ob = aClass.newInstance();
                    ReadableHeader rf = ob;
                    Volume.addReadableHeader(rf);
                    return ob;
                }
                if (MangoPlugin.class.isAssignableFrom(aClass)) {
                    ob = aClass.newInstance();
                    MangoPlugin mp = ob;
                    String userName = mp.getPluginName();
                    PLUGINS.put(userName, className);
                    return ob;
                }
                if (!Atlas.class.isAssignableFrom(aClass)) return ob;
                ob = aClass.newInstance();
                Atlas atlas = ob;
                Context.addAtlas(atlas);
                return ob;
            }
            catch (HeadlessException | ClassNotFoundException | Error | IllegalAccessException | InstantiationException throwable) {
                // empty catch block
            }
            return ob;
        }
    }

    public static boolean isScriptablePlugin(String className) {
        Object obj = CLIUtils.findPlugin(className);
        return obj instanceof MangoPlugin && obj instanceof ScriptablePlugin;
    }

    public static Object findPlugin(String pluginName) {
        try {
            Set<String> pluginNames = PLUGINS.keySet();
            for (String aPluginName : pluginNames) {
                if (!pluginName.equals(aPluginName)) continue;
                Class<?> aClass = Class.forName(PLUGINS.get(pluginName));
                return aClass.newInstance();
            }
        }
        catch (ClassNotFoundException ex) {
            AppLogger.warn((Throwable)ex);
        }
        catch (InstantiationException ex) {
            AppLogger.warn((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            AppLogger.warn((Throwable)ex);
        }
        return null;
    }

    public static File makeOutputFile(File infile, File outfile, Volume invol, String suffix, String ext, boolean anonymize) {
        return CLIUtils.makeOutputFile(infile, outfile, invol, suffix, ext, null, anonymize);
    }

    public static File makeOutputFile(File infile, File outfile, Volume invol, String suffix, String ext, String defaultName, boolean anonymize) {
        String filename = null;
        String dir = null;
        if (outfile != null) {
            filename = outfile.getName();
            dir = outfile.getAbsoluteFile().getParent();
        } else if (defaultName != null) {
            filename = defaultName;
            dir = infile.getAbsoluteFile().getParent();
        } else {
            if (invol != null) {
                filename = invol.getTitle();
            }
            if (StringUtils.isBlank((CharSequence)filename)) {
                filename = StringUtilities.makeNiceImageName((String)FileUtilities.getName((URI)infile.toURI()));
            }
            dir = infile.getAbsoluteFile().getParent();
        }
        if (filename.indexOf(46) != -1) {
            filename = filename.substring(0, filename.indexOf(46));
        }
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            filename = filename + suffix;
        }
        if (StringUtils.isNotBlank((CharSequence)ext)) {
            filename = filename + ext;
        }
        return new File(dir, filename);
    }

    public static ImageType verifyDatatype(WritableHeader wh, ImageType it) {
        ImageType imageType = CLIUtils.findBestFloatDatatype(wh, it, true);
        if (imageType == null) {
            imageType = CLIUtils.findBestSignedIntegerDatatype(wh, it, true);
        }
        if (imageType == null) {
            imageType = CLIUtils.findBestUnsignedIntegerDatatype(wh, it, true);
        }
        if (imageType.getNumBytesPerVoxel() < it.getNumBytesPerVoxel()) {
            imageType = null;
        }
        if (imageType == null) {
            imageType = CLIUtils.findBestSignedIntegerDatatype(wh, it, false);
        }
        if (imageType == null) {
            imageType = CLIUtils.findBestUnsignedIntegerDatatype(wh, it, false);
        }
        if (imageType == null) {
            imageType = CLIUtils.findBestFloatDatatype(wh, it, false);
        }
        if (imageType == null) {
            imageType = it;
        }
        imageType = CLIUtils.verifyEndianness(wh, imageType);
        return imageType;
    }

    private static ImageType findBestFloatDatatype(WritableHeader wh, ImageType it, boolean matchOnly) {
        int byteType = it.getByteType();
        int numBytes = it.getNumBytesPerVoxel();
        int[] numBytesSupported = wh.getSupportedBytesForType(4);
        if ((!matchOnly || byteType == 4) && CollectionUtilities.isNotEmpty((Object)numBytesSupported)) {
            if (CLIUtils.contains(numBytesSupported, numBytes)) {
                return new ImageType(numBytes, 4, numBytes * 8, it.isLittleEndian());
            }
            if (CLIUtils.contains(numBytesSupported, 4)) {
                return new ImageType(4, 4, 32, it.isLittleEndian());
            }
        }
        return null;
    }

    private static ImageType findBestSignedIntegerDatatype(WritableHeader wh, ImageType it, boolean matchOnly) {
        int byteType = it.getByteType();
        int numBytes = it.getNumBytesPerVoxel();
        int[] numBytesSupported = wh.getSupportedBytesForType(2);
        if ((!matchOnly || byteType == 2) && CollectionUtilities.isNotEmpty((Object)numBytesSupported)) {
            if (CLIUtils.contains(numBytesSupported, numBytes)) {
                return new ImageType(numBytes, 2, numBytes * 8, it.isLittleEndian());
            }
            if (CLIUtils.contains(numBytesSupported, 2)) {
                return new ImageType(2, 2, 16, it.isLittleEndian());
            }
            if (CLIUtils.contains(numBytesSupported, 4)) {
                return new ImageType(4, 2, 32, it.isLittleEndian());
            }
            if (CLIUtils.contains(numBytesSupported, 1)) {
                return new ImageType(1, 2, 8, it.isLittleEndian());
            }
        }
        return null;
    }

    private static ImageType findBestUnsignedIntegerDatatype(WritableHeader wh, ImageType it, boolean matchOnly) {
        int byteType = it.getByteType();
        int numBytes = it.getNumBytesPerVoxel();
        int[] numBytesSupported = wh.getSupportedBytesForType(3);
        if ((!matchOnly || byteType == 3) && CollectionUtilities.isNotEmpty((Object)numBytesSupported)) {
            if (CLIUtils.contains(numBytesSupported, numBytes)) {
                return new ImageType(numBytes, 3, numBytes * 8, it.isLittleEndian());
            }
            if (CLIUtils.contains(numBytesSupported, 2)) {
                return new ImageType(2, 3, 16, it.isLittleEndian());
            }
            if (CLIUtils.contains(numBytesSupported, 4)) {
                return new ImageType(4, 3, 32, it.isLittleEndian());
            }
            if (CLIUtils.contains(numBytesSupported, 1)) {
                return new ImageType(1, 3, 8, it.isLittleEndian());
            }
        }
        return null;
    }

    private static boolean contains(int[] array, int value) {
        for (int element : array) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    private static ImageType verifyEndianness(WritableHeader wh, ImageType it) {
        if (it.getNumBytesPerVoxel() > 1) {
            if (!wh.isSupportedBigEndian()) {
                return new ImageType(it.getNumBytesPerVoxel(), it.getByteType(), it.getBitsStored(), true);
            }
            if (!wh.isSupportedLittleEndian()) {
                return new ImageType(it.getNumBytesPerVoxel(), it.getByteType(), it.getBitsStored(), false);
            }
            return new ImageType(it.getNumBytesPerVoxel(), it.getByteType(), it.getBitsStored(), true);
        }
        return it;
    }

    public static String verifyOrientation(WritableHeader wh, String orientation) {
        String[] supported = wh.getSupportedOrientations();
        if (CollectionUtilities.isEmpty((Object)supported)) {
            return orientation;
        }
        for (String current : supported) {
            if (!current.equals(orientation)) continue;
            return current;
        }
        String orient = orientation.substring(0, 3);
        for (String current : supported) {
            if (!orient.equals(current.substring(0, 3))) continue;
            return current;
        }
        return supported[0];
    }

    public static boolean isIgnoreAppLogger() {
        return ignoreAppLogger;
    }

    public static void setIgnoreAppLogger(boolean isIgnoreFileLogger) {
        ignoreAppLogger = isIgnoreFileLogger;
    }
}

