function fileout=evlab17_run_qa(varargin)
% EVLAB17_RUN_QA runs Quality Assurance plots
%
%  OPTIONS (entered in .cfg file preceeded by #, or entered as arguments to evlab17_run_qa)
%
%      dataset         : file generated by preprocessing step evlab17_*.mat (note: explicitly specifying a dataset may be skipped when evlab17_run_qa is run immediately after evlab17_run_preproc or evlab17_run_model)
%      qa_plist        : (optional) list of quality assurance plots to create ([] for all QA displays; 'preprocessing' for all preprocessing QA displays; 'firstlevel_##' for all first-level analysis QA displays) (default value: [])
%      qa_folder       : (optional) output directory for QA plots
%      qa_set          : (optional) functional dataset for preprocessing QA plots [1]
%      parallel.N      : (optional) parallelization options; number of parallel jobs [0]
%      parallel.profile: (optional) parallelization options; cluster computing profile (see "conn_jobmanager profiles" to see a list of available parallelization profiles) ['Grid Engine']
%

evlab17_module init;
fileout=[];

% loads .cfg files
options=struct;
if nargin>1&&ischar(varargin{1})&&isempty(dir(varargin{1}))
    n=0;
else
    for n=1:nargin
        if isempty(varargin{n}), break; end
        filename=varargin{n};
        if ischar(filename)
            if isempty(dir(filename)),
                if ~isempty(dir(fullfile(fileparts(which(mfilename)),filename))), filename=fullfile(fileparts(which(mfilename)),filename);
                else
                    fprintf('warning: file %s not found\n',filename);
                    filename=which(filename);
                end
            end
            fprintf('loading file %s\n',filename);
        end
        options=conn_loadcfgfile(filename,options);
    end
end
for n=n+1:2:nargin-1
    fieldname=regexp(varargin{n},'\.','split');
    fieldvalue=varargin{n+1};
    options=setfield(options,fieldname{:},fieldvalue);
end
fprintf('%s options:\n',mfilename);
disp(options);
options0=options;
options0.arguments=varargin;

% interprets info
tag=datestr(now,'yyyy_mm_dd_HHMMSSFFF');
fields={};
niifolder=pwd;
qa_plots=evlab17_module('default','qa_plots');
qa_parallel=evlab17_module('default','qa_parallel');
qa_profile=evlab17_module('default','qa_profile');
qa_plist=[];
qa_folder=[];
qa_set=[];
if isfield(options,'dataset')
    fileout=conn_prepend('',options.dataset,'.mat');
    qafolder=fullfile(fileparts(fileout),['QA_',tag]);
    %qafolder=fullfile(conn_prepend('',fileout,''),'results','qa',['QA_',tag]);
    options=rmfield(options,'dataset');
    ok=evlab17_module('load',fileout);
    if ~ok, error('problem loading preprocessed dataset info from %s',fileout); end
else
    filename=evlab17_module('filename');
    if isempty(filename), error('#dataset field not specified'); end
    if ~isfield(options,'oknodataset')
        if 0, fprintf('Warning: #dataset field not specified; using current dataset (%s)\n',filename);
        elseif ~isequal(conn_questdlg({'#dataset field not specified','Do you want to continue processing dataset',[filename,'?']},'','Yes','No','Yes'),'Yes'), return;
        end
    end
    qafolder=fullfile(fileparts(filename),['QA_',tag]);
end

if isfield(options,'qa_plots')
    qa_plots=options.qa_plots;
    options=rmfield(options,'qa_plots');
end
if isfield(options,'qa_plist')
    qa_plist=options.qa_plist;
    options=rmfield(options,'qa_plist');
end
if isfield(options,'qa_set')
    qa_set=options.qa_set;
    options=rmfield(options,'qa_set');
end
if isfield(options,'qa_folder')
    qa_folder=options.qa_folder;
    options=rmfield(options,'qa_folder');
end
if isfield(options,'qa_parallel')
    qa_parallel=options.qa_parallel;
    options=rmfield(options,'qa_parallel');
end
if isfield(options,'parallel'), 
    parallel=options.parallel;
	options=rmfield(options,'parallel');
else
    parallel.N=qa_parallel;
    if ~isempty(qa_profile), parallel.profile=qa_profile; end
end
if isfield(options,'qa_profile')
    parallel.profile=options.qa_profile;
    options=rmfield(options,'qa_profile');
end
parallel.N=max(parallel.N,qa_parallel);

tnames=fieldnames(options);
tnames=tnames(~ismember(tnames,{'subjects','design','runs','files','path'}));
if ~isempty(tnames), fprintf('note: the following information fields are not used by run_qa: %s\n',sprintf('%s ',tnames{:})); end

if isfield(options,'subjects'), subjects=options.subjects; % note: for multi-subject projects
else subjects=[];
end
plots1=[1,2,3,4,5,7,9,10,31];   % preproc plots
plots2=[21,22,23];              % first-level plots
if ~isempty(qa_plist)&&ischar(qa_plist)
    if isequal(lower(qa_plist),'all'), qa_plist=[];
    elseif isequal(lower(qa_plist),'preprocessing'), qa_plist=plots1;
    elseif isequal(lower(qa_plist),'firstlevel'), qa_plist=plots2;
    elseif ~isempty(regexp(qa_plist,'^firstlevel_'))
        model_name=regexprep(qa_plist,'^firstlevel_','');
        qa_plist=plots2;
        prependmodelname=true;
        if evlab17_module('inconnfolders'),
            model_folder=fullfile(conn_prepend('',evlab17_module('filename'),''),'results','firstlevel');
            prependmodelname=false;
        else model_folder=fullfile(fileparts(fileparts(evlab17_module('filename'))));
        end
        model_name=fullfile(model_folder,model_name);
        if prependmodelname, model_name=conn_prepend('firstlevel_',model_name); end
        if evlab17_module('get','Setup.nsubjects')>1,
            files=evlab17_module('get','spm');
            for nsubject=subjects(:)'
                files(nsubject)={fullfile(model_name,sprintf('sub-%04d',nsubject),'SPM.mat')};
            end
            evlab17_module('set','spm',files);
        else
            files=evlab17_module('get','spm');
            files(1)={fullfile(model_name,'SPM.mat')};
            evlab17_module('set','spm',files);
        end
    else error('unrecognized qa_plist entry %s',qa_plist);
    end
end
if isempty(qa_plist), qa_plist=[plots1 plots2]; end
batch_qa.QA.rois=1;
if isempty(qa_set), batch_qa.QA.sets=1; 
elseif ischar(qa_set), batch_qa.QA.sets=conn_datasetlabel(qa_set,'error'); 
else batch_qa.QA.sets=qa_set;
end

batch_qa.parallel=parallel;
if parallel.N>0, batch_qa.filename=evlab17_module('filename'); end
if ~isempty(subjects), batch_qa.subjects=subjects; end

if any(ismember(qa_plist,plots1))
    if ~isempty(qa_folder), 
        if isempty(qa_folder)||isequal(qa_folder,'root'), % back-compatibility
            qa_folder=fullfile(fileparts(evlab17_module('filename')));
            [tpath,tname]=fileparts(qa_folder); if isequal(tname,'nii'), qa_folder=tpath; end
        end
        qafolder=qa_folder;
    elseif evlab17_module('inconnfolders'), try, qafolder=fullfile(evlab17_module('get','folders.qa'),['QA_','PREPROC_',tag]); end
    end
    batch_qa.QA.plots=qa_plist(ismember(qa_plist,plots1));
    batch_qa.QA.foldername=qafolder;
    conn_batch(batch_qa);
    conn_fixpermissions(qafolder);
end

if any(ismember(qa_plist,plots2))
    if ~isempty(qa_folder), 
        if isempty(qa_folder)||isequal(qa_folder,'root'), % back-compatibility
            qa_folder=fullfile(fileparts(evlab17_module('filename')));
            [tpath,tname]=fileparts(qa_folder); if isequal(tname,'nii'), qa_folder=tpath; end
        end
        qafolder=qa_folder;
    elseif evlab17_module('inconnfolders'), try, qafolder=fullfile(evlab17_module('get','folders.qa'),['QA_','MODEL_',tag]); end
    end
    batch_qa.QA.plots=qa_plist(ismember(qa_plist,plots2));
    batch_qa.QA.foldername=qafolder;
    conn_batch(batch_qa);
    conn_fixpermissions(qafolder);
end
%%try, conn_qaplotsexplore(qafolder,'createreport'); end

end




