#!/bin/bash

pwd

echo "ID ROI FA Volume WayTotal" > ./data_collection_XTRACT.txt

for Patient in ???????
do
cd ./$Patient/DT/

pwd
date

cd ./XTRACT_output_standard

sed -e '1d' stats.csv > temp.csv

for ROI in  \
ac \
af_l \
af_r \
ar_l \
ar_r \
atr_l \
atr_r \
cbd_l \
cbd_r \
cbp_l \
cbp_r \
cbt_l \
cbt_r \
cst_l \
cst_r \
fa_l \
fa_r \
fma \
fmi \
fx_l \
fx_r \
ifo_l \
ifo_r \
ilf_l \
ilf_r \
mcp \
mdlf_l \
mdlf_r \
or_l \
or_r \
slf1_l \
slf1_r \
slf2_l \
slf2_r \
slf3_l \
slf3_r \
str_l \
str_r \
uf_l \
uf_r \
vof_l \
vof_r

do
WayTotal=`cat ./tracts/${ROI}/waytotal`
Volume=$(grep ${ROI} temp.csv | sed 's/,/ /g' | awk '{print $2}')
FA=$(grep ${ROI} temp.csv | sed 's/,/ /g' | awk '{print $10}')
echo ${Patient} ${ROI} ${FA} ${Volume} ${WayTotal}
echo ${Patient} ${ROI} ${FA} ${Volume} ${WayTotal} >> ../../../data_collection_XTRACT.txt
done
rm temp.csv
cd ../

cd ../../
done
cat data_collection_XTRACT.txt

echo "Finishing CST data collection"
pwd
date
