#!/bin/bash

pwd

# patiets No = ???????
for Patient in ???????

do
# Getting into DT directory
cd ./${Patient}/DT/

pwd
echo "Now, running tractography display"
date
rm -r Figures_standard
mkdir Figures_standard
cp -r ./XTRACT_output_standard/tracts ./Figures_standard/tracts
cd ./Figures_standard/tracts/

THR=0.01
SAT=0.01
for ROI in \
ac \
af_l \
af_r \
ar_l \
ar_r \
atr_l \
atr_r \
cbd_l \
cbd_r \
cbp_l \
cbp_r \
cbt_l \
cbt_r \
cst_l \
cst_r \
fa_l \
fa_r \
fma \
fmi \
fx_l \
fx_r \
ifo_l \
ifo_r \
ilf_l \
ilf_r \
mcp \
mdlf_l \
mdlf_r \
or_l \
or_r \
slf1_l \
slf1_r \
slf2_l \
slf2_r \
slf3_l \
slf3_r \
str_l \
str_r \
uf_l \
uf_r \
vof_l \
vof_r

do
cd ./${ROI}
fslmaths densityNorm.nii.gz -thr ${THR} -mul ${FSLDIR}/data/standard/MNI152_T1_1mm_brain_mask.nii.gz thr_densityNorm.nii.gz
cd ../
done

# procuding right-left separation masks
fslmaths ${FSLDIR}/data/standard/MNI152_T1_1mm_brain.nii.gz -mul 0 -add 1 -roi 92 91 0 218 0 182 0 1 -bin Lt_rectangular.nii.gz
fslmaths ${FSLDIR}/data/standard/MNI152_T1_1mm_brain.nii.gz -mul 0 -add 1 -roi 0 91 0 218 0 182 0 1 -bin Rt_rectangular.nii.gz

fslmaths ${FSLDIR}/data/standard/MNI152_T1_1mm_brain.nii.gz -mul 0 -add 1 -roi 0 182 0 50 0 182 0 1 -bin back.nii.gz
fslmaths ${FSLDIR}/data/standard/MNI152_T1_1mm_brain.nii.gz -mul 0 -add 1 -roi 0 182 170 48 0 182 0 1 -bin front.nii.gz
fslmaths ${FSLDIR}/data/standard/MNI152_T1_1mm_brain.nii.gz -mul 0 -add 1 -roi 0 182 0 218 0 35 0 1 -bin inferior.nii.gz

fslmaths Lt_rectangular.nii.gz -add back.nii.gz -add front.nii.gz -add inferior.nii.gz -bin Lt_inclusion_mask.nii.gz
fslmaths Rt_rectangular.nii.gz -add back.nii.gz -add front.nii.gz -add inferior.nii.gz -bin Rt_inclusion_mask.nii.gz

fslmaths ${FSLDIR}/data/standard/MNI152_T1_1mm_brain.nii.gz -mul Rt_inclusion_mask.nii.gz Rt+_MNI152_T1_1mm_brain.nii.gz
fslmaths ${FSLDIR}/data/standard/MNI152_T1_1mm_brain.nii.gz -mul Lt_inclusion_mask.nii.gz Lt+_MNI152_T1_1mm_brain.nii.gz

fsleyes \
--scene 3d \
--bgColour 0 0 0 \
--hideLegend \
--hideCursor \
--zoom 125 \
-rot 300 -15 -15 \
Rt+_MNI152_T1_1mm_brain.nii.gz \
./cst_l/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm red -n cst_l \
./slf1_l/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm yellow -n slf1_l \
./slf2_l/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm blue -n slf2_l \
./slf3_l/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm green -n slf3_l \
./ifo_l/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm cool -n ifo_l \
./atr_l/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm blue-lightblue -n atr_l \
./ilf_l/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm copper -n ilf_l \
./uf_l/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm winter -n uf_l \
./fa_l/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm Oranges -n fa_l \
./af_l/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm pink -n af_l \
./cbd_l/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm pink -n cbd_l &


fsleyes \
--scene 3d \
--bgColour 0 0 0 \
--hideLegend \
--hideCursor \
--zoom 125 \
-rot 60 -15 15 \
Lt+_MNI152_T1_1mm_brain.nii.gz \
./cst_r/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm red -n cst_r \
./slf1_r/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm yellow -n slf1_r \
./slf2_r/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm blue -n slf2_r \
./slf3_r/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm green -n slf3_r \
./ifo_r/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm cool -n ifo_r \
./atr_r/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm blue-lightblue -n atr_r \
./ilf_r/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm copper -n ilf_r \
./uf_r/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm winter -n uf_r \
./fa_r/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm Oranges -n fa_r \
./af_r/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm pink -n af_r \
./cbd_r/thr_densityNorm.nii.gz -dr ${THR} ${SAT} -cm pink -n cbd_r &

cd ../

cd ../../
done

echo "Finishing tractography display"
pwd
date

