#!/bin/bash

pwd

# patiets No = ???????
for Patient in ???????

do
# Getting into DT directory
cd ./${Patient}/DT/

pwd
echo "Now, running fnirt+TBSS FA calculation process"
date

# fnirt standard space FA analysis
mkdir my_fnirt
pwd
date
cd ./my_fnirt/
cp ../dti_FA.nii.gz ./
 
# obtaining non-linear transformation (warp) file (my_nonlinear_transf.nii.gz)
bet ${FSLDIR}/data/standard/FMRIB58_FA_1mm FMRIB58_FA_1mm_brain -f 0.3
flirt -ref FMRIB58_FA_1mm_brain -in dti_FA -omat my_affine_transf.mat
fnirt --in=dti_FA --aff=my_affine_transf.mat --cout=my_nonlinear_transf --config=FA_2_FMRIB58_1mm

# non-linear transformation (warp) of dti-FA
applywarp --ref=FMRIB58_FA_1mm_brain --in=dti_FA --warp=my_nonlinear_transf --out=dti_FA_warped

# obtaining inversed warp transfomation file (invwarp_FMRIB_to_dti_FA.nii.gz)
invwarp -w my_nonlinear_transf -o invwarp_FMRIB_to_dti_FA -r dti_FA

# setting invwarp_FMRIB_to_dti_FA.nii.gz to upper level directory for future usage
cp invwarp_FMRIB_to_dti_FA.nii.gz ../

# Copy JHU-ICBM-FA-1mm standard images into current directory
cp ${FSLDIR}/data/atlases/JHU/JHU-ICBM-labels-1mm.nii.gz ./

# inversed warp of JHU-ICBM-labels to individual dti_FA
applywarp --in=JHU-ICBM-labels-1mm --ref=dti_FA --warp=invwarp_FMRIB_to_dti_FA --interp=nn --out=JHU-ICBM-labels-1mm_to_dti_FA

# JHU ROI Labels mask (standard space)
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 1 -uthr 1 -bin 01_Middle-cerebellar-peduncle_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 2 -uthr 2 -bin 02_Pontine-crossing-tract_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 3 -uthr 3 -bin 03_Genu-of-corpus-callosum_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 4 -uthr 4 -bin 04_Body-of-corpus-callosum_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 5 -uthr 5 -bin 05_Splenium-of-corpus-callosum_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 6 -uthr 6 -bin 06_Fornix_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 7 -uthr 7 -bin 07_Corticospinal-tract_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 8 -uthr 8 -bin 08_Corticospinal-tract_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 9 -uthr 9 -bin 09_Medial-lemniscus_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 10 -uthr 10 -bin 10_Medial-lemniscus_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 11 -uthr 11 -bin 11_Inferior-cerebellar-peduncle_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 12 -uthr 12 -bin 12_Inferior-cerebellar-peduncle_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 13 -uthr 13 -bin 13_Superior-cerebellar-peduncle_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 14 -uthr 14 -bin 14_Superior-cerebellar-peduncle_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 15 -uthr 15 -bin 15_Cerebral-peduncle_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 16 -uthr 16 -bin 16_Cerebral-peduncle_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 17 -uthr 17 -bin 17_Anterior-limb-of-internal-capsule_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 18 -uthr 18 -bin 18_Anterior-limb-of-internal-capsule_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 19 -uthr 19 -bin 19_Posterior-limb-of-internal-capsule_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 20 -uthr 20 -bin 20_Posterior-limb-of-internal-capsule_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 21 -uthr 21 -bin 21_Retrolenticular-part-of-internal-capsule_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 22 -uthr 22 -bin 22_Retrolenticular-part-of-internal-capsule_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 23 -uthr 23 -bin 23_Anterior-corona-radiata_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 24 -uthr 24 -bin 24_Anterior-corona-radiata_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 25 -uthr 25 -bin 25_Superior-corona-radiata_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 26 -uthr 26 -bin 26_Superior-corona-radiata_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 27 -uthr 27 -bin 27_Posterior-corona-radiata_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 28 -uthr 28 -bin 28_Posterior-corona-radiata_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 29 -uthr 29 -bin 29_Posterior-thalamic-radiation_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 30 -uthr 30 -bin 30_Posterior-thalamic-radiation_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 31 -uthr 31 -bin 31_Sagittal-stratum_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 32 -uthr 32 -bin 32_Sagittal-stratum_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 33 -uthr 33 -bin 33_External-capsule_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 34 -uthr 34 -bin 34_External-capsule_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 35 -uthr 35 -bin 35_Cingulum-cingulate-gyrus_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 36 -uthr 36 -bin 36_Cingulum-cingulate-gyrus_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 37 -uthr 37 -bin 37_Cingulum-hippocampus_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 38 -uthr 38 -bin 38_Cingulum-hippocampus_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 39 -uthr 39 -bin 39_Fornix-Stria-terminalis_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 40 -uthr 40 -bin 40_Fornix-Stria-terminalis_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 41 -uthr 41 -bin 41_Superior-longitudinal-fasciculus_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 42 -uthr 42 -bin 42_Superior-longitudinal-fasciculus_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 43 -uthr 43 -bin 43_Superior-fronto-occipital-fasciculus_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 44 -uthr 44 -bin 44_Superior-fronto-occipital-fasciculus_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 45 -uthr 45 -bin 45_Inferior-fronto-occipital-fasciculus_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 46 -uthr 46 -bin 46_Inferior-fronto-occipital-fasciculus_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 47 -uthr 47 -bin 47_Uncinate-fasciculus_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 48 -uthr 48 -bin 48_Uncinate-fasciculus_L_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 49 -uthr 49 -bin 49_Tapetum_R_mask
fslmaths JHU-ICBM-labels-1mm.nii.gz -thr 50 -uthr 50 -bin 50_Tapetum_L_mask

# Calculation of FA values in JHU Labels (npte: these calclulations were made in standard space)
for ROI in *_mask.nii.gz
 do
  fslmaths dti_FA_warped.nii.gz -mul $ROI -thr 0.2 temp
  fslstats temp -M > temp_data.txt
  ROI_BASENAME=$(basename ${ROI} _mask.nii.gz)
  cat temp_data.txt | sed -e "s/^/${ROI_BASENAME} /" >>  ./JHU_segmentation_FA_data.txt
  rm temp.nii.gz
  rm temp_data.txt
 done
 cat JHU_segmentation_FA_data.txt

pwd
date
cd ../


# TBSS tract-based analysis
mkdir my_tbss
 pwd
 date
 cd ./my_tbss/
 cp ../dti_FA.nii.gz ./
 mv dti_FA.nii.gz $Patient.nii.gz

# TBSS procedures
 tbss_1_preproc *.nii.gz
 tbss_2_reg -T
 tbss_3_postreg -T
 tbss_4_prestats 0.2

# ROI-based FA analysus
 mkdir roi_FA_analysis
 cd ./roi_FA_analysis
 pwd
 date

# extracting ROIs
 cp ${FSLDIR}/data/atlases/JHU/JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz ./
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 1 -uthr 1 -bin lt_ant_thal_rad_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 2 -uthr 2 -bin rt_ant_thal_rad_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 3 -uthr 3 -bin lt_cst_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 4 -uthr 4 -bin rt_cst_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 5 -uthr 5 -bin lt_cingulum_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 6 -uthr 6 -bin rt_cingulum_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 7 -uthr 7 -bin lt_hippocumpus_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 8 -uthr 8 -bin rt_hippocumpus_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 9 -uthr 9 -bin forceps_major_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 10 -uthr 10 -bin forceps_minor_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 11 -uthr 11 -bin lt_ifof_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 12 -uthr 12 -bin rt_ifof_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 13 -uthr 13 -bin lt_ilf_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 14 -uthr 14 -bin rt_ilf_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 15 -uthr 15 -bin lt_slf_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 16 -uthr 16 -bin rt_slf_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 17 -uthr 17 -bin lt_uncinate_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 18 -uthr 18 -bin rt_uncinate_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 19 -uthr 19 -bin lt_slf_temp_mask
 fslmaths JHU-ICBM-tracts-maxprob-thr25-1mm.nii.gz -thr 20 -uthr 20 -bin rt_slf_temp_mask

# setting FA image data
 cp ../stats/all_FA_skeletonised.nii.gz ./
 cp ../stats/mean_FA_skeleton.nii.gz ./
 cp ../stats/mean_FA.nii.gz ./

# extracting individual skeletonised FA images (only one subject, so only vol0000.nii.gz is to be extracted)
fslsplit all_FA_skeletonised

# calculating FA in response to ROIs (only one subject, so only vol0000.nii.gz is to be extracted)
for ROI in *_mask.nii.gz
 do
  fslmaths vol0000.nii.gz -mul $ROI -thr 0.2 temp
  fslstats temp -M > temp_data.txt
  ROI_BASENAME=$(basename ${ROI} _mask.nii.gz)
  cat temp_data.txt | sed -e "s/^/${ROI_BASENAME} /" >> ../tbss_tracts_FA_data.txt
  rm temp.nii.gz
  rm temp_data.txt
 done
 rm vol0000.nii.gz
 cat ../tbss_tracts_FA_data.txt

pwd
date
cd ../../

# Back in working direcotory
cd ../../
done

echo "Finishing fnirt+TBSS FA calculation process"
pwd
date
