#!/bin/bash

pwd

# patiets No = ???????
for Patient in ???????

do
# Getting into DT directory
cd ./${Patient}/DT/

pwd
echo "Now, running preprocessing process"
date

# Copy original bvecs and bvals, preprocessing will overwitre bvecs and bvals
cp bvecs bvecs_orig
cp bvals bvals_orig

# Converting nii type into MRtrix3 type
mrconvert i.nii.gz i.mif -fslgrad bvecs bvals -datatype float32
date

# denoize using MRtrix3
dwidenoise i.mif i_den.mif -noise i_noise.mif
date

# Adjusting gibbs artifacts using MRtrix3
mrdegibbs i_den.mif i_den_unr.mif -axes 0,1
date

# taking TotalReadoutTime from i.json
grep TotalReadoutTime i.json | awk '{ print $2 }' | sed 's/,//' > TotalReadoutTime.txt

# getting TotalReadoutTime
temp_00=$(<./TotalReadoutTime.txt)
TotalReadoutTime=`echo "scale=4; $temp_00/1" | bc`

# Performing eddy current correction
dwifslpreproc i_den_unr.mif i_den_unr_preproc.mif -pe_dir AP -rpe_none -eddy_options " --slm=linear" -readout_time $TotalReadoutTime

# Performing B1 field correction
dwibiascorrect ants i_den_unr_preproc.mif i_den_unr_preproc_unbiased.mif -bias bias.mif

# Changing file type (mandatory to this pipeline)
mrconvert i_den_unr_preproc_unbiased.mif i_den_unr_preproc_unbiased.nii.gz -export_grad_fsl bvecs bvals -force

# Cleaning up *.mif files
rm *.mif

# Making brain masks
bet i_den_unr_preproc_unbiased.nii.gz i_den_unr_preproc_unbiased_brain.nii.gz -f 0.3 -g 0 -m

# back to woring directory
cd ../../
done

echo "Finishing preprocessing process"
pwd
date

# the preprocessing procedure is partially based on the following paper
# https://pubmed.ncbi.nlm.nih.gov/34332375/
